<?php

/**
 * Checkout Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-checkout.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.4.0
 */

if (! defined('ABSPATH')) {
	exit;
}
if (get_option('trusty_active_template')) {
	$active_layout = get_option('trusty_active_template');
	$layout_data = json_decode(get_post_meta($active_layout, 'trusty_checkout_data', true));
	do_action('woocommerce_before_checkout_form', $checkout);
	// If checkout registration is disabled and not logged in, the user cannot checkout.
	if (! $checkout->is_registration_enabled() && $checkout->is_registration_required() && ! is_user_logged_in()) {
		echo esc_html(apply_filters('woocommerce_checkout_must_be_logged_in_message', __('You must be logged in to checkout.', 'all-in-one-checkout-page-builder-for-woocommerce')));
		return;
	}

?>
	<form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url(wc_get_checkout_url()); ?>" enctype="multipart/form-data" aria-label="<?php echo esc_attr__('Checkout', 'all-in-one-checkout-page-builder-for-woocommerce'); ?>">
		<?php
		if (!empty($layout_data) && isset($layout_data->post_layout_data->initial_data)) {
			$layout = $layout_data->post_layout_data->initial_data;
		} else {
			$layout = []; // fallback to empty array or handle error
		}
		// echo "<pre>";
		// print_r($layout);
		// echo "</pre>";
		$allowed_html = array(
			'div'    => array(
				'id' => true,
				'class' => true,
				'style' => true,
				'data-*' => true,
			),
			'p' => array(
				'class' => true,
				'style' => true,
				'id'=>true,
				'data-*'=>true,
			),
			'span' => array(
				'class' => true,
				'id' => true,
				'style' => true,
				'data-*' => true,
			),
			'label' => array(
				'for' => true,
				'class' => true,
				'id' => true,
				'style' => true,
			),
			'input' => array(
				'type' => true,
				'name' => true,
				'value' => true,
				'class' => true,
				'id' => true,
				'placeholder' => true,
				'checked' => true,
				'selected' => true,
				'readonly' => true,
				'disabled' => true,
				'required' => true,
				'autocomplete' => true,
				'maxlength' => true,
				'minlength' => true,
				'min' => true,
				'max' => true,
				'step' => true,
				'pattern' => true,
				'data-*' => true,
				'style' => true,
				'aria-required'=>true,
				'aria-invalid'=>true,
			),
			'select' => array(
				'name' => true,
				'id' => true,
				'class' => true,
				'required' => true,
				'disabled' => true,
				'multiple' => true,
				'data-*' => true,
				'style' => true,
				'aria-required'=>true,
				'aria-invalid'=>true,
			),
			'option' => array(
				'value' => true,
				'selected' => true,
				'disabled' => true,
				'aria-required'=>true,
				'aria-invalid'=>true,
			),
			'textarea' => array(
				'name' => true,
				'id' => true,
				'class' => true,
				'cols' => true,
				'rows' => true,
				'placeholder' => true,
				'required' => true,
				'maxlength' => true,
				'minlength' => true,
				'readonly' => true,
				'disabled' => true,
				'autocomplete' => true,
				'data-*' => true,
				'style' => true,
				'aria-required'=>true,
				'aria-invalid'=>true,
			),
			'ul' => array(
				'class' => true,
				'id' => true,
				'style' => true,
				'aria-required'=>true,
				'aria-invalid'=>true,
			),
			'li' => array(
				'class' => true,
				'id' => true,
				'style' => true,
				'data-*' => true,
				'aria-required'=>true,
				'aria-invalid'=>true,
			),
			'strong' => array(),
			'em' => array(),
			'b' => array(),
			'i' => array(),
			'br' => array(),
			'hr' => array(),
			'h1' => array('class' => true),
			'h2' => array('class' => true),
			'h3' => array('class' => true),
			'h4' => array('class' => true),
			'h5' => array('class' => true),
			'h6' => array('class' => true),
		);
		
		foreach ($layout as $rowkey => $row) {
			echo '<div class="trusty-woo-checkout-row trusty-woo-checkout-row-' . esc_attr($rowkey) . '">';
			foreach ($row->data as $columnkey => $column) {
				echo '<div class="trusty-woo-checkout-column trusty-woo-checkout-row-' . esc_attr($rowkey) . '-column-' . esc_attr($columnkey) . '">';
				foreach ($column->data as $modulekey => $module) {
					echo '<div class="trusty-woo-checkout-module woo-module-' . esc_attr($module->key) . ' trusty-woo-checkout-row-' . esc_attr($rowkey) . '-column-' . esc_attr($columnkey) . '-module-' . esc_attr($modulekey) . '">';
					switch ($module->key) {
						case 'billing_fields':
							ob_start();
							do_action('woocommerce_checkout_billing', $module); // This executes the inline code in default template
							$billing_html = ob_get_clean();
							echo '<div class="trusty-woo-billing-fields">';
							echo wp_kses($billing_html,$allowed_html);
							echo '</div>';
							break;

						case 'shipping_fields':
							ob_start();
							do_action('woocommerce_checkout_shipping'); // This executes the inline code in default template
							$shipping_html = ob_get_clean();
							echo '<div class="trusty-woo-shipping-fields">';
							echo wp_kses($shipping_html,$allowed_html);
							echo '</div>';
							break;
						case 'order_review':
							do_action('woocommerce_checkout_order_review');
							break;
						case 'payment_method':
							do_action('woocommerce_checkout_after_order_review');
							break;
						case 'apply_coupon':
							echo '<div class="checkout_coupon woocommerce-form-coupon">';
							echo '<label for="coupon_code">' . esc_html($module->settings->label) . '</label>';
							echo '<div class="coupon_frame">';
							echo '<input type="text" name="coupon_code" class="input-text" placeholder="' . esc_html($module->settings->placeholder) . '" id="coupon_code" autocomplete="off" value="">';
							echo '<button type="button" class="btn-coupon-sub apply-coupon-btn" name="apply_coupon" value="Apply coupon">' . esc_html($module->settings->btn_text) . '</button>';
							echo '</div>';
							echo '<div class="clear"></div>';
							echo '<div class="coupon-message"></div>';
							echo '</div>';
							break;
						case 'customtext':
							echo "<div class='woo-checkout-text-wrapper'>" . wp_kses_post($module->settings->customText) . "</div>";
							break;
						default:
							echo '<div class="trusty-module-placeholder">Module: ' . esc_html($module->key) . '</div>';
							break;
					}
					echo "</div>";
				}
				echo "</div>";
			}
			echo "</div>";
		}

		?>

	</form>
<?php
	do_action('woocommerce_after_checkout_form', $checkout);
} else {
	do_action('woocommerce_before_checkout_form', $checkout);

	// If checkout registration is disabled and not logged in, the user cannot checkout.
	if (! $checkout->is_registration_enabled() && $checkout->is_registration_required() && ! is_user_logged_in()) {
		echo esc_html(apply_filters('woocommerce_checkout_must_be_logged_in_message', __('You must be logged in to checkout.', 'all-in-one-checkout-page-builder-for-woocommerce')));
		return;
	}

?>

	<form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url(wc_get_checkout_url()); ?>" enctype="multipart/form-data" aria-label="<?php echo esc_attr__('Checkout', 'all-in-one-checkout-page-builder-for-woocommerce'); ?>">

		<?php if ($checkout->get_checkout_fields()) : ?>

			<?php do_action('woocommerce_checkout_before_customer_details'); ?>

			<div class="col2-set" id="customer_details">
				<div class="col-1">
					<?php do_action('woocommerce_checkout_billing'); ?>
				</div>

				<div class="col-2">
					<?php do_action('woocommerce_checkout_shipping'); ?>
				</div>
			</div>

			<?php do_action('woocommerce_checkout_after_customer_details'); ?>

		<?php endif; ?>

		<?php do_action('woocommerce_checkout_before_order_review_heading'); ?>

		<h3 id="order_review_heading"><?php esc_html_e('Your order', 'all-in-one-checkout-page-builder-for-woocommerce'); ?></h3>

		<?php do_action('woocommerce_checkout_before_order_review'); ?>

		<div id="order_review" class="woocommerce-checkout-review-order">
			<?php do_action('woocommerce_checkout_order_review'); ?>
		</div>

		<?php do_action('woocommerce_checkout_after_order_review'); ?>

	</form>

<?php do_action('woocommerce_after_checkout_form', $checkout);
} ?>