export const shippingFieldsRawData = [
    {
      "key": "shipping_first_name",
      "label": "First name",
      "type": "text",
      "required": true,
      "class": [
        "form-row-first"
      ],
      "custom_attributes": [],
      "autocomplete": "given-name",
      "priority": 10,
      "woo_default":true,
      "disable":false,
    },
    {
      "key": "shipping_last_name",
      "label": "Last name",
      "type": "text",
      "required": true,
      "class": [
        "form-row-last"
      ],
      "custom_attributes": [],
      "autocomplete": "family-name",
      "priority": 20,
      "woo_default":true,
      "disable":false,
    },
    {
      "key": "shipping_country",
      "label": "Country \/ Region",
      "type": "country",
      "required": true,
      "class": [
        "form-row-wide",
        "address-field",
        "update_totals_on_change"
      ],
      "custom_attributes": [],
      "autocomplete": "country",
      "priority": 40,
      "woo_default":true,
      "disable":false,
    },
    {
      "key": "shipping_address_1",
      "label": "Street address",
      "type": "text",
      "required": true,
      "class": [
        "form-row-wide",
        "address-field"
      ],
      "custom_attributes": [],
      "autocomplete": "address-line1",
      "priority": 50,
      "woo_default":true,
      "disable":false,
    },
    {
      "key": "shipping_address_2",
      "label": "Apartment, suite, unit, etc.",
      "type": "text",
      "required": false,
      "class": [
        "form-row-wide",
        "address-field"
      ],
      "custom_attributes": [],
      "autocomplete": "address-line2",
      "priority": 60,
      "woo_default":true,
      "disable":false,
    },
    {
      "key": "shipping_city",
      "label": "Town \/ City",
      "type": "text",
      "required": true,
      "class": [
        "form-row-wide",
        "address-field"
      ],
      "custom_attributes": [],
      "autocomplete": "address-level2",
      "priority": 70,
      "woo_default":true,
      "disable":false,
    },
    {
      "key": "shipping_state",
      "label": "State",
      "type": "state",
      "required": true,
      "class": [
        "form-row-wide",
        "address-field"
      ],
      "custom_attributes": [],
      "validate": [
        "state"
      ],
      "autocomplete": "address-level1",
      "priority": 80,
      "country_field": "shipping_country",
      "country": "IN",
      "woo_default":true,
      "disable":false,
    },
    {
      "key": "shipping_postcode",
      "label": "PIN Code",
      "type": "text",
      "required": true,
      "class": [
        "form-row-wide",
        "address-field"
      ],
      "custom_attributes": [],
      "validate": [
        "postcode"
      ],
      "autocomplete": "postal-code",
      "priority": 90,
      "woo_default":true,
      "disable":false,
    },
    {
      "key": "shipping_phone",
      "label": "Phone",
      "type": "tel",
      "required": false,
      "class": [
        "form-row-wide"
      ],
      "custom_attributes": [],
      "validate": [
        "phone"
      ],
      "autocomplete": "tel",
      "priority": 100,
      "woo_default":true,
      "disable":false,
    },
    {
      "key": "shipping_email",
      "label": "Email address",
      "type": "email",
      "required": true,
      "class": [
        "form-row-wide"
      ],
      "custom_attributes": [],
      "validate": [
        "email"
      ],
      "autocomplete": "email",
      "priority": 110,
      "woo_default":true,
      "disable":false,
    }

  ]
