import React from "react";
import TextArea from "antd/es/input/TextArea";

function ModuleCustomTextContent(props) {
  const { type, rowindex, columnindex, moduleindex } = props.data.indexes;
  const items = [...props.data.data];
  const item = {
    ...items[rowindex].data[columnindex].data[moduleindex]["settings"],
  };

  const onChange = (e) => {
    const newItems = [...props.data.data];
    const updatedSettings = {
      ...newItems[rowindex].data[columnindex].data[moduleindex]["settings"],
      customText: e.target.value,
    };

    newItems[rowindex].data[columnindex].data[moduleindex]["settings"] = updatedSettings;
    props.onSettingChange(newItems);
  };

  return (
    <div className="module-content-tab-row">
      <TextArea
        placeholder="Enter text or HTML..."
        rows={5}
        onChange={onChange}
        value={item.customText || ""}
      />
      <p style={{ fontSize: "12px", color: "#888", marginTop: "5px" }}>
        You can include raw HTML or plain text.
      </p>
    </div>
  );
}

export default ModuleCustomTextContent;
