import React, { useEffect, useState } from "react";
import { Select, Switch, Input, Button, ColorPicker } from "antd";
import ContentIcons from "./ContentComponents/ContentIcons";
import { DragDropContext, Draggable, Droppable } from "react-beautiful-dnd";
import { SettingOutlined, ArrowLeftOutlined, DeleteOutlined, FontSizeOutlined, ItalicOutlined, SortDescendingOutlined, StrikethroughOutlined, UnderlineOutlined, } from "@ant-design/icons"; // Ant Design icon
import axios from 'axios';
function ModuleCouponsContent(props) {
  //console.log(props);
  const { type, rowindex, columnindex, moduleindex } = props.data.indexes;
  let items = [...props.data.data];
  let item = {
    ...items[rowindex].data[columnindex].data[moduleindex]["settings"],
  };
  //console.log(item);

  const updateParent = (updatedFields) => {
    const reorderedObject = {};
    updatedFields.forEach(([key, value], index) => {
      reorderedObject[key] = {
        ...value,
        priority: (index + 1) * 10,
      };
    });
    item.fields = reorderedObject;
    items[rowindex].data[columnindex].data[moduleindex]["settings"] = item;
    props.onSettingChange(items);
  };

  //console.log(activeField);
  return (
    <>
      <div className="billing-fields-wrapper">
        <div className="field-settings-panel">
          <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
            <label>Label:</label>
            <Input
              value={item?.label}
              onChange={(e) => {
                const updated = { ...item, label: e.target.value };
                items[rowindex].data[columnindex].data[moduleindex]["settings"] = updated;
                props.onSettingChange(items);
              }}
            />
          </div>
          <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
            <label>Placeholder:</label>
            <Input
              value={item?.placeholder}
              onChange={(e) => {
                const updated = { ...item, placeholder: e.target.value };
                items[rowindex].data[columnindex].data[moduleindex]["settings"] = updated;
                props.onSettingChange(items);
              }}
            />
          </div>
          <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
            <label>Button Text:</label>
            <Input
              value={item?.btn_text}
              onChange={(e) => {
                const updated = { ...item, btn_text: e.target.value };
                items[rowindex].data[columnindex].data[moduleindex]["settings"] = updated;
                props.onSettingChange(items);
              }}
            />
          </div>
        </div>
      </div>
    </>
  )
}


export default ModuleCouponsContent;
