import React, { useEffect, useState } from "react";
import { Select, Switch, Input, Button, ColorPicker, notification } from "antd";
import ContentIcons from "./ContentComponents/ContentIcons";
import { DragDropContext, Draggable, Droppable } from "react-beautiful-dnd";
import {
  SettingOutlined, ArrowLeftOutlined, DeleteOutlined, FontSizeOutlined,
  ItalicOutlined, SortDescendingOutlined, StrikethroughOutlined, UnderlineOutlined,
  EyeOutlined, EyeInvisibleOutlined
} from "@ant-design/icons"; // Ant Design icon
import axios from 'axios';
function ModuleBillingFieldsContent(props) {
  console.log(props);
  const { type, rowindex, columnindex, moduleindex } = props.data.indexes;
  let items = [...props.data.data];
  let item = {
    ...items[rowindex].data[columnindex].data[moduleindex]["settings"],
  };
  console.log(item);
  const [fields, setFields] = useState(Object.entries(item.fields).sort((a, b) => a[1].priority - b[1].priority));
  //const [checkLabel, setCheckLabel] = useState(item.label.is_label === 'false' ? false : true);
  //const [labelInput, setLabelInput] = useState(item.label.value);
  const [iconsArray, setIconsArray] = useState("");
  const path_url = trusty_woo_ajaxObject.plugin_path;
  let icons_url = path_url + "admin/fa-icons/fontawesome-5.json";
  const [isModalVisible, setIsModalVisible] = useState(false);
  const [activeField, setActiveField] = useState(null); // Holds current field data
  const [activeFieldId, setActiveFieldId] = useState(null);
  const [newFieldLabel, setNewFieldLabel] = useState("");
  const [fontFamilyArray, setFontFamilyArray] = useState("");
  const site_url = trusty_woo_ajaxObject.plugin_path;
  let url = site_url + "admin/google-fonts.json";
  let fstyle = "normal";
  let trans = "inherit";
  let uldcor = "inherit";
  useEffect(() => {
    const fetchFonts = async () => {
      try {
        const response = await axios.get(url);
        // console.log(response);
        if (response?.data?.items) {
          setFontFamilyArray(response.data.items);
        }
      } catch (error) {
        console.error("Error ", error);
      }
    };
    fetchFonts();
  }, []);


  useEffect(() => {
    const fetchIcons = async () => {
      try {
        const response = await axios.get(icons_url);
        if (response.data) {
          setIconsArray(response.data);
        }
      } catch (error) {
        console.error("Error ", error);
      }
    };

    fetchIcons();
  }, []);
  const handleDragEnd = (result) => {
    if (!result.destination) return;
    const reordered = Array.from(fields);
    const [moved] = reordered.splice(result.source.index, 1);
    reordered.splice(result.destination.index, 0, moved);
    // Update local state
    setFields(reordered);
    // Convert reordered array back to object
    const reorderedObject = {};
    reordered.forEach(([key, value], index) => {
      // Optionally update priority to reflect new position
      reorderedObject[key] = {
        ...value,
        priority: (index + 1) * 10
      };
    });
    // Update the actual data structure
    item.fields = reorderedObject; // ✅ CORRECT
    items[rowindex].data[columnindex].data[moduleindex]["settings"] = item;
    console.log(items);
    // Apply update
    props.onSettingChange(items);
  };
  const openFieldSettings = (fieldId, fieldData) => {
    setActiveField({ id: fieldId, ...fieldData });
    setActiveFieldId(fieldId);
    setIsModalVisible(true);
  };
  const updateParent = (updatedFields) => {
    const reorderedObject = {};
    updatedFields.forEach(([key, value], index) => {
      reorderedObject[key] = {
        ...value,
        priority: (index + 1) * 10,
      };
    });
    item.fields = reorderedObject;
    items[rowindex].data[columnindex].data[moduleindex]["settings"] = item;
    props.onSettingChange(items);
  };
  const sanitizeKey = (label) => {
    return (
      "billing_" +
      label
        .toLowerCase()
        .trim()
        .replace(/\s+/g, '_')         // replace spaces with underscores
        .replace(/[^a-z0-9_]/g, '')   // remove invalid characters
    );
  };

  const handleAddField = () => {
    if (!newFieldLabel) return;

    // Generate a new unique ID for the field
    const newId = Date.now().toString();
    const fieldKey = sanitizeKey(newFieldLabel);
    const newField = {
      key: fieldKey,
      label: newFieldLabel,
      type: "text",
      required: false,
      class: ["form-row-input"],
      custom_attributes: [],
      autocomplete: "",
      priority: (fields.length + 1) * 10,
    };

    const updatedFields = [...fields, [newId, newField]];
    setFields(updatedFields);
    setNewFieldLabel("");
    updateParent(updatedFields);
  };
  const handleRemoveField = (fieldId, field) => {
    console.log(fieldId, field);
    if (field['woo_default'] === true) {
      notification.open({
        message: 'Default field cannot be removed.',
        className: "layout-saved-note",
        duration: 3,
        onClick: () => {
          // Optional: Handle notification click if needed
          // console.log("Notification Clicked!");
        },
      });
      return false;
    }
    const updatedFields = fields.filter(([id]) => id !== fieldId);
    setFields(updatedFields);
    updateParent(updatedFields);
  };
  const disableField = (fieldId, field) => {
    const updatedFields = fields.map(([id, f]) => {
      if (id === fieldId && f.woo_default === true) {
        return [id, { ...f, disable: true }];
      }
      return [id, f];
    });
  
    setFields(updatedFields);
    updateParent(updatedFields);
  };
  
  const enableField = (fieldId, field) => {
    const updatedFields = fields.map(([id, f]) => {
      if (id === fieldId && f.woo_default === true) {
        return [id, { ...f, disable: false }];
      }
      return [id, f];
    });
  
    setFields(updatedFields);
    updateParent(updatedFields);
  };
  
  const onChangeStyle = (style) => {
    // console.log(style);
    props.onChangeStyle(style);
  };


  //console.log(activeField);
  return (
    <>
      <div className="billing-fields-wrapper">
        {!isModalVisible ? (
          <>
            <DragDropContext onDragEnd={handleDragEnd}>
              <Droppable droppableId="billing-fields">
                {(provided) => (
                  <div {...provided.droppableProps} ref={provided.innerRef}>
                    {fields.map(([fieldId, field], index) => (
                      <Draggable key={fieldId} draggableId={fieldId} index={index}>
                        {(provided) => (
                          <div
                            className={`drag-drop-field-wrapper`}
                            ref={provided.innerRef}
                            {...provided.draggableProps}
                            {...provided.dragHandleProps}
                          >
                            <div className="custom-woo-field-label">
                              <span className="custom-woo-field-sett-label">{field.label}</span>
                              <div className="custom-woo-manage-icons-right">
                                <SettingOutlined
                                  style={{ cursor: "pointer" }}
                                  onClick={() => openFieldSettings(fieldId, field)}
                                />
                                {field['woo_default'] !== true &&
                                  <DeleteOutlined
                                    style={{ cursor: "pointer", color: "red" }}
                                    onClick={() => handleRemoveField(fieldId, field)}
                                  />
                                }
                                {field['woo_default'] === true && field?.['disable']===false &&
                                  <EyeOutlined 
                                    style={{ cursor: "pointer", color: "red" }}
                                    onClick={() => disableField(fieldId, field)}
                                  />
                                }
                                {field['woo_default'] === true && field?.['disable']===true &&
                                  <EyeInvisibleOutlined
                                    style={{ cursor: "pointer", color: "#b9b7b7" }}
                                    onClick={() => enableField(fieldId, field)}
                                  />
                                }
                              </div>
                            </div>
                          </div>
                        )}
                      </Draggable>
                    ))}
                    {provided.placeholder}
                  </div>
                )}
              </Droppable>
            </DragDropContext>
            <div className="custom-woo-add-field-wrapper">
              <Input
                placeholder="Field Label"
                value={newFieldLabel}
                onChange={(e) => setNewFieldLabel(e.target.value)}
              />
              <Button type="primary" onClick={handleAddField}>
                Add Field
              </Button>
            </div>
          </>
        ) : (
          <>
            <div className="field-settings-panel">
              <Button
                type="link"
                icon={<ArrowLeftOutlined />}
                onClick={() => {
                  setActiveField(null);
                  setActiveFieldId(null);
                  setIsModalVisible(false);
                }}
                style={{ marginBottom: 10, padding: 0 }}
              >
                Back
              </Button>

              <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                <label>Label:</label>
                <Input
                  value={activeField.label}
                  onChange={(e) => {
                    const updated = { ...activeField, label: e.target.value };
                    setActiveField(updated);

                    const updatedFields = [...fields];
                    const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                    if (idx !== -1) {
                      updatedFields[idx][1].label = e.target.value;
                      setFields(updatedFields);
                      updateParent(updatedFields);
                    }
                  }}
                />
              </div>

              <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                <label>Type:</label>
                <Select
                  value={activeField.type}
                  onChange={(val) => {
                    const updated = { ...activeField, type: val };
                    setActiveField(updated);

                    const updatedFields = [...fields];
                    const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                    if (idx !== -1) {
                      updatedFields[idx][1].type = val;
                      setFields(updatedFields);
                      updateParent(updatedFields);
                    }
                  }}
                  style={{ width: "100%" }}
                  options={[
                    { label: "Text", value: "text" },
                    { label: "Password", value: "password" },
                    { label: "Email", value: "email" },
                    { label: "Number", value: "number" },
                    { label: "Tel", value: "tel" },
                    { label: "Textarea", value: "textarea" },
                    { label: "Select", value: "select" },
                    { label: "Checkbox", value: "checkbox" },
                    { label: "Radio", value: "radio" },
                    { label: "Country", value: "country" },
                    { label: "State", value: "state" },
                    { label: "Heading", value: "heading" },
                  ]}
                />
              </div>

              {(activeField.type === 'select' || activeField.type === 'checkbox' || activeField.type === 'radio') && (
                <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                  <label>Options (key:value Pair):</label>
                  <Input.TextArea
                    rows={4}
                    placeholder="red:Red,green:Green"
                    value={activeField.options || ""}
                    onChange={(e) => {
                      const updated = { ...activeField, options: e.target.value };
                      setActiveField(updated);

                      const updatedFields = [...fields];
                      const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                      if (idx !== -1) {
                        updatedFields[idx][1].options = e.target.value;
                        setFields(updatedFields);
                        updateParent(updatedFields);
                      }
                    }}
                  />
                </div>
              )}

              {activeField.type != 'heading' && activeField.type != 'select' && activeField.type != 'checkbox' && activeField.type != 'radio' && activeField.type != 'country' && activeField.type != 'state' && (
                <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                  <label>Placeholder:</label>
                  <Input
                    value={activeField.placeholder}
                    onChange={(e) => {
                      const updated = { ...activeField, placeholder: e.target.value };
                      setActiveField(updated);

                      const updatedFields = [...fields];
                      const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                      if (idx !== -1) {
                        updatedFields[idx][1].placeholder = e.target.value;
                        setFields(updatedFields);
                        updateParent(updatedFields);
                      }
                    }}
                  />
                </div>
              )}
              {activeField.type != 'heading' && (
                <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                  <label>Width : </label>
                  <Select
                    value={activeField.width || "full"}
                    onChange={(val) => {
                      const updated = { ...activeField, width: val };
                      setActiveField(updated);

                      const updatedFields = [...fields];
                      const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                      if (idx !== -1) {
                        updatedFields[idx][1].width = val;
                        setFields(updatedFields);
                        updateParent(updatedFields);
                      }
                    }}
                    options={[
                      { label: "Half", value: "half" },
                      { label: "Full", value: "full" }
                    ]}
                  />
                </div>
              )}
              {activeField.type != 'heading' && (
                <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                  <label>Required:</label>
                  <Switch
                    checked={activeField.required}
                    onChange={(val) => {
                      const updated = { ...activeField, required: val };
                      setActiveField(updated);

                      const updatedFields = [...fields];
                      const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                      if (idx !== -1) {
                        updatedFields[idx][1].required = val;
                        setFields(updatedFields);
                        updateParent(updatedFields);
                      }
                    }}
                  />
                </div>
              )}


              {activeField.required && (
                <>
                  <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                    <label>Validation Message:</label>
                    <Input
                      placeholder="This field is required"
                      value={activeField.validation_message || ""}
                      onChange={(e) => {
                        const updated = { ...activeField, validation_message: e.target.value };
                        setActiveField(updated);

                        const updatedFields = [...fields];
                        const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                        if (idx !== -1) {
                          updatedFields[idx][1].validation_message = e.target.value;
                          setFields(updatedFields);
                          updateParent(updatedFields);
                        }
                      }}
                    />
                  </div>

                  <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                    <label>Validation Message Position:</label>
                    <Select
                      value={activeField.validation_position || "bottom"}
                      onChange={(val) => {
                        const updated = { ...activeField, validation_position: val };
                        setActiveField(updated);

                        const updatedFields = [...fields];
                        const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                        if (idx !== -1) {
                          updatedFields[idx][1].validation_position = val;
                          setFields(updatedFields);
                          updateParent(updatedFields);
                        }
                      }}
                      options={[
                        { label: "Bottom of Field", value: "bottom" },
                        { label: "Top of Field", value: "top" }
                      ]}
                    />
                  </div>


                </>
              )}
              {activeField.type != 'heading' && (
                <>
                  <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                    <label>Display in Emails:</label>
                    <Switch
                      checked={activeField.display_in_email || false}
                      onChange={(val) => {
                        const updated = { ...activeField, display_in_email: val };
                        setActiveField(updated);

                        const updatedFields = [...fields];
                        const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                        if (idx !== -1) {
                          updatedFields[idx][1].display_in_email = val;
                          setFields(updatedFields);
                          updateParent(updatedFields);
                        }
                      }}
                    />
                  </div>

                  <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                    <label>Display in Order Details Page:</label>
                    <Switch
                      checked={activeField.display_in_order || false}
                      onChange={(val) => {
                        const updated = { ...activeField, display_in_order: val };
                        setActiveField(updated);

                        const updatedFields = [...fields];
                        const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                        if (idx !== -1) {
                          updatedFields[idx][1].display_in_order = val;
                          setFields(updatedFields);
                          updateParent(updatedFields);
                        }
                      }}
                    />
                  </div>
                </>
              )}

              {activeField.type === 'heading' && (
                <>
                  <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                    <label>Heading Type : </label>
                    <Select
                      value={activeField.heading_type || "h2"}
                      onChange={(val) => {
                        const updated = { ...activeField, heading_type: val };
                        setActiveField(updated);

                        const updatedFields = [...fields];
                        const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                        if (idx !== -1) {
                          updatedFields[idx][1].heading_type = val;
                          setFields(updatedFields);
                          updateParent(updatedFields);
                        }
                      }}
                      options={[
                        { label: "H1", value: "h1" },
                        { label: "H2", value: "h2" },
                        { label: "H3", value: "h3" },
                        { label: "H4", value: "h4" },
                        { label: "H5", value: "h5" },
                        { label: "H6", value: "h6" }


                      ]}
                    />
                  </div>


                  <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                    <label>Font Family</label>
                    <Select style={{ width: "100%", }}
                      onChange={(val) => {
                        const updated = {
                          ...activeField,
                          style: {
                            ...(activeField.style || {}),
                            fontFamily: val,
                          },
                        };
                        setActiveField(updated);

                        const updatedFields = [...fields];
                        const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                        if (idx !== -1) {
                          updatedFields[idx][1].style = {
                            ...(updatedFields[idx][1].style || {}),
                            fontFamily: val,
                          };
                          setFields(updatedFields);
                          updateParent(updatedFields);
                        }
                      }}
                      options={fontFamilyArray ? fontFamilyArray?.map((item, index) => ({
                        label: item.family,
                        value: item.family,
                      })) : ''}
                      value={activeField.style?.fontFamily || "Open Sans"}
                    />
                  </div>

                  <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                    <label>Font Weight</label>
                    <Select style={{ width: "100%", }}
                      onChange={(val) => {
                        const updated = {
                          ...activeField, style: {
                            ...(activeField.style || {}),
                            fontWeight: val,
                          },
                        };
                        setActiveField(updated);

                        const updatedFields = [...fields];
                        const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                        if (idx !== -1) {
                          updatedFields[idx][1].style = {
                            ...(updatedFields[idx][1].style || {}),
                            fontWeight: val,
                          };
                          setFields(updatedFields);
                          updateParent(updatedFields);
                        }
                      }}
                      options={[
                        {
                          value: "300",
                          label: "Light",
                        },
                        {
                          value: "400",
                          label: "Regular",
                        },
                        {
                          value: "600",
                          label: "Semi Bold",
                        },
                        {
                          value: "700",
                          label: "Bold",
                        },
                        {
                          value: "800",
                          label: "Ultra Bold",
                        },
                      ]}
                      value={activeField.fontWeight || "400"}
                    />
                  </div>

                  <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                    <label>Font Style</label>
                    <div className="style-icons-wrapped">
                      <ItalicOutlined
                        className={activeField?.style?.fontStyle === "italic" ? "active" : ""}
                        onClick={() => {
                          const newStyle = activeField?.style?.fontStyle === "italic" ? "normal" : "italic";
                          //const updated = { ...activeField, fontStyle: newStyle };
                          const updated = {
                            ...activeField, style: {
                              ...(activeField.style || {}),
                              fontStyle: newStyle,
                            },
                          };
                          setActiveField(updated);

                          const updatedFields = [...fields];
                          const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                          if (idx !== -1) {
                            //updatedFields[idx][1].fontStyle = newStyle;
                            updatedFields[idx][1].style = {
                              ...(updatedFields[idx][1].style || {}),
                              fontStyle: newStyle,
                            };
                            setFields(updatedFields);
                            updateParent(updatedFields);
                          }
                        }}
                      />

                      <SortDescendingOutlined
                        className={activeField?.style?.textTransform === "uppercase" ? "active" : ""}
                        onClick={() => {
                          const newStyle = activeField?.style?.textTransform === "uppercase" ? "inherit" : "uppercase";
                          const updated = {
                            ...activeField, style: {
                              ...(activeField.style || {}),
                              textTransform: newStyle,
                            },
                          };
                          setActiveField(updated);

                          const updatedFields = [...fields];
                          const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                          if (idx !== -1) {
                            updatedFields[idx][1].style = {
                              ...(updatedFields[idx][1].style || {}),
                              textTransform: newStyle,
                            };
                            setFields(updatedFields);
                            updateParent(updatedFields);
                          }
                        }}
                      />
                      <FontSizeOutlined
                        className={activeField?.style?.textTransform === "capitalize" ? "active" : ""}
                        onClick={() => {
                          const newStyle = activeField?.style?.textTransform === "capitalize" ? "inherit" : "capitalize";
                          //const updated = { ...activeField, textTransform: newStyle };
                          const updated = {
                            ...activeField, style: {
                              ...(activeField.style || {}),
                              textTransform: newStyle,
                            },
                          };
                          setActiveField(updated);

                          const updatedFields = [...fields];
                          const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                          if (idx !== -1) {
                            updatedFields[idx][1].style = {
                              ...(updatedFields[idx][1].style || {}),
                              textTransform: newStyle,
                            };
                            setFields(updatedFields);
                            updateParent(updatedFields);
                          }
                        }}
                      />
                      <UnderlineOutlined
                        className={activeField?.style?.textDecoration === "underline" ? "active" : ""}
                        onClick={() => {
                          const newStyle = activeField?.style?.textDecoration === "underline" ? "inherit" : "underline";
                          // const updated = { ...activeField, textDecoration: newStyle };
                          const updated = {
                            ...activeField, style: {
                              ...(activeField.style || {}),
                              textDecoration: newStyle,
                            },
                          };
                          setActiveField(updated);

                          const updatedFields = [...fields];
                          const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                          if (idx !== -1) {
                            updatedFields[idx][1].style = {
                              ...(updatedFields[idx][1].style || {}),
                              textDecoration: newStyle,
                            };
                            setFields(updatedFields);
                            updateParent(updatedFields);
                          }
                        }}
                      />
                      <StrikethroughOutlined
                        className={activeField?.style?.textDecoration === "line-through" ? "active" : ""}
                        onClick={() => {
                          const newStyle = activeField?.style?.textDecoration === "line-through" ? "inherit" : "line-through";
                          // const updated = { ...activeField, textDecoration: newStyle };
                          const updated = {
                            ...activeField, style: {
                              ...(activeField.style || {}),
                              textDecoration: newStyle,
                            },
                          };
                          setActiveField(updated);

                          const updatedFields = [...fields];
                          const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                          if (idx !== -1) {
                            updatedFields[idx][1].style = {
                              ...(updatedFields[idx][1].style || {}),
                              textDecoration: newStyle,
                            };
                            setFields(updatedFields);
                            updateParent(updatedFields);
                          }
                        }}
                      />
                    </div>
                  </div>

                  <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                    <label>Color:</label>
                    <ColorPicker
                      value={activeField?.style?.color || "#000000"}
                      onChange={(color) => {
                        const hexColor = color.toHexString(); // Convert to HEX
                        //const updated = { ...activeField, color: hexColor };
                        const updated = {
                          ...activeField, style: {
                            ...(activeField.style || {}),
                            color: hexColor,
                          },
                        };
                        setActiveField(updated);

                        const updatedFields = [...fields];
                        const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                        if (idx !== -1) {
                          updatedFields[idx][1].style = {
                            ...(updatedFields[idx][1].style || {}),
                            color: hexColor,
                          };
                          setFields(updatedFields);
                          updateParent(updatedFields);
                        }
                      }}

                    />
                  </div>

                  <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                    <label>Font Size (px):</label>
                    <Input
                      type="number"
                      min={5}
                      max={100}
                      value={activeField?.style?.fontSize || "14"}
                      placeholder="e.g. 16"
                      onChange={(e) => {
                        // const updated = { ...activeField, fontSize: e.target.value };
                        const updated = {
                          ...activeField, style: {
                            ...(activeField.style || {}),
                            fontSize: e.target.value,
                          },
                        };
                        setActiveField(updated);
                        const updatedFields = [...fields];
                        const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                        if (idx !== -1) {
                          //updatedFields[idx][1].fontSize = e.target.value;
                          updatedFields[idx][1].style = {
                            ...(updatedFields[idx][1].style || {}),
                            fontSize: e.target.value,
                          };
                          setFields(updatedFields);
                          updateParent(updatedFields);
                        }
                      }}
                    />
                  </div>

                  <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                    <label>Line Height (px):</label>
                    <Input
                      type="number"
                      min={10}
                      max={100}
                      value={activeField?.style?.lineHeight || "20"}
                      placeholder="e.g. 16"
                      onChange={(e) => {
                        //const updated = { ...activeField, lineHeight: e.target.value };
                        const updated = {
                          ...activeField, style: {
                            ...(activeField.style || {}),
                            lineHeight: e.target.value,
                          },
                        };
                        setActiveField(updated);

                        const updatedFields = [...fields];
                        const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                        if (idx !== -1) {
                          //updatedFields[idx][1].lineHeight = e.target.value;
                          updatedFields[idx][1].style = {
                            ...(updatedFields[idx][1].style || {}),
                            lineHeight: e.target.value,
                          };
                          setFields(updatedFields);
                          updateParent(updatedFields);
                        }
                      }}
                    />
                  </div>

                  <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                    <label>Padding Top (px):</label>
                    <Input
                      type="number"
                      min={0}
                      max={100}
                      value={activeField?.style?.paddingTop || "5"}
                      placeholder="e.g. 10"
                      onChange={(e) => {
                        // const updated = { ...activeField, paddingTop: e.target.value };
                        const updated = {
                          ...activeField, style: {
                            ...(activeField.style || {}),
                            paddingTop: e.target.value,
                          },
                        };
                        setActiveField(updated);

                        const updatedFields = [...fields];
                        const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                        if (idx !== -1) {
                          // updatedFields[idx][1].paddingTop = e.target.value;
                          updatedFields[idx][1].style = {
                            ...(updatedFields[idx][1].style || {}),
                            paddingTop: e.target.value,
                          };
                          setFields(updatedFields);
                          updateParent(updatedFields);
                        }
                      }}
                    />
                  </div>

                  <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                    <label>Padding Right (px):</label>
                    <Input
                      type="number"
                      min={0}
                      max={100}
                      value={activeField?.style?.paddingRight || "0"}
                      placeholder="e.g. 10"
                      onChange={(e) => {
                        //const updated = { ...activeField, paddingRight: e.target.value };
                        const updated = {
                          ...activeField, style: {
                            ...(activeField.style || {}),
                            paddingRight: e.target.value,
                          },
                        };
                        setActiveField(updated);

                        const updatedFields = [...fields];
                        const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                        if (idx !== -1) {
                          //updatedFields[idx][1].paddingRight = e.target.value;
                          updatedFields[idx][1].style = {
                            ...(updatedFields[idx][1].style || {}),
                            paddingRight: e.target.value,
                          };
                          setFields(updatedFields);
                          updateParent(updatedFields);
                        }
                      }}
                    />
                  </div>

                  <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                    <label>Padding Bottom (px):</label>
                    <Input
                      type="number"
                      min={0}
                      max={100}
                      value={activeField?.style?.paddingBottom || "5"}
                      placeholder="e.g. 10"
                      onChange={(e) => {
                        //const updated = { ...activeField, paddingBottom: e.target.value };
                        const updated = {
                          ...activeField, style: {
                            ...(activeField.style || {}),
                            paddingBottom: e.target.value,
                          },
                        };
                        setActiveField(updated);

                        const updatedFields = [...fields];
                        const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                        if (idx !== -1) {
                          //updatedFields[idx][1].paddingBottom = e.target.value;
                          updatedFields[idx][1].style = {
                            ...(updatedFields[idx][1].style || {}),
                            paddingBottom: e.target.value,
                          };
                          setFields(updatedFields);
                          updateParent(updatedFields);
                        }
                      }}
                    />
                  </div>

                  <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                    <label>Padding Left (px):</label>
                    <Input
                      type="number"
                      min={0}
                      max={100}
                      value={activeField?.style?.paddingLeft || "0"}
                      placeholder="e.g. 10"
                      onChange={(e) => {
                        //const updated = { ...activeField, paddingLeft: e.target.value };
                        const updated = {
                          ...activeField, style: {
                            ...(activeField.style || {}),
                            paddingLeft: e.target.value,
                          },
                        };
                        setActiveField(updated);
                        const updatedFields = [...fields];
                        const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                        if (idx !== -1) {
                          //updatedFields[idx][1].paddingLeft = e.target.value;
                          updatedFields[idx][1].style = {
                            ...(updatedFields[idx][1].style || {}),
                            paddingLeft: e.target.value,
                          };
                          setFields(updatedFields);
                          updateParent(updatedFields);
                        }
                      }}
                    />
                  </div>

                  <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                    <label>Margin Top (px):</label>
                    <Input
                      type="number"
                      min={0}
                      max={100}
                      value={activeField?.style?.marginTop || "0"}
                      placeholder="e.g. 10"
                      onChange={(e) => {
                        //const updated = { ...activeField, marginTop: e.target.value };
                        const updated = {
                          ...activeField, style: {
                            ...(activeField.style || {}),
                            marginTop: e.target.value,
                          },
                        };
                        setActiveField(updated);
                        const updatedFields = [...fields];
                        const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                        if (idx !== -1) {
                          //updatedFields[idx][1].marginTop = e.target.value;
                          updatedFields[idx][1].style = {
                            ...(updatedFields[idx][1].style || {}),
                            marginTop: e.target.value,
                          };
                          setFields(updatedFields);
                          updateParent(updatedFields);
                        }
                      }}
                    />
                  </div>

                  <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                    <label>Margin Right (px):</label>
                    <Input
                      type="number"
                      min={0}
                      max={100}
                      value={activeField?.style?.marginRight || "0"}
                      placeholder="e.g. 10"
                      onChange={(e) => {
                        //const updated = { ...activeField, marginRight: e.target.value };
                        const updated = {
                          ...activeField, style: {
                            ...(activeField.style || {}),
                            marginRight: e.target.value,
                          },
                        };
                        setActiveField(updated);

                        const updatedFields = [...fields];
                        const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                        if (idx !== -1) {
                          //updatedFields[idx][1].marginRight = e.target.value;
                          updatedFields[idx][1].style = {
                            ...(updatedFields[idx][1].style || {}),
                            marginRight: e.target.value,
                          };
                          setFields(updatedFields);
                          updateParent(updatedFields);
                        }
                      }}
                    />
                  </div>

                  <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                    <label>Margin Bottom (px):</label>
                    <Input
                      type="number"
                      min={0}
                      max={100}
                      value={activeField?.style?.marginBottom || "0"}
                      placeholder="e.g. 10"
                      onChange={(e) => {
                        //const updated = { ...activeField, marginBottom: e.target.value };
                        const updated = {
                          ...activeField, style: {
                            ...(activeField.style || {}),
                            marginBottom: e.target.value,
                          },
                        };
                        setActiveField(updated);

                        const updatedFields = [...fields];
                        const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                        if (idx !== -1) {
                          //updatedFields[idx][1].marginBottom = e.target.value;
                          updatedFields[idx][1].style = {
                            ...(updatedFields[idx][1].style || {}),
                            marginBottom: e.target.value,
                          };
                          setFields(updatedFields);
                          updateParent(updatedFields);
                        }
                      }}
                    />
                  </div>

                  <div className='custom-woo-setting-field-wrap' style={{ marginBottom: 10 }}>
                    <label>Margin Left (px):</label>
                    <Input
                      type="number"
                      min={0}
                      max={100}
                      value={activeField?.style?.marginLeft || "0"}
                      placeholder="e.g. 10"
                      onChange={(e) => {
                        //const updated = { ...activeField, marginLeft: e.target.value };
                        const updated = {
                          ...activeField, style: {
                            ...(activeField.style || {}),
                            marginLeft: e.target.value,
                          },
                        };
                        setActiveField(updated);

                        const updatedFields = [...fields];
                        const idx = updatedFields.findIndex(([id]) => id === activeFieldId);
                        if (idx !== -1) {
                          //updatedFields[idx][1].marginLeft = e.target.value;
                          updatedFields[idx][1].style = {
                            ...(updatedFields[idx][1].style || {}),
                            marginLeft: e.target.value,
                          };
                          setFields(updatedFields);
                          updateParent(updatedFields);
                        }
                      }}
                    />
                  </div>

                </>
              )}


            </div>
          </>)}
      </div>


    </>
  );
}

export default ModuleBillingFieldsContent;
