import React, { useState } from "react";
import { Select, Input, Switch } from "antd";

function ContentLink(props) {
  //console.log(props);
  const { type, rowindex, columnindex, moduleindex } = props.indexes;
  let items = [...props.data];
  let item = {
    ...items[rowindex].data[columnindex].data[moduleindex]["settings"],
  };
  let visibility = "";
  let ltype = "post-url";
  let cLink = "";
  let target = "same-tab";
  if (item?.link?.visibility) {
    visibility = item.link.visibility;
  }
  if (item?.link?.type) {
    ltype = item.link.type;
  }
  if (item?.link?.customlink) {
    cLink = item.link.customlink;
  }
  if (item?.link?.target) {
    target = item.link.target;
  }
  const [linkSwitch, setLinkSwitch] = useState(visibility);
  const [linkType, setLinkType] = useState(ltype);
  const [customLink, setCustomLink] = useState(cLink);
  const [linkTarget, setLinkTarget] = useState(target);

  let link = {
    visibility: linkSwitch,
    type: linkType,
    customlink: customLink,
    target: linkTarget,
    condition: false,
  };
  const onLinkSwitch = (checked) => {
    //console.log(checked);
    setLinkSwitch(checked);
    let lnk = { ...link };
    lnk.visibility = checked;
    item.link = { ...link, ...lnk };
    items[rowindex].data[columnindex].data[moduleindex]["settings"] = item;
    props.onSettingChange(props.data);
  };

  const handleLinkTypeChange = (value) => {
    setLinkType(value);
    let lnk = { ...link };
    lnk.type = value;
    item.link = { ...link, ...lnk };
    items[rowindex].data[columnindex].data[moduleindex]["settings"] = item;
    props.onSettingChange(props.data);
  };

  const handleCustomLink = (e) => {
    const value = e.target.value;
    setCustomLink(value);
    let lnk = { ...link };
    lnk.customlink = value;
    item.link = { ...link, ...lnk };
    items[rowindex].data[columnindex].data[moduleindex]["settings"] = item;
    props.onSettingChange(props.data);
  };
  const handleLinkTarget = (value) => {
    setLinkTarget(value);
    let lnk = { ...link };
    lnk.target = value;
    item.link = { ...link, ...lnk };
    items[rowindex].data[columnindex].data[moduleindex]["settings"] = item;
    props.onSettingChange(props.data);
  };
  return (
    <>
      <div class="module-content-tab-row">
        <label>{props.title}</label>
        <div className="module-content-icon-switch">
          <Switch onChange={onLinkSwitch} checked={linkSwitch} />
        </div>
      </div>
      {linkSwitch && (
        <>
          <div class="module-content-tab-row">
            <label>Link Type</label>
            <Select
              defaultValue="post-url"
              style={{
                width: "100%",
              }}
              onChange={handleLinkTypeChange}
              value={linkType}
              options={[
                {
                  value: "post-url",
                  label: "Post URL",
                },
                {
                  value: "custom-url",
                  label: "custom-url",
                },
              ]}
            />
          </div>
          {linkType == "custom-url" && (
            <div class="module-content-tab-row">
              <label>Custom Link</label>
              <Input
                placeholder="https://example.com/"
                onChange={handleCustomLink}
                value={customLink}
              />
            </div>
          )}

          <div class="module-content-tab-row">
            <label>Link Target</label>
            <Select
              defaultValue="same-tab"
              style={{
                width: "100%",
              }}
              onChange={handleLinkTarget}
              value={linkTarget}
              options={[
                {
                  value: "same-tab",
                  label: "In The Same Window",
                },
                {
                  value: "new-tab",
                  label: "In The New Tab",
                },
              ]}
            />
          </div>
        </>
      )}
    </>
  );
}

export default ContentLink;
