import React, { useState } from "react";
import { Select, Input, Switch } from "antd";
function ContentIcons(props) {
  const [iconsArray, setIconsArray] = useState(props?.iconsArray);
  const { type, rowindex, columnindex, moduleindex } = props.indexes;
  let items = [...props.data];
  let item = '';
  if (props?.moduleIcon == 'custom-field-label') {
    item = {
      ...items[rowindex].data[columnindex].data[moduleindex]["settings"]["label"],
    };
  } else {
    item = {
      ...items[rowindex].data[columnindex].data[moduleindex]["settings"],
    };
  }


  const [searchString, setSearchString] = useState("");
  const [iconSwitch, setIconSwitch] = useState(item?.icons?.visibility);
  let pos = "";
  if (item?.icons?.position) {
    pos = item.icons.position;
  } else {
    pos = `before-${props.labelType}`;

  }
  let icn = "";
  if (item?.icons?.icon) {
    icn = item.icons.icon;
  } else {
    icn = "";
  }
  const [iconPosition, setIconPosition] = useState(pos);
  const [selectedIcon, setSelectedIcon] = useState(icn);
  let icons = {
    visibility: iconSwitch,
    icon: selectedIcon,
    position: iconPosition
  }
  const handleIconSelect = (icon) => {
    setSelectedIcon(icon);
    let ic = { ...icons };
    ic.icon = icon;
    item.icons = { ...icons, ...ic };
    if (props?.moduleIcon == 'custom-field-label') {
      items[rowindex].data[columnindex].data[moduleindex]["settings"]["label"] = item;
    } else {
      items[rowindex].data[columnindex].data[moduleindex]["settings"] = item;
    }
    props.onSettingChange(props.data);
  };
  const handlePositionChange = (value) => {
    //console.log(value);
    setIconPosition(value);
    let ic = { ...icons };
    ic.position = value;
    item.icons = { ...icons, ...ic };
    if (props?.moduleIcon == 'custom-field-label') {
      items[rowindex].data[columnindex].data[moduleindex]["settings"]["label"] = item;
    } else {
      items[rowindex].data[columnindex].data[moduleindex]["settings"] = item;
    }
    props.onSettingChange(props.data);
  };
  const handleIconSearch = (e) => {
    const searchValue = e.target.value;
    setSearchString(searchValue);
    let newArray = props?.iconsArray.filter(function (item) {
      return item
        .toString()
        .toLowerCase()
        .includes(searchValue.toString().toLowerCase());
    });
    setIconsArray([...newArray]);
  };
  const onIconSwitch = (checked) => {
    setIconSwitch(checked);
    let ic = { ...icons };
    if (checked == false) {
      ic.icon = ""
      setSelectedIcon('');
      setSearchString('')
      setIconsArray([...props?.iconsArray]);
    }
    ic.visibility = checked;
    item.icons = { ...icons, ...ic };

    if (props?.moduleIcon == 'custom-field-label') {
      items[rowindex].data[columnindex].data[moduleindex]["settings"]["label"] = item;
    } else {
      items[rowindex].data[columnindex].data[moduleindex]["settings"] = item;
    }
    props.onSettingChange(props.data);
  };
  return (
    <>
      <div class="module-content-tab-row">
        <label>{props.title}</label>
        <div className="module-content-icon-switch">
          <Switch onChange={onIconSwitch} checked={iconSwitch} />
        </div>
        {iconSwitch ? (
          <>
            <div className="icons-search">
              <Input
                placeholder="Search icon"
                onChange={handleIconSearch}
                value={searchString}
              />
            </div>

            <div className="icons-map">
              {iconsArray?.map((icon, index) => {
                //console.log(icon,index);
                return (
                  <>
                    <i
                      data-icon-name={icon}
                      value={icon}
                      className={`${icon} ${selectedIcon === icon ? "active" : ""
                        }`}
                      onClick={() => handleIconSelect(icon)}
                    ></i>
                  </>
                );
              })}
            </div>
          </>
        ) : (
          ""
        )}
      </div>

      {iconSwitch ? (
        <div class="module-content-tab-row">
          <label>Icon Position</label>
          <Select
            defaultValue={`before-${props.labelType}`}
            style={{
              width: "100%",
            }}
            onChange={handlePositionChange}
            value={iconPosition}
            options={[
              {
                value: `before-${props.labelType}`,
                label: "Before" + " " + props.labelType.charAt(0).toUpperCase() + props.labelType.slice(1),
              },
              {
                value: `after-${props.labelType}`,
                label: "After" + " " + props.labelType.charAt(0).toUpperCase() + props.labelType.slice(1),
              },
            ]}
          />
        </div>
      ) : (
        ""
      )}
    </>
  );
}

export default ContentIcons;
