import React, { useEffect, useState } from "react";
import { CaretDownOutlined } from "@ant-design/icons";
import { Collapse, Col, Row, Switch, Tabs, Skeleton } from "antd";
import axios from "axios";
import SliderMain from "../design-components/common-component/SliderMain";
import SelectMain from "../design-components/common-component/SelectMain";
import ColorMain from "../design-components/common-component/ColorMain";
import AlignMain from "../design-components/common-component/AlignMain";
import BorderMain from "../design-components/common-component/BorderMain";
import BoxShadow from "../design-components/common-component/BoxShadow";
import TextMain from "../design-components/common-component/TextMain";
import ContentImage from "./ModuleContentData/ContentComponents/ContentImage";
import InputMain from "../design-components/common-component/InputMain";
//import CustomFieldSubTab from "../design-components/CustomFieldSubTab";

const DesignTab = (props) => {
  axios.defaults.headers.common['Cache-Control'] = 'no-cache, no-store, must-revalidate';
  axios.defaults.headers.common['Pragma'] = 'no-cache';
  axios.defaults.headers.common['Expires'] = '0';
  //console.log(props);
  const { type, rowindex, columnindex, moduleindex, module } = props.indexes;
  let items = [...props.data];
  let item = {
    ...items[rowindex]?.data[columnindex]?.data[moduleindex],
  };
  //console.log(item);
  //console.log(module);
  const onChangeStyle = (style) => {
    // console.log(style);
    props.onChangeStyle(style);
  };

  const [fontFamilyArray, setFontFamilyArray] = useState("");
  const [hoverSwitchText, setHoverSwitchText] = useState(false);
  const [hoverSwitchSpacing, setHoverSwitchSpacing] = useState(false);
  const [hoverSwitchPosition, setHoverSwitchPosition] = useState(false);
  const [hoverSwitchBg, setHoverSwitchBg] = useState(false);
  const [hoverSwitchAl, setHoverSwitchAl] = useState(false);
  const [hoverSwitchBr, setHoverSwitchBr] = useState(false);
  const [hoverSwitchBs, setHoverSwitchBs] = useState(false);
  const [loading, setLoading] = useState(false);
  const [labelStatus, setLabelStatus] = useState(module.key === 'billing_fields'
    || module.key === 'shipping_fields'
    || module.key === 'order_review'
    || module.key === 'apply_coupon'
    ? true : false);
  const [labelTab, setLabelTab] = useState({ key: 'label', label: 'Label' })
  const [metaTab, setMetaTab] = useState({ key: 'meta', label: 'Meta' })
  const [styleTab, setStyleTab] = useState("container");
  const site_url = trusty_woo_ajaxObject.plugin_path;
  //console.log(styleTab);
  let url = site_url + "admin/google-fonts.json";
  //console.log(url);
  let device = props.deviceSwitch;

  useEffect(() => {
    const fetchFonts = async () => {
      try {
        const response = await axios.get(url);
        // console.log(response);
        if (response?.data?.items) {
          setFontFamilyArray(response.data.items);
        }
      } catch (error) {
        console.error("Error ", error);
      }
    };
    fetchFonts();
  }, []);


  // console.log(module.settings)

  const onHoverSwitchText = (checked) => {
    setHoverSwitchText((checked) => !checked);
  };
  const onHoverSwitchSpacing = (checked) => {
    setHoverSwitchSpacing((checked) => !checked);
  };
  const onHoverSwitchPosition = (checked) => {
    setHoverSwitchPosition((checked) => !checked);
  };
  const onHoverSwitchBg = (checked) => {
    setHoverSwitchBg((checked) => !checked);
  };
  const onHoverSwitchAl = (checked) => {
    setHoverSwitchAl((checked) => !checked);
  };
  const onHoverSwitchBr = (checked) => {
    setHoverSwitchBr((checked) => !checked);
  };
  const onHoverSwitchBs = (checked) => {
    setHoverSwitchBs((checked) => !checked);
  };
  let styleStateSpacing = "default";
  if (hoverSwitchSpacing) {
    styleStateSpacing = "hover";
  }
  let styleStatePosition = "default";
  if (hoverSwitchPosition) {
    styleStatePosition = "hover";
  }
  let styleStateBg = "default";
  if (hoverSwitchBg) {
    styleStateBg = "hover";
  }
  let styleStateAl = "default";
  if (hoverSwitchAl) {
    styleStateAl = "hover";
  }
  let styleStateBr = "default";
  if (hoverSwitchBr) {
    styleStateBr = "hover";
  }
  let styleStateBs = "default";
  if (hoverSwitchBs) {
    styleStateBs = "hover";
  }


  // useEffect(()=>{
  //   if(type!=="module"){
  //     setDesignItems(designItems.filter(item => item.key !== '1'))
  //   }
  //   if(type=="module" &&  module.key=="image"){
  //     setDesignItems(designItems.filter(item => item.key !== '1' && item.key !== '5'))
  //   }
  //   if(type == 'module' && module.key== "customfield" && labelStatus === true){
  //     setDesignItems(designItems.filter(item => item.key !== '1'))
  //   }
  // },[type,styleTab,labelStatus])

  const onChangeTab = (key) => {
    //console.log(key, module, item);
    if (key === 'label') {
      if (!('label' in module.style)) {
        module.style.label = { 'desktop': {}, 'tablet': {}, 'mobile': {} }; // or set default structure
       // console.log('Added missing style.label');
      }
    }
    else if (key === 'meta') {
      if (!('meta' in module.style)) {
        module.style.meta = { 'desktop': {}, 'tablet': {}, 'mobile': {} }; // or set default structure
       // console.log('Added missing style.meta');
      }
    }
    setStyleTab(key);
    // setDeviceSwitch(false)
    setHoverSwitchText(false)
    setHoverSwitchSpacing(false)
    setHoverSwitchPosition(false)
    setHoverSwitchBg(false)
    setHoverSwitchAl(false)
    setHoverSwitchBr(false)
    setHoverSwitchBs(false)
    setLoading(true)
    setTimeout(() => {
      setLoading(false)
    }, 500)

  }

  useEffect(() => {
    if (labelStatus === true) {
      setLabelTab({
        key: 'label',
        label: 'Label',
      })
      setMetaTab({
        key: 'meta',
        label: 'Input',
      })
    }
    else {
      setLabelTab("")
      setMetaTab("")
    }
  }, [labelStatus])
  let tab_items = [
    {
      key: 'container',
      label: 'Container',
    },
    labelTab,
    metaTab,
  ];
  let styleItems = [
    {
      key: "1",
      label: "Text",
      children: (
        <div className="collapse-main-content">
          {/* <div className="hoverswitchguard">
            <Switch
              checkedChildren="hover"
              unCheckedChildren="default"
              onChange={onHoverSwitchText}
              checked={hoverSwitchText}
              className="hoverSwitch"
            />
          </div> */}
          <TextMain
            data={props.data}
            indexes={props.indexes}
            property="text"
            label="Text"
            onChangeStyle={onChangeStyle}
            fonts={fontFamilyArray}
            hoverSwitch={hoverSwitchText}
            deviceSwitch={props.deviceSwitch}
          />
        </div>
      ),
    },
    {
      key: "2",
      label: "Sizing",
      children: (
        <div className="collapse-main-content">
          <SliderMain
            data={props.data}
            indexes={props.indexes}
            property={type == "row" ? "width" : "flexBasis"}
            label="Width"
            defaultSuffix="%"
            defaultValue="100"
            onChangeStyle={onChangeStyle}
            deviceSwitch={props.deviceSwitch}
          />
          <SliderMain
            data={props.data}
            indexes={props.indexes}
            property="height"
            label="Height"
            defaultSuffix="%"
            defaultValue="100"
            onChangeStyle={onChangeStyle}
            deviceSwitch={props.deviceSwitch}
          />
        </div>
      ),
    },
    {
      key: "3",
      label: "Spacing",
      children: (
        <div className="collapse-main-content">
          {/* <div className="hoverswitchguard">
            <Switch
              checkedChildren="hover"
              unCheckedChildren="default"
              onChange={onHoverSwitchSpacing}
              checked={hoverSwitchSpacing}
              className="hoverSwitch"
            />
          </div> */}

          <Row className="without-border">
            {/* <Col span={12}> */}
            <SliderMain
              data={props.data}
              indexes={props.indexes}
              property="paddingTop"
              label="Padding Top"
              defaultSuffix="px"
              defaultValue="10"
              onChangeStyle={onChangeStyle}
              extraClass="colm2"
              styleState={styleStateSpacing}
              deviceSwitch={props.deviceSwitch}
            />
            {/* </Col> */}
            {/* <Col span={12}> */}
            <SliderMain
              data={props.data}
              indexes={props.indexes}
              property="paddingRight"
              label="Padding Right"
              defaultSuffix="px"
              defaultValue="10"
              onChangeStyle={onChangeStyle}
              extraClass="colm2"
              styleState={styleStateSpacing}
              deviceSwitch={props.deviceSwitch}
            />
            {/* </Col> */}
          </Row>
          <Row>
            {/* <Col span={12}> */}
            <SliderMain
              data={props.data}
              indexes={props.indexes}
              property="paddingBottom"
              label="Padding Bottom"
              defaultSuffix="px"
              defaultValue="10"
              onChangeStyle={onChangeStyle}
              extraClass="colm2"
              styleState={styleStateSpacing}
              deviceSwitch={props.deviceSwitch}
            />
            {/* </Col> */}
            {/* <Col span={12}> */}
            <SliderMain
              data={props.data}
              indexes={props.indexes}
              property="paddingLeft"
              label="Padding Left"
              defaultSuffix="px"
              defaultValue="10"
              onChangeStyle={onChangeStyle}
              extraClass="colm2"
              styleState={styleStateSpacing}
              deviceSwitch={props.deviceSwitch}
            />
            {/* </Col> */}
          </Row>
          <Row>
            {/* <Col span={12}> */}
            <SliderMain
              data={props.data}
              indexes={props.indexes}
              property="marginTop"
              label="Margin Top"
              defaultSuffix="px"
              defaultValue="0"
              onChangeStyle={onChangeStyle}
              extraClass="colm2"
              styleState={styleStateSpacing}
              deviceSwitch={props.deviceSwitch}
            />
            {/* </Col> */}
            {/* <Col span={12}> */}
            <SliderMain
              data={props.data}
              indexes={props.indexes}
              property="marginRight"
              label="Margin Right"
              defaultSuffix="px"
              defaultValue="0"
              onChangeStyle={onChangeStyle}
              extraClass="colm2"
              styleState={styleStateSpacing}
              deviceSwitch={props.deviceSwitch}
            />
            {/* </Col> */}
          </Row>
          <Row>
            {/* <Col span={12}> */}
            <SliderMain
              data={props.data}
              indexes={props.indexes}
              property="marginBottom"
              label="Margin Bottom"
              defaultSuffix="px"
              defaultValue="0"
              onChangeStyle={onChangeStyle}
              extraClass="colm2"
              styleState={styleStateSpacing}
              deviceSwitch={props.deviceSwitch}
            />
            {/* </Col>
        <Col span={12}> */}
            <SliderMain
              data={props.data}
              indexes={props.indexes}
              property="marginLeft"
              label="Margin Left"
              defaultSuffix="px"
              defaultValue="0"
              onChangeStyle={onChangeStyle}
              extraClass="colm2"
              styleState={styleStateSpacing}
              deviceSwitch={props.deviceSwitch}
            />
            {/* </Col> */}
          </Row>
        </div>
      ),
    },
    {
      key: "4",
      label: "Positioning",
      children: (
        <div className="collapse-main-content">
          {/* <div className="hoverswitchguard">
            <Switch
              checkedChildren="hover"
              unCheckedChildren="default"
              onChange={onHoverSwitchPosition}
              checked={hoverSwitchPosition}
              className="hoverSwitch"
            />
          </div> */}
          <SelectMain
            data={props.data}
            indexes={props.indexes}
            onChangeStyle={onChangeStyle}
            property="position"
            defaultValue="relative"
            label="Position"
            styleState={styleStatePosition}
            deviceSwitch={props.deviceSwitch}
            options={[
              {
                value: "relative",
                label: "Relative",
              },
              {
                value: "absolute",
                label: "Absolute",
              },
              {
                value: "inherit",
                label: "Inherit",
              },
            ]}
          />
          <InputMain
            data={props.data}
            indexes={props.indexes}
            onChangeStyle={onChangeStyle}
            property="zIndex"
            defaultValue="999"
            label="Z Index"
            styleState={styleStatePosition}
            deviceSwitch={props.deviceSwitch}
          />
          <Row>
            <Col span={12}>
              <SliderMain
                data={props.data}
                indexes={props.indexes}
                property="top"
                label="Top"
                defaultSuffix="px"
                defaultValue="0"
                styleState={styleStatePosition}
                onChangeStyle={onChangeStyle}
                extraClass="colm2"
                deviceSwitch={props.deviceSwitch}
              />
            </Col>
            <Col span={12}>
              <SliderMain
                data={props.data}
                indexes={props.indexes}
                property="right"
                label="Right"
                defaultSuffix="px"
                defaultValue="0"
                styleState={styleStatePosition}
                onChangeStyle={onChangeStyle}
                extraClass="colm2"
                deviceSwitch={props.deviceSwitch}
              />
            </Col>
          </Row>
          <Row>
            <Col span={12}>
              <SliderMain
                data={props.data}
                indexes={props.indexes}
                property="bottom"
                label="Bottom"
                defaultSuffix="px"
                defaultValue="0"
                styleState={styleStatePosition}
                onChangeStyle={onChangeStyle}
                extraClass="colm2"
                deviceSwitch={props.deviceSwitch}
              />
            </Col>
            <Col span={12}>
              <SliderMain
                data={props.data}
                indexes={props.indexes}
                property="left"
                label="Left"
                defaultSuffix="px"
                defaultValue="0"
                styleState={styleStatePosition}
                onChangeStyle={onChangeStyle}
                extraClass="colm2"
                deviceSwitch={props.deviceSwitch}
              />
            </Col>
          </Row>
        </div>
      ),
    },
    {
      key: "5",
      label: "Background",
      children: (
        <div className="collapse-main-content">
          {/* <div className="hoverswitchguard">
            <Switch
              checkedChildren="hover"
              unCheckedChildren="default"
              onChange={onHoverSwitchBg}
              checked={hoverSwitchBg}
              className="hoverSwitch"
            />
          </div> */}
          <ColorMain
            data={props.data}
            indexes={props.indexes}
            property="backgroundColor"
            defaultValue="#333333"
            label="Background Color"
            onChangeStyle={onChangeStyle}
            styleState={styleStateBg}
            deviceSwitch={props.deviceSwitch}
          />
          {type != "module" &&     // hide bg image option from module
            <ContentImage
              data={props.data}
              indexes={props.indexes}
              label="Background Image"
              type="background-image"
              onChangeStyle={onChangeStyle}
              styleState={styleStateBg}
              postData={props.postData}
              deviceSwitch={props.deviceSwitch}
            ></ContentImage>
          }
        </div>
      ),
    },
    {
      key: "6",
      label: "Alignment",
      children: (
        <div className="collapse-main-content">
          {/* <div className="hoverswitchguard">
            <Switch
              checkedChildren="hover"
              unCheckedChildren="default"
              onChange={onHoverSwitchAl}
              checked={hoverSwitchAl}
              className="hoverSwitch"
            />
          </div> */}
          {type != "module" && (
            <>
              {type == "row" && (
                <AlignMain
                  data={props.data}
                  indexes={props.indexes}
                  property="float"
                  label="Float"
                  defaultValue="none"
                  onChangeStyle={onChangeStyle}
                  styleState={styleStateAl}
                  //  styleState={false}
                  deviceSwitch={props.deviceSwitch}
                  options={[
                    {
                      value: 'none',
                      label: 'none',
                    },
                    {
                      value: 'left',
                      label: 'left',
                    },
                    {
                      value: 'right',
                      label: 'right',
                    },
                  ]}
                />
              )}
              <AlignMain
                data={props.data}
                indexes={props.indexes}
                property="justifyContent"
                label="justify Content"
                defaultValue="flex-start"
                onChangeStyle={onChangeStyle}
                styleState={styleStateAl}
                // styleState={false}
                deviceSwitch={props.deviceSwitch}
                options={[
                  {
                    value: 'flex-start',
                    label: 'flex-start',
                  },
                  {
                    value: 'flex-end',
                    label: 'flex-end',
                  },
                  {
                    value: 'center',
                    label: 'center',
                  },
                  {
                    value: 'space-between',
                    label: 'space-between',
                  },
                  {
                    value: 'space-around',
                    label: 'space-around',
                  },
                  {
                    value: 'space-evenly',
                    label: 'space-evenly',
                  },
                ]}
              />
              <AlignMain
                data={props.data}
                indexes={props.indexes}
                property="alignItems"
                label="Align Items"
                defaultValue="flex-start"
                onChangeStyle={onChangeStyle}
                styleState={styleStateAl}
                // styleState={false}
                deviceSwitch={props.deviceSwitch}
                options={[
                  {
                    value: 'flex-start',
                    label: 'flex-start',
                  },
                  {
                    value: 'flex-end',
                    label: 'flex-end',
                  },
                  {
                    value: 'center',
                    label: 'center',
                  },
                  {
                    value: 'stretch',
                    label: 'stretch',
                  },
                  {
                    value: 'baseline',
                    label: 'baseline',
                  },
                ]}
              />
              <AlignMain
                data={props.data}
                indexes={props.indexes}
                property="flexDirection"
                label="Flex Direction"
                defaultValue="row"
                onChangeStyle={onChangeStyle}
                styleState={styleStateAl}
                // styleState={false}
                deviceSwitch={props.deviceSwitch}
                options={[
                  {
                    value: 'row',
                    label: 'row',
                  },
                  {
                    value: 'column',
                    label: 'column',
                  },
                ]}
              />
            </>
          )}
          {type == 'module' && (
            <>
              <AlignMain
                data={props.data}
                indexes={props.indexes}
                property="justifyContent"
                label="justify Content"
                defaultValue="flex-start"
                onChangeStyle={onChangeStyle}
                styleState={styleStateAl}
                // styleState={false}
                deviceSwitch={props.deviceSwitch}
                options={[
                  {
                    value: 'flex-start',
                    label: 'flex-start',
                  },
                  {
                    value: 'center',
                    label: 'center',
                  },
                  {
                    value: 'flex-end',
                    label: 'flex-end',
                  },
                  {
                    value: 'space-between',
                    label: 'space-between',
                  },
                  {
                    value: 'space-around',
                    label: 'space-around',
                  },
                  {
                    value: 'space-evenly',
                    label: 'space-evenly',
                  },

                ]}
              />

            </>
          )}
          {type === 'module' && module.key === 'customfield' && labelStatus === true && (
            <>
              {/* <div className="caf-builder-setting-row-label">
              <label>Display Type</label>
              <Switch
                checkedChildren="Row"
                unCheckedChildren="Column"
                onChange={onDisplaySwitchChange}
                checked={displaySwitchStatus}
                className="hoverSwitch"
              />
            </div> */}
              <AlignMain
                data={props.data}
                indexes={props.indexes}
                property="flexWrap"
                label="Flex Wrap"
                defaultValue="nowrap"
                onChangeStyle={onChangeStyle}
                styleState={styleStateAl}
                // styleState={false}
                deviceSwitch={props.deviceSwitch}
                options={[
                  {
                    value: 'nowrap',
                    label: 'nowrap',
                  },
                  {
                    value: 'wrap',
                    label: 'wrap',
                  },

                ]}
              />
            </>
          )}

        </div>
      ),
    },
    {
      key: "7",
      label: "Border",
      children: (
        <div className="collapse-main-content">
          {/* <div className="hoverswitchguard">
            <Switch
              checkedChildren="hover"
              unCheckedChildren="default"
              onChange={onHoverSwitchBr}
              checked={hoverSwitchBr}
              className="hoverSwitch"
            />
          </div> */}
          <BorderMain
            data={props.data}
            indexes={props.indexes}
            property="border"
            label="Border"
            onChangeStyle={onChangeStyle}
            styleState={styleStateBr}
            deviceSwitch={props.deviceSwitch}
          ></BorderMain>
        </div>
      ),
    },
    {
      key: "8",
      label: "Box Shadow",
      children: (
        <div className="collapse-main-content">
          {/* <div className="hoverswitchguard">
            <Switch
              checkedChildren="hover"
              unCheckedChildren="default"
              onChange={onHoverSwitchBs}
              checked={hoverSwitchBs}
              className="hoverSwitch"
            />
          </div> */}
          <BoxShadow
            data={props.data}
            indexes={props.indexes}
            property="boxShadow"
            label="Box Shadow"
            onChangeStyle={onChangeStyle}
            styleState={styleStateBs}
            deviceSwitch={props.deviceSwitch}
          ></BoxShadow>
        </div>
      ),
    },
  ];
  //const[designItems,setDesignItems]=useState(styleItems);

  let subTabItems = [
    {
      key: "1",
      label: "Text",
      children: (
        <div className="collapse-main-content">
          {/* <div className="hoverswitchguard">
          <Switch
            checkedChildren="hover"
            unCheckedChildren="default"
            onChange={onHoverSwitchText}
            checked={hoverSwitchText}
            className="hoverSwitch"
          />
        </div> */}
          <TextMain
            data={props.data}
            indexes={props.indexes}
            property="text"
            label="Text"
            onChangeStyle={onChangeStyle}
            fonts={fontFamilyArray}
            hoverSwitch={hoverSwitchText}
            deviceSwitch={props.deviceSwitch}
            styleTab={styleTab}
          />
        </div>
      ),
    },
    {
      key: "2",
      label: "Sizing",
      children: (
        <div className="collapse-main-content">
          <SliderMain
            data={props.data}
            indexes={props.indexes}
            property={type == "row" ? "width" : "flex-basis"}
            label="Width"
            defaultSuffix="%"
            defaultValue="100"
            onChangeStyle={onChangeStyle}
            deviceSwitch={props.deviceSwitch}
            styleTab={styleTab}
          />
          <SliderMain
            data={props.data}
            indexes={props.indexes}
            property="height"
            label="Height"
            defaultSuffix="%"
            defaultValue="100"
            onChangeStyle={onChangeStyle}
            deviceSwitch={props.deviceSwitch}
            styleTab={styleTab}
          />
        </div>
      ),
    },
    {
      key: "3",
      label: "Spacing",
      children: (
        <div className="collapse-main-content">
          {/* <div className="hoverswitchguard">
          <Switch
            checkedChildren="hover"
            unCheckedChildren="default"
            onChange={onHoverSwitchSpacing}
            checked={hoverSwitchSpacing}
            className="hoverSwitch"
          />
        </div> */}

          <Row className="without-border">
            {/* <Col span={12}> */}
            <SliderMain
              data={props.data}
              indexes={props.indexes}
              property="paddingTop"
              label="Padding Top"
              defaultSuffix="px"
              defaultValue="10"
              onChangeStyle={onChangeStyle}
              extraClass="colm2"
              styleState={styleStateSpacing}
              deviceSwitch={props.deviceSwitch}
              styleTab={styleTab}
            />
            {/* </Col> */}
            {/* <Col span={12}> */}
            <SliderMain
              data={props.data}
              indexes={props.indexes}
              property="paddingRight"
              label="Padding Right"
              defaultSuffix="px"
              defaultValue="10"
              onChangeStyle={onChangeStyle}
              extraClass="colm2"
              styleState={styleStateSpacing}
              deviceSwitch={props.deviceSwitch}
              styleTab={styleTab}
            />
            {/* </Col> */}
          </Row>
          <Row>
            {/* <Col span={12}> */}
            <SliderMain
              data={props.data}
              indexes={props.indexes}
              property="paddingBottom"
              label="Padding Bottom"
              defaultSuffix="px"
              defaultValue="10"
              onChangeStyle={onChangeStyle}
              extraClass="colm2"
              styleState={styleStateSpacing}
              deviceSwitch={props.deviceSwitch}
              styleTab={styleTab}
            />
            {/* </Col> */}
            {/* <Col span={12}> */}
            <SliderMain
              data={props.data}
              indexes={props.indexes}
              property="paddingLeft"
              label="Padding Left"
              defaultSuffix="px"
              defaultValue="10"
              onChangeStyle={onChangeStyle}
              extraClass="colm2"
              styleState={styleStateSpacing}
              deviceSwitch={props.deviceSwitch}
              styleTab={styleTab}
            />
            {/* </Col> */}
          </Row>
          <Row>
            {/* <Col span={12}> */}
            <SliderMain
              data={props.data}
              indexes={props.indexes}
              property="marginTop"
              label="Margin Top"
              defaultSuffix="px"
              defaultValue="0"
              onChangeStyle={onChangeStyle}
              extraClass="colm2"
              styleState={styleStateSpacing}
              deviceSwitch={props.deviceSwitch}
              styleTab={styleTab}
            />
            {/* </Col> */}
            {/* <Col span={12}> */}
            <SliderMain
              data={props.data}
              indexes={props.indexes}
              property="marginRight"
              label="Margin Right"
              defaultSuffix="px"
              defaultValue="0"
              onChangeStyle={onChangeStyle}
              extraClass="colm2"
              styleState={styleStateSpacing}
              deviceSwitch={props.deviceSwitch}
              styleTab={styleTab}
            />
            {/* </Col> */}
          </Row>
          <Row>
            {/* <Col span={12}> */}
            <SliderMain
              data={props.data}
              indexes={props.indexes}
              property="marginBottom"
              label="Margin Bottom"
              defaultSuffix="px"
              defaultValue="0"
              onChangeStyle={onChangeStyle}
              extraClass="colm2"
              styleState={styleStateSpacing}
              deviceSwitch={props.deviceSwitch}
              styleTab={styleTab}
            />
            {/* </Col>
      <Col span={12}> */}
            <SliderMain
              data={props.data}
              indexes={props.indexes}
              property="marginLeft"
              label="Margin Left"
              defaultSuffix="px"
              defaultValue="0"
              onChangeStyle={onChangeStyle}
              extraClass="colm2"
              styleState={styleStateSpacing}
              deviceSwitch={props.deviceSwitch}
              styleTab={styleTab}
            />
            {/* </Col> */}
          </Row>
        </div>
      ),
    },
    {
      key: "5",
      label: "Border",
      children: (
        <div className="collapse-main-content">
          {/* <div className="hoverswitchguard">
          <Switch
            checkedChildren="hover"
            unCheckedChildren="default"
            onChange={onHoverSwitchBr}
            checked={hoverSwitchBr}
            className="hoverSwitch"
          />
        </div> */}
          <BorderMain
            data={props.data}
            indexes={props.indexes}
            property="border"
            label="Border"
            onChangeStyle={onChangeStyle}
            styleState={styleStateBr}
            deviceSwitch={props.deviceSwitch}
            styleTab={styleTab}
          ></BorderMain>
        </div>
      ),
    },
    {
      key: "6",
      label: "Box Shadow",
      children: (
        <div className="collapse-main-content">
          {/* <div className="hoverswitchguard">
          <Switch
            checkedChildren="hover"
            unCheckedChildren="default"
            onChange={onHoverSwitchBs}
            checked={hoverSwitchBs}
            className="hoverSwitch"
          />
        </div> */}
          <BoxShadow
            data={props.data}
            indexes={props.indexes}
            property="boxShadow"
            label="Box Shadow"
            onChangeStyle={onChangeStyle}
            styleState={styleStateBs}
            deviceSwitch={props.deviceSwitch}
            styleTab={styleTab}
          ></BoxShadow>
        </div>
      ),
    },
    {
      key: "7",
      label: "Background",
      children: (
        <div className="collapse-main-content">
          {/* <div className="hoverswitchguard">
            <Switch
              checkedChildren="hover"
              unCheckedChildren="default"
              onChange={onHoverSwitchBg}
              checked={hoverSwitchBg}
              className="hoverSwitch"
            />
          </div> */}
          <ColorMain
            data={props.data}
            indexes={props.indexes}
            property="backgroundColor"
            defaultValue="#333333"
            label="Background Color"
            onChangeStyle={onChangeStyle}
            styleState={styleStateBg}
            deviceSwitch={props.deviceSwitch}
            styleTab={styleTab}
          />
          {type != "module" &&     // hide bg image option from module
            <ContentImage
              data={props.data}
              indexes={props.indexes}
              label="Background Image"
              type="background-image"
              onChangeStyle={onChangeStyle}
              styleState={styleStateBg}
              postData={props.postData}
              deviceSwitch={props.deviceSwitch}
              styleTab={styleTab}
            ></ContentImage>
          }
        </div>
      ),
    }
  ];
  return (
    <>
      {type == 'module' && module.key == "billing_fields" && labelStatus === true && (
        <Tabs defaultActiveKey="container" items={tab_items} onChange={onChangeTab} className="caf-design-tabs" />
      )}
      {type == 'module' && module.key == "shipping_fields" && labelStatus === true && (
        <Tabs defaultActiveKey="container" items={tab_items} onChange={onChangeTab} className="caf-design-tabs" />
      )}
      {type == 'module' && module.key == "order_review" && labelStatus === true && (
        <Tabs defaultActiveKey="container" items={[
          {
            key: 'container',
            label: 'Table Head',
          },
          {
            key: 'label',
            label: 'Table Cells',
          },
          {
            key: 'meta',
            label: 'Table Footer',
          }
        ]
        } onChange={onChangeTab} className="caf-design-tabs" />
      )}
      {type == 'module' && module.key == "apply_coupon" && labelStatus === true && (
        <Tabs defaultActiveKey="container" items={[
          {
            key: 'container',
            label: 'Label',
          },
          {
            key: 'label',
            label: 'Input',
          },
          {
            key: 'meta',
            label: 'Button',
          }
        ]
        } onChange={onChangeTab} className="caf-design-tabs" />
      )}
      {!loading ? (
        <div className="row-design-tab-data">
          {props.widgets == "1" ? (
            <Collapse
              //defaultActiveKey={["1"]}
              expandIconPosition="end"
              expandIcon={({ isActive }) => (
                <CaretDownOutlined rotate={isActive ? 180 : 0} />
              )}
              items={[
                {
                  key: "1",
                  label: "Sizing",
                  children: (
                    <div className="collapse-main-content">
                      {type == "column" ? (
                        <>
                          <SliderMain
                            data={props.data}
                            indexes={props.indexes}
                            property="width"
                            label="Width"
                            defaultSuffix="%"
                            defaultValue="100"
                            onChangeStyle={onChangeStyle}
                            deviceSwitch={props.deviceSwitch}
                          />
                          <SliderMain
                            data={props.data}
                            indexes={props.indexes}
                            property="flexBasis"
                            label="Flex Basis"
                            defaultSuffix="%"
                            defaultValue="100"
                            onChangeStyle={onChangeStyle}
                            deviceSwitch={props.deviceSwitch}
                          />
                        </>
                      ) : (
                        <SliderMain
                          data={props.data}
                          indexes={props.indexes}
                          property="width"
                          label="Width"
                          defaultSuffix="%"
                          defaultValue="100"
                          onChangeStyle={onChangeStyle}
                          deviceSwitch={props.deviceSwitch}
                        />
                      )}
                      <SliderMain
                        data={props.data}
                        indexes={props.indexes}
                        property="height"
                        label="Height"
                        defaultSuffix="%"
                        defaultValue="100"
                        onChangeStyle={onChangeStyle}
                        deviceSwitch={props.deviceSwitch}
                      />
                    </div>
                  ),
                }, {
                  key: "2",
                  label: "Alignment",
                  children: (
                    <div className="collapse-main-content">
                      {/* <div className="hoverswitchguard">
                      <Switch
                        checkedChildren="hover"
                        unCheckedChildren="default"
                        onChange={onHoverSwitchAl}
                        checked={hoverSwitchAl}
                        className="hoverSwitch"
                      />
                    </div> */}
                      {type == "row" && (
                        <AlignMain
                          data={props.data}
                          indexes={props.indexes}
                          property="float"
                          label="Float"
                          defaultValue="none"
                          onChangeStyle={onChangeStyle}
                          styleState={styleStateAl}
                          //  styleState={false}
                          deviceSwitch={props.deviceSwitch}
                          options={[
                            {
                              value: 'none',
                              label: 'none',
                            },
                            {
                              value: 'left',
                              label: 'left',
                            },
                            {
                              value: 'right',
                              label: 'right',
                            },
                          ]}
                        />
                      )}
                      <AlignMain
                        data={props.data}
                        indexes={props.indexes}
                        property="justifyContent"
                        label="justify Content"
                        defaultValue="flex-start"
                        onChangeStyle={onChangeStyle}
                        styleState={styleStateAl}
                        // styleState={false}
                        deviceSwitch={props.deviceSwitch}
                        options={[
                          {
                            value: 'flex-start',
                            label: 'flex-start',
                          },
                          {
                            value: 'flex-end',
                            label: 'flex-end',
                          },
                          {
                            value: 'center',
                            label: 'center',
                          },
                          {
                            value: 'space-between',
                            label: 'space-between',
                          },
                          {
                            value: 'space-around',
                            label: 'space-around',
                          },
                          {
                            value: 'space-evenly',
                            label: 'space-evenly',
                          },
                        ]}
                      />
                      <AlignMain
                        data={props.data}
                        indexes={props.indexes}
                        property="alignItems"
                        label="Align Items"
                        defaultValue="flex-start"
                        onChangeStyle={onChangeStyle}
                        styleState={styleStateAl}
                        // styleState={false}
                        deviceSwitch={props.deviceSwitch}
                        options={[
                          {
                            value: 'flex-start',
                            label: 'flex-start',
                          },
                          {
                            value: 'flex-end',
                            label: 'flex-end',
                          },
                          {
                            value: 'center',
                            label: 'center',
                          },
                          {
                            value: 'stretch',
                            label: 'stretch',
                          },
                          {
                            value: 'baseline',
                            label: 'baseline',
                          },
                        ]}
                      />
                      <AlignMain
                        data={props.data}
                        indexes={props.indexes}
                        property="flexDirection"
                        label="Flex Direction"
                        defaultValue="row"
                        onChangeStyle={onChangeStyle}
                        styleState={styleStateAl}
                        // styleState={false}
                        deviceSwitch={props.deviceSwitch}
                        options={[
                          {
                            value: 'row',
                            label: 'row',
                          },
                          {
                            value: 'column',
                            label: 'column',
                          },
                        ]}
                      />
                    </div>
                  ),
                },
              ]}
            />
          ) : (
            <>
              {styleTab == 'container' && (
                <Collapse
                  //defaultActiveKey={["1"]}
                  expandIconPosition="end"
                  expandIcon={({ isActive }) => (
                    <CaretDownOutlined rotate={isActive ? 180 : 0} />
                  )}
                  items={

                    (() => {
                      // console.log(styleItems);
                      if (type !== 'module') {
                        return styleItems.filter(item => item.key !== '1');
                      }

                      // if (type === 'module' && module?.key === 'image') {
                      //   return styleItems.filter(item => item.key !== '1' && item.key !== '5');
                      // }
                      if (type === 'module' && module?.key === 'billing_fields') {
                        return styleItems.filter(item => item.key !== '4' && item.key !== '6' && item.key !== '8' && item.key !== '2' && item.key !== '1' && item.key !== '3');
                      }
                      if (type === 'module' && module?.key === 'shipping_fields') {
                        return styleItems.filter(item => item.key !== '4' && item.key !== '6' && item.key !== '8' && item.key !== '2' && item.key !== '1' && item.key !== '3');
                      }

                      if (type === 'module' && module?.key === 'order_review') {
                        return styleItems.filter(item => item.key !== '4' && item.key !== '6' && item.key !== '8' && item.key !== '2');
                      }
                      if (type === 'module' && module?.key === 'apply_coupon') {
                        return styleItems.filter(item => item.key !== '4' && item.key !== '6' && item.key !== '8' && item.key !== '2' && item.key !== '7' && item.key !== '5');
                      }
                      if (type === 'module' && module?.key === 'customtext') {
                        return styleItems.filter(item => item.key !== '4' && item.key !== '6' && item.key !== '8' && item.key !== '2' && item.key !== '7' && item.key !== '5');
                      }
                      return styleItems;
                    })()
                  }
                />
              )}
              {styleTab == "label" && (
                <Collapse
                  //defaultActiveKey={["1"]}
                  expandIconPosition="end"
                  expandIcon={({ isActive }) => (
                    <CaretDownOutlined rotate={isActive ? 180 : 0} />
                  )}
                  items={(() => {
                    if (type === 'module' && module?.key === 'billing_fields') {
                      return subTabItems.filter(item => item.key !== '5' && item.key !== '2' && item.key !== '6' && item.key !== '7');
                    }
                    if (type === 'module' && module?.key === 'shipping_fields') {
                      return subTabItems.filter(item => item.key !== '5' && item.key !== '2' && item.key !== '6' && item.key !== '7');
                    }
                    if (type === 'module' && module?.key === 'order_review') {
                      return subTabItems.filter(item => item.key !== '6' && item.key !== '2');
                    }
                    if (type === 'module' && module?.key === 'apply_coupon') {
                      return subTabItems.filter(item => item.key !== '6');
                    }
                    return subTabItems;
                  })()}
                />
              )}
              {styleTab == "meta" && (
                <Collapse
                  //defaultActiveKey={["1"]}
                  expandIconPosition="end"
                  expandIcon={({ isActive }) => (
                    <CaretDownOutlined rotate={isActive ? 180 : 0} />
                  )}
                  items={(() => {
                    if (type === 'module' && module?.key === 'billing_fields') {
                      return subTabItems.filter(item => item.key !== '2' && item.key !== '6' && item.key !== '7');
                    }
                    if (type === 'module' && module?.key === 'shipping_fields') {
                      return subTabItems.filter(item => item.key !== '2' && item.key !== '6' && item.key !== '7');
                    }
                    if (type === 'module' && module?.key === 'order_review') {
                      return subTabItems.filter(item => item.key !== '6' && item.key !== '2');
                    }
                    if (type === 'module' && module?.key === 'apply_coupon') {
                      return subTabItems.filter(item => item.key !== '6');
                    }
                    return subTabItems;
                  })()}
                />
              )}
            </>
          )}
        </div>
      ) : (
        <Skeleton active />
      )}
    </>
  );
};

export default DesignTab;
