import React, { useState } from 'react'
import { Input } from 'antd';
const AdvancedTab = (props) => {
  const { type, rowindex, columnindex, moduleindex, module } = props.indexes;
  let items = [...props.data];
  let item = '';
  if (type == 'row') {
    item = {
      ...items[rowindex]["settings"]
    };
  }
  if (type == 'column') {
    item = {
      ...items[rowindex].data[columnindex]["settings"]
    };
  }
  if (type == 'module') {
    item = {
      ...items[rowindex].data[columnindex].data[moduleindex]["settings"]
    };
  }
  const [value, setValue] = useState(item.custom_class);
  const handleChange = (val) => {
    setValue(val);
    item.custom_class = val
    if (type == 'row') {
      items[rowindex]["settings"] = item;
    }
    if (type == 'column') {
      items[rowindex].data[columnindex]["settings"] = item;
    }
    if (type == 'module') {
      items[rowindex].data[columnindex].data[moduleindex]["settings"] = item;
    }
    //console.log(props.data);
    props.onChangeData(props.data);
  }
  return (
    <div className='caf-builder-setting-row-label'>
      <label>Add Custom Class</label>
      <Input onChange={(e) => handleChange(e.target.value)} value={value} placeholder='Add Custom Class' />
    </div>
  )
}

export default AdvancedTab