import React, { useEffect, useState } from "react";
import axios from "axios";
import { Skeleton } from "antd";
function ModuleShippingFields({
  postData,
  settings,
  styleDefault,
  module,
  rowindex,
  columnindex,
  moduleindex,
  selectedDevice,
  setIndexes = () => { },
}) {
  const apiBase = trusty_woo_ajaxObject.apiBase
  const baseURL = apiBase;
  const [isLoading, setIsLoading] = useState(false);
  const [shippingStatus, setShippingStatus] = useState(false);
  const [shippingDifChecked, setShippingDifChecked] = useState(0);
  const fieldsData = settings.fields;
  //console.log(fieldsData,settings);
  let customtext = "Custom Text";
  if (settings?.customText) {
    customtext = settings.customText;
  }
  let custom_class = "";
  if (settings?.custom_class) {
    custom_class = settings.custom_class;
  }
  //console.log(excerpt);
  let ar = [];
  function CamelToSnake(string) {
    return string.replace(/([a-z]|(?=[A-Z]))([A-Z])/g, "$1-$2").toLowerCase();
  }
  const removeDuplicateProperty = (arr, item) => {
    if (arr.length === 0) {
      return arr;
    }
    let deletedval = "";
    arr.map((property, index) => {
      let propVal = property.split(":");
      if (item == propVal[0]) {
        deletedval = property;
      }
    });
    if (deletedval != "") {
      return arr.filter((e) => e !== deletedval);
    }
    return arr;
  };
  function generateCSS(style, state, device, settings) {
    let styleArr = [];

    if (device == "desktop") {
      if (state == "default") {
        // console.log(style,'kk')
        Object.keys(style[device][state]).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                postData?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style[device][state][item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style[device][state][item] + ";"
            );
          }
        });
      } else {
        Object.keys(style[device].default).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                postData?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style[device].default[item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style[device].default[item] + ";"
            );
          }
        });

        Object.keys(style[device][state]).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                postData?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style[device][state][item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style[device][state][item] + ";"
            );
          }
        });
      }
    }


    return styleArr.join(" ");
  }

  useEffect(() => {
    const getShippingStatus = async () => {
      setIsLoading(true);
      const { data } = await axios.get(baseURL + "get-shipping-status", {
        headers: {
          'X-WP-Nonce': trusty_woo_ajaxObject.nonce
        }
      });
      if (data) {
        if (data.status == "success") {
          //console.log(data);
          if (data.needs_shipping === true) {
            setShippingStatus(true);
          }
          setShippingDifChecked(data.ship_to_different);
          setIsLoading(false);
        } else {

        }
      }
    };
    getShippingStatus();
  }, []);
  //console.log(shippingStatus, isLoading);
  return (
    <>
      {!isLoading && shippingStatus ? (

        <div
          onClick={() =>
            setIndexes({
              type: "module",
              rowindex: rowindex,
              columnindex: columnindex,
              moduleindex: moduleindex,
              module: module,
            })
          }
          className={`caf-builder-module-main caf-module-${module.key} caf-module-${moduleindex} ${custom_class} post-id-${postData?.id ?? 0}`}>
          {settings?.display_shipping &&
            <h3 id="ship-to-different-address">
              <label className="woocommerce-form__label woocommerce-form__label-for-checkbox checkbox">
                <input
                  id="ship-to-different-address-checkbox"
                  className="woocommerce-form__input woocommerce-form__input-checkbox input-checkbox"
                  type="checkbox"
                  name="ship_to_different_address"
                  checked={settings?.shipping_checked}
                //onChange={(e) => setShippingDifChecked(e.target.checked)}
                />
                <span>{settings?.shipping_diff_label ? settings?.shipping_diff_label : 'Ship to a different address?'}</span>
              </label>

            </h3>
          }
          {Object.entries(fieldsData).sort((a, b) => a[1].priority - b[1].priority).map(([i, field]) => (
            <>{
              field?.disable !== true && (
            <div key={field.key} className={`trusty-preview-field-wrapper ${field.width ? field.width : 'full'} ${field.type != 'heading' ? 'apply_css' : ''}`} >
              <p className={`form-row ${field.class?.join(' ')} `} id={`${field.key}_field`} data-priority={field.priority}>
                {field.type != 'heading' && (
                  <label for={field.key} className="required_field">{field.label}{field.required && <span class="required" aria-hidden="true">*</span>}</label>
                )}
                <span class="woocommerce-input-wrapper">
                  {field.type === 'text' || field.type === 'email' || field.type === 'tel' || field.type === 'number' || field.type === 'password' ? (
                    <input
                      type={field.type}
                      className="input-text"
                      name={field.key}
                      id={field.key}
                      required={field.required}
                      placeholder={field.placeholder || ''}
                      autoComplete={field.autocomplete || ''}
                    />
                  ) : field.type === 'textarea' ? (
                    <textarea rows={10} cols={10} name={field.key} required={field.required} autoComplete={field.autocomplete || ''} className="input-text" />
                  ) : field.type === 'radio' ? (
                    <label for={field.key} className="required_field">
                      {field.options
                        ? field.options
                          .split(",")
                          .map((line, idx) => {
                            const [value, label] = line.split(":");
                            if (!value || !label) return null;
                            return (
                              <>
                              <span className="custom-woo-spanner">
                                <input
                                  type={field.type}
                                  className={`custom-woo-checkout-${field.type} input-${field.type}`}
                                  name={field.key}
                                  id={idx}
                                  required={field.required}
                                /> {" "}{label.trim()}{" "}</span></>

                            );
                          })
                        : "No options available"}

                    </label>
                  ) : field.type === 'checkbox' ? (
                    <label for={field.key} className="required_field">
                      {field.options
                        ? field.options
                          .split(",")
                          .map((line, idx) => {
                            const [value, label] = line.split(":");
                            if (!value || !label) return null;
                            return (
                              <>
                              <span className="custom-woo-spanner">
                                <input
                                  type={field.type}
                                  className={`custom-woo-checkout-${field.type} input-${field.type}`}
                                  name={`${field.key}[]`}
                                  id={`${field.key}-${idx}`}
                                  required={field.required}
                                /> {" "}{label.trim()}{" "}</span></>
                            );
                          })
                        : "No options available"}

                    </label>
                  ) : field.type === 'select' ? (
                    <select
                      name={field.key}
                      id={field.key}
                      className="shipping_select"
                      autoComplete={field.autocomplete}
                    >
                      {field.options
                        ? field.options
                          .split(",")
                          .map((line, idx) => {
                            const [value, label] = line.split(":");
                            if (!value || !label) return null;
                            return (
                              <option key={idx} value={value.trim()}>
                                {label.trim()}
                              </option>
                            );
                          })
                        : <option value="">No options available</option>}
                    </select>
                  ) : field.type === 'country' ? (
                    <select name={field.key} id={field.key} className="country_to_state country_select" autoComplete={field.autocomplete}>
                      {/* Add your country options here */}
                      <option value="">Select a country</option>
                      <option value="IN">India</option>
                      <option value="US">United States</option>
                    </select>
                  ) : field.type === 'state' ? (
                    <select name={field.key} id={field.key} className="state_select" autoComplete={field.autocomplete}>
                      {/* Add your country options here */}
                      <option value="">Select a State</option>
                      <option value="PB">Punjab</option>
                      <option value="HR">Haryana</option>
                    </select>
                  ) : field.type === 'heading' ? (
                    (() => {
                      const HeadingTag = field.heading_type || 'h2'; // Default to h2
                      return (
                        <HeadingTag className="custom-woo-field-heading"
                          style={{
                            fontSize: field?.style?.fontSize ? `${field?.style?.fontSize}px` : '14px',
                            lineHeight: field?.style?.lineHeight ? `${field?.style?.lineHeight}px` : '20px',
                            color: field?.style?.color || '#000000',
                            fontStyle: field?.style?.fontStyle === 'italic' ? 'italic' : 'normal',
                            textTransform: field?.style?.textTransform || 'inherit',       // e.g., 'uppercase'
                            textDecoration: field?.style?.textDecoration || 'inherit',
                            fontWeight: field?.style?.fontWeight || '400',
                            fontFamily: field?.style?.fontFamily || '',
                            paddingTop: field?.style?.paddingTop ? `${field?.style?.paddingTop}px` : '5px',
                            paddingRight: field?.style?.paddingRight ? `${field?.style?.paddingRight}px` : '0px',
                            paddingBottom: field?.style?.paddingBottom ? `${field?.style?.paddingBottom}px` : '5px',
                            paddingLeft: field?.style?.paddingLeft ? `${field?.style?.paddingLeft}px` : '0px',
                            marginTop: field?.style?.marginTop ? `${field?.style?.marginTop}px` : '0px',
                            marginRight: field?.style?.marginRight ? `${field?.style?.marginRight}px` : '0px',
                            marginBottom: field?.style?.marginBottom ? `${field?.style?.marginBottom}px` : '0px',
                            marginLeft: field?.style?.marginLeft ? `${field?.style?.marginLeft}px` : '0px',
                          }}>
                          {field.label || 'Heading'}
                        </HeadingTag>
                      );
                    })()
                  )
                    : <></>}
                </span>
              </p>

            </div>
              )}</>
          ))}


          <style>
            {`
    .caf-bl-post .caf-row-${rowindex} .caf-column-${columnindex} .caf-module-${moduleindex}.post-id-${postData?.id ?? 0
              } .apply_css{
        ${generateCSS(styleDefault, "default", selectedDevice, settings)}
    }
    .caf-bl-post .caf-row-${rowindex} .caf-column-${columnindex} .caf-module-${moduleindex}.post-id-${postData?.id ?? 0
              } .apply_css label{
${generateCSS(styleDefault?.label, "default", selectedDevice, settings)}
}
.caf-bl-post .caf-row-${rowindex} .caf-column-${columnindex} .caf-module-${moduleindex}.post-id-${postData?.id ?? 0
              } .apply_css input[type='text'],.caf-bl-post .caf-row-${rowindex} .caf-column-${columnindex} .caf-module-${moduleindex}.post-id-${postData?.id ?? 0
              } .apply_css input[type='number'],.caf-bl-post .caf-row-${rowindex} .caf-column-${columnindex} .caf-module-${moduleindex}.post-id-${postData?.id ?? 0
              } .apply_css input[type='tel'],.caf-bl-post .caf-row-${rowindex} .caf-column-${columnindex} .caf-module-${moduleindex}.post-id-${postData?.id ?? 0
              } .apply_css input[type='password'],.caf-bl-post .caf-row-${rowindex} .caf-column-${columnindex} .caf-module-${moduleindex}.post-id-${postData?.id ?? 0
              } .apply_css input[type='email'],.caf-bl-post .caf-row-${rowindex} .caf-column-${columnindex} .caf-module-${moduleindex}.post-id-${postData?.id ?? 0
              } .apply_css select,.caf-bl-post .caf-row-${rowindex} .caf-column-${columnindex} .caf-module-${moduleindex}.post-id-${postData?.id ?? 0
              } .apply_css textarea {
${generateCSS(styleDefault?.meta, "default", selectedDevice, settings)}
}
    `}
          </style>
        </div>
      ) : !isLoading && !shippingStatus ? (<><div className='shipping-disabled-message' style={{ width: '100%' }}>Shipping not enabled<a href='#' target="_blank">Read More</a></div></>) : (
        <div style={{ width: '400px' }}><Skeleton active /></div>

      )}
    </>
  );
}

export default ModuleShippingFields;
