import React, { useEffect, useState } from "react";
import axios from "axios";
function ModuleCoupon({
  postData,
  settings,
  styleDefault,
  module,
  rowindex,
  columnindex,
  moduleindex,
  selectedDevice,
  setIndexes = () => { },
}) {
  const apiBase = trusty_woo_ajaxObject.apiBase
  const baseURL = apiBase;
  const [isLoading, setIsLoading] = useState(false);
  const [couponData, setCouponData] = useState('data loading...');

  let custom_class = "";
  if (settings?.custom_class) {
    custom_class = settings.custom_class;
  }
  //console.log(excerpt);
  let ar = [];
  function CamelToSnake(string) {
    return string.replace(/([a-z]|(?=[A-Z]))([A-Z])/g, "$1-$2").toLowerCase();
  }
  const removeDuplicateProperty = (arr, item) => {
    if (arr.length === 0) {
      return arr;
    }
    let deletedval = "";
    arr.map((property, index) => {
      let propVal = property.split(":");
      if (item == propVal[0]) {
        deletedval = property;
      }
    });
    if (deletedval != "") {
      return arr.filter((e) => e !== deletedval);
    }
    return arr;
  };
  function generateCSS(style, state, device, settings) {
    let styleArr = [];
    if (device == "mobile") {
      if (state == "default") {
        Object.keys(style.desktop[state]).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                postData?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style.desktop[state][item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style.desktop[state][item] + ";"
            );
          }
        });
        Object.keys(style[device][state]).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                postData?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style[device][state][item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style[device][state][item] + ";"
            );
          }
        });
      } else {
        Object.keys(style.desktop.default).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                postData?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style.desktop.default[item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style.desktop.default[item] + ";"
            );
          }
        });

        Object.keys(style.desktop[state]).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                postData?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style.desktop[state][item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style.desktop[state][item] + ";"
            );
          }
        });

        Object.keys(style[device].default).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                postData?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style[device].default[item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style[device].default[item] + ";"
            );
          }
        });

        Object.keys(style[device][state]).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                postData?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style[device][state][item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style[device][state][item] + ";"
            );
          }
        });
      }
    } else if (device == "tablet") {
      if (state == "default") {
        Object.keys(style.desktop[state]).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                postData?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style.desktop[state][item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style.desktop[state][item] + ";"
            );
          }
        });
        Object.keys(style[device][state]).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                postData?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style[device][state][item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style[device][state][item] + ";"
            );
          }
        });
      } else {
        Object.keys(style.desktop.default).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                postData?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style.desktop.default[item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style.desktop.default[item] + ";"
            );
          }
        });

        Object.keys(style.desktop[state]).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                postData?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style.desktop[state][item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style.desktop[state][item] + ";"
            );
          }
        });

        Object.keys(style[device].default).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                postData?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style[device].default[item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style[device].default[item] + ";"
            );
          }
        });

        Object.keys(style[device][state]).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                postData?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style[device][state][item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style[device][state][item] + ";"
            );
          }
        });
      }
    } else {
      if (device == "desktop") {
        if (state == "default") {
          // console.log(style,'kk')
          Object.keys(style[device][state]).map((item, i) => {
            let filter_item = CamelToSnake(item);
            styleArr = removeDuplicateProperty(styleArr, filter_item);
            if (item == "backgroundImage") {
              if (settings?.background_image == "post-img") {
                styleArr.push(
                  CamelToSnake(item) +
                  ":url(" +
                  postData?.image +
                  ");"
                );
              } else {
                styleArr.push(
                  CamelToSnake(item) +
                  ":url(" +
                  style[device][state][item] +
                  ");"
                );
              }
            } else {
              styleArr.push(
                CamelToSnake(item) + ":" + style[device][state][item] + ";"
              );
            }
          });
        } else {
          Object.keys(style[device].default).map((item, i) => {
            let filter_item = CamelToSnake(item);
            styleArr = removeDuplicateProperty(styleArr, filter_item);
            if (item == "backgroundImage") {
              if (settings?.background_image == "post-img") {
                styleArr.push(
                  CamelToSnake(item) +
                  ":url(" +
                  postData?.image +
                  ");"
                );
              } else {
                styleArr.push(
                  CamelToSnake(item) +
                  ":url(" +
                  style[device].default[item] +
                  ");"
                );
              }
            } else {
              styleArr.push(
                CamelToSnake(item) + ":" + style[device].default[item] + ";"
              );
            }
          });

          Object.keys(style[device][state]).map((item, i) => {
            let filter_item = CamelToSnake(item);
            styleArr = removeDuplicateProperty(styleArr, filter_item);
            if (item == "backgroundImage") {
              if (settings?.background_image == "post-img") {
                styleArr.push(
                  CamelToSnake(item) +
                  ":url(" +
                  postData?.image +
                  ");"
                );
              } else {
                styleArr.push(
                  CamelToSnake(item) +
                  ":url(" +
                  style[device][state][item] +
                  ");"
                );
              }
            } else {
              styleArr.push(
                CamelToSnake(item) + ":" + style[device][state][item] + ";"
              );
            }
          });
        }
      }
    }

    return styleArr.join(" ");
  }

  useEffect(() => {
    handleCouponData();
  }, []);

  const handleCouponData = () => {
    setIsLoading(true);
    axios
      .get(baseURL + "get-coupon-section", {
        headers: {
          'X-WP-Nonce': trusty_woo_ajaxObject.nonce
        }
      })
      .then((response) => {
        if (response.data.status === 'success') {
          setCouponData(response.data.data);
        }
      })
      .catch((error) => {
        alert("Error fetching billing fields: " + error.message);
      })
      .finally(() => {
        setIsLoading(false);
      });
  };
  return (
    <>
      <div
        onClick={() =>
          setIndexes({
            type: "module",
            rowindex: rowindex,
            columnindex: columnindex,
            moduleindex: moduleindex,
            module: module,
          })
        }
        className={`caf-builder-module-main caf-module-${module.key} caf-module-${moduleindex} ${custom_class} post-id-${postData?.id ?? 0}`}
      >
        <div className="checkout_coupon woocommerce-form-coupon" method="post">
          <label for="coupon_code">{settings?.label}</label>
          <div className="coupon_frame">
            <input type="text" name="coupon_code" className="input-text" placeholder={settings?.placeholder} id="coupon_code" value="" autoComplete="off"/>
            <button type="button" className="button" name="apply_coupon" value="Apply coupon">{settings?.btn_text}</button>
            </div>
          <div class="clear"></div>
        </div>

        <style>
          {`
    .caf-bl-post .caf-row-${rowindex} .caf-column-${columnindex} .caf-module-${moduleindex}.post-id-${postData?.id ?? 0
            } .checkout_coupon label{
        ${generateCSS(styleDefault, "default", selectedDevice, settings)}
    }
    .caf-bl-post .caf-row-${rowindex} .caf-column-${columnindex} .caf-module-${moduleindex}.post-id-${postData?.id ?? 0
            } .checkout_coupon input{
${generateCSS(styleDefault?.label, "default", selectedDevice, settings)}
}
.caf-bl-post .caf-row-${rowindex} .caf-column-${columnindex} .caf-module-${moduleindex}.post-id-${postData?.id ?? 0
            } .checkout_coupon button{
${generateCSS(styleDefault?.meta, "default", selectedDevice, settings)}
}
    `}
        </style>
      </div>
    </>
  );
}

export default ModuleCoupon;
