import React, { useEffect, useState } from "react";
import { Col, Input, Row, Slider, Select, Space,Tooltip } from "antd";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faArrowRotateLeft} from "@fortawesome/free-solid-svg-icons";
const { Option } = Select;

const SliderMain = (props) => {
  //console.log(props);
  const { type, rowindex, columnindex, moduleindex } = props.indexes;
  const {
    property,
    label,
    defaultSuffix,
    extraClass = "",
    defaultValue,
    styleState = 'default',
    styleTab = '',
    deviceSwitch
  } = props;
  let currentValue = "";
  if (defaultValue) {
    currentValue = defaultValue;
  }
  let device = deviceSwitch;
  let currentSuffix = "";
  if (defaultSuffix) {
    currentSuffix = defaultSuffix
  }
  function getSuffix(value) {
    if (value === "auto") {
        return "auto"; // If value is "auto", return "auto"
    }
    // Use regex to match "px", "%", or any alphabetical unit
    let match = value.match(/[a-z%]+/i);
    return match ? match[0] : "px"; // Return the suffix or default to "px" if no match is found
}
  if (type == 'row') {
    let RowStyle = props.data[rowindex].style;

    if (RowStyle[device][styleState]?.[property]) {
      currentValue = RowStyle[device][styleState][property];
    } else {
      if (device == "desktop") {
        if (styleState == "hover") {
          if (RowStyle[device]["default"]?.[property]) {
            currentValue = RowStyle[device]["default"][property];
          }
        }
      }
      if (device == "tablet") {
        if (styleState == "default") {
          if (RowStyle["desktop"]["default"]?.[property]) {
            currentValue = RowStyle["desktop"]["default"][property];
          }
        } else {
          if (RowStyle[device]["default"]?.[property]) {
            currentValue = RowStyle[device]["default"][property];
          } else {
            if (RowStyle["desktop"]["hover"]?.[property]) {
              currentValue = RowStyle["desktop"]["hover"][property];
            } else {
              if (RowStyle["desktop"]["default"]?.[property]) {
                currentValue = RowStyle["desktop"]["default"][property];
              }
            }
          }
        }
      }
      if (device == "mobile") {
        if (styleState == "default") {
          if (RowStyle["desktop"]["default"]?.[property]) {
            currentValue = RowStyle["desktop"]["default"][property];
          }
        } else {
          if (RowStyle[device]["default"]?.[property]) {
            currentValue = RowStyle[device]["default"][property];
          } else {
            if (RowStyle["desktop"]["hover"]?.[property]) {
              currentValue = RowStyle["desktop"]["hover"][property];
            } else {
              if (RowStyle["desktop"]["default"]?.[property]) {
                currentValue = RowStyle["desktop"]["default"][property];
              }
            }
          }
        }
      }
    }
  }
  if (type == 'column') {
    let ColStyle = props.data[rowindex].data[columnindex].style;
    if (ColStyle[device][styleState]?.[property]) {
      currentValue = ColStyle[device][styleState][property];
    } else {
      if (device == "desktop") {
        if (styleState == "hover") {
          if (ColStyle[device]["default"]?.[property]) {
            currentValue = ColStyle[device]["default"][property];
          }
        }
      }
      if (device == "tablet") {
        if (styleState == "default") {
          if (ColStyle["desktop"]["default"]?.[property]) {
            currentValue = ColStyle["desktop"]["default"][property];
          }
        } else {
          if (ColStyle[device]["default"]?.[property]) {
            currentValue = ColStyle[device]["default"][property];
          } else {
            if (ColStyle["desktop"]["hover"]?.[property]) {
              currentValue = ColStyle["desktop"]["hover"][property];
            } else {
              if (ColStyle["desktop"]["default"]?.[property]) {
                currentValue = ColStyle["desktop"]["default"][property];
              }
            }
          }
        }
      }
      if (device == "mobile") {
        if (styleState == "default") {
          if (ColStyle["desktop"]["default"]?.[property]) {
            currentValue = ColStyle["desktop"]["default"][property];
          }
        } else {
          if (ColStyle[device]["default"]?.[property]) {
            currentValue = ColStyle[device]["default"][property];
          } else {
            if (ColStyle["desktop"]["hover"]?.[property]) {
              currentValue = ColStyle["desktop"]["hover"][property];
            } else {
              if (ColStyle["desktop"]["default"]?.[property]) {
                currentValue = ColStyle["desktop"]["default"][property];
              }
            }
          }
        }
      }
    }
  }
  if (type == "module") {
    let ModuleStyle = props.data[rowindex].data[columnindex].data[moduleindex].style;
      if(styleTab!=""){
        if (ModuleStyle[styleTab][device][styleState]?.[property]) {
          currentValue = ModuleStyle[styleTab][device][styleState][property];
        } 
        else {
          if (device == "desktop") {
            if (styleState == "hover") {
              if (ModuleStyle[styleTab][device]["default"]?.[property]) {
                currentValue = ModuleStyle[styleTab][device]["default"][property];
              }
            }
          }
          if (device == "tablet") {
            if (styleState == "default") {
              if (ModuleStyle[styleTab]["desktop"]["default"]?.[property]) {
                currentValue = ModuleStyle[styleTab]["desktop"]["default"][property];
              }
            } else {
              if (ModuleStyle[styleTab][device]["default"]?.[property]) {
                currentValue = ModuleStyle[styleTab][device]["default"][property];
              } else {
                if (ModuleStyle[styleTab]["desktop"]["hover"]?.[property]) {
                  currentValue = ModuleStyle[styleTab]["desktop"]["hover"][property];
                } else {
                  if (ModuleStyle[styleTab]["desktop"]["default"]?.[property]) {
                    currentValue =
                      ModuleStyle[styleTab]["desktop"]["default"][property];
                  }
                }
              }
            }
          }
          if (device == "mobile") {
            if (styleState == "default") {
              if (ModuleStyle[styleTab]["desktop"]["default"]?.[property]) {
                currentValue = ModuleStyle[styleTab]["desktop"]["default"][property];
              }
            } else {
              if (ModuleStyle[styleTab][device]["default"]?.[property]) {
                currentValue = ModuleStyle[styleTab][device]["default"][property];
              } else {
                if (ModuleStyle[styleTab]["desktop"]["hover"]?.[property]) {
                  currentValue = ModuleStyle[styleTab]["desktop"]["hover"][property];
                } else {
                  if (ModuleStyle[styleTab]["desktop"]["default"]?.[property]) {
                    currentValue =
                    ModuleStyle[styleTab]["desktop"]["default"][property];
                  }
                }
              }
            }
          }
        }
    }else{
    if (ModuleStyle[device][styleState]?.[property]) {
      currentValue = ModuleStyle[device][styleState][property];
    } 
    else {
      if (device == "desktop") {
        if (styleState == "hover") {
          if (ModuleStyle[device]["default"]?.[property]) {
            currentValue = ModuleStyle[device]["default"][property];
          }
        }
      }
      if (device == "tablet") {
        if (styleState == "default") {
          if (ModuleStyle["desktop"]["default"]?.[property]) {
            currentValue = ModuleStyle["desktop"]["default"][property];
          }
        } else {
          if (ModuleStyle[device]["default"]?.[property]) {
            currentValue = ModuleStyle[device]["default"][property];
          } else {
            if (ModuleStyle["desktop"]["hover"]?.[property]) {
              currentValue = ModuleStyle["desktop"]["hover"][property];
            } else {
              if (ModuleStyle["desktop"]["default"]?.[property]) {
                currentValue =
                  ModuleStyle["desktop"]["default"][property];
              }
            }
          }
        }
      }
      if (device == "mobile") {
        if (styleState == "default") {
          if (ModuleStyle["desktop"]["default"]?.[property]) {
            currentValue = ModuleStyle["desktop"]["default"][property];
          }
        } else {
          if (ModuleStyle[device]["default"]?.[property]) {
            currentValue = ModuleStyle[device]["default"][property];
          } else {
            if (ModuleStyle["desktop"]["hover"]?.[property]) {
              currentValue = ModuleStyle["desktop"]["hover"][property];
            } else {
              if (ModuleStyle["desktop"]["default"]?.[property]) {
                currentValue =
                ModuleStyle["desktop"]["default"][property];
              }
            }
          }
        }
      }
    }
  }
  }

  // let regex = /\d+/g;
  // if (currentValue === "auto") {
  //   currentSuffix = currentValue.replace(regex, "");
  // } else {
  //   currentSuffix = currentValue.replace(regex, "");
  //   if (currentSuffix === "") {
  //     currentSuffix = defaultSuffix
  //   }
  // }
  // if (currentSuffix == 'NaNpx') {
  //   currentSuffix = 'px'
  // }
  // if (currentSuffix == 'NaN%') {
  //   currentSuffix = '%';
  // }
  currentSuffix = getSuffix(currentValue);
  // const [inputValue, setInputValue] = useState(parseInt(currentValue, 10));
  const [suffix, setSuffix] = useState(currentSuffix);
  useEffect(()=>{
    setSuffix(getSuffix(currentValue));
  },[styleState])
  const onSelectChange = (value) => {
    if (value != "auto") {
      setSuffix(value);
      ChangeStyle(property, parseInt(currentValue, 10), value);
    } else {
      setSuffix(value);
      ChangeStyle(property, "auto");
    }
  };
  //console.log(currentValue, property, label, suffix);
  const selectAfter = (
    <Select defaultValue={suffix} value={suffix} onChange={onSelectChange}>
      <Select.Option value="px">PX</Select.Option>
      <Select.Option value="%">%</Select.Option>
      <Select.Option value="auto">auto</Select.Option>
    </Select>
  );
  // const onChangeSlider = (newValue) => {
  //   //setInputValue(newValue);
  //   ChangeStyle(property, newValue, suffix);
  // };
  const onChangeNumber = (e) => {
    //setInputValue(e.target.value);
    ChangeStyle(property, e.target.value, suffix);
  };
  const ChangeStyle = (property, value, suffix = "") => {
    let items = [...props.data];
    if (type == "row") {
      let RowStyle = props.data[rowindex].style;
      let swcopy = { ...RowStyle[device] };
      let item = { ...swcopy[styleState] };
      item[property] = value + suffix;
      swcopy[styleState] = item
      items[rowindex]["style"][device] = swcopy;
    }
    if (type == "column") {
      let ColStyle = props.data[rowindex].data[columnindex].style;
      let swcopy = { ...ColStyle[device] };
      let item = { ...swcopy[styleState] };
      item[property] = value + suffix;
      swcopy[styleState] = item
      items[rowindex].data[columnindex]["style"][device] = swcopy;
    }
    if (type == "module") {
      let ModuleStyle = props.data[rowindex].data[columnindex].data[moduleindex].style;
      if(styleTab!=""){
        let swcopy = { ...ModuleStyle[styleTab] }
        let deviceCopy = { ...swcopy[device] }
        let item = { ...deviceCopy[styleState] }
        item[property] = value + suffix;
        deviceCopy[styleState] = item
        swcopy[device]=deviceCopy
        items[rowindex].data[columnindex].data[moduleindex]["style"][styleTab] = swcopy;
      }else{
        let swcopy = {...ModuleStyle[device],};
        let item = swcopy[styleState];
        item[property] = value + suffix;
        swcopy[styleState]= item
        items[rowindex].data[columnindex].data[moduleindex]["style"][device] = swcopy
      }
    }
    props.onChangeStyle(props.data);
  };
  const resetValue = () => {
    setSuffix(defaultSuffix);
    let items = [...props.data];
    if (type == "row") {
      let RowStyle = props.data[rowindex].style;
      let deviceCopy = {...RowStyle[device]}
      let item = { ...deviceCopy[styleState] };
      item[property] = defaultValue + defaultSuffix;
      deviceCopy[styleState] = item
      items[rowindex]["style"][device] = deviceCopy;
    }
    if (type == "column") {
      let ColStyle = props.data[rowindex].data[columnindex].style;
      let swcopy = { ...ColStyle[device] };
      let item = { ...swcopy[styleState] };
      item[property] = defaultValue + defaultSuffix;
      swcopy[styleState] = item
      items[rowindex].data[columnindex]["style"][device] = swcopy;
    }
    if (type == "module") {
      let ModuleStyle = props.data[rowindex].data[columnindex].data[moduleindex].style;
      if(styleTab!=""){
        let swcopy = { ...ModuleStyle[styleTab] }
        let deviceCopy = { ...swcopy[device] }
        let item = { ...deviceCopy[styleState] }
        item[property] = defaultValue + defaultSuffix;
        deviceCopy[styleState] = item
        swcopy[device]=deviceCopy
        items[rowindex].data[columnindex].data[moduleindex]["style"][styleTab] = swcopy;
      }else{
        let swcopy = {...ModuleStyle[device],};
        let item = swcopy[styleState];
        item[property] = defaultValue + defaultSuffix;
        swcopy[styleState]= item
        items[rowindex].data[columnindex].data[moduleindex]["style"][device] = swcopy
      }
    }
    props.onChangeStyle(props.data);
  }
  return (
    <div className={`${extraClass} caf-builder-setting-row-label width`}>
      <label>
        {label}
        <Tooltip title="Reset">
        <span onClick={resetValue}><FontAwesomeIcon icon={faArrowRotateLeft} /></span> 
        </Tooltip>
      </label>
      <Space direction="vertical"></Space>
      <Row>
        {/* <Col span={extraClass == "colm2" ? 12 : 17}>
          <Slider
            min={0}
            max={100}
            onChange={onChangeSlider}
            value={parseInt(currentValue, 10)}
          />
        </Col> */}
        <Col span={extraClass == "colm2" ? 24 : 24}>
          <Input
            // style={{
            //   margin: "0 0px 0 10px",
            // }}
            addonAfter={selectAfter}
            value={parseInt(currentValue, 10)}
            onChange={onChangeNumber}
            type="number"
          />
        </Col>
      </Row>
    </div>
  );
};

export default SliderMain;
