import React, { useState, useRef, useEffect } from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faRectangleXmark } from "@fortawesome/free-solid-svg-icons";
import ContentTab from "./settingTabContent/ContentTab";
import DesignTab from "./settingTabContent/DesignTab";
import AdvancedTab from "./settingTabContent/AdvancedTab"; 
import { Skeleton} from "antd";
const SettingPopUp = (props) => {
  // console.log(props);
  const [resetState, setResetState] = useState(false);
  //const {animation}=props;
  const { type, rowindex, columnindex, moduleindex, module } = props.indexes;
  const ref = useRef();
  // console.log(type,rowindex,columnindex,moduleindex,props);
  const [activeTab, setActiveTab] = useState("content");
  const [loading,setLoading]=useState(false);
  const handleSettingTab = (div) => {
    setActiveTab(div);
  };
  const onChangeStyle = (style) => {
    console.log(style);
    props.onChangeStyle(style);
  };
  useEffect(()=>{
    setLoading(true)
    setTimeout(()=>{
      setLoading(false)
    },500)
  },[props.selectedDevice,activeTab])
  return (
    <div
      className={`setting-popup-overlay-wrapper animate common-setting-popup`}
    >
      <div className={`setting-popup ${props?.animation}`}>
        {!props.addSkelton ? (
        <>  
        <div className="setting-popup-title-bar">
          {module ? module?.title : type} Settings
          {/* <div className="closeSettingPop" onClick={props.closePopup}>
            <FontAwesomeIcon icon={faRectangleXmark} />
          </div> */}
        </div>
        <div className="setting-popup-tab-bar">
          <div
            className={`setting-popup-tab content${
              activeTab == "content" ? " active" : ""
            }`}
            onClick={() => handleSettingTab("content")}
          >
            Content
          </div>
          <div
            className={`setting-popup-tab design${
              activeTab == "design" ? " active" : ""
            }`}
            onClick={() => handleSettingTab("design")}
          >
            Design
          </div>
          <div
            className={`setting-popup-tab advanced${
              activeTab == "advanced" ? " active" : ""
            }`}
            onClick={() => handleSettingTab("advanced")}
          >
            Advanced
          </div>
        </div>

        <div className="setting-popup-tab-content">
        {!loading ? (
          <>
          {activeTab == "content" ? (
            <>
            {type == "module" ?(
            <ContentTab
              data={props.data}
              indexes={props.indexes}
              onChangeStyle={onChangeStyle}
              postData={props?.postData}
            ></ContentTab>
            ):(
              <DesignTab
              data={props.data}
              indexes={props.indexes}
              onChangeStyle={onChangeStyle}
              postData={props?.postData}
              deviceSwitch={props.selectedDevice}
              widgets ="1"
            ></DesignTab>
            )}
            </>
          ) : null}
          {activeTab == "design" ? (
            <DesignTab
              data={props.data}
              indexes={props.indexes}
              onChangeStyle={onChangeStyle}
              postData={props?.postData}
              deviceSwitch={props.selectedDevice}
               widgets =""
            ></DesignTab>
          ) : null}
          {activeTab == "advanced" ? (
            <AdvancedTab
              data={props.data}
              indexes={props.indexes}
              postData={props?.postData}
              onChangeData={onChangeStyle}
            ></AdvancedTab>
          ) : null}
          </>
        ):(
          <Skeleton active/>
        )}
        </div>
        {/* <div className="setting-popup-footer">
          <div className="setting-popup-footer-btn cancel" onClick={cancelPopUp}>Cancel</div>
          <div className="setting-popup-footer-btn save" onClick={() => props.closePopup('save')}>Save</div>
        </div> */}
        </>
       ):(
        <Skeleton active/>
      )}
      </div>
    </div>
  );
};

export default SettingPopUp;
