import React, { useState } from "react";
import { Input } from "antd";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faRectangleXmark } from "@fortawesome/free-solid-svg-icons";
import { moduleStyle } from "./styleData";
import customText from "../MainComponents/images/custom-text-module.png";
import image from "../MainComponents/images/custom-image-module.png";
import { billingFieldsRawData } from "./billingFieldsRawData";
import { shippingFieldsRawData } from "./shippingFieldsRawData";
const NewModulePopUp = (props) => {
  // console.log(props);
  // console.log(props.data);
  const initialModules = [
    {
      title: "Billing Fields",
      type: "module",
      style: {
        ...moduleStyle,
        desktop: {
          ...moduleStyle.desktop,
          default: {
            ...moduleStyle.desktop.default,
            paddingTop: '0px',
            paddingBottom: '0px',
          },
        },
        label: {
          ...moduleStyle,
          desktop: {
            ...moduleStyle.desktop,
            default: {
              ...moduleStyle.desktop.default,
              flexBasis: "auto",
              height: "auto",
              position: "relative",
              paddingTop: "0px",
              paddingRight: "0",
              paddingBottom: "0px",
              paddingLeft: "0",
              marginTop: "0",
              marginRight: "0",
              marginBottom: "0",
              marginLeft: "0",
              backgroundColor: 'initial',
              color: "#666666",
              fontFamily: "Open Sans",
            }
          },
        },
        meta: {
          ...moduleStyle,
          desktop: {
            ...moduleStyle.desktop,
            default: {
              ...moduleStyle.desktop.default,
              flexBasis: "auto",
              height: "auto",
              position: "relative",
              paddingTop: "16px",
              paddingRight: "16px",
              paddingBottom: "16px",
              paddingLeft: "16px",
              marginTop: "0",
              marginRight: "0",
              marginBottom: "0",
              marginLeft: "0",
              backgroundColor: "#eeeeee",
              color: "#999999",
              fontFamily: "Open Sans",
              fontSize: '14px',
              borderWidth: '0px',
              borderRadius: '0px'
            }
          },
        }
      },
      key: "billing_fields",
      settings: {
        background_image: "",
        custom_class: "",
        link: {
          visibility: false,
          type: "",
          customlink: "",
          target: "",
          condition: "",
        },
        icons: {
          visibility: false,
          icon: "",
          position: "before-title",
        },
        fields: { ...billingFieldsRawData },
      },

    },
    {
      title: "Shipping Fields",
      type: "module",
      style: {
        ...moduleStyle,
        desktop: {
          ...moduleStyle.desktop,
          default: {
            ...moduleStyle.desktop.default,
            paddingTop: '0px',
            paddingBottom: '0px',
          },
        },
        label: {
          ...moduleStyle,
          desktop: {
            ...moduleStyle.desktop,
            default: {
              ...moduleStyle.desktop.default,
              flexBasis: "auto",
              height: "auto",
              position: "relative",
              paddingTop: "0px",
              paddingRight: "0",
              paddingBottom: "0px",
              paddingLeft: "0",
              marginTop: "0",
              marginRight: "0",
              marginBottom: "0",
              marginLeft: "0",
              backgroundColor: 'initial',
              color: "#666666",
              fontFamily: "Open Sans",
            }
          },
        },
        meta: {
          ...moduleStyle,
          desktop: {
            ...moduleStyle.desktop,
            default: {
              ...moduleStyle.desktop.default,
              flexBasis: "auto",
              height: "auto",
              position: "relative",
              paddingTop: "16px",
              paddingRight: "16px",
              paddingBottom: "16px",
              paddingLeft: "16px",
              marginTop: "0",
              marginRight: "0",
              marginBottom: "0",
              marginLeft: "0",
              backgroundColor: "#eeeeee",
              color: "#999999",
              fontFamily: "Open Sans",
              fontSize: '14px',
              borderWidth: '0px',
              borderRadius: '0px'
            }
          },
        }
      },
      key: "shipping_fields",
      settings: {
        background_image: "",
        custom_class: "",
        display_shipping: 1,
        shipping_diff_label: "Ship to a different address?",
        shipping_checked: 1,
        link: {
          visibility: false,
          type: "",
          customlink: "",
          target: "",
          condition: "",
        },
        icons: {
          visibility: false,
          icon: "",
          position: "before-title",
        },
        fields: { ...shippingFieldsRawData },
      },
    },
    {
      title: "Order Review",
      type: "module",
      style: {
        ...moduleStyle,
        desktop: {
          ...moduleStyle.desktop,
          default: {
            ...moduleStyle.desktop.default,
            paddingTop: '10px',
            paddingBottom: '10px',
            paddingLeft: '10px',
            paddingRight: '10px',
            fontWeight: '700',
            fontSize: '16px',
            lineHeight: '21px',
            fontFamily: 'Open Sans',
            backgroundColor: 'initial',
          },
        },
        label: {
          ...moduleStyle,
          desktop: {
            ...moduleStyle.desktop,
            default: {
              ...moduleStyle.desktop.default,
              flexBasis: "auto",
              height: "auto",
              position: "relative",
              paddingTop: '10px',
              paddingBottom: '10px',
              paddingLeft: '10px',
              paddingRight: '10px',
              marginTop: "0",
              marginRight: "0",
              marginBottom: "0",
              marginLeft: "0",
              backgroundColor: 'initial',
              color: "#666666",
              fontSize: '16px',
              lineHeight: '21px',
              fontFamily: 'Open Sans'
            }
          },
        },
        meta: {
          ...moduleStyle,
          desktop: {
            ...moduleStyle.desktop,
            default: {
              ...moduleStyle.desktop.default,
              flexBasis: "auto",
              height: "auto",
              position: "relative",
              paddingTop: "10px",
              paddingRight: "10px",
              paddingBottom: "10px",
              paddingLeft: "10px",
              marginTop: "0",
              marginRight: "0",
              marginBottom: "0",
              marginLeft: "0",
              backgroundColor: "initial",
              color: "#666666",
              fontSize: '16px',
              fontWeight: '700',
              lineHeight: '21px',
              fontFamily: 'Open Sans',
              borderWidth: '1px',
              borderRadius: '0px'
            }
          },
        }
      },
      key: "order_review",
      settings: {
        background_image: "",
        custom_class: "",
        link: {
          visibility: false,
          type: "",
          customlink: "",
          target: "",
          condition: "",
        },
        icons: {
          visibility: false,
          icon: "",
          position: "before-title",
        }
      },
    },
    {
      title: "Payments",
      type: "module",
      style: { ...moduleStyle },
      key: "payment_method",
      settings: {
        background_image: "",
        custom_class: "",
        link: {
          visibility: false,
          type: "",
          customlink: "",
          target: "",
          condition: "",
        },
        icons: {
          visibility: false,
          icon: "",
          position: "before-title",
        }
      },
    },
    {
      title: "Coupons Section",
      type: "module",
      style: {
        ...moduleStyle,
        desktop: {
          ...moduleStyle.desktop,
          default: {
            ...moduleStyle.desktop.default,
            paddingTop: '10px',
            paddingBottom: '10px',
            paddingLeft: '10px',
            paddingRight: '10px',
            fontWeight: '700',
            fontSize: '16px',
            lineHeight: '21px',
            fontFamily: 'Open Sans',
            backgroundColor: 'initial',
          },
        },
        label: {
          ...moduleStyle,
          desktop: {
            ...moduleStyle.desktop,
            default: {
              ...moduleStyle.desktop.default,
              flexBasis: "auto",
              height: "auto",
              position: "relative",
              paddingTop: '10px',
              paddingBottom: '10px',
              paddingLeft: '10px',
              paddingRight: '10px',
              marginTop: "0",
              marginRight: "0",
              marginBottom: "0",
              marginLeft: "0",
              backgroundColor: 'initial',
              color: "#666666",
              fontSize: '16px',
              lineHeight: '21px',
              fontFamily: 'Open Sans'
            }
          },
        },
        meta: {
          ...moduleStyle,
          desktop: {
            ...moduleStyle.desktop,
            default: {
              ...moduleStyle.desktop.default,
              flexBasis: "auto",
              height: "auto",
              position: "relative",
              paddingTop: "10px",
              paddingRight: "10px",
              paddingBottom: "10px",
              paddingLeft: "10px",
              marginTop: "0",
              marginRight: "0",
              marginBottom: "0",
              marginLeft: "0",
              backgroundColor: "initial",
              color: "#666666",
              fontSize: '16px',
              fontWeight: '700',
              lineHeight: '21px',
              fontFamily: 'Open Sans',
              borderWidth: '1px',
              borderRadius: '0px'
            }
          },
        }
      },
      key: "apply_coupon",
      settings: {
        background_image: "",
        custom_class: "",
        label: "If you have a coupon code, please apply it below.",
        placeholder: 'Coupon Code',
        btn_text: 'Apply Coupon',
        link: {
          visibility: false,
          type: "",
          customlink: "",
          target: "",
          condition: "",
        },
        icons: {
          visibility: false,
          icon: "",
          position: "before-title",
        }
      },
    },
    {
      title: "Custom Text",
      type: "module",
      style: { ...moduleStyle },
      key: "customtext",
      settings: {
        background_image: "",
        custom_class: "",
        customText: "",
      },
    },
  ];
  // console.log(initialModules);
  const [searchValue, setSearchValue] = useState("");
  const [modules, setModules] = useState(initialModules.map(item => JSON.parse(JSON.stringify(item))));
  // console.log(modules);
  const handleModuleSearch = (event) => {
    let value = event.target.value;
    setSearchValue(value);
    let newArray = initialModules.filter(function (item) {
      return item.title
        .toString()
        .toLowerCase()
        .includes(value.toString().toLowerCase());
    });
    setModules([...newArray]);
  };
  const selectModuleImage = (key) => {
    if (key === "customtext") {
      return customText;
    } else {
      return image;
    }
  };
  const handleSelectModule = (item) => {
    //console.log(item);
    props.onSelectModule(item)
  }
  const getUsedModuleKeys = () => {
    const usedKeys = new Set();
    props.data?.forEach((row) => {
      row.data?.forEach((column) => {
        column.data?.forEach((module) => {
          usedKeys.add(module.key);
        });
      });
    });
    return usedKeys;
  };
  const allowMultiple = ['customtext', 'customimage']; // add more as needed

  return (
    <div className="setting-popup-overlay-wrapper new-module">
      <div className={`setting-popup ${props?.animation}`}>
        <div className="setting-popup-title-bar">
          Select Module
          <div className="closeSettingPop" onClick={props.closeNewModulePopup}>
            <FontAwesomeIcon icon={faRectangleXmark} />
          </div>
        </div>
        <div className="new-modules-container">
          <div className="module-search-bar">
            <Input
              placeholder="Search module"
              value={searchValue}
              onChange={handleModuleSearch}
            />
          </div>
          <ul>
            {modules.map((item) => {
              const usedKeys = getUsedModuleKeys();
              const isUsed = usedKeys.has(item.key) && !allowMultiple.includes(item.key);
              return (
                <li
                  key={item.key}
                  className={`caf-post-select-module-pop-up ${isUsed ? "disabled" : ""}`}
                  style={{ opacity: isUsed ? 0.5 : 1, pointerEvents: isUsed ? 'none' : 'auto' }}
                >
                  <img className="caf-post-select-module-pop-up-img"
                    onClick={() => !isUsed && handleSelectModule(item)}
                    src={selectModuleImage(item.key)}
                    alt="img"
                  />
                  {item.title}
                </li>
              );
            })}
          </ul>
        </div>
      </div>
    </div >
  );
};

export default NewModulePopUp;
