import React, { useState, useEffect } from 'react';
//import existingGif from '../assets/images/existing.gif';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faUpDownLeftRight, faGear, faTableColumns, faTrash, faXmark } from '@fortawesome/free-solid-svg-icons';
import { initialData } from './initialData';
const RenderTemplate = (id) => {
    console.log("id1", id);
    console.log("initialData", initialData);
    const [showPopUp, setShowPopUp] = useState(false);
    const [pHeaderName, setPHeaderName] = useState('Settings');
    const [pClass, setPClass] = useState('common-settings');

    const handleColumnSettings = (headername) => {
        console.log('columnhandle');
        setShowPopUp(true);
        setPHeaderName(headername);
        setPClass('column-settings');
    };
    const handleClosePopup = () => {
        console.log('closepopup');
        setShowPopUp(false);
    };
    const ColumnSettingCompo = () => {
        return (
            <>
                <FontAwesomeIcon icon={faTableColumns} />
                <FontAwesomeIcon icon={faTableColumns} />
                <FontAwesomeIcon icon={faTableColumns} />
                <FontAwesomeIcon icon={faTableColumns} />
                <FontAwesomeIcon icon={faTableColumns} />
                <FontAwesomeIcon icon={faTableColumns} />
            </>
        )
    }
    return (
        <>
            {initialData?.map((section, sectionindex) => {
                if (section.type === 'section') {
                    return (
                        <div className='trusty-woo-checkout-builder-sections' key={sectionindex} style={section.style?.desktop?.default || {}}>
                            <div className='trusty-woo-checkout-builder-settings'>
                                <FontAwesomeIcon icon={faUpDownLeftRight} />
                                <FontAwesomeIcon icon={faGear} />
                                <FontAwesomeIcon icon={faTrash} />
                            </div>

                            {/* ✅ Render Rows Inside Section */}
                            {section.data?.map((row, rowindex) => (
                                <div className="trusty-woo-checkout-row" key={rowindex} style={row.style?.desktop?.default || {}}>
                                     <div className='trusty-woo-checkout-builder-settings'>
                                <FontAwesomeIcon icon={faUpDownLeftRight} />
                                <FontAwesomeIcon icon={faGear} />
                                <FontAwesomeIcon icon={faTableColumns} onClick={() => handleColumnSettings('Choose Layout')} />
                                <FontAwesomeIcon icon={faTrash} />
                            </div>
                                    {/* ✅ Render Columns Inside Section */}
                                    {row.data?.map((column, columnindex) => (
                                        <div className="trusty-woo-checkout-column" key={columnindex}>
                                            {/* Optional: render modules */}
                                            {column.data?.map((module, moduleindex) => (
                                                <div className="trusty-woo-checkout-module" key={moduleindex}>
                                                    {module.title}
                                                </div>
                                            ))}
                                        </div>
                                    ))}
                                </div>
                            ))}
<div className='trusty-woo-checkout-builder-section-add'><span>+</span></div>
                        </div>
                    );
                }

                return null;
            })}

            {/* <div className='trusty-woo-checkout-builder-sections'>
                <div className='trusty-woo-checkout-builder-section-add'>
                    <div className='trusty-woo-checkout-builder-settings'>
                        <FontAwesomeIcon icon={faUpDownLeftRight} />
                        <FontAwesomeIcon icon={faGear} />
                        <FontAwesomeIcon icon={faTableColumns} onClick={() => handleColumnSettings('Choose Layout')} />
                        <FontAwesomeIcon icon={faTrash} />
                    </div>
                    <div className='trusty-woo-checkout-builder-column-add' title="Add Module">+</div>
                </div>

            </div> */}


            {showPopUp && (
                <div className={`trusty-woo-popup-overlay ${pClass}`}>
                    <div className="trusty-woo-popup-content">
                        <div className='trusty-woo-popup-header'>
                            <h2>{pHeaderName}</h2>
                            <FontAwesomeIcon icon={faXmark} onClick={handleClosePopup} />
                        </div>
                        <div className='trusty-woo-popup-settings-area'>
                            {pClass === 'column-settings' && (
                                <>
                                    <ColumnSettingCompo />
                                </>
                            )}

                        </div>
                    </div>

                </div>
            )}

        </>

    );
}

export default RenderTemplate; 