import React, { useEffect, useState } from "react";
import { columnStyle } from "../../components/styleData";
import { Resizable } from "react-resizable";
import { DragDropContext, Draggable, Droppable } from "react-beautiful-dnd";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {  faPlus,  faTrashAlt } from "@fortawesome/free-solid-svg-icons";
// import { LeftOutlined, RightOutlined } from "@ant-design/icons";
import { CaretDownOutlined, CaretUpOutlined, EditOutlined } from "@ant-design/icons";
import titleImg from "../images/post-title.png";
import descriptionImg from "../images/post-description.png";
import axios from "axios";
import { Skeleton } from "antd";
import newRow from "../../components/newElementData/newRow";
import newColumnData from "../../components/newElementData/newColumn";
import NewModulePopUp from "../../components/NewModulePopUp";
import SettingPopUp from "../../components/SettingPopUp";
import MainArea from "./MainArea";
import moduleActive from "../images/module-active.png"
import moduleInActive from "../images/module-inactive.png"
import leftArrow from "../images/left-arrow.svg"
import rightArrow from "../images/right-arrow.svg"

const PostBuilderContainer = (props) => {
  axios.defaults.headers.common['Cache-Control'] = 'no-cache, no-store, must-revalidate';
  axios.defaults.headers.common['Pragma'] = 'no-cache';
  axios.defaults.headers.common['Expires'] = '0';
  // console.log(props);
  const { extra_data } = { ...props.mainBuilderData.post_layout_data };
  const [width, setWidth] = useState(335);
  const [rWidth, setRwidth] = useState(335);
  const [addSkelton, setAddSkelton] = useState(false);
  const [selectedDevice, setSelectedDevice] = useState("desktop");
  const [previewState, setPreviewState] = useState("1");
  const [initialdata, setInitialData] = useState(
    props.mainBuilderData.post_layout_data?.initial_data
  );
  //console.log(props.mainBuilderData.post_layout_data?.initial_data);
  const [showModulePopUp, setShowModulePopUp] = useState(false);
  // const [mainBuilderData,setMainBuilderData]=useState()
  const [indexes, setIndexes] = useState({
    rowindex: 0,
    columnindex: "",
    moduleindex: "",
    module: "",
    type: "row",
  });
  const [moduleIndexes, setModuleIndexes] = useState({});
  const [clicked, setClicked] = useState(false);
  const [points, setPoints] = useState({
    x: 0,
    y: 0,
  });
  const [popIndex, setPopIndex] = useState({
    rowIndex: "",
    columnIndex: "",
    moduleIndex: "",
  });
  useEffect(() => {
    if (initialdata !== undefined) {
      // Create a new copy of the mainBuilderData object
      const newbuilderdata = {
        ...props.mainBuilderData,
        post_layout_data: {
          ...props.mainBuilderData.post_layout_data,
          initial_data: initialdata,
        },
      };
      props.updatedBuilderData(newbuilderdata);
    }
  }, [initialdata]);

  useEffect(() => {
    if (previewState == "0") {
      setWidth(0);
      setRwidth(0);
      setShowModulePopUp(false);
    } else {
      setWidth(335);
      setRwidth(335);
      setShowModulePopUp(false);
    }
  }, [previewState])

  useEffect(() => {
    setAddSkelton(true);
    setTimeout(() => {
      setAddSkelton(false);
    }, 300);
  }, [indexes?.moduleindex, indexes.columnindex, indexes.rowindex]);

  const handleResize = (e, { size }) => {
    if (size.width < 335 && size.width > 250) {
      setWidth(size.width);
    }
  };
  const handleResizeRightSideBar = (e, { size }) => {
    let screen_width = window.innerWidth;
    let sizewidth = e.x;
    let setwidth = screen_width - sizewidth;
    if (setwidth <= 335 && setwidth >= 250) {
      setRwidth(setwidth);
    }
  };

  const handleSettingPopUp = (
    type,
    rowindex = "",
    columnindex = "",
    moduleindex = "",
    module = ""
  ) => {
    setIndexes((prevIndexes) => ({
      ...prevIndexes,
      type: type,
      rowindex: rowindex,
      columnindex: columnindex,
      moduleindex: moduleindex,
      module: module,
    }));
  };
  const removeArray = (arr, index) => [
    // part of the array before the specified index
    ...arr.slice(0, index),
    // part of the array after the specified index
    ...arr.slice(index + 1),
  ];

  const handleRemove = (type, rowindex, columnindex, moduleindex) => {
    if (type == "row" && initialdata?.length != 1) {
      const layoutCopy = JSON.parse(JSON.stringify(initialdata));
      const d = removeArray(layoutCopy, rowindex);
      setInitialData([...d]);
    }
    if (type == "column") {
      const layoutCopy = JSON.parse(JSON.stringify(initialdata));
      layoutCopy[rowindex].data.splice(columnindex, 1);
      setInitialData([...layoutCopy]);
    }
    if (type == "module") {
      const layoutCopy = JSON.parse(JSON.stringify(initialdata));
      layoutCopy[rowindex].data[columnindex].data.splice(moduleindex, 1);
      setInitialData([...layoutCopy]);
    }
    setIndexes({
      rowindex: 0,
      columnindex: "",
      moduleindex: "",
      module: "",
      type: "row",
    });
  };
  const checkModuleClick = (e, rowindex, columnindex, moduleindex) => {
    e.preventDefault();
    setClicked(!clicked);
    setPoints({
      x: e.pageX,
      y: e.pageY,
    });
    setPopIndex({
      rowIndex: rowindex,
      columnIndex: columnindex,
      moduleIndex: moduleindex,
    });
  };
  const onSelectModule = (item) => {
    const { rowindex, columnindex, moduleindex } = moduleIndexes;
    setShowModulePopUp(false);
    const layoutCopy = JSON.parse(JSON.stringify(initialdata));
    layoutCopy[rowindex].data[columnindex].data.push(item);
    setInitialData([...layoutCopy]);
    setIndexes(moduleIndexes);
    if (layoutCopy[rowindex].data[columnindex].data?.length == 1) {
      handleSettingPopUp("module", rowindex, columnindex, 0, item);
    } else {
      handleSettingPopUp(
        "module",
        rowindex,
        columnindex,
        moduleindex + 1,
        item
      );
    }
  };

  const handleAddModule = (rowindex, columnindex, moduleindex) => {
    moduleIndexes.rowindex = rowindex;
    moduleIndexes.columnindex = columnindex;
    moduleIndexes.moduleindex = moduleindex;
    setModuleIndexes(moduleIndexes);
    setShowModulePopUp(true);
  };

  const handleAddColumn = (rowindex, columnindex, addAfter = true) => {
    const layoutCopy = JSON.parse(JSON.stringify(initialdata));
    let index = addAfter ? columnindex + 1 : columnindex;

    let newCol = { ...newColumnData, data: [] };
    layoutCopy[rowindex].data.splice(index, 0, newCol);

    setInitialData([...layoutCopy]);

    indexes.rowindex = rowindex;
    indexes.columnindex = index;
    indexes.moduleindex = "";
    indexes.module = "";
    indexes.type = "column";
    setIndexes({ ...indexes });
  };

  const insert = (arr, index, newItem) => [
    // part of the array before the specified index
    ...arr.slice(0, index),
    // inserted item
    newItem,
    // part of the array after the specified index
    ...arr.slice(index),
  ];
  const handleAddRow = (rowindex) => {
    let newColData = [
      {
        type: "column",
        data: [],
        style: { ...columnStyle },
        settings: {
          background_image: "",
          collapse_status: "false",
        },
      },
    ];
    let index = rowindex + 1;
    let newRowData = { ...newRow, data: newColData };
    const newData = insert(initialdata, index, newRowData);
    setInitialData([...newData]);
    indexes.rowindex = index;
    indexes.columnindex = "";
    indexes.moduleindex = "";
    indexes.module = "";
    indexes.type = "row";
    setIndexes({ ...indexes });
  };
  const closeNewModulePopUp = () => {
    setShowModulePopUp(false);
  };
  const handleDragDrop = (results) => {
    const { source, destination, type } = results;
    if (!destination) return;
    if (type === "row") {
      let mdata = initialdata;
      let sourceRowIndex = source.index;
      let destinationRowIndex = destination.index;
      let removedRowData = mdata.splice(sourceRowIndex, 1)[0];
      mdata.splice(destinationRowIndex, 0, removedRowData);
      setInitialData([...mdata]);
      indexes.type = "row";
      indexes.rowindex = destinationRowIndex;
      indexes.columnindex = 0;
      indexes.moduleindex = 0;
      indexes.module = "";
      setIndexes(indexes);
      return;
    }
    if (type == "column") {
      let SourceColumnIndex = source.index;
      let DestinationColumnIndex = destination.index;

      let SourceRowIndex = source.droppableId;
      let DestinationRowIndex = destination.droppableId;

      let SourceColumns = [...initialdata[SourceRowIndex].data];

      let DestinationColumns =
        SourceRowIndex !== DestinationRowIndex
          ? [...initialdata[DestinationRowIndex].data]
          : SourceColumns;
      let [deletedColumn] = SourceColumns.splice(SourceColumnIndex, 1);
      DestinationColumns.splice(DestinationColumnIndex, 0, deletedColumn);

      let mdata = [...initialdata];
      mdata[SourceRowIndex] = {
        ...initialdata[SourceRowIndex],
        data: SourceColumns,
      };
      mdata[DestinationRowIndex] = {
        ...initialdata[DestinationRowIndex],
        data: DestinationColumns,
      };
      setInitialData(mdata);
      indexes.type = "column";
      indexes.rowindex = DestinationRowIndex;
      indexes.columnindex = DestinationColumnIndex;
      indexes.moduleindex = 0;
      indexes.module = "";
      setIndexes(indexes);
      return;
    }
    if (type == "module") {
      let SourceModuleIndex = source.index;
      let DestinationModuleIndex = destination.index;

      let SourceDroppableData = source.droppableId.split(",");
      let DestinationDroppableData = destination.droppableId.split(",");

      let SourceColumnIndex = SourceDroppableData[1];
      let DestinationColumnIndex = DestinationDroppableData[1];

      let SourceRowIndex = SourceDroppableData[0];
      let DestinationRowIndex = DestinationDroppableData[0];

      let mdata = initialdata;
      let DeletedModuledata = mdata[SourceRowIndex].data[
        SourceColumnIndex
      ].data.splice(SourceModuleIndex, 1)[0];
      mdata[DestinationRowIndex].data[DestinationColumnIndex].data.splice(
        DestinationModuleIndex,
        0,
        DeletedModuledata
      );
      setInitialData([...mdata]);
      indexes.type = "module";
      indexes.rowindex = DestinationRowIndex;
      indexes.columnindex = DestinationColumnIndex;
      indexes.moduleindex = DestinationModuleIndex;
      indexes.module = DeletedModuledata;
      setIndexes(indexes);
      return;
    }
  };
  const collapseArrowLeftClick = () => {
    if (previewState == '1') {
      if (width == 0) {
        setWidth(335);
      } else {
        setWidth(0);
      }
      setShowModulePopUp(false);
    }
  };

  const collapseArrowRightClick = () => {
    if (previewState == '1') {
      if (rWidth == 0) {
        setRwidth(335);
      } else {
        setRwidth(0);
      }
    }
  };
  const onChangeStyle = (data) => {
    setInitialData([...data]);
  };
  const handleCollapse = (type, indexRow, indexCol) => {
    if (type === "row") {
      setInitialData((prevData) =>
        prevData.map((row, i) =>
          i === indexRow
            ? { ...row, settings: { ...row.settings, collapse_status: "true" } }
            : row
        )
      );
    } else {
      setInitialData((prevData) =>
        prevData.map((row, i) => {
          if (i === indexRow) {
            return {
              ...row,
              data: row.data.map((col, j) =>
                j === indexCol
                  ? {
                    ...col,
                    settings: { ...col.settings, collapse_status: "true" },
                  }
                  : col
              ),
            };
          }
          return row;
        })
      );
    }
  };
  const handleExpand = (type, indexRow, indexCol) => {
    if (type === "row") {
      setInitialData((prevData) =>
        prevData.map((row, i) =>
          i === indexRow
            ? {
              ...row,
              settings: { ...row.settings, collapse_status: "false" },
            }
            : row
        )
      );
    } else {
      setInitialData((prevData) =>
        prevData.map((row, i) => {
          if (i === indexRow) {
            return {
              ...row,
              data: row.data.map((col, j) =>
                j === indexCol
                  ? {
                    ...col,
                    settings: { ...col.settings, collapse_status: "false" },
                  }
                  : col
              ),
            };
          }
          return row;
        })
      );
    }
  };
  const selectModuleImage = (key) => {
    if (key === "title") {
      return titleImg;
    } else if (key === "excerpt") {
      return descriptionImg;
    } else {
      return descriptionImg;
    }
  };
  const getItemStyle = (isDragging, draggableStyle) => ({
    // Change background color if dragging
    background: isDragging ? "lightblue" : "",
    // styles we need to apply on draggables
    ...draggableStyle,
  });

  /*============================================== Start Font Family Linking =========================================================*/

  const loadFont = (fontFamily) => {
    if (!document.getElementById(fontFamily) && fontFamily) {
      const link = document.createElement("link");
      link.href = `https://fonts.googleapis.com/css?family=${fontFamily}:regular&display=swap`;
      link.async = true;
      link.id = fontFamily;
      link.type = "text/css";
      link.rel = "stylesheet";
      document.body.appendChild(link);
    }
  };
  {
    /* Start For Row */
    initialdata?.map((row, rowindex) => {

      {
        row.data.map((column, columnindex) => {
          {
            column.data?.map((module, moduleindex) => {

              if (module.key === 'billing_fields' || module.key === 'shipping_fields') {
               // console.log(module);
                {
                  Object.values(module.settings.fields)?.map((field, fieldindex) => {
                   if(field.type==='heading') {
                    loadFont(field?.style?.fontFamily);
                   }
                  })
                }
              }
            })
          }
        })
      }
      if (row?.style?.desktop?.default?.fontFamily) {
        loadFont(row?.style?.desktop?.default?.fontFamily);
      }
      if (row?.style?.desktop?.hover?.fontFamily) {
        loadFont(row?.style?.desktop?.hover?.fontFamily);
      }
      if (row?.style?.tablet?.default?.fontFamily) {
        loadFont(row?.style?.tablet?.default?.fontFamily);
      }
      if (row?.style?.tablet?.hover?.fontFamily) {
        loadFont(row?.style?.tablet?.hover?.fontFamily);
      }
      if (row?.style?.mobile?.default?.fontFamily) {
        loadFont(row?.style?.mobile?.default?.fontFamily);
      }
      if (row?.style?.mobile?.hover?.fontFamily) {
        loadFont(row?.style?.mobile?.hover?.fontFamily);
      }
      /* Start For Column */
      row.data?.map((column, columnindex) => {

        if (column?.style?.desktop?.default?.fontFamily) {
          loadFont(column?.style?.desktop?.default?.fontFamily);
        }
        if (column?.style?.desktop?.hover?.fontFamily) {
          loadFont(column?.style?.desktop?.hover?.fontFamily);
        }
        if (column?.style?.tablet?.default?.fontFamily) {
          loadFont(column?.style?.tablet?.default?.fontFamily);
        }
        if (column?.style?.tablet?.hover?.fontFamily) {
          loadFont(column?.style?.tablet?.hover?.fontFamily);
        }
        if (column?.style?.mobile?.default?.fontFamily) {
          loadFont(column?.style?.mobile?.default?.fontFamily);
        }
        if (column?.style?.mobile?.hover?.fontFamily) {
          loadFont(column?.style?.mobile?.hover?.fontFamily);
        }
        /* Start For Module */
        column.data?.map((module, moduleindex) => {
          /*Start for container*/

          if (module?.style?.desktop?.default?.fontFamily) {
            loadFont(module?.style?.desktop?.default?.fontFamily);
          }
          if (module?.style?.desktop?.hover?.fontFamily) {
            loadFont(module?.style?.desktop?.hover?.fontFamily);
          }
          if (module?.style?.tablet?.default?.fontFamily) {
            loadFont(module?.style?.tablet?.default?.fontFamily);
          }
          if (module?.style?.tablet?.hover?.fontFamily) {
            loadFont(module?.style?.tablet?.hover?.fontFamily);
          }
          if (module?.style?.mobile?.default?.fontFamily) {
            loadFont(module?.style?.container?.mobile?.default?.fontFamily);
          }
          if (module?.style?.mobile?.hover?.fontFamily) {
            loadFont(module?.style?.container?.mobile?.hover?.fontFamily);
          }


          /* start for custom field label */

          if (module?.style?.label?.desktop?.default?.fontFamily) {
            loadFont(module?.style?.label?.desktop?.default?.fontFamily);
          }
          if (module?.style?.label?.desktop?.hover?.fontFamily) {
            loadFont(module?.style?.label?.desktop?.hover?.fontFamily);
          }
          if (module?.style?.label?.tablet?.default?.fontFamily) {
            loadFont(module?.style?.label?.tablet?.default?.fontFamily);
          }
          if (module?.style?.label?.tablet?.hover?.fontFamily) {
            loadFont(module?.style?.label?.tablet?.hover?.fontFamily);
          }
          if (module?.style?.label?.mobile?.default?.fontFamily) {
            loadFont(module?.style?.label?.mobile?.default?.fontFamily);
          }
          if (module?.style?.label?.mobile?.hover?.fontFamily) {
            loadFont(module?.style?.label?.mobile?.hover?.fontFamily);
          }

          /*start for custom field  meta*/

          if (module?.style?.meta?.desktop?.default?.fontFamily) {
            loadFont(module?.style?.meta?.desktop?.default?.fontFamily);
          }
          if (module?.style?.meta?.desktop?.hover?.fontFamily) {
            loadFont(module?.style?.meta?.desktop?.hover?.fontFamily);
          }
          if (module?.style?.meta?.tablet?.default?.fontFamily) {
            loadFont(module?.style?.meta?.tablet?.default?.fontFamily);
          }
          if (module?.style?.meta?.tablet?.hover?.fontFamily) {
            loadFont(module?.style?.meta?.tablet?.hover?.fontFamily);
          }
          if (module?.style?.meta?.mobile?.default?.fontFamily) {
            loadFont(module?.style?.meta?.mobile?.default?.fontFamily);
          }
          if (module?.style?.meta?.mobile?.hover?.fontFamily) {
            loadFont(module?.style?.meta?.mobile?.hover?.fontFamily);
          }
        });
      });
    }
    )
  };
  /*============================================== End Font Family Linking =========================================================*/
  return (
    <div className="main-area-container-fix main-container-post">
      <div className="caf-collapse-left-sidebar" style={{ display: "flex", position: "relative" }}>
        {showModulePopUp ? (
          <NewModulePopUp
            closeNewModulePopup={closeNewModulePopUp}
            onSelectModule={onSelectModule}
            data={initialdata}
            indexes={indexes}
            animation="popup-content"
          />
        ) : null}
        <div className="caf-builder-sidebar" style={{
          width: `${width}px`,
          transition: "all 0.5s ease-out",
          visibility: width == 0 ? "hidden" : "visible",
        }}
        >
          <Resizable
            width={width}
            height={500} // Set the fixed height here
            onResize={handleResize}
            enable={{
              top: false, // Disable top resizing
              right: true, // Enable right resizing
              bottom: false, // Disable bottom resizing
              left: true, // Enable left resizing
              topRight: false,
              bottomRight: false,
              bottomLeft: false,
              topLeft: false,
            }}
          >
            <div className="caf-builder-wrapper">
              <div className="caf-builder-wrapper-area wrapper">
                <DragDropContext onDragEnd={handleDragDrop}>
                  <Droppable droppableId="ROOT" type="row">
                    {(provided) => (
                      <div {...provided.droppableProps} ref={provided.innerRef}>
                        {initialdata?.length == 0 ? (
                          <>
                            <Skeleton active />
                            <Skeleton active />
                            <Skeleton active />
                          </>
                        ) : (
                          ""
                        )}
                        {initialdata?.map((row, rowindex) => {
                          return (
                            <Draggable
                              draggableId={`${rowindex}`}
                              key={rowindex}
                              index={rowindex}
                            >
                              {(provided, snapshot) => (
                                <div
                                  index={rowindex}
                                  {...provided.dragHandleProps}
                                  {...provided.draggableProps}
                                  style={provided.draggableProps.style}
                                  ref={provided.innerRef}
                                >
                                  <div
                                    style={{
                                      backgroundColor: snapshot.isDragging
                                        ? "lightblue"
                                        : "",
                                    }}
                                    className={`${row.settings.collapse_status === "true"
                                        ? "caf-builder-row-wrapper-none"
                                        : "caf-builder-row-wrapper"
                                      } ${indexes.type == "row" &&
                                        indexes.rowindex == rowindex
                                        ? " active"
                                        : ""
                                      }`}
                                    key={rowindex}
                                  >
                                    <div
                                      className={`caf-builder-title-bar b-row ${indexes.type == "row" &&
                                          indexes.rowindex == rowindex
                                          ? " active"
                                          : ""
                                        }`}
                                    >
                                      <div className="caf-title-bar-left-side-row">
                                        <div className="caf-collapse-arrow">
                                          {row.settings.collapse_status ===
                                            "false" ? (
                                            <CaretUpOutlined
                                              color="#ffffff"
                                              size="1x"
                                              onClick={() =>
                                                handleCollapse("row", rowindex)
                                              }
                                            />
                                          ) : (
                                            <CaretDownOutlined
                                              color="#ffffff"
                                              size="1x"
                                              onClick={() =>
                                                handleExpand("row", rowindex)
                                              }
                                            />
                                          )}
                                        </div>
                                        <div className="caf-main-text">Row</div>
                                      </div>
                                      <div className="caf-title-bar-right-side-row">
                                        <div
                                          className="builder-setting-btn caf-right-module"
                                          onClick={() =>
                                            handleSettingPopUp("row", rowindex)
                                          }
                                        >
                                          <EditOutlined style={{ fontSize: '20px', color: '#ffffff' }} />
                                        </div>
                                        <div
                                          className="caf-main-text-close"
                                          onClick={() =>
                                            handleRemove("row", rowindex)
                                          }
                                        >
                                          <FontAwesomeIcon icon={faTrashAlt} className="caf-builder-delete-icon" style={{ fontSize: '18px', color: '#ffffff' }} />
                                        </div>
                                      </div>
                                    </div>
                                    <div
                                      className={`caf-builder-wrapper-area b-row ${row.settings.collapse_status === "false"
                                          ? ""
                                          : "caf-post-builder-col"
                                        }`}
                                    >
                                      <Droppable
                                        droppableId={`${rowindex}`}
                                        type="column"
                                      >
                                        {(provided) => (
                                          <div
                                            className={`caf-builder-col ${row?.data?.length == 0 ?
                                                "empty-row" : ""
                                              }`}
                                            {...provided.droppableProps}
                                            ref={provided.innerRef}
                                          >
                                            {row?.data?.map(
                                              (column, columnindex) => {
                                                return (
                                                  <Draggable
                                                    draggableId={`${rowindex},${columnindex}`}
                                                    index={columnindex}
                                                    key={columnindex}
                                                  >
                                                    {(provided, snapshot) => (
                                                      <div
                                                        index={columnindex}
                                                        {...provided.dragHandleProps}
                                                        {...provided.draggableProps}
                                                        style={getItemStyle(
                                                          snapshot.isDragging,
                                                          provided
                                                            .draggableProps
                                                            .style
                                                        )}
                                                        ref={provided.innerRef}
                                                        className={`${column.settings
                                                            .collapse_status ===
                                                            "true"
                                                            ? "caf-builder-column-wrapper-none"
                                                            : "caf-builder-column-wrapper"
                                                          } ${columnindex > 0 ? 'draggable-col-wrapper' : ""} ${indexes.type ==
                                                            "column" &&
                                                            indexes.rowindex ==
                                                            rowindex &&
                                                            indexes.columnindex ==
                                                            columnindex
                                                            ? "active"
                                                            : ""
                                                          }`}
                                                      >
                                                        <div
                                                          className={`caf-builder-title-bar b-column ${indexes.type ==
                                                              "column" &&
                                                              indexes.rowindex ==
                                                              rowindex &&
                                                              indexes.columnindex ==
                                                              columnindex
                                                              ? "active"
                                                              : ""
                                                            }`}
                                                        >
                                                          <div className="caf-title-bar-left-side-row">
                                                            <div className="caf-collapse-arrow">
                                                              {column.settings
                                                                .collapse_status ===
                                                                "false" ? (
                                                                <CaretUpOutlined
                                                                  color="#ffffff"
                                                                  size="1x"
                                                                  onClick={() =>
                                                                    handleCollapse(
                                                                      "col",
                                                                      rowindex,
                                                                      columnindex
                                                                    )
                                                                  }
                                                                />
                                                              ) : (
                                                                <CaretDownOutlined
                                                                  color="#ffffff"
                                                                  size="1x"
                                                                  onClick={() =>
                                                                    handleExpand(
                                                                      "col",
                                                                      rowindex,
                                                                      columnindex
                                                                    )
                                                                  }
                                                                />
                                                              )}
                                                            </div>
                                                            <div className="caf-main-text">
                                                              Column
                                                            </div>
                                                          </div>
                                                          <div className="caf-title-bar-right-side-row">
                                                            <div
                                                              className="builder-setting-btn caf-right-module"
                                                              onClick={() =>
                                                                handleSettingPopUp(
                                                                  "column",
                                                                  rowindex,
                                                                  columnindex
                                                                )
                                                              }
                                                            >
                                                              <EditOutlined style={{ fontSize: '20px' }} />
                                                            </div>
                                                            <div
                                                              className="caf-main-text-close"
                                                              onClick={() =>
                                                                handleRemove(
                                                                  "column",
                                                                  rowindex,
                                                                  columnindex
                                                                )
                                                              }
                                                            >
                                                              <FontAwesomeIcon icon={faTrashAlt} className="caf-builder-delete-icon" style={{ fontSize: '18px' }} />
                                                            </div>
                                                          </div>
                                                        </div>
                                                        <div
                                                          className={`caf-builder-wrapper-area b-column ${column.settings
                                                              .collapse_status ===
                                                              "false"
                                                              ? ""
                                                              : "caf-post-builder-col"
                                                            } ${column.data
                                                              .length == 0 ?
                                                              "empty-col" : ""
                                                            }`}
                                                        >
                                                          <Droppable
                                                            droppableId={`${rowindex},${columnindex}`}
                                                            type="module"
                                                          >
                                                            {(provided) => (
                                                              <div
                                                                {...provided.droppableProps}
                                                                ref={
                                                                  provided.innerRef
                                                                }
                                                                className="drop-module"
                                                                style={{
                                                                  minHeight:
                                                                    "40px",
                                                                }}
                                                              >
                                                                {column?.data?.map(
                                                                  (
                                                                    module,
                                                                    moduleindex
                                                                  ) => {
                                                                    return (
                                                                      <Draggable
                                                                        draggableId={`${rowindex},${columnindex},${moduleindex}`}
                                                                        index={
                                                                          moduleindex
                                                                        }
                                                                        key={
                                                                          moduleindex
                                                                        }
                                                                      >
                                                                        {(
                                                                          provided,
                                                                          snapshot
                                                                        ) => (
                                                                          <>
                                                                            <div
                                                                              {...provided.dragHandleProps}
                                                                              {...provided.draggableProps}
                                                                              style={
                                                                                provided
                                                                                  .draggableProps
                                                                                  .style
                                                                              }
                                                                              ref={
                                                                                provided.innerRef
                                                                              }
                                                                            >
                                                                              <div
                                                                                style={{
                                                                                  backgroundColor:
                                                                                    snapshot.isDragging
                                                                                      ? "lightblue"
                                                                                      : "",
                                                                                }}
                                                                                className={`caf-builder-module b-module ${indexes.type ==
                                                                                    "module" &&
                                                                                    indexes.rowindex ==
                                                                                    rowindex &&
                                                                                    indexes.columnindex ==
                                                                                    columnindex &&
                                                                                    indexes.moduleindex ==
                                                                                    moduleindex
                                                                                    ? "active"
                                                                                    : ""
                                                                                  } `}
                                                                                key={
                                                                                  moduleindex
                                                                                }
                                                                              // onContextMenu={() =>
                                                                              //   checkModuleClick(
                                                                              //     event,
                                                                              //     rowindex,
                                                                              //     columnindex,
                                                                              //     moduleindex
                                                                              //   )
                                                                              // }
                                                                              >
                                                                                <div className="caf-title-bar-left-side-row">
                                                                                  <div className="builder-setting-btn">
                                                                                    <img
                                                                                      src={
                                                                                        indexes.type ==
                                                                                          "module" &&
                                                                                          indexes.rowindex ==
                                                                                          rowindex &&
                                                                                          indexes.columnindex ==
                                                                                          columnindex &&
                                                                                          indexes.moduleindex ==
                                                                                          moduleindex
                                                                                          ? moduleActive
                                                                                          : moduleInActive
                                                                                      }
                                                                                      alt="img"
                                                                                    />
                                                                                  </div>
                                                                                  <div className="caf-main-text">
                                                                                    {
                                                                                      module.title
                                                                                    }
                                                                                  </div>
                                                                                </div>
                                                                                <div className="caf-title-bar-right-side-row">
                                                                                  <div
                                                                                    className="builder-setting-btn caf-right-module"
                                                                                    onClick={() =>
                                                                                      handleSettingPopUp(
                                                                                        "module",
                                                                                        rowindex,
                                                                                        columnindex,
                                                                                        moduleindex,
                                                                                        module
                                                                                      )
                                                                                    }
                                                                                  >
                                                                                    <EditOutlined style={{ fontSize: '20px' }} />
                                                                                  </div>
                                                                                  <div
                                                                                    className="caf-main-text-close"
                                                                                    onClick={() =>
                                                                                      handleRemove(
                                                                                        "module",
                                                                                        rowindex,
                                                                                        columnindex,
                                                                                        moduleindex
                                                                                      )
                                                                                    }
                                                                                  >
                                                                                    <FontAwesomeIcon icon={faTrashAlt} className="caf-builder-delete-icon" style={{ fontSize: '18px' }} />
                                                                                  </div>
                                                                                </div>
                                                                              </div>
                                                                            </div>
                                                                            {/* {moduleindex + 1 === column.data.length ? ( */}
                                                                            <div className="caf-builder-row-add module">
                                                                              <div
                                                                                className="caf-new-widget-main"
                                                                                onClick={() =>
                                                                                  handleAddModule(
                                                                                    rowindex,
                                                                                    columnindex,
                                                                                    moduleindex
                                                                                  )
                                                                                }
                                                                              >
                                                                                <FontAwesomeIcon icon={faPlus} className="caf-builder-plus-icon" style={{ fontSize: '18px', color: '#000000' }} />
                                                                                <span className="caf-new-widget-label">
                                                                                  New Widget
                                                                                </span>
                                                                              </div>
                                                                            </div>
                                                                            {/* ) : null} */}
                                                                          </>
                                                                        )}
                                                                      </Draggable>
                                                                    );
                                                                  }
                                                                )}
                                                                {column.data
                                                                  .length ==
                                                                  0 ? (
                                                                  <div className="caf-builder-row-add module">
                                                                    <div
                                                                      className="caf-new-widget-main"
                                                                      onClick={() =>
                                                                        handleAddModule(
                                                                          rowindex,
                                                                          columnindex,
                                                                          0
                                                                        )
                                                                      }
                                                                    >
                                                                      <FontAwesomeIcon icon={faPlus} className="caf-builder-plus-icon" style={{ fontSize: '18px', color: '#000000' }} />
                                                                      <span className="caf-new-widget-label modl">
                                                                        New Widget
                                                                        </span>
                                                                    </div>
                                                                  </div>
                                                                ) : null}
                                                                <div className="caf-builder-row-add column">
                                                                  <div
                                                                    className="caf-new-column-main"
                                                                    onClick={() =>
                                                                      handleAddColumn(
                                                                        rowindex,
                                                                        columnindex,
                                                                        true
                                                                      )
                                                                    }
                                                                  >
                                                                    <FontAwesomeIcon icon={faPlus} className="caf-builder-plus-icon" style={{ fontSize: '18px', color: '#000000' }} />
                                                                    <span className="caf-new-widget-label colm">
                                                                      New Column
                                                                    </span>
                                                                  </div>
                                                                </div>
                                                                {
                                                                  provided.placeholder
                                                                }
                                                              </div>
                                                            )}
                                                          </Droppable>
                                                        </div>
                                                      </div>
                                                    )}
                                                  </Draggable>
                                                );
                                              }
                                            )}
                                            {row?.data?.length == 0 && (
                                              <div className="caf-builder-row-add column add-new-col">
                                                <div
                                                  className="caf-new-column-main"
                                                  onClick={() =>
                                                    handleAddColumn(
                                                      rowindex,
                                                      0,
                                                      false
                                                    )
                                                  }
                                                >
                                                 <FontAwesomeIcon icon={faPlus} className="caf-builder-plus-icon" style={{ fontSize: '18px', color: '#000000' }} />
                                                  <span className="caf-new-widget-label colm">
                                                    New Column
                                                  </span>
                                                </div>
                                              </div>
                                            )}
                                            {provided.placeholder}
                                          </div>
                                        )}
                                      </Droppable>
                                      <div className="caf-builder-row-add">
                                        {/* <FontAwesomeIcon
                                          icon={faPlus}
                                          title="Add New Row"
                                          onClick={() => handleAddRow(rowindex)}
                                        /> */}

                                        <div
                                          className="caf-new-row-main"
                                          onClick={() => handleAddRow(rowindex)}
                                        >
                                          <FontAwesomeIcon icon={faPlus} className="caf-builder-plus-icon" style={{ fontSize: '18px', color: '#ffffff' }} />
                                          <span className="caf-new-widget-label rowbtn">
                                            New Row
                                          </span>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              )}
                            </Draggable>
                          );
                        })}
                        {provided.placeholder}
                      </div>
                    )}
                  </Droppable>
                </DragDropContext>
              </div>
            </div>
          </Resizable>
        </div>

        <div className="caf-collapse-left-sidebar-btn" style={{ position: "absolute", top: "50%", left: "100%", zIndex: 1 }} onClick={collapseArrowLeftClick}>
          {/* <button> */}
          {/* {width <= 335 && width != 0 && <LeftOutlined />}
            {width == 0 && <RightOutlined />} */}
          {width <= 335 && width != 0 && <img className="caf-collapse-left-sidebar-arrow-btn" src={leftArrow} />}
          {width == 0 && <img className="caf-collapse-left-sidebar-arrow-btn" src={leftArrow} />}
          {/* </button> */}
        </div>

      </div>
      <MainArea
        className="mainarea"
        previewState={setPreviewState}
        selectType={props.selectType}
        setSelectType={props.setSelectType}
        currStep={props.currStep}
        setCurrStep={props.setCurrStep}
        mainBuilderData={props.mainBuilderData}
        updatedBuilderData={props.updatedBuilderData}
        setIndexes={setIndexes}
        setSelectedDevice={setSelectedDevice}
      ></MainArea>
      <div className="caf-collapse-right-sidebar" style={{ display: "flex", position: "relative" }}>
        <div
          className="caf-collapse-right-sidebar-btn"
          style={{ position: "absolute", top: "50%", right: "100%", zIndex: 1 }}
          onClick={collapseArrowRightClick}
        >
          {/* <button> */}
          {/* {rWidth <= 335 && rWidth != 0 && <RightOutlined />}
            {rWidth == 0 && <LeftOutlined />} */}
          {rWidth <= 335 && rWidth != 0 && <img className="caf-collapse-left-sidebar-arrow-btn" src={rightArrow} />}
          {rWidth == 0 && <img className="caf-collapse-left-sidebar-arrow-btn" src={rightArrow} />}
          {/* </button> */}
        </div>
        <Resizable
          width={rWidth}
          height={500} // Set the fixed height here
          onResize={handleResizeRightSideBar}
          axis={"x"}
          enable={{
            top: false, // Disable top resizing
            right: true, // Enable right resizing
            bottom: false, // Disable bottom resizing
            left: true, // Enable left resizing
            topRight: false,
            bottomRight: false,
            bottomLeft: false,
            topLeft: false,
          }}
        >
          <div
            className="caf-builder-right-sidebar"
            style={{ width: `${rWidth}px`, transition: "all 0.5s ease-out" }}
          >
            {!addSkelton ? (
              <SettingPopUp
                addSkelton={addSkelton}
                data={initialdata}
                indexes={indexes}
                // closePopup={closeSettingPopUp}
                onChangeStyle={onChangeStyle}
                animation="popup-content"
                postData={extra_data?.single_post_data}
                selectedDevice={selectedDevice}
              />
            ) : (
              <Skeleton active />
            )}
          </div>
        </Resizable>
      </div>
    </div>
  );
};

export default PostBuilderContainer;
