import React, { useEffect, useState } from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faGear } from "@fortawesome/free-solid-svg-icons";
import ModuleTitle from "../../components/modules-output/ModuleTitle";
import ModuleExcerpt from "../../components/modules-output/ModuleExcerpt";
import ModuleImage from "../../components/modules-output/ModuleImage";
import ModuleCategories from "../../components/modules-output/ModuleCategories";
import ModuleAuthor from "../../components/modules-output/ModuleAuthor";
import ModuleDate from "../../components/modules-output/ModuleDate";
import ModuleCommentCount from "../../components/modules-output/ModuleCommentCount";
import ModuleButton from "../../components/modules-output/ModuleButton";
import ModuleCustomField from "../../components/modules-output/ModuleCustomField";
import ModuleCustomText from "../../components/modules-output/ModuleCustomText";
import ModuleBillingFields from "../../components/modules-output/ModuleBillingFields";
import ModuleShippingFields from "../../components/modules-output/ModuleShippingFields";
import ModuleOrderReview from "../../components/modules-output/ModuleOrderReview";
import ModulePayments from "../../components/modules-output/ModulePayments";
import ModuleCoupon from "../../components/modules-output/ModuleCoupon";
import ModulePlaceOrder from "../../components/modules-output/ModulePlaceOrder";
import { ColorPicker, Skeleton, Button } from "antd";
import {
  ArrowsAltOutlined,
  QuestionCircleFilled,
  QuestionCircleOutlined,
  ShrinkOutlined,
  RightOutlined,
  MobileOutlined,
  DesktopOutlined,
  TabletOutlined,
  EyeInvisibleFilled,
  EyeFilled
} from "@ant-design/icons";
import { Col, Input, Row, Slider, Select, Space } from "antd";
const { Option } = Select;
const MainArea = (props) => {
  const { extra_data } = { ...props.mainBuilderData?.post_layout_data };
  // console.log("mainArea",props)
  const initialdata = [
    ...props.mainBuilderData?.post_layout_data?.initial_data,
  ];

  const [colorHex, setColorHex] = useState(extra_data?.bg_color);
  const [fullScreen, setFullScreen] = useState(false);
  const [suffix, setSuffix] = useState(extra_data?.slider_data?.suffix ?? "%");
  const [selectedDevice, setSelectedDevice] = useState("desktop");
  const [previewState, setPreviewState] = useState("1");
  const [previewWidth, setPreviewWidth] = useState(
    extra_data?.slider_data?.value ?? "100"
  );
  const [screenWidth, setScreenWidth] = useState(window.innerWidth);
  useEffect(() => {
    if (props.newSliderval?.suffix) {
      setSuffix(props.newSliderval?.suffix);
    }
    if (props.newSliderval?.value) {
      setPreviewWidth(props.newSliderval?.value);
    }
  }, [props.newSliderval]);

  useEffect(() => {
    if (extra_data?.bg_color) {
      setColorHex(extra_data.bg_color);
    } else {
      setColorHex("#eaeaea");
    }
  }, [extra_data?.bg_color]);

  const setColorHexFun = (value) => {
    setColorHex(value.toHexString());
    extra_data.bg_color = value.toHexString();
    const newbuilderdata = {
      ...props.mainBuilderData,
      common_data: {
        ...props.mainBuilderData.common_data,
        preview_template_data: {
          ...props.mainBuilderData.common_data.preview_template_data,
          misc_preview_data: {
            ...props.mainBuilderData.common_data.preview_template_data
              .misc_preview_data,
            container: {
              ...props.mainBuilderData.common_data.preview_template_data
                .misc_preview_data.container,
              style: {
                ...props.mainBuilderData.common_data.preview_template_data
                  .misc_preview_data.container.style,
                desktop: {
                  ...props.mainBuilderData.common_data.preview_template_data
                    .misc_preview_data.container.style.desktop,
                  default: {
                    ...props.mainBuilderData.common_data.preview_template_data
                      .misc_preview_data.container.style.desktop?.default,
                    backgroundColor: value.toHexString(),
                  },
                },
              },
            },
          },
        },
      },
      post_layout_data: {
        ...props.mainBuilderData.post_layout_data,
        extra_data: extra_data,
      },
    };
    props.updatedBuilderData(newbuilderdata);
  };

  function CamelToSnake(string) {
    return string.replace(/([a-z]|(?=[A-Z]))([A-Z])/g, "$1-$2").toLowerCase();
  }
  const removeDuplicateProperty = (arr, item) => {
    if (arr.length === 0) {
      return arr;
    }
    let deletedval = "";
    arr.map((property, index) => {
      let propVal = property.split(":");
      if (item == propVal[0]) {
        deletedval = property;
      }
    });
    if (deletedval != "") {
      return arr.filter((e) => e !== deletedval);
    }
    return arr;
  };
  function generateCSS(style, state, device, settings) {
    let styleArr = [];
    if (device == "mobile") {
      if (state == "default") {
        Object.keys(style.desktop[state]).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                extra_data.single_post_data?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style.desktop[state][item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style.desktop[state][item] + ";"
            );
          }
        });
        Object.keys(style[device][state]).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                extra_data.single_post_data?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style[device][state][item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style[device][state][item] + ";"
            );
          }
        });
      } else {
        Object.keys(style.desktop.default).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                extra_data.single_post_data?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style.desktop.default[item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style.desktop.default[item] + ";"
            );
          }
        });

        Object.keys(style.desktop[state]).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                extra_data.single_post_data?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style.desktop[state][item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style.desktop[state][item] + ";"
            );
          }
        });

        Object.keys(style[device].default).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                extra_data.single_post_data?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style[device].default[item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style[device].default[item] + ";"
            );
          }
        });

        Object.keys(style[device][state]).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                extra_data.single_post_data?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style[device][state][item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style[device][state][item] + ";"
            );
          }
        });
      }
    } else if (device == "tablet") {
      if (state == "default") {
        Object.keys(style.desktop[state]).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                extra_data.single_post_data?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style.desktop[state][item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style.desktop[state][item] + ";"
            );
          }
        });
        Object.keys(style[device][state]).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                extra_data.single_post_data?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style[device][state][item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style[device][state][item] + ";"
            );
          }
        });
      } else {
        Object.keys(style.desktop.default).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                extra_data.single_post_data?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style.desktop.default[item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style.desktop.default[item] + ";"
            );
          }
        });

        Object.keys(style.desktop[state]).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                extra_data.single_post_data?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style.desktop[state][item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style.desktop[state][item] + ";"
            );
          }
        });

        Object.keys(style[device].default).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                extra_data.single_post_data?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style[device].default[item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style[device].default[item] + ";"
            );
          }
        });

        Object.keys(style[device][state]).map((item, i) => {
          let filter_item = CamelToSnake(item);
          styleArr = removeDuplicateProperty(styleArr, filter_item);
          if (item == "backgroundImage") {
            if (settings?.background_image == "post-img") {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                extra_data.single_post_data?.image +
                ");"
              );
            } else {
              styleArr.push(
                CamelToSnake(item) +
                ":url(" +
                style[device][state][item] +
                ");"
              );
            }
          } else {
            styleArr.push(
              CamelToSnake(item) + ":" + style[device][state][item] + ";"
            );
          }
        });
      }
    } else {
      if (device == "desktop") {
        if (state == "default") {
          // console.log(style,'kk')
          Object.keys(style[device][state]).map((item, i) => {
            let filter_item = CamelToSnake(item);
            styleArr = removeDuplicateProperty(styleArr, filter_item);
            if (item == "backgroundImage") {
              if (settings?.background_image == "post-img") {
                styleArr.push(
                  CamelToSnake(item) +
                  ":url(" +
                  extra_data.single_post_data?.image +
                  ");"
                );
              } else {
                styleArr.push(
                  CamelToSnake(item) +
                  ":url(" +
                  style[device][state][item] +
                  ");"
                );
              }
            } else {
              styleArr.push(
                CamelToSnake(item) + ":" + style[device][state][item] + ";"
              );
            }
          });
        } else {
          Object.keys(style[device].default).map((item, i) => {
            let filter_item = CamelToSnake(item);
            styleArr = removeDuplicateProperty(styleArr, filter_item);
            if (item == "backgroundImage") {
              if (settings?.background_image == "post-img") {
                styleArr.push(
                  CamelToSnake(item) +
                  ":url(" +
                  extra_data.single_post_data?.image +
                  ");"
                );
              } else {
                styleArr.push(
                  CamelToSnake(item) +
                  ":url(" +
                  style[device].default[item] +
                  ");"
                );
              }
            } else {
              styleArr.push(
                CamelToSnake(item) + ":" + style[device].default[item] + ";"
              );
            }
          });

          Object.keys(style[device][state]).map((item, i) => {
            let filter_item = CamelToSnake(item);
            styleArr = removeDuplicateProperty(styleArr, filter_item);
            if (item == "backgroundImage") {
              if (settings?.background_image == "post-img") {
                styleArr.push(
                  CamelToSnake(item) +
                  ":url(" +
                  extra_data.single_post_data?.image +
                  ");"
                );
              } else {
                styleArr.push(
                  CamelToSnake(item) +
                  ":url(" +
                  style[device][state][item] +
                  ");"
                );
              }
            } else {
              styleArr.push(
                CamelToSnake(item) + ":" + style[device][state][item] + ";"
              );
            }
          });
        }
      }
    }

    return styleArr.join(" ");
  }
  const handleFullScreenChange = () => {
    setFullScreen(
      document.fullscreenElement ||
      document.webkitFullscreenElement ||
      document.msFullscreenElement
    );
  };

  useEffect(() => {
    document.addEventListener("fullscreenchange", handleFullScreenChange);
    document.addEventListener("webkitfullscreenchange", handleFullScreenChange);
    document.addEventListener("msfullscreenchange", handleFullScreenChange);

    // Cleanup event listeners on component unmount
    return () => {
      document.removeEventListener("fullscreenchange", handleFullScreenChange);
      document.removeEventListener(
        "webkitfullscreenchange",
        handleFullScreenChange
      );
      document.removeEventListener(
        "msfullscreenchange",
        handleFullScreenChange
      );
    };
  }, []);
  const handleFullScreen = () => {
    var elem = document.documentElement;

    if (
      !document.fullscreenElement &&
      !document.webkitFullscreenElement &&
      !document.msFullscreenElement
    ) {
      // Document is not in fullscreen mode, request fullscreen.
      if (elem.requestFullscreen) {
        elem.requestFullscreen();
      } else if (elem.webkitRequestFullscreen) {
        /* Safari */
        elem.webkitRequestFullscreen();
      } else if (elem.msRequestFullscreen) {
        /* IE11 */
        elem.msRequestFullscreen();
      }
    } else {
      // Document is in fullscreen mode, exit fullscreen.
      if (document.exitFullscreen) {
        document.exitFullscreen();
      } else if (document.webkitExitFullscreen) {
        /* Safari */
        document.webkitExitFullscreen();
      } else if (document.msExitFullscreen) {
        /* IE11 */
        document.msExitFullscreen();
      }
    }
  };

  const onSelectChange = (val) => {
    setSuffix(val);
    extra_data.slider_data.suffix = val;
    const newbuilderdata = {
      ...props.mainBuilderData,
      post_layout_data: {
        ...props.mainBuilderData.post_layout_data,
        extra_data: extra_data,
      },
    };
    props.updatedBuilderData(newbuilderdata);
  };

  const onChangeSlider = (val) => {
    setPreviewWidth(val);
    extra_data.slider_data = { value: val, suffix: suffix };
    const newbuilderdata = {
      ...props.mainBuilderData,
      post_layout_data: {
        ...props.mainBuilderData.post_layout_data,
        extra_data: extra_data,
      },
    };
    props.updatedBuilderData(newbuilderdata);
  };
  const onChangeNumber = (e) => {
    setPreviewWidth(e.target.value);
    extra_data.slider_data = { value: e.target.value, suffix: suffix };
    const newbuilderdata = {
      ...props.mainBuilderData,
      post_layout_data: {
        ...props.mainBuilderData.post_layout_data,
        extra_data: extra_data,
      },
    };
    props.updatedBuilderData(newbuilderdata);
  };
  const selectAfter = (
    <Select
      defaultValue={suffix}
      onChange={onSelectChange}
      value={suffix}
      options={[
        {
          value: "px",
          label: "PX",
        },
        {
          value: "%",
          label: "%",
        },
      ]}
    />
  );
  const handleSelectLayout = () => {
    props.setSelectType("post-preview");
    props.setCurrStep("3");
  };
  {
    /* <Select.Option value="px">PX</Select.Option>
      <Select.Option value="%">%</Select.Option> */
  }
  {
    /* </Select> */
  }
  const handleBack = () => {
    props.setSelectType("");
    props.setCurrStep("1");
  }
  const onEyeClick = (val) => {
    setPreviewState(val);
    props.previewState(val);
  }

  window.onresize = function () {
    setScreenWidth(window.innerWidth);
  };
  const handleDeviceChange = (val) => {
    setSelectedDevice(val)
    props.setSelectedDevice(val)
  }
  return (
    <div className="caf-builder-mainarea caf-bl-post" style={{ background: colorHex }}>
      <div className="caf-builder-post-preview-wrapper">
        <div
          className="caf-builder-post-preview "
          style={{ width: `${previewWidth}${suffix}` }}
        >
          <div className="woocommerce">
            <form name="checkout" method="post" action="javascript:void(0);" class="checkout woocommerce-checkout" enctype="multipart/form-data" aria-label="Checkout" novalidate="novalidate" onsubmit="return false;">

              {initialdata.length == 0 ? (
                <>
                  <Skeleton active />
                  <Skeleton active />
                </>
              ) : (
                ""
              )}
              {initialdata.map((row, rowindex) => {
                const rowStyle = row.style;
                const rowSettings = row.settings;
                const row_custom_class = row.settings?.custom_class;

                return (
                  <div
                    className={`caf-builder-row-main caf-row-${rowindex} ${row_custom_class || ""
                      } post-id-${extra_data.single_post_data?.id ?? 0}`}
                    key={rowindex}
                  >
                    {row.data.map((column, columnindex) => {
                      const columnStyle = column.style;
                      const ColSettings = column.settings
                      const col_custom_class = column.settings?.custom_class;

                      return (
                        <div
                          className={`caf-builder-column-main caf-column-${columnindex} ${col_custom_class || ""
                            } post-id-${extra_data.single_post_data?.id ?? 0}`}
                          key={columnindex}
                        >
                          {column.data?.map((module, moduleindex) => {
                            const moduleStyle = module.style;
                            // console.log(moduleStyle);
                            const moduleSettings = module.settings;
                            return (
                              <>
                                {module.key == "title" ? (
                                  <ModuleTitle
                                    postData={extra_data.single_post_data}
                                    settings={moduleSettings}
                                    styleDefault={moduleStyle}
                                    module={module}
                                    rowindex={rowindex}
                                    columnindex={columnindex}
                                    moduleindex={moduleindex}
                                    setIndexes={props.setIndexes}
                                    selectedDevice={selectedDevice}
                                  />
                                ) : module.key == "excerpt" ? (
                                  <ModuleExcerpt
                                    postData={extra_data.single_post_data}
                                    settings={moduleSettings}
                                    styleDefault={moduleStyle}
                                    module={module}
                                    rowindex={rowindex}
                                    columnindex={columnindex}
                                    moduleindex={moduleindex}
                                    setIndexes={props.setIndexes}
                                    selectedDevice={selectedDevice}
                                  />
                                ) : module.key == "image" ? (
                                  <ModuleImage
                                    postData={extra_data.single_post_data}
                                    settings={moduleSettings}
                                    styleDefault={moduleStyle}
                                    module={module}
                                    rowindex={rowindex}
                                    columnindex={columnindex}
                                    moduleindex={moduleindex}
                                    setIndexes={props.setIndexes}
                                    selectedDevice={selectedDevice}
                                  />
                                ) : module.key == "categories" ? (
                                  <ModuleCategories
                                    postData={extra_data.single_post_data}
                                    settings={moduleSettings}
                                    styleDefault={moduleStyle}
                                    module={module}
                                    rowindex={rowindex}
                                    columnindex={columnindex}
                                    moduleindex={moduleindex}
                                    setIndexes={props.setIndexes}
                                    selectedDevice={selectedDevice}
                                  />
                                ) : module.key == "author" ? (
                                  <ModuleAuthor
                                    postData={extra_data.single_post_data}
                                    settings={moduleSettings}
                                    styleDefault={moduleStyle}
                                    module={module}
                                    rowindex={rowindex}
                                    columnindex={columnindex}
                                    moduleindex={moduleindex}
                                    setIndexes={props.setIndexes}
                                    selectedDevice={selectedDevice}
                                  />
                                ) : module.key == "date" ? (
                                  <ModuleDate
                                    postData={extra_data.single_post_data}
                                    settings={moduleSettings}
                                    styleDefault={moduleStyle}
                                    module={module}
                                    rowindex={rowindex}
                                    columnindex={columnindex}
                                    moduleindex={moduleindex}
                                    setIndexes={props.setIndexes}
                                    selectedDevice={selectedDevice}
                                  />
                                ) : module.key == "commentcount" ? (
                                  <ModuleCommentCount
                                    postData={extra_data.single_post_data}
                                    settings={moduleSettings}
                                    styleDefault={moduleStyle}
                                    module={module}
                                    rowindex={rowindex}
                                    columnindex={columnindex}
                                    moduleindex={moduleindex}
                                    setIndexes={props.setIndexes}
                                    selectedDevice={selectedDevice}
                                  />
                                ) : module.key == "button" ? (
                                  <ModuleButton
                                    postData={extra_data.single_post_data}
                                    settings={moduleSettings}
                                    styleDefault={moduleStyle}
                                    module={module}
                                    rowindex={rowindex}
                                    columnindex={columnindex}
                                    moduleindex={moduleindex}
                                    setIndexes={props.setIndexes}
                                    selectedDevice={selectedDevice}
                                  />
                                ) : module.key == "customfield" ? (
                                  <ModuleCustomField
                                    postData={extra_data.single_post_data}
                                    settings={moduleSettings}
                                    styleDefault={moduleStyle}
                                    module={module}
                                    rowindex={rowindex}
                                    columnindex={columnindex}
                                    moduleindex={moduleindex}
                                    setIndexes={props.setIndexes}
                                    selectedDevice={selectedDevice}
                                  />
                                ) : module.key == "customtext" ? (
                                  <ModuleCustomText
                                    postData={extra_data.single_post_data}
                                    settings={moduleSettings}
                                    styleDefault={moduleStyle}
                                    module={module}
                                    rowindex={rowindex}
                                    columnindex={columnindex}
                                    moduleindex={moduleindex}
                                    setIndexes={props.setIndexes}
                                    selectedDevice={selectedDevice}
                                  />
                                ) : module.key == "billing_fields" ? (
                                  <ModuleBillingFields
                                    postData={extra_data.single_post_data}
                                    settings={moduleSettings}
                                    styleDefault={moduleStyle}
                                    module={module}
                                    rowindex={rowindex}
                                    columnindex={columnindex}
                                    moduleindex={moduleindex}
                                    setIndexes={props.setIndexes}
                                    selectedDevice={selectedDevice}
                                  />
                                ) : module.key == "shipping_fields" ? (
                                  <ModuleShippingFields
                                    postData={extra_data.single_post_data}
                                    settings={moduleSettings}
                                    styleDefault={moduleStyle}
                                    module={module}
                                    rowindex={rowindex}
                                    columnindex={columnindex}
                                    moduleindex={moduleindex}
                                    setIndexes={props.setIndexes}
                                    selectedDevice={selectedDevice}
                                  />
                                ) : module.key == "order_review" ? (
                                  <ModuleOrderReview
                                    postData={extra_data.single_post_data}
                                    settings={moduleSettings}
                                    styleDefault={moduleStyle}
                                    module={module}
                                    rowindex={rowindex}
                                    columnindex={columnindex}
                                    moduleindex={moduleindex}
                                    setIndexes={props.setIndexes}
                                    selectedDevice={selectedDevice}
                                  />
                                ) : module.key == "payment_method" ? (
                                  <ModulePayments
                                    postData={extra_data.single_post_data}
                                    settings={moduleSettings}
                                    styleDefault={moduleStyle}
                                    module={module}
                                    rowindex={rowindex}
                                    columnindex={columnindex}
                                    moduleindex={moduleindex}
                                    setIndexes={props.setIndexes}
                                    selectedDevice={selectedDevice}
                                  />
                                ) : module.key == "apply_coupon" ? (
                                  <ModuleCoupon
                                    postData={extra_data.single_post_data}
                                    settings={moduleSettings}
                                    styleDefault={moduleStyle}
                                    module={module}
                                    rowindex={rowindex}
                                    columnindex={columnindex}
                                    moduleindex={moduleindex}
                                    setIndexes={props.setIndexes}
                                    selectedDevice={selectedDevice}
                                  />
                                ) : (
                                  module.title
                                )}

                                {/* {module.title} */}
                                {/* </div> */}
                              </>
                            );
                          })}
                          <style>
                            {`
              .caf-bl-post .caf-row-${rowindex} .caf-column-${columnindex}.post-id-${extra_data.single_post_data?.id
                              ?? 0}{
                ${generateCSS(columnStyle, "default", selectedDevice, ColSettings)}
              }
              
              `}
                          </style>
                        </div>
                      );
                    })}
                    <style>
                      {`
              .caf-bl-post .caf-row-${rowindex}.post-id-${extra_data.single_post_data?.id ?? 0} {
                ${generateCSS(rowStyle, "default", selectedDevice, rowSettings)}
              }
              
              `}
                    </style>
                  </div>
                );
              })}
            </form>
          </div>
        </div>
      </div>





    </div>
  );
};

export default MainArea;
