import React, { useEffect, useState } from "react";
import Header from "./Header";
import PostBuilderContainer from "./PostComponents/PostBuilderContainer";
function LayoutContainer(props) {
  const [mainBuilderData, setMainBuilderData] = useState(props.mainBuilderData);
  const [currStep, setCurrStep] = useState("1");
  const [selectType, setSelectType] = useState("");
  const [previewState ,setPreviewState]=useState("1");

  useEffect(()=>{
    if(props.selectType == 'filter-settings'){
      setCurrStep("2");
      setSelectType("filter");
    } else if(props.selectType == 'post-settings'){
      setCurrStep("2");
      setSelectType("post");
    }else if(props.selectType == 'preview-settings'){
      setCurrStep("3");
      setSelectType("post-preview");
    }else{
      setCurrStep("1");
      setSelectType("");
    }
  },[props.selectType])
  
  const updatedBuilderData = (data) => {
    setMainBuilderData(data);
  };
  return (
    <div className="caf-layout-container-page">
      <div className="caf-inner-container">
        <div className="caf-layout-header-section">
          <Header
            selectType={selectType}
            setSelectType={setSelectType}
            currStep={currStep}
            setCurrStep={setCurrStep}
            mainBuilderData={mainBuilderData}
            updatedBuilderData={updatedBuilderData}
            closeAllPopUps={props.closeAllPopUps}
            previewState={setPreviewState}
          />
        </div>
        <div className={`caf-main-layout-content-section ${selectType == "post-preview" ? "layout-preview":""}`}>
          {selectType === "post" && (
           <PostBuilderContainer
           selectType={selectType}
           setSelectType={setSelectType}
           currStep={currStep}
           setCurrStep={setCurrStep}
           mainBuilderData={mainBuilderData}
           updatedBuilderData={updatedBuilderData}
         />
         )}
        </div>
      </div>
    </div>
  );
}

export default LayoutContainer;
