import React, { useEffect, useState, useRef } from "react";
import editBtn from "./images/edit-btn.png";
import homeImg from "./images/home-icon.png";
import rightArrow from "./images/right-arrow.png";
import closeIcon from "./images/close-icon.png";
import logo from "./woo-checkout-builder/logo1.png";
//import MiscSettingPage from "./MiscSettingPage";
import axios from "axios"; 
import {ImportOutlined} from "@ant-design/icons";
import { Button, notification, Modal, Input ,Upload ,message} from "antd";
import cloneDeep from "lodash/cloneDeep";
function Header(props) {

  //console.log("hd",props);
  axios.defaults.headers.common['Cache-Control'] = 'no-cache, no-store, must-revalidate';
  axios.defaults.headers.common['Pragma'] = 'no-cache';
  axios.defaults.headers.common['Expires'] = '0';
  const [miscSettingPage, setMiscSettingPage] = useState(false);
  const site_url = trusty_woo_ajaxObject.site_base_url;
  const baseURL = site_url + "/wp-json/woo-checkout-builder/v1/";
  const [mainBuilderData, setMainBuilderData] = useState(props.mainBuilderData);
  const [storeStep, setStoreStep] = useState("");
  const [modalPopUp, setModalPopUp] = useState(false);

  const [fileList, setFileList] = useState([]);
  const [fileImport, setFileImport] = useState({});
  const [uploading, setUploading] = useState(false);

  const prevMainBuilderData = useRef(cloneDeep(mainBuilderData));
  const [builderTitle, setBuilderTitle] = useState(
    props.mainBuilderData.common_data.layout_name
  );
  const [builderLabel, setBuilderLabel] = useState(
    props.mainBuilderData.common_data.layout_name
  );
  const [layoutRenamePopup, setLayoutRenamePopup] = useState(false);
  const [isImport ,setIsImport]=useState(false);
  useEffect(() => {
    setMainBuilderData(props.mainBuilderData);
    //prevMainBuilderData.current =cloneDeep(props.mainBuilderData);
  }, [props.mainBuilderData]);

  

  const importProps = {
    onRemove: (file) => {
      setFileList([]);
    },
    beforeUpload: (file) => {
      const isJson = file.type === 'application/json' || file.name.endsWith('.json');
      
      if (!isJson) {
        message.error('You can only import JSON file!');
        return false;
      }
      setFileList([file]);
      const reader = new FileReader();
      reader.onload = (event) => {
        try {
          const jsonData = JSON.parse(event.target.result);
          if (jsonData) {
            setFileImport(jsonData);
          }
        } catch (error) {
          message.error('Error parsing JSON file.');
        }
      };
      reader.readAsText(file);
      return false;
    },
    fileList,
  };
  const handleSetting = () => {
    setMiscSettingPage(!miscSettingPage);
  };
  const handleMiscSettingPage = (res) => {
    setMiscSettingPage(res);
  };
  const openNotification = (flag = false) => {
    const handleButtonClick = () => {
      props.setSelectType("");
      props.setCurrStep("1");
    };
    const messageWithButton = (
      <>
        {props.selectType == "filter" &&
        mainBuilderData?.post_layout_data?.breadcrumb_data?.select_builder ===
          "false" ? (
          <div>
            Layout Saved! Now you can go for
            {flag == false ? (
              <Button type="link" onClick={handleButtonClick}>
                Post Layout!
              </Button>
            ) : (
              " Post Layout!"
            )}
          </div>
        ) : (
          <div>Layout Saved!</div>
        )}
      </>
    );

    notification.open({
      message: messageWithButton,
      className: "layout-saved-note",
      duration: flag == false ? 3 : 1,
      onClick: () => {
        // Optional: Handle notification click if needed
        // console.log("Notification Clicked!");
      },
    });
  };
  const onHandleSaveLayout = (flag = false) => {
    let newData = {};
    prevMainBuilderData.current = cloneDeep(mainBuilderData);
   console.log("mn",mainBuilderData);
   console.log("pr",props.mainBuilderData);
      newData = {
        ...props.mainBuilderData,
        post_layout_data: {
          ...props.mainBuilderData.post_layout_data,
          breadcrumb_data: {
            ...props.mainBuilderData.post_layout_data.breadcrumb_data,
            select_builder: "true",
          },
        },
      };
    
    // if(props.currStep =="3" && props.mainBuilderData.common_data?.layout_publish == "draft"){
    //   newData = {
    //     ...newData,
    //     common_data:{
    //       ...newData.common_data,
    //       layout_publish: "publish",
    //     }
    //   };
    //   //console.log('work')
    // }
    console.log(newData);
    if (newData.common_data.layout_key === "") return;
    prevMainBuilderData.current = cloneDeep(newData);

    let postedData = {
      layout_data: JSON.stringify(newData),
      layout_key: newData.common_data.layout_key,
      layout_index: newData.common_data.layout_index,
    };

    axios
      .post(baseURL + "update-builder-layout/", postedData,{
        headers: {
          'X-WP-Nonce': trusty_woo_ajaxObject.nonce
        }
      })
      .then((response) => {
        if (response.data) {
          if (response.data.status == "success") {
            if (flag == false) {
              openNotification();
            } else {
              openNotification(true);
            }
            setMainBuilderData(response.data.layout_data);
            props.updatedBuilderData(response.data.layout_data);
          }
        }
      });
  };

  const updatedBuilderData = (data) => {
    setMainBuilderData(data);
    props.updatedBuilderData(data);
  };

  const handleCancel = () => {
    if (
      JSON.stringify(prevMainBuilderData.current) !==
      JSON.stringify(mainBuilderData)
    ) {
      setModalPopUp(true);
      setStoreStep("all");
      return;
    }
   // delete query param
  //  let currentUrl = new URL(window.location.href);
  //  let queryParams = currentUrl.searchParams;
  //  queryParams.delete('builder');
  //  currentUrl.search = queryParams.toString();
  //  window.history.replaceState(null, '', currentUrl.toString());
   // end delete query param
    props.setCurrStep("2");
    props.closeAllPopUps(false);
  };
  const changeTab = (step, type = "") => {
    if (parseInt(props.currStep) >= 2 && step < 2) {
      if (
        JSON.stringify(prevMainBuilderData.current) !==
        JSON.stringify(mainBuilderData)
      ) {

        setModalPopUp(true);
        setStoreStep(step);
        return;
      }
    }
    if (step === 0) {
      props.closeAllPopUps(false);
    }
    if (step === 1) {
      props.setSelectType("");
      props.setCurrStep("1");
    }
    if (step === 2 && type != "filter") {
      props.setSelectType("post");
      props.setCurrStep("2");
    }
    if (step === 3) {
      props.setSelectType("post-preview");
      props.setCurrStep("3");
    }
  };
  const handleUpdateLayoutTitle = () => {
    let value = builderLabel.replace(/\s+/g, " ");
    let key = mainBuilderData.common_data.layout_key;
    //let arr = str.split("_");
   // let key = arr[arr.length - 1];

    let posted_data = {
      label: value,
      index: key,
    };

    axios
      .post(baseURL + "rename-builder-layout-label/", posted_data,{
        headers: {
          'X-WP-Nonce': trusty_woo_ajaxObject.nonce
        }
      })
      .then((response) => {
        if (response.data) {
          if (response.data.status == "success") {
            console.log(response.data);
            setBuilderLabel(response.data.label);
            setBuilderTitle(response.data.label);
            setLayoutRenamePopup(false);
            notification.open({
              message: "Filter Label Updated!",
            });
            let newData = {
              ...props.mainBuilderData,
              common_data: {
                ...props.mainBuilderData.common_data,
                layout_name: response.data.label,
              },
            };
            props.updatedBuilderData(newData);
          }
        }
      });
  };

  const handleCancelLayoutRename = () => {
    setLayoutRenamePopup(false);
    setBuilderLabel(builderTitle);
  };
  const onChangeBuilderLabel = (e) => {
    setBuilderLabel(e.target.value);
  };
  const editTitle = () => {
    setLayoutRenamePopup(true);
  };
  const handlePopUp = () => {
    if (storeStep === 0) {
      onHandleSaveLayout(true);
      props.closeAllPopUps(false);
    }
    if (storeStep === 1) {
      onHandleSaveLayout(true);
      props.setSelectType("");
      props.setCurrStep("1");
    }
    if (storeStep == "all") {
      onHandleSaveLayout(true);
      props.setCurrStep("2");
      props.closeAllPopUps(false);
    }
    setModalPopUp(false);
     // delete query param
  //  let currentUrl = new URL(window.location.href);
  //  let queryParams = currentUrl.searchParams;
  //  queryParams.delete('builder');
  //  currentUrl.search = queryParams.toString();
  //  window.history.replaceState(null, '', currentUrl.toString());
   // end delete query param
  };
  const handlePopUpCancel = () => {
    props.updatedBuilderData(prevMainBuilderData.current);
    setModalPopUp(false);
    if (storeStep === 0) {
      props.closeAllPopUps(false);
    }
    if (storeStep === 1) {
      props.setSelectType("");
      props.setCurrStep("1");
    }
    if (storeStep == "all") {
      props.setCurrStep("2");
      props.closeAllPopUps(false);
    }
     // delete query param
  //  let currentUrl = new URL(window.location.href);
  //  let queryParams = currentUrl.searchParams;
  //  queryParams.delete('builder');
  //  currentUrl.search = queryParams.toString();
  //  window.history.replaceState(null, '', currentUrl.toString());
   // end delete query param
  };
const handelImportClick=()=>{
  setIsImport(true);
}
function updateFilterModuleSettings(newData) {
  const filterKeys = ["button_filter", "checkbox_filter", "dropdown_filter"];

  const newSettings = {
    dropdown_data: {
      icons: {
        icon_switch: true,
        active_icon: "fas fa-arrow-up",
        inactive_icon: "fas fa-arrow-down",
      },
      all_option: {
        value: "All",
        icons: {
          visibility: false,
          icon: "",
          position: "before-option",
        },
      },
    },
    post_type: "post",
    filter_type: "button",
    taxonomy_data: [],
    taxonomy_relation: "OR",
    category_relation: "OR",
    meta_relation: "IN",
    custom_class: "",
    predefined_terms: [],
    cf_predefined_terms: [],
    label: {
      is_label: "true",
      value: "Label",
      icons: {
        visibility: false,
        icon: "",
        position: "before-label",
      },
    },
    skins: {
      checkbox: "checkbox_skin1",
      button: "button_skin1",
    },
    multiple_term: "false",
    enable_toggle: "false",
    close_toggle: "false",
    data_source: "taxonomy",
    custom_field_data: {
      custom_field_key: "",
      custom_field_value: [],
      compare_operator: "IN",
      meta_type: "CHAR",
    },
  };

  newData.filter_layout_data.initial_data = newData.filter_layout_data.initial_data.map(row => {
    if (!row.data) return row;

    return {
      ...row,
      data: row.data.map(column => {
        if (!column.data) return column;

        return {
          ...column,
          data: column.data.map(module => {
            if (module.type === "module" && filterKeys.includes(module.key)) {
              return {
                ...module,
                settings: { ...newSettings },
              };
            }
            return module;
          }),
        };
      }),
    };
  });

  return newData;
}

function updatedFilterQueryData(newData){
  const newFilterQuery = {
      data_source: {
        taxonomy: "true",
        custom_field: "false",
      },
      taxonomy_relation: "OR",
      category_relation: "IN",
      order_by_meta:"false",
      meta_key:"",
      meta_value:"",
      meta_relation:"IN",
      custom_field_data: [
        {
          custom_field_key: "",
          custom_field_value: "",
          custom_field_value_list: [],
          compare_operator: "=",
          meta_type:"CHAR",
          
        },
      ],
      taxonomy_data: [],
    };

    newData.filter_layout_data.filter_query_data= {...newFilterQuery}
    return newData;
}
function updatePostLayoutData(newData){
   newData.post_layout_data.extra_data.single_post_data = {}
    return newData;
}

const handleImportLayout=()=>{
  let newData = {...fileImport}
  if(newData.common_data){
   let layout_key =  mainBuilderData.common_data.layout_key;
   let layout_name =  mainBuilderData.common_data.layout_name;
   let layout_index = mainBuilderData.common_data.layout_index;
   let layout_publish = mainBuilderData.common_data.layout_publish;
   newData.common_data.layout_key = layout_key;
   newData.common_data.layout_name = layout_name;
   newData.common_data.layout_index = layout_index;
   newData.common_data.layout_publish = layout_publish;
   newData.common_data.post_type = "post";
    updateFilterModuleSettings(newData)
    updatedFilterQueryData(newData)
    updatePostLayoutData(newData);
    
   let postedData = {
    layout_data: JSON.stringify(newData),
    layout_key: layout_key,
    layout_index:layout_index
  };
  setUploading(true);
  axios
    .post(baseURL + "update-builder-layout/", postedData,{
      headers: {
        'X-WP-Nonce': trusty_woo_ajaxObject.nonce
      }
    })
    .then((response) => {
      if (response.data) {
        if (response.data.status == "success") {
          setMainBuilderData(response.data.layout_data);
          props.updatedBuilderData(response.data.layout_data);
          prevMainBuilderData.current = cloneDeep(response.data.layout_data);
          setFileList([])
          setFileImport({})
          setUploading(false)
          setIsImport(false);
          notification.open({
            message: "Layout Imported Successfully",
            className: "layout-import-note",
            duration: 3,
            onClick: () => {
              // Optional: Handle notification click if needed
              // console.log("Notification Clicked!");
            },
          });
          props.setSelectType("");
          props.setCurrStep("1");
        }
      }
    });

  }else{
    notification.open({
      message: "Not Selected Valid Layout",
      className: "layout-import-note",
      duration: 3,
      onClick: () => {
        // Optional: Handle notification click if needed
        // console.log("Notification Clicked!");
      },
    });
  }
}
const handleCancelImport=()=>{
  setIsImport(false);
}
  return (
    <div className="caf-builder-layout-header-container">
      <div className="caf-builder-layout-rename-main">
        <img className='rename-logo-img' src={logo} alt="img" />
        <div className="caf-builder-layout-title">
          <span>{builderTitle}</span>
          <span onClick={editTitle}>
            <img src={editBtn} alt="img" />
          </span>
        </div>
      </div>
      <div className="caf-builder-layout-header-breadcrumb">
        <span
          onClick={() => changeTab(0)}
          className={`caf-text ${props.currStep === "1" ? "active" : ""}`}
        >
          <img src={homeImg} alt="img" />
        </span>

        {/* <img src={rightArrow} alt="img" />
        <span
          onClick={() => changeTab(1)}
          className={`caf-text ${props.currStep === "1" ? "active" : ""}`}
        >
          Filter/Post Settings
        </span> */}

        {(props.selectType === "post" || props.selectType === "post-preview") &&
          parseInt(props.currStep) > 1 && (
            <>
              <img src={rightArrow} alt="img" />
              <span
                onClick={() => changeTab(2)}
                className={`caf-text ${props.currStep === "2" ? "active" : ""}`}
              >
                Checkout Template
              </span>
              {/* <img src={rightArrow} alt="img" />
              <span
                onClick={() => changeTab(3)}
                className={`caf-text ${props.currStep === "3" ? "active" : ""}`}
              >
                Preview Template
              </span> */}
            </>
          )}

        

        {/* <span className="caf-text">Single Filter Design</span> */}
      </div>
      <div className="caf-builder-layout-header-global-save-section">
          {/* <button className="caf-import-btn" onClick={handelImportClick}>
            Import
          </button> */}
        {/* <span onClick={handleSetting}>
          <img src={setting} alt="img" />
        </span> */}
        {parseInt(props.currStep) >= 2 && (() => {
          const updateStatus =
            JSON.stringify(prevMainBuilderData.current) !== JSON.stringify(mainBuilderData)
              ? "1"
              : "0";

          return (
            <>
              <span
                className={`caf-save-btn ${updateStatus == "1" ? "active" : "deactive"}`}
                onClick={() => onHandleSaveLayout()}
              >
                {props.currStep === "3" || props.mainBuilderData.common_data.layout_publish === "publish"
                  ? "Publish"
                  : "Save"}
              </span>
            </>
          );
        })()}

        <span onClick={handleCancel}>
          <img src={closeIcon} alt="img" />
        </span>
      </div>
      {/* {miscSettingPage && (
        <MiscSettingPage
          handleMiscSettingPage={handleMiscSettingPage}
          mainBuilderData={mainBuilderData}
          updatedBuilderData={updatedBuilderData}
        />
      )} */}
      <Modal
        title="Enter New Template Name"
        open={layoutRenamePopup}
        onOk={handleUpdateLayoutTitle}
        onCancel={handleCancelLayoutRename}
        footer={[
          <Button key="back" onClick={handleCancelLayoutRename}>
            Cancel
          </Button>,
          <Button key="save" type="primary" onClick={handleUpdateLayoutTitle}>
            Save
          </Button>,
        ]}
      >
        <Input
          className="caf-builder-rename-input"
          defaultValue={builderLabel}
          value={builderLabel}
          onChange={onChangeBuilderLabel}
        />
      </Modal>
      <Modal
        // title="Enter New Layout Label"
        open={modalPopUp}
        onOk={handlePopUp}
        onCancel={handlePopUpCancel}
        footer={[
          <Button key="back" onClick={handlePopUpCancel}>
            Cancel
          </Button>,
          <Button key="save" type="primary" onClick={handlePopUp}>
            Save
          </Button>,
        ]}
      >
        Do you want to save the Layout!
      </Modal>
      <Modal
        title="Import layout"
        open={isImport}
        onOk={handleImportLayout}
        onCancel={handleCancelImport}
        // footer={[
        //   <Button key="back" onClick={handleCancelImport}>
        //     Cancel
        //   </Button>,
        //   <Button key="save" type="primary" onClick={handleImportLayout}>
        //     Import
        //   </Button>,
        // ]}
        footer={[]}
      >
        <Upload {...importProps}>
                    <Button
                      style={{
                        marginTop: 10,
                      }}
                      icon={<ImportOutlined />}
                    >
                      Select File
                    </Button>
                  </Upload>
                  <Button
                    type="primary"
                    onClick={handleImportLayout}
                    disabled={fileList.length === 0}
                    loading={uploading}
                    style={{
                      marginTop: 16,
                      marginBottom: 10,
                    }}
                  >
                    {uploading ? "Uploading" : "Start Import"}
                  </Button>
        </Modal>
    </div>
  );
}

export default Header;
