import { columnStyle, moduleStyle, rowStyle } from "../components/styleData";
import { billingFieldsRawData } from "../components/billingFieldsRawData";
import { shippingFieldsRawData } from "../components/shippingFieldsRawData";
export const builderLayoutData = {
  common_data: {
    layout_name: "",
    layout_key: "",
    layout_index: "",
    post_type: "",
    layout_publish: "draft",
  },
  post_layout_data: {
    initial_data: [
      {
        type: "row",
        style: { ...rowStyle },
        settings: {
          background_image: "",
          collapse_status: "false",
          custom_class: ""
        },
        // Start Column
        data: [
          {
            type: "column",
            settings: {
              background_image: "",
              collapse_status: "false",
              custom_class: ""
            },
            style: { ...columnStyle, 
              desktop: {
                ...columnStyle.desktop,
                default: {
                  ...columnStyle.desktop.default,
                  width:"50%",
                },
              }
            },
            data: [
              {
                type: "module",
                title: "Billing Fields",
                style: {
                  ...moduleStyle,
                  desktop: {
                    ...moduleStyle.desktop,
                    default: {
                      ...moduleStyle.desktop.default,
                      paddingTop: "0",
                      paddingBottom: "0",
                      marginBottom: "0",
                    },
                  },

                },
                key: "billing_fields",
                style: {
                  ...moduleStyle,
                  desktop: {
                    ...moduleStyle.desktop,
                    default: {
                      ...moduleStyle.desktop.default,
                      paddingTop: '0px',
                      paddingBottom: '0px',
                    },
                  },
                  label: {
                    ...moduleStyle,
                    desktop: {
                      ...moduleStyle.desktop,
                      default: {
                        ...moduleStyle.desktop.default,
                        flexBasis: "auto",
                        height: "auto",
                        position: "relative",
                        paddingTop: "0px",
                        paddingRight: "0",
                        paddingBottom: "0px",
                        paddingLeft: "0",
                        marginTop: "0",
                        marginRight: "0",
                        marginBottom: "0",
                        marginLeft: "0",
                        backgroundColor: 'initial',
                        color: "#666666",
                        fontFamily: "Open Sans",
                      }
                    },
                  },
                  meta: {
                    ...moduleStyle,
                    desktop: {
                      ...moduleStyle.desktop,
                      default: {
                        ...moduleStyle.desktop.default,
                        flexBasis: "auto",
                        height: "auto",
                        position: "relative",
                        paddingTop: "16px",
                        paddingRight: "16px",
                        paddingBottom: "16px",
                        paddingLeft: "16px",
                        marginTop: "0",
                        marginRight: "0",
                        marginBottom: "0",
                        marginLeft: "0",
                        backgroundColor: "#eeeeee",
                        color: "#999999",
                        fontFamily: "Open Sans",
                        fontSize: '14px',
                        borderWidth: '0px',
                        borderRadius: '0px'
                      }
                    },
                  }
                },
                settings: {
                  background_image: "",
                  image_size: "thumbnail",
                  custom_class: "",
                  placeholder_image: "",
                  link: {
                    condition: false,
                    customlink: "",
                    target: "same-tab",
                    type: "post-url",
                    visibility: false
                  },
                  fields: { ...billingFieldsRawData },
                },

              },
              {
                type: "module",
                title: "Shipping Fields",
                style: {
                  ...moduleStyle,
                  desktop: {
                    ...moduleStyle.desktop,
                    default: {
                      ...moduleStyle.desktop.default,
                      paddingTop: '0px',
                      paddingBottom: '0px',
                    },
                  },
                  label: {
                    ...moduleStyle,
                    desktop: {
                      ...moduleStyle.desktop,
                      default: {
                        ...moduleStyle.desktop.default,
                        flexBasis: "auto",
                        height: "auto",
                        position: "relative",
                        paddingTop: "0px",
                        paddingRight: "0",
                        paddingBottom: "0px",
                        paddingLeft: "0",
                        marginTop: "0",
                        marginRight: "0",
                        marginBottom: "0",
                        marginLeft: "0",
                        backgroundColor: 'initial',
                        color: "#666666",
                        fontFamily: "Open Sans",
                      }
                    },
                  },
                  meta: {
                    ...moduleStyle,
                    desktop: {
                      ...moduleStyle.desktop,
                      default: {
                        ...moduleStyle.desktop.default,
                        flexBasis: "auto",
                        height: "auto",
                        position: "relative",
                        paddingTop: "16px",
                        paddingRight: "16px",
                        paddingBottom: "16px",
                        paddingLeft: "16px",
                        marginTop: "0",
                        marginRight: "0",
                        marginBottom: "0",
                        marginLeft: "0",
                        backgroundColor: "#eeeeee",
                        color: "#999999",
                        fontFamily: "Open Sans",
                        fontSize: '14px',
                        borderWidth: '0px',
                        borderRadius: '0px'
                      }
                    },
                  }
                },
                key: "shipping_fields",
                settings: {
                  background_image: "",
                  image_size: "thumbnail",
                  custom_class: "",
                  placeholder_image: "",
                  display_shipping: 1,
                  shipping_diff_label: "Ship to a different address?",
                  shipping_checked: 1,
                  link: {
                    condition: false,
                    customlink: "",
                    target: "same-tab",
                    type: "post-url",
                    visibility: false
                  },
                  fields: { ...shippingFieldsRawData },
                },
              },

            ],
          },
          {
            type: "column",
            settings: {
              background_image: "",
              collapse_status: "false",
              custom_class: ""
            },
            style: { ...columnStyle, 
              desktop: {
                ...columnStyle.desktop,
                default: {
                  ...columnStyle.desktop.default,
                  width:"50%",
                },
              }
            },
            data: [
              {
                title: "Order Review",
                type: "module",
                style: {
                  ...moduleStyle,
                  desktop: {
                    ...moduleStyle.desktop,
                    default: {
                      ...moduleStyle.desktop.default,
                      paddingTop: '10px',
                      paddingBottom: '10px',
                      paddingLeft: '10px',
                      paddingRight: '10px',
                      fontWeight: '700',
                      fontSize: '16px',
                      lineHeight: '21px',
                      fontFamily: 'Open Sans',
                      backgroundColor: 'initial',
                    },
                  },
                  label: {
                    ...moduleStyle,
                    desktop: {
                      ...moduleStyle.desktop,
                      default: {
                        ...moduleStyle.desktop.default,
                        flexBasis: "auto",
                        height: "auto",
                        position: "relative",
                        paddingTop: '10px',
                        paddingBottom: '10px',
                        paddingLeft: '10px',
                        paddingRight: '10px',
                        marginTop: "0",
                        marginRight: "0",
                        marginBottom: "0",
                        marginLeft: "0",
                        backgroundColor: 'initial',
                        color: "#666666",
                        fontSize: '16px',
                        lineHeight: '21px',
                        fontFamily: 'Open Sans'
                      }
                    },
                  },
                  meta: {
                    ...moduleStyle,
                    desktop: {
                      ...moduleStyle.desktop,
                      default: {
                        ...moduleStyle.desktop.default,
                        flexBasis: "auto",
                        height: "auto",
                        position: "relative",
                        paddingTop: "10px",
                        paddingRight: "10px",
                        paddingBottom: "10px",
                        paddingLeft: "10px",
                        marginTop: "0",
                        marginRight: "0",
                        marginBottom: "0",
                        marginLeft: "0",
                        backgroundColor: "initial",
                        color: "#666666",
                        fontSize: '16px',
                        fontWeight: '700',
                        lineHeight: '21px',
                        fontFamily: 'Open Sans',
                        borderWidth: '1px',
                        borderRadius: '0px'
                      }
                    },
                  }
                },
                key: "order_review",
                settings: {
                  background_image: "",
                  icons: {
                    visibility: true,
                    icon: "far fa-user",
                    position: "before-author",
                  },
                  custom_class: ""
                },
              },
              {
                title: "Payments",
                type: "module",
                style: {
                  ...moduleStyle,
                  desktop: {
                    ...moduleStyle.desktop,
                    default: {
                      ...moduleStyle.desktop.default,
                      paddingLeft: "0px",
                      fontSize: "12px",
                      color: "#666666",
                      backgroundColor: "#816e9924",
                      paddingTop: "0px",
                      paddingRight: "0px",
                      paddingBottom: "0px",
                      paddingLeft: "0px",
                      marginTop: "0",
                      marginRight: "0",
                      marginBottom: "0",
                      marginLeft: "0",
                    }
                  },
                },
                key: "payment_method",
                settings: {
                  background_image: "",
                  icons: {
                    visibility: true,
                    icon: "far fa-user",
                    position: "before-author",
                  },
                  custom_class: ""
                },
              },
              {
                title: "Coupons",
                type: "module",
                style: {
                  ...moduleStyle,
                  desktop: {
                    ...moduleStyle.desktop,
                    default: {
                      ...moduleStyle.desktop.default,
                      paddingTop: '10px',
                      paddingBottom: '10px',
                      paddingLeft: '0px',
                      paddingRight: '0px',
                      fontWeight: '400',
                      fontSize: '16px',
                      lineHeight: '21px',
                      fontFamily: 'Open Sans',
                      backgroundColor: 'initial',
                    },
                  },
                  label: {
                    ...moduleStyle,
                    desktop: {
                      ...moduleStyle.desktop,
                      default: {
                        ...moduleStyle.desktop.default,
                        flexBasis: "auto",
                        height: "auto",
                        position: "relative",
                        paddingTop: '10px',
                        paddingBottom: '10px',
                        paddingLeft: '10px',
                        paddingRight: '10px',
                        marginTop: "0",
                        marginRight: "0",
                        marginBottom: "0",
                        marginLeft: "0",
                        backgroundColor: 'initial',
                        color: "#666666",
                        fontSize: '16px',
                        lineHeight: '21px',
                        fontFamily: 'Open Sans',
                        flexBasis:'70%',
                        borderRadius: '0px',
                      }
                    },
                  },
                  meta: {
                    ...moduleStyle,
                    desktop: {
                      ...moduleStyle.desktop,
                      default: {
                        ...moduleStyle.desktop.default,
                        flexBasis: "auto",
                        height: "auto",
                        position: "relative",
                        paddingTop: "10px",
                        paddingRight: "10px",
                        paddingBottom: "10px",
                        paddingLeft: "10px",
                        marginTop: "0",
                        marginRight: "10px",
                        marginBottom: "0",
                        marginLeft: "10px",
                        backgroundColor: "#000000",
                        color: "#ffffff",
                        fontSize: '16px',
                        fontWeight: '700',
                        lineHeight: '21px',
                        fontFamily: 'Open Sans',
                        borderTopWidth: '1px',
                        borderRightWidth: '1px',
                        borderBottomWidth: '1px',
                        borderLeftWidth: '1px',
                        borderRadius: '0px',
                        borderTopColor:'#000000',
                        borderRightColor:'#000000',
                        borderBottomColor:'#000000',
                        borderLeftColor:'#000000',
                        flexBasis:'30%',
                      }
                    },
                  }
                },
                key: "apply_coupon",
                settings: {
                  background_image: "",
                  icons: {
                    visibility: true,
                    icon: "far fa-user",
                    position: "before-author",
                  },
                  custom_class: "",
                  label:"If you have a coupon code, please apply it below.",
                  placeholder:'Coupon Code',
                  btn_text:'Apply Coupon',
                },
              },

            ],
          },
        ],

      },
    ],

    extra_data: {
      slider_data: {
        value: "100",
        suffix: "%",
      },
      bg_color: "#ffffff",
      single_post_data: {},
    },
    breadcrumb_data: {
      select_builder: "false",
      select_layout: "false",
    },
  },
};
