import React, { useState} from "react";
import { Modal, Button, notification } from "antd";
import logo from "./woo-checkout-builder/logo1.png";
import welcomeImg from "./images/welcome-img.png";
import { RightOutlined } from "@ant-design/icons";

import axios from "axios";
const AddNewPage = (props) => {
  axios.defaults.headers.common['Cache-Control'] = 'no-cache, no-store, must-revalidate';
  axios.defaults.headers.common['Pragma'] = 'no-cache';
  axios.defaults.headers.common['Expires'] = '0';
  const site_url = trusty_woo_ajaxObject.site_base_url;
  const apiBase = trusty_woo_ajaxObject.apiBase
  const baseURL = apiBase;
  const [layoutName, setLayoutName] = useState("");
  const [mainBuilderData, setMainBuilderData] = useState(props.mainBuilderData);
  const [errorMsg ,setErrorMsg]=useState(false);
  const handleCancel = () => {
    props.pagePopupState(false);
  };
  const handleNext = () => {
    props.pagePopupState(false);
  };

  const openNotification = () => {
    notification.open({
      message: "Layout Saved!",
      className: "layout-saved-note",
      duration: 5,
      onClick: () => {
        //console.log('Notification Clicked!');
      },
    });
  };
 
  const handleSelectLayout = () => {
    if (layoutName.trim() != "") {
      let alldata = { ...mainBuilderData };
        let trimLayoutName = layoutName.replace(/\s+/g, ' ');
        alldata.common_data.layout_name = trimLayoutName;
        let postedData = {
          layout_data: JSON.stringify(alldata),
        };
        axios
          .post(baseURL + "save-builder-layout/", postedData , {
            headers: {
              'X-WP-Nonce': trusty_woo_ajaxObject.nonce
            }
          })
          .then((response) => {
            if (response.data) {
              if (response.data.status == "success") {
                const newbuilderdata = {
                  ...props.mainBuilderData,
                  common_data: {
                    ...props.mainBuilderData.common_data,
                    layout_key: response.data.post_id,
                   // layout_index:response.data.layout_index,
                  },
                };
                setMainBuilderData(newbuilderdata);
                props.updatedBuilderData(newbuilderdata);
                openNotification();
                props.pagePopupState(false);
                props.handleLayoutContainer(true);
               
              }
            }
          })
          .catch((error) => {
            alert(error);
          });
      
    } else {
        setErrorMsg(true);
      //alert("Plz Select PostType Or Name");
    }
  };
  const handleLayoutLabel = (val) => {
    setLayoutName(val);
  };
  return (
    <>
      <Modal
        open={true}
        onOk={handleNext}
        onCancel={handleCancel}
        footer={null}
        className="caf-add-new-page-popup-container"
      >
        <div className="caf-add-new-page-popup-content-main">
          <div className="caf-add-new-page-popup-content">
            <div className="caf-add-new-page-popup-image-section">
              <div className="logo">
                <img src={logo} alt="caf-logo" />
              </div>
              <div className="welcome-img">
                <img src={welcomeImg} alt="caf-logo" />
              </div>
            </div>
            <div className="caf-add-new-page-popup-form-section">
              <div className="caf-heading">
                <h1>
                Build Smarter <br /> WooCommerce Checkouts
                </h1>
                <span className="caf-description">
                Drag, drop, and customize everything from billing fields to order review. Your perfect checkout starts here.
                </span>
              </div>
              <div className="caf-form-section">
                <label>Name</label>
                <input
                  type="text"
                  placeholder="Enter Name"
                  value={layoutName}
                  onChange={(e) => handleLayoutLabel(e.target.value)}
                />
                <div className="caf-error-msg">{
                  errorMsg && layoutName.trim() =='' && (
                    <>
                    Plz Enter a Layout Name
                    </>
                  )
                  }</div>
              </div>
              <div className="select-layout-btn">
                <Button
                  type="primary"
                  icon={<RightOutlined />}
                  iconPosition={"end"}
                  size="large"
                  onClick={handleSelectLayout}
                >
                  Next
                </Button>
              </div>
            </div>
          </div>
        </div>
      </Modal>
    </>
  );
};

export default AddNewPage;
