import React from "react";
import { useState, useEffect, useRef } from "react";
import axios from "axios";
import { Button, Skeleton, Modal, Tabs, Select, Input, Checkbox, Switch } from "antd";
import AddNewPage from "./MainComponents/AddNewPage";
import MainLayoutContainer from "./MainComponents/MainLayoutContainer";
import logo1 from "./MainComponents/woo-checkout-builder/logo1.png";
import deleteIcon from "./MainComponents/images/delete-icon.png";
import { builderLayoutData } from "./MainComponents/BuilderLayoutData";
import {
  LeftOutlined, DoubleLeftOutlined, RightOutlined,
  DoubleRightOutlined, UndoOutlined, EditOutlined
} from "@ant-design/icons";
const LayoutsList = () => {
  axios.defaults.headers.common['Cache-Control'] = 'no-cache, no-store, must-revalidate';
  axios.defaults.headers.common['Pragma'] = 'no-cache';
  axios.defaults.headers.common['Expires'] = '0';
  const site_url = trusty_woo_ajaxObject.site_base_url;
  const apiBase = trusty_woo_ajaxObject.apiBase
  const baseURL = apiBase;
  const [layoutsList, setLayoutList] = useState(false);
  const [activeLayout, setActiveLayout] = useState('');
  const [filteredLayoutList, setFilteredLayoutList] = useState([]);
  const [loading, setLoading] = useState(true);
  const [layoutContainer, setLayoutContainer] = useState(false);
  const [addNewPagePopup, setAddNewPagePopup] = useState(false); //comment
  const [deleteIndex, setDeleteIndex] = useState({});
  const [isModalOpen, setIsModalOpen] = useState(false);
  const [selectedPage, setSelectedPage] = useState("0");
  const [seletedTab, setSelectedTab] = useState('filters');
  const [selectLoading, setSelectLoading] = useState(false)
  const [checkPostId, setCheckPostId] = useState("0");
  const [selectType, setSelectType] = useState("");
  const [searchPostValue, setSearchPostValue] = useState("");
  const [filtersBulkActionVal, setFiltersBulkActionVal] = useState("0");
  const [currentPage, setCurrentPage] = useState("1");
  const [totalPage, setTotalPage] = useState("1");
  const [totalFilters, setTotalFilters] = useState(0);
  // const [closePopUps, setClosePopUps] = useState(false);
  const [mainBuilderData, setMainBuilderData] = useState({
    ...builderLayoutData,
  });
  const [selectedItems, setSelectedItems] = useState([]);
  const [selectAll, setSelectAll] = useState(false);
  const inputRef = useRef(null);

  /*start trash states*/
  const [searchTrashPostValue, setSearchTrashPostValue] = useState("");
  const [trashLayoutsList, setTrashLayoutList] = useState(false);
  const [filteredTrashLayoutList, setFilteredTrashLayoutList] = useState([]);
  const [selectTrashAll, setSelectTrashAll] = useState(false);
  const [selectedTrashItems, setSelectedTrashItems] = useState([]);
  const [trashCurrentPage, setTrashCurrentPage] = useState("1");
  const [trashTotalPage, setTrashTotalPage] = useState("1");
  const [filtersTrashBulkActionVal, setFiltersTrashBulkActionVal] = useState("0");
  const [totalTrashFilters, setTotalTrashFilters] = useState(0);
  /*end trash states*/


  useEffect(() => {
    setSelectAll(selectedItems.length === filteredLayoutList.length);
  }, [selectedItems, filteredLayoutList]);
  useEffect(() => {
    setSelectTrashAll(selectedTrashItems.length === filteredTrashLayoutList.length);
  }, [selectedTrashItems, filteredTrashLayoutList]);

  useEffect(() => {
    getLayouts(1);
    getTrashLayouts(1)
    setSelectedItems([])
    setCurrentPage(1);
    setTotalPage("1")
    setTrashCurrentPage(1)
    setTrashTotalPage("1")
    setSelectedTrashItems([])
  }, [seletedTab]);

  const handleSearchTrashPostChange = (val) => {
    setSearchTrashPostValue(val);
    const filteredData = trashLayoutsList && trashLayoutsList?.filter(item => item.post_title && item.post_title.toLowerCase().includes(val));
    setFilteredTrashLayoutList(filteredData);
  }

  const handleSelectTrashAllChange = (e) => {
    const checked = e.target.checked;
    setSelectTrashAll(checked);
    if (checked) {
      const allIds = filteredTrashLayoutList.map((item) => {
        if (item?.layout_source == 'Builder') {
          return 'bl_' + item.list_index;
        } else {
          return item.ID;
        }
      });
      setSelectedTrashItems(allIds);
    } else {
      setSelectedTrashItems([]);
    }
  };
  const handleTrashCheckboxChange = (id) => {
    if (selectedTrashItems.includes(id)) {
      setSelectedTrashItems(selectedTrashItems.filter((itemId) => itemId !== id));
    } else {
      setSelectedTrashItems([...selectedTrashItems, id]);
    }
  };
  const getTrashLayouts = async (page) => {
    setLoading(true);
    const { data } = await axios.get(baseURL + "get-trash-layouts-list?page=" + page, {
      headers: {
        'X-WP-Nonce': trusty_woo_ajaxObject.nonce
      }
    });
    if (data) {
      if (data.status == "success") {
        setTrashCurrentPage(data.current_page)
        setTrashTotalPage(data.total_page);
        setTrashLayoutList(data.layouts_list);
        setFilteredTrashLayoutList(data.layouts_list)
        setTotalTrashFilters(data.total_trash_filters);
        setLoading(false);
      } else {
        setTrashLayoutList([]);
        setFilteredTrashLayoutList([])
        setLoading(false);
      }
    }
  };
  const handleTrashBulkActionsApply = () => {
    if (filtersTrashBulkActionVal != "0" && selectedTrashItems.length > 0) {
      setLoading(true);
      if (filtersTrashBulkActionVal == "restore") {
        let postedData = {
          post_ids: JSON.stringify(selectedTrashItems),
        };
        axios
          .post(baseURL + "bulk-layouts-restore", postedData, {
            headers: {
              'X-WP-Nonce': trusty_woo_ajaxObject.nonce
            }
          })
          .then((response) => {
            if (response.data.status == "success") {
              getLayouts(1);
              getTrashLayouts(1);
              setFiltersTrashBulkActionVal("0")
            }
          })
          .catch((error) => {
            console.error(error);
          });
      }
      if (filtersTrashBulkActionVal == "delete") {
        let postedData = {
          post_ids: JSON.stringify(selectedTrashItems),
        };
        axios
          .post(baseURL + "bulk-layouts-delete-permanent", postedData, {
            headers: {
              'X-WP-Nonce': trusty_woo_ajaxObject.nonce
            }
          })
          .then((response) => {
            if (response.data.status == "success") {
              getLayouts(1);
              getTrashLayouts(1);
              setFiltersTrashBulkActionVal("0")
            }
          })
          .catch((error) => {
            console.error(error);
          });
      }
    }
  }
  const handleTrashPageChange = (val, type) => {
    const currentPageNumber = parseInt(trashCurrentPage);
    const newPage = parseInt(val);
    if (type === 'prev') {
      if (newPage >= 1 && newPage !== currentPageNumber) {
        getTrashLayouts(newPage);
      }
    }

    if (type === 'next') {
      if (newPage <= trashTotalPage && newPage !== currentPageNumber) {
        getTrashLayouts(newPage);
      }
    }
  };

  const handleLayoutRestore = (postId, source, index) => {
    setLoading(true);
      let layout_detail = {
        post_id: postId,
      };
      axios
        .post(baseURL + "restore-layout", layout_detail, {
          headers: {
            'X-WP-Nonce': trusty_woo_ajaxObject.nonce
          }
        })
        .then((response) => {
          if (response.data.status == "success") {
            getLayouts(1);
            getTrashLayouts(1);
          } else {
            alert(response.data.message);
          }
        })
        .catch((error) => {
          console.error(error);
        })
        .finally(() => {
          // setLoading(false);
        });
  }
  const handleDeletePermanent = (postId, source, index) => {
    setLoading(true);
      let layout_detail = {
        post_id: postId,
      };
      axios
        .post(baseURL + "delete-layout-permanent", layout_detail, {
          headers: {
            'X-WP-Nonce': trusty_woo_ajaxObject.nonce
          }
        })
        .then((response) => {
          if (response.data.status == "success") {
            getLayouts(1);
            getTrashLayouts(1);
          } else {
            setLoading(false);
            alert(response.data.message);
          }
        })
        .catch((error) => {
          console.error(error);
        })
        .finally(() => {
          // setLoading(false);
        });
  }
  const getLayouts = async (page) => {
    setLoading(true);
    //const { data } = await axios.get(baseURL + "get-layouts-list?page=" + page);
    const { data } = await axios.get(baseURL + "get-layouts-list?page=" + page, {
      headers: {
        'X-WP-Nonce': trusty_woo_ajaxObject.nonce
      }
    });
    if (data) {
      if (data.status == "success") {
        setCurrentPage(data.current_page)
        setTotalPage(data.total_page);
        setLayoutList(data.layouts_list);
        setFilteredLayoutList(data.layouts_list)
        setTotalFilters(data.total_filters)
        setLoading(false);
      } else {
        setLayoutList([]);
        setFilteredLayoutList([])
        setLoading(false);
      }
    }
  };

  const handlePageChange = (val, type) => {
    const currentPageNumber = parseInt(currentPage);
    const newPage = parseInt(val);
    if (type === 'prev') {
      if (newPage >= 1 && newPage !== currentPageNumber) {
        getLayouts(newPage);
      }
    }

    if (type === 'next') {
      if (newPage <= totalPage && newPage !== currentPageNumber) {
        getLayouts(newPage);
      }
    }
  };

  const handelAddNew = () => {
    setAddNewPagePopup(true);
    setSelectedTab("filters");
  };
  const handlePagePopupState = (res) => {
    setAddNewPagePopup(res);
    // setClosePopUps(res);
  };

  const closeAllPopUps = (val) => {
    setAddNewPagePopup(val);
    setLayoutContainer(val);
    getLayouts(1);
    getTrashLayouts(1);
    setSelectedPage("0");
    setCheckPostId("0");
    setSelectType("");
    setSelectedTab("filters");
  };
  const handleBulkActionsApply = () => {
    if (filtersBulkActionVal != "0" && selectedItems.length > 0) {
      setLoading(true);
      let postedData = {
        post_ids: JSON.stringify(selectedItems),
      };
      axios
        .post(baseURL + "move-to-trash", postedData, {
          headers: {
            'X-WP-Nonce': trusty_woo_ajaxObject.nonce
          }
        })
        .then((response) => {
          if (response.data.status == "success") {
            getLayouts(1);
            getTrashLayouts(1);
            setFiltersBulkActionVal('0')
          }
        })
        .catch((error) => {
          console.error(error);
        });
    }
  }
  const handleLayoutContainer = (res) => {
    setLayoutContainer(res);
  };
  const updatedBuilderData = (data) => {
    setMainBuilderData(data);
  };

  const handleLayoutDelete = (postId, source, index) => {
    let obj = {
      id: postId,
      source: source,
      index: index,
    };
    setDeleteIndex(obj);
    setIsModalOpen(true);
  };
  const handleDeleteConfirm = () => {
    setLoading(true);
      let layout_detail = {
        post_id: deleteIndex.id,
      };
      axios
        .post(baseURL + "delete-layout", layout_detail, {
          headers: {
            'X-WP-Nonce': trusty_woo_ajaxObject.nonce
          }
        })
        .then((response) => {
          if (response.data.status == "success") {
            getLayouts(1);
            getTrashLayouts(1);
          } else {
            alert(response.data.message);
          }
        })
        .catch((error) => {
          console.error(error);
        })
        .finally(() => {
          //setLoading(false);
        });
    
    setIsModalOpen(false);
  };
  const handleDeleteCancel = () => {
    setIsModalOpen(false);
  };
  const TabItems = [
    {
      key: 'filters',
      label: (`Filters (${totalFilters ?? 0})`),
    },
    {
      key: 'trash',
      label: (`Trash (${totalTrashFilters ?? 0})`),
    }
  ];
  const onChangeTab = (tab) => {
    setSelectedTab(tab);
  }
  const handleSelectedPageChange = (val, postId) => {
    console.log(postId);
    if (val != "0") {
      setSelectLoading(true);
      setCheckPostId(postId)
      setSelectedPage(val);
      let postedData = {
        layout_key: postId,
      };
      axios
        .post(baseURL + "get-layout-data", postedData, {
          headers: {
            'X-WP-Nonce': trusty_woo_ajaxObject.nonce
          }
        })
        .then((response) => {
          if (response.data.status == "success") {
            //let mainData = response.data.layout_data;
            if (val == 'post-settings' || val == "preview-settings") {
              let builderState = "true";
              if (builderState == "true") {
                setMainBuilderData({ ...response.data.layout_data });
                setSelectType(val)
                setLayoutContainer(true);
                setSelectLoading(false);
              } else {
                alert("Not allowed to Jump this page")
              }
            } else {
              setMainBuilderData({ ...response.data.layout_data });
              setSelectType(val)
              setLayoutContainer(true);
              setSelectLoading(false);
            }
          } else {
            alert(response.data.message);
          }
          setSelectLoading(false);
        })
        .catch((error) => {
          console.error(error);
        });

    }
  }
  const handleSearchPostChange = (val) => {
    setSearchPostValue(val);
    const filteredData = layoutsList && layoutsList?.filter(item => item.post_title && item.post_title.toLowerCase().includes(val));
    setFilteredLayoutList(filteredData);
  }
  const handleCheckboxChange = (id) => {
    if (selectedItems.includes(id)) {
      setSelectedItems(selectedItems.filter((itemId) => itemId !== id));
    } else {
      setSelectedItems([...selectedItems, id]);
    }
  };

  const handleSelectAllChange = (e) => {
    const checked = e.target.checked;
    setSelectAll(checked);
    if (checked) {
      const allIds = filteredLayoutList.map((item) => {
        if (item?.layout_source == 'Builder') {
          return 'bl_' + item.list_index;
        } else {
          return item.ID;
        }
      });
      setSelectedItems(allIds);
    } else {
      setSelectedItems([]);
    }
  };

  const handleActiveChange = (isChecked, postId, index) => {
    setLoading(true);

    const layout_detail = {
      post_id: postId,
      deactivate: !isChecked, // send info to tell if it should deactivate
    };

    axios
      .post(baseURL + "activate-layout", layout_detail, {
        headers: {
          'X-WP-Nonce': trusty_woo_ajaxObject.nonce
        }
      })
      .then((response) => {
        if (response.data.status === "success") {
          getLayouts(1);
          getTrashLayouts(1);
        } else {
          alert(response.data.message);
        }
      })
      .catch((error) => {
        console.error(error);
      });
  };



  return (
    <>
      <div className="caf-layouts-list-main-container">
        <Modal open={isModalOpen} onOk={handleDeleteConfirm} onCancel={handleDeleteCancel}>
          <p>Are you sure, want to delete this post layout </p>
        </Modal>
        <div className="caf-layouts-list-header-container">
          <div className="caf-layouts-list-header-inner-section">
            <div className="caf-layouts-list-header-left">
              <div className="caf-logo-main">
                <img src={logo1} className="caf-logo" />
              </div>
              <div className="caf-header-title-desc-main">
                <h2 className="caf-header-title">Welcome to Woo Checkout Builder</h2>
                <div className="caf-header-desc">
                  Easily create, manage, and activate custom WooCommerce checkout layouts from your WordPress admin panel.
                </div>
              </div>
            </div>
            <div className="caf-layouts-list-header-right">
              <div className="caf-layouts-list-header-right-inner">
                <div className="caf-add-new-btn-out">
                  <button className="caf-add-new-btn" onClick={handelAddNew}>
                    Add New
                  </button>
                </div>

              </div>
            </div>
          </div>
        </div>
        <div className="caf-layouts-list-tabs-main">
          <Tabs defaultActiveKey="filters" activeKey={seletedTab} items={TabItems} onChange={onChangeTab} />
        </div>
        {seletedTab == 'filters' ? (
          <>
            {!loading ? (
              <>
                {filteredLayoutList && filteredLayoutList.length > 0 ? (
                  <>
                    <div className="caf-layouts-list-conatiner">
                      <ul className="caf-layout-list-inner">
                        <li className="caf-list-single-row-header">
                          <div className="caf-multiple-select">
                            <input type="checkbox"
                              className="filters-select-all-checkbox"
                              checked={selectAll}
                              onChange={handleSelectAllChange}
                            />
                          </div>
                          <div className="caf-sr-no">#</div>
                          <div className="caf-filter-label">Title</div>
                          <div className="caf-filter-active-template">Activate</div>
                          <div className="caf-filter-actions">Actions</div>
                        </li>
                        {filteredLayoutList?.map((item, index) => (
                          <li className="caf-list-single-row">
                            <div className="caf-multiple-select">
                              <input type="checkbox" className="caf-latyout-list-multiple-select-check-box"
                                checked={selectedItems.includes(item?.layout_source == "Builder" ? 'bl_' + item?.list_index : item.ID)}
                                onChange={() => handleCheckboxChange(item?.layout_source == "Builder" ? 'bl_' + item?.list_index : item.ID)}
                              />
                            </div>
                            <div className="caf-sr-no">{index + 1}{"."}</div>

                            <div className="caf-filter-name">
                              {item?.post_title}
                            </div>

                            <div className="caf-filter-active-template">
                              <Switch
                                onChange={(checked) => handleActiveChange(checked, item.ID, item.list_index)}
                                checked={!!item?.active_layout_id}
                              />
                            </div>

                            <div className="caf-filter-actions">

                              <EditOutlined
                                style={{
                                  fontSize: '24px',
                                  cursor: 'pointer',
                                  color: '#000000',
                                  marginRight:'10px',
                                }}
                                spin={checkPostId === item?.ID && selectLoading}
                                onClick={() => handleSelectedPageChange("post-settings", item?.ID)}
                              />
                              <span
                                onClick={() =>
                                  handleLayoutDelete(
                                    item.ID,
                                    item?.layout_source,
                                    item.list_index
                                  )
                                }
                              >
                                <img src={deleteIcon} alt="img" />
                              </span>
                            </div>
                          </li>
                        ))}
                      </ul>
                    </div>
                    <div className="caf-layouts-list-filter-tab-footer-container">
                      <div className="caf-layouts-list-filter-tab-footer-inner-section">
                        <div className="caf-layouts-list-filter-tab-footer-left">
                          <Select
                            defaultValue={filtersBulkActionVal}
                            style={{
                              width: "150px",
                            }}
                            onChange={setFiltersBulkActionVal}
                            options={[
                              {
                                label: "Bulk Actions",
                                value: "0",
                              },
                              {
                                label: "Move To Trash",
                                value: "move-to-trash",
                              },
                            ]}
                            value={filtersBulkActionVal}
                          />
                          <div className="caf-add-new-btn-out caf-filter-tab-bulk-apply">
                            <button className="caf-add-new-btn caf-fitler-tab-bulk-apply-btn" onClick={handleBulkActionsApply}>
                              Apply
                            </button>
                          </div>
                        </div>
                        <div className="caf-layouts-list-filter-tab-footer-right">
                          <div className="caf-layouts-list-filter-tab-footer-pagination-prev-side"><DoubleLeftOutlined className={`pagination-icon-prev ${currentPage != 1 && "pagination-btn-active"}`} onClick={() => handlePageChange(1, "prev")} /><LeftOutlined className={`pagination-icon-prev ${currentPage != 1 && "pagination-btn-active"}`} onClick={() => handlePageChange(currentPage - 1, "prev")} /></div>
                          <div className="caf-layouts-list-filter-tab-footer-pagination-page-no-info"> <span className="caf-current-page">{currentPage}</span> of <span className="caf-total-page">{totalPage}</span></div>
                          <div className="caf-layouts-list-filter-tab-footer-pagination-next-side"><RightOutlined className={`pagination-icon-next ${currentPage != totalPage && "pagination-btn-active"}`} onClick={() => handlePageChange(currentPage + 1, "next")} /> <DoubleRightOutlined className={`pagination-icon-next ${currentPage != totalPage && "pagination-btn-active"}`} onClick={() => handlePageChange(totalPage, "next")} /></div>
                        </div>
                      </div>
                    </div>
                  </>
                ) : (
                  <>
                    {!loading && filteredLayoutList.length == 0 &&
                      <p className="caf-layout-list-error-message">
                        No Filter Found...
                      </p>
                    }
                  </>
                )}
              </>
            ) : (
              <Skeleton active />
            )}
          </>
        ) : (
          <>
            {!loading ? (
              <>
                {trashLayoutsList && trashLayoutsList.length > 0 && (
                  <div class="caf-layouts-list-search-section trash-search">
                    <Input
                      placeholder="Search"
                      className="caf-layouts-list-search-input"
                      value={searchTrashPostValue}
                      onChange={(e) => handleSearchTrashPostChange(e.target.value)}
                    />
                  </div>
                )}
                {filteredTrashLayoutList.length > 0 ? (
                  <>
                    <div className="caf-layouts-list-conatiner trash-layouts-list">
                      <ul className="caf-layout-list-inner">
                        <li className="caf-list-single-row-header">
                          <div className="caf-multiple-select">
                            <input type="checkbox"
                              className="filters-select-all-checkbox"
                              checked={selectTrashAll}
                              onChange={handleSelectTrashAllChange}

                            />
                          </div>
                          <div className="caf-sr-no">#</div>
                          <div className="caf-filter-label">Title</div>
                          <div className="caf-filter-actions">Actions</div>
                        </li>
                        {filteredTrashLayoutList?.map((item, index) => (
                          <li className="caf-list-single-row">
                            <div className="caf-multiple-select">
                              <input type="checkbox" className="caf-latyout-list-multiple-select-check-box"
                                checked={selectedTrashItems.includes(item?.layout_source == "Builder" ? 'bl_' + item?.list_index : item.ID)}
                                onChange={() => handleTrashCheckboxChange(item?.layout_source == "Builder" ? 'bl_' + item?.list_index : item.ID)}
                              />
                            </div>
                            <div className="caf-sr-no">{index + 1}{"."}</div>
                            <div className="caf-filter-name">
                              {item?.post_title}-{" "}
                              <span className={`caf-layout-tag ${item?.layout_source?.toLowerCase()?.replace(/\s+/g, '_')}`}>
                                {item?.layout_source}
                              </span>
                            </div>
                            <div className="caf-filter-actions">
                              <Button
                                title="Restore Filter"
                                icon={<UndoOutlined />}
                                type="default"
                                shape="default"
                                size="medium"
                                className="caf-layout-restore-filter-btn"
                                onClick={() => handleLayoutRestore(item.ID,
                                  item?.layout_source,
                                  item.list_index)}
                              />
                              <Button
                                title="Delete Permanently"
                                icon={<img src={deleteIcon} alt="img" />}
                                type="default"
                                shape="default"
                                size="medium"
                                className="caf-layout-delete-permanently-filter-btn"
                                onClick={() =>
                                  handleDeletePermanent(
                                    item.ID,
                                    item?.layout_source,
                                    item.list_index
                                  )
                                }
                              />
                             
                            </div>
                          </li>
                        ))}
                      </ul>
                    </div>
                    <div className="caf-layouts-list-filter-tab-footer-container trash-footer">
                      <div className="caf-layouts-list-filter-tab-footer-inner-section">
                        <div className="caf-layouts-list-filter-tab-footer-left">
                          <Select
                            defaultValue={filtersTrashBulkActionVal}
                            style={{
                              width: "170px",
                            }}
                            onChange={setFiltersTrashBulkActionVal}
                            options={[
                              {
                                label: "Bulk Actions",
                                value: "0",
                              },
                              {
                                label: "Restore",
                                value: "restore",
                              },
                              {
                                label: "Delete Permanently",
                                value: "delete",
                              },
                            ]}
                            value={filtersTrashBulkActionVal}
                          />
                          <div className="caf-add-new-btn-out caf-fiter-tab-bulk-apply">
                            <button className="caf-add-new-btn caf-fiter-tab-bulk-apply-btn" onClick={handleTrashBulkActionsApply}>
                              Apply
                            </button>
                          </div>
                        </div>
                        <div className="caf-layouts-list-filter-tab-footer-right">
                          <div className="caf-layouts-list-filter-tab-footer-pagination-prev-side"><DoubleLeftOutlined className={`pagination-icon-prev ${trashCurrentPage != 1 && "pagination-btn-active"}`} onClick={() => handleTrashPageChange(1, "prev")} /><LeftOutlined className={`pagination-icon-prev ${trashCurrentPage != 1 && "pagination-btn-active"}`} onClick={() => handleTrashPageChange(trashCurrentPage - 1, "prev")} /></div>
                          <div className="caf-layouts-list-filter-tab-footer-pagination-page-no-info"> <span className="caf-current-page">{trashCurrentPage}</span> of <span className="caf-total-page">{trashTotalPage}</span></div>
                          <div className="caf-layouts-list-filter-tab-footer-pagination-next-side"><RightOutlined className={`pagination-icon-next ${trashCurrentPage != trashTotalPage && "pagination-btn-active"}`} onClick={() => handleTrashPageChange(trashCurrentPage + 1, "next")} /> <DoubleRightOutlined className={`pagination-icon-next ${trashCurrentPage != trashTotalPage && "pagination-btn-active"}`} onClick={() => handleTrashPageChange(trashTotalPage, "next")} /></div>
                        </div>
                      </div>
                    </div>
                  </>
                ) : (
                  <>
                    {!loading && filteredTrashLayoutList.length == 0 &&
                      <p className="caf-layout-list-error-message">
                        No Filter Found...
                      </p>
                    }
                  </>
                )}
              </>
            ) : (
              <Skeleton active />
            )}
          </>
        )}
        {addNewPagePopup && (
          <AddNewPage
            pagePopupState={handlePagePopupState}
            handleLayoutContainer={handleLayoutContainer}
            updatedBuilderData={updatedBuilderData}
            mainBuilderData={builderLayoutData}
          />
        )}
      </div>
      {layoutContainer && (
        <MainLayoutContainer
          mainBuilderData={mainBuilderData}
          closeAllPopUps={closeAllPopUps}
          //selectType={selectType}
          selectType={'post-settings'}
        />
      )}
    </>
  );
};

export default LayoutsList;
