import React, { useState, useEffect } from 'react';
import existingGif from '../assets/images/existing.gif';
import RenderTemplate from './RenderTemplate';
import { render } from '@wordpress/element';
const FloatingBar = () => {
    const [showTemplates, setShowTemplates] = useState(false);
    const [isLoading, setIsLoading] = useState(false);
    const [hideBar, setHideBar] = useState(false);
    const [selectedLayout, setSelectedLayout] = useState(() => {
        return parseInt(ajaxObject.savedTemplate) || null;
    });
    const [hideClose, setHideClose] = useState(false);
    useEffect(() => {
        // Check if template already selected in backend
        if (ajaxObject.savedTemplate) {
            console.log("Template already selected:", ajaxObject.savedTemplate);
            setHideBar(true); // Hide the bar
        }
    }, []);
    const handleExploreTemplates = () => {
        setShowTemplates(true);
    };
    const handleExploreTemplatesChange = () => {
        setShowTemplates(true);
        setHideBar(false);
        const checkoutForm = document.querySelector('.trusty-woo-checkout-floating-bar');

        if (checkoutForm) {
            checkoutForm.classList.remove('trusty-layout-selected');
        }
        setHideClose(true);
    };

    const handleScratchBuilding = () => {
        setIsLoading(true);
        setTimeout(() => {
            const checkoutForm = document.querySelector('.trusty-woo-checkout-floating-bar');
            if (checkoutForm) {
                checkoutForm.classList.add('trusty-layout-selected');
            }
            setShowTemplates(false);
            setIsLoading(false);
            setHideBar(true);
        }, 1000);
        const targetRender = document.querySelector('.trusty-woo-checkout-main-form');
             render(<RenderTemplate id={0} />,targetRender);
    };


    const handleCloseTemplates = () => {
        //console.log("innnn", showTemplates);
        if (hideClose) {
            setShowTemplates(false);
            setHideBar(true);
            const checkoutForm = document.querySelector('.trusty-woo-checkout-floating-bar');
            if (checkoutForm) {
                checkoutForm.classList.add('trusty-layout-selected');
            }
            setHideClose(false);
        }
        else {
            setShowTemplates(false);
        }
    };
    const handleTemplateSelect = (templateId) => {
        if (!ajaxObject.is_admin) {
            console.warn("Only admins can apply templates.");
            return;
        }

        console.log("Selected Template:", templateId);
        setIsLoading(true);

        const templateData = {
            template_id: templateId,
            template_title: `Layout ${templateId}`,
            applied_at: new Date().toISOString()
        };

        fetch(ajaxObject.ajax_url, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: new URLSearchParams({
                action: 'trusty_save_checkout_template',
                data: JSON.stringify(templateData),
                _ajax_nonce: ajaxObject.nonce
            })
        })
            .then(res => res.json())
            .then(response => {
                console.log("Server response:", response);

                setTimeout(() => {
                    const checkoutForm = document.querySelector('.trusty-woo-checkout-floating-bar');

                    if (checkoutForm) {
                        checkoutForm.classList.add('trusty-layout-selected');
                    }

                    setShowTemplates(false);
                    setIsLoading(false);
                    setHideBar(true);
                    setSelectedLayout(templateId);
                }, 4000);
            })
            .catch(error => {
                console.error("Error saving template:", error);
                setIsLoading(false);
            });
    };

    if (hideBar) {
        const checkoutForm = document.querySelector('.trusty-woo-checkout-floating-bar');

        if (checkoutForm) {
            checkoutForm.classList.add('trusty-layout-selected');
        }
        return (
            <>
                <div className="trusty-woo-checkout-builder-arrange">
                    <button
                        type="button"
                        className="trusty-checkout-layout-change trusty-checkout-button"
                        onClick={handleExploreTemplatesChange}
                    >
                        Change Layout
                    </button>
                    <button
                        type="button"
                        className="trusty-checkout-publish trusty-checkout-button"
                    >
                        Save
                    </button>
                </div>

            </>
        )
    }
    const targetRender = document.querySelector('.trusty-woo-checkout-main-form');
    if (selectedLayout => 0) {
        // render(<RenderTemplate id={selectedLayout} />,targetRender);

    }
    return (
        <>
            <div className='trusty-woo-initial-floating-bars'>
                <div className={`trusty-woo-fade-wrapper ${showTemplates ? 'trusty-woo-hidden' : 'trusty-woo-visible'
                    }`} >
                    <div className='trusty-woo-float-bar trusty-scratch' onClick={handleScratchBuilding}>
                        <div className='trusty-woo-float-manage'>
                            <img src={existingGif} alt="Existing Layout Preview" />
                            <h2>Start From Scratch</h2>
                            <div className='trusty-woo-float-description'>Use the builder to build the checkout page with existing modules.</div>
                        </div>
                        <button className='trusty-woo-float-button' onClick={handleScratchBuilding}>Start Building</button>
                    </div>
                    <div className='trusty-woo-float-bar trusty-premade' onClick={handleExploreTemplates}>
                        <div className='trusty-woo-float-manage'>
                            <img src={existingGif} alt="Existing Layout Preview" />
                            <h2>Premade Templates</h2>
                            <div className='trusty-woo-float-description'>Quickly start designing with professionally crafted checkout layouts.</div>
                        </div>
                        <button className='trusty-woo-float-button' onClick={handleExploreTemplates}>Explore Templates</button>
                    </div>
                </div>

                <div
                    className={`trusty-woo-fade-wrapper ${showTemplates ? 'trusty-woo-visible' : 'trusty-woo-hidden'
                        }`}
                >
                    <div className='trusty-woo-template-explorer'>
                        <div className='trusty-woo-template-header'>
                            <h2>Template Library</h2>
                            <button onClick={handleCloseTemplates} className='trusty-woo-close-button'>×</button>
                        </div>
                        <div className='trusty-woo-template-content'>
                        <div className={`trusty-woo-template ${selectedLayout === 0 ? 'active' : ''}`}><img src={existingGif} alt="Existing Layout Preview" onClick={() => handleTemplateSelect(0)} /><h2>Default</h2></div>
                            <div className={`trusty-woo-template ${selectedLayout === 1 ? 'active' : ''}`}><img src={existingGif} alt="Existing Layout Preview" onClick={() => handleTemplateSelect(1)} /><h2>Layout 1</h2></div>
                            <div className={`trusty-woo-template ${selectedLayout === 2 ? 'active' : ''}`}><img src={existingGif} alt="Existing Layout Preview" onClick={() => handleTemplateSelect(2)} /><h2>Layout 2</h2></div>
                            <div className={`trusty-woo-template ${selectedLayout === 3 ? 'active' : ''}`}><img src={existingGif} alt="Existing Layout Preview" onClick={() => handleTemplateSelect(3)} /><h2>Layout 3</h2></div>
                            <div className={`trusty-woo-template ${selectedLayout === 4 ? 'active' : ''}`}><img src={existingGif} alt="Existing Layout Preview" onClick={() => handleTemplateSelect(4)} /><h2>Layout 4</h2></div>
                            <div className={`trusty-woo-template ${selectedLayout === 5 ? 'active' : ''}`}><img src={existingGif} alt="Existing Layout Preview" onClick={() => handleTemplateSelect(5)} /><h2>Layout 5</h2></div>
                            <div className={`trusty-woo-template ${selectedLayout === 6 ? 'active' : ''}`}><img src={existingGif} alt="Existing Layout Preview" onClick={() => handleTemplateSelect(6)} /><h2>Layout 6</h2></div>
                        </div>
                    </div>

                </div>
                {isLoading && (
                    <div className="trusty-woo-loader-overlay">
                        <div className="trusty-woo-spinner"></div>
                        <div className="trusty-woo-loading-text">Applying template...</div>
                    </div>
                )}
            </div>


        </>
    );
}

export default FloatingBar; 