<?php
if (! defined('ABSPATH')) {
    exit;
}

class TRUSTY_WOO_CHECKOUT_POST_TYPE
{
    const post_type = 'trusty_check_builder';
    public function __construct()
    {
        add_action('init', array($this, 'trusty_woo_register_post_type'), 100);
    }

    public function trusty_woo_register_post_type()
    {
        register_post_type(self::post_type, array(
            'labels' => array(
                'name' => __('Trusty Checkout', 'all-in-one-checkout-page-builder-for-woocommerce'),
                'singular_name' => __('Trusty Checkout', 'all-in-one-checkout-page-builder-for-woocommerce'),
            ),
            'public' => false,
            'hierarchical' => false,
            'exclude_from_search' => true,
            'show_ui' => current_user_can('manage_options') ? true : false,
            'show_in_admin_bar' => false,
            'menu_position' => 7,
            //'menu_icon'     => TC_trusty_woo_PRO_URL.'admin/images/tp icon CAF.svg',
            'menu_icon' => 'dashicons-layout',
            'rewrite' => false,
            'query_var' => false,
            'supports' => array(
                'title',
            ),
        ));
    }
}

class TRUSTY_WOO_CHECKOUT_ENQUEUES
{
    public function __construct()
    {
        add_action('admin_enqueue_scripts', array($this, 'trusty_woo_checkout_embedCssJs'));
    }
    public function trusty_woo_checkout_embedCssJs()
    {
        global $post_type, $hook_suffix;
        if ($post_type == "trusty_check_builder") {
            wp_enqueue_style('google-fonts-urbanist', 'https://fonts.googleapis.com/css2?family=Urbanist:ital,wght@0,100..900;1,100..900&display=swap', array(), TRUSTY_WOO_CHECKOUT_VERSION);
            wp_enqueue_style('cbuilder-style', plugin_dir_url(__FILE__) . '../assets/css/style.css', array(), TRUSTY_WOO_CHECKOUT_VERSION);
            wp_enqueue_script('wc-builder-script', plugin_dir_url(__FILE__) . '../build/index.js', array('wp-element'), TRUSTY_WOO_CHECKOUT_VERSION, true);
            wp_localize_script('wc-builder-script', 'trusty_woo_ajaxObject', [
                'ajax_url' => admin_url('admin-ajax.php'),
                'site_base_url' => site_url(),
                'nonce'    => wp_create_nonce('wp_rest'),
                'apiBase'  => esc_url_raw(rest_url('woo-checkout-builder/v1/')), // Base path
                'userCanEdit' => current_user_can('manage_options'),
                'plugin_path' => TRUSTY_WOO_CHECKOUT_URL
            ]);
            if (class_exists('WooCommerce')) {
                $wc_url = WC()->plugin_url(); // gets plugin URL dynamically
                wp_enqueue_style(
                    'trusty-woocommerce-css-admin',
                    $wc_url . '/assets/css/woocommerce.css',
                    array(),
                    TRUSTY_WOO_CHECKOUT_VERSION
                );
            }
        }
    }
}


new TRUSTY_WOO_CHECKOUT_POST_TYPE();
new TRUSTY_WOO_CHECKOUT_ENQUEUES();


add_action('rest_api_init', 'trusty_woo_builder_layout_init_fun');

function trusty_woo_builder_layout_init_fun()
{

    register_rest_route('woo-checkout-builder/v1', '/get-layouts-list/', array(
        'methods' => 'GET',
        'callback' => 'trusty_woo_get_layouts_list',
        'permission_callback' => function () {
            return current_user_can('manage_options');
        },
    ));
    register_rest_route('woo-checkout-builder/v1', '/get-trash-layouts-list/', array(
        'methods' => 'GET',
        'callback' => 'trusty_woo_get_trash_layouts_list',
        'permission_callback' => function () {
            return current_user_can('manage_options');
        },
    ));
    register_rest_route('woo-checkout-builder/v1', '/save-builder-layout/', array(
        'methods' => 'POST',
        'callback' => 'trusty_woo_save_builder_layout',
        'permission_callback' => function () {
            return current_user_can('manage_options');
        },
    ));
    register_rest_route('woo-checkout-builder/v1', '/delete-layout/', array(
        'methods' => 'POST',
        'callback' => 'trusty_woo_delete_builder_layout',
        'permission_callback' => function () {
            return current_user_can('manage_options');
        },
    ));
    register_rest_route('woo-checkout-builder/v1', '/restore-layout/', array(
        'methods' => 'POST',
        'callback' => 'trusty_woo_restore_builder_layout',
        'permission_callback' => function () {
            return current_user_can('manage_options');
        },
    ));
    register_rest_route('woo-checkout-builder/v1', '/delete-layout-permanent/', array(
        'methods' => 'POST',
        'callback' => 'trusty_woo_delete_builder_layout_permanent',
        'permission_callback' => function () {
            return current_user_can('manage_options');
        },
    ));
    register_rest_route('woo-checkout-builder/v1', '/move-to-trash/', array(
        'methods' => 'POST',
        'callback' => 'trusty_woo_move_to_trash',
        'permission_callback' => function () {
            return current_user_can('manage_options');
        },
    ));
    register_rest_route('woo-checkout-builder/v1', '/bulk-layouts-restore/', array(
        'methods' => 'POST',
        'callback' => 'trusty_woo_bulk_layouts_restore',
        'permission_callback' => function () {
            return current_user_can('manage_options');
        },
    ));
    register_rest_route('woo-checkout-builder/v1', '/bulk-layouts-delete-permanent/', array(
        'methods' => 'POST',
        'callback' => 'trusty_woo_bulk_layouts_delete_permanent',
        'permission_callback' => function () {
            return current_user_can('manage_options');
        },
    ));
    register_rest_route('woo-checkout-builder/v1', '/get-layout-data/', array(
        'methods' => 'POST',
        'callback' => 'trusty_woo_get_layout_data',
        'permission_callback' => function () {
            return current_user_can('manage_options');
        },
    ));
    register_rest_route('woo-checkout-builder/v1', '/rename-builder-layout-label/', array(
        'methods' => 'POST',
        'callback' => 'trusty_woo_rename_builder_layout_label',
        'permission_callback' => function () {
            return current_user_can('manage_options');
        },
    ));
    register_rest_route('woo-checkout-builder/v1', '/update-builder-layout/', array(
        'methods' => 'POST',
        'callback' => 'trusty_woo_update_builder_layout',
        'permission_callback' => function () {
            return current_user_can('manage_options');
        },
    ));
    register_rest_route('woo-checkout-builder/v1', '/get-shipping-status/', array(
        'methods' => 'GET',
        'callback' => 'trusty_woo_get_shipping_status',
        'permission_callback' => function () {
            return current_user_can('manage_options');
        },
    ));
    register_rest_route('woo-checkout-builder/v1', '/get-order-review-section/', array(
        'methods' => 'GET',
        'callback' => 'trusty_woo_get_order_review_section',
        'permission_callback' => function () {
            return current_user_can('manage_options');
        },
    ));
    register_rest_route('woo-checkout-builder/v1', '/get-payments-section/', array(
        'methods' => 'GET',
        'callback' => 'trusty_woo_get_payment_methods_section',
        'permission_callback' => function () {
            return current_user_can('manage_options');
        },
    ));
    register_rest_route('woo-checkout-builder/v1', '/get-coupon-section/', array(
        'methods' => 'GET',
        'callback' => 'trusty_woo_get_coupon_section',
        'permission_callback' => function () {
            return current_user_can('manage_options');
        },
    ));


    register_rest_route('woo-checkout-builder/v1', '/activate-layout/', array(
        'methods' => 'POST',
        'callback' => 'trusty_woo_activate_layout',
        'permission_callback' => function () {
            return current_user_can('manage_options');
        },
    ));
}

function  trusty_woo_get_layouts_list($data)
{
    $args = array(
        'post_type' => 'trusty_check_builder',
        'posts_per_page' => -1,
        'post_status' => array('publish', 'draft'),
    );
    $posts = get_posts($args);
    $results = [];
    if (!empty($posts)) {
        foreach ($posts as $post) {
            $active_layout_id = get_option('trusty_active_template');

            if ($post->ID === intval($active_layout_id)) {
                $post->active_layout_id = $active_layout_id;
            }

            $results[] = $post;
        }
    }
    
    if (count($results) > 0) {
        $perPage = isset($data['perPage']) ? (int)$data['perPage'] : 10;
        $currentPage = isset($data['page']) ? (int)$data['page'] : 1;
        $startIndex = ($currentPage - 1) * $perPage;
        $paginatedResults = array_slice($results, $startIndex, $perPage);
        $totalItems = count($results);
        $totalPages = ceil($totalItems / $perPage);
        echo wp_json_encode(array("status" => "success", "layouts_list" => $paginatedResults, "current_page" => $currentPage, "total_page" => $totalPages, "total_filters" => $totalItems));
    } else {
        echo wp_json_encode(array("status" => "success", "layouts_list" => $results));
    }
}

function  trusty_woo_get_trash_layouts_list($data)
{
    $args = array(
        'post_type' => 'trusty_check_builder',
        'posts_per_page' => -1,
        'post_status' => array('trash'),
    );
    $posts = get_posts($args);
    $results = [];
    if (!empty($posts)) {
        foreach ($posts as $post) {
            $post->shortcode = "[trusty_woo_filter id='" . $post->ID . "']";
            $post->layout_source = "Old Panel";
            $post->list_index = "";
            $results[] = $post;
        }
    }
    if (count($results) > 0) {
        $perPage = isset($data['perPage']) ? (int)$data['perPage'] : 10;
        $currentPage = isset($data['page']) ? (int)$data['page'] : 1;
        $startIndex = ($currentPage - 1) * $perPage;
        $paginatedResults = array_slice($results, $startIndex, $perPage);
        $totalItems = count($results);
        $totalPages = ceil($totalItems / $perPage);
        echo wp_json_encode(array("status" => "success", "layouts_list" => $paginatedResults, "current_page" => $currentPage, "total_page" => $totalPages, "total_trash_filters" => $totalItems));
    } else {
        echo wp_json_encode(array("status" => "success", "layouts_list" => $results));
    }
}

function trusty_woo_save_builder_layout($data)
{
    ob_start();
    $layout_data = json_decode($data['layout_data']);
    $layout_name = $layout_data->common_data->layout_name;
    //$layout_name = json_decode($data['layout_data']);

    $post_id = wp_insert_post([
        'post_title'  => $layout_name,
        'post_type'   => 'trusty_check_builder',
        'post_status' => 'publish',
    ]);
    if (!is_wp_error($post_id)) {
        $layout_data->common_data->layout_key = $post_id;
        update_post_meta($post_id, 'trusty_checkout_data', wp_json_encode($layout_data));
    }

    echo wp_json_encode(array("status" => "success", "post_id" => $post_id));
}

function trusty_woo_delete_builder_layout($request)
{
    $post_id = intval($request['post_id']);
    if (get_post_status($post_id)) {
        wp_trash_post($post_id);
        echo wp_json_encode(array("status" => "success", 'message' => 'Post deleted successfully.'));
    } else {
        echo wp_json_encode(array("status" => "error", 'message' => 'Failed to delete post.'));
    }
}
function trusty_woo_restore_builder_layout($request)
{
    $post_id = intval($request['post_id']);
    if (get_post_status($post_id)) {
        wp_untrash_post($post_id);
        echo wp_json_encode(array("status" => "success", 'message' => 'Post Restore successfully.'));
    } else {
        echo wp_json_encode(array("status" => "error", 'message' => 'Failed to Restore Post.'));
    }
}
function trusty_woo_delete_builder_layout_permanent($request)
{
    $post_id = intval($request['post_id']);
    if (wp_delete_post($post_id, true)) {
        echo wp_json_encode(array("status" => "success", 'message' => 'Post deleted successfully.'));
    } else {
        echo wp_json_encode(array("status" => "error", 'message' => 'Failed to delete post.'));
    }
}
function trusty_woo_move_to_trash($data)
{
    $postIds = json_decode($data['post_ids']);
    if (!empty($postIds)) {
        foreach ($postIds as $pid) {
            if (get_post_status($pid)) {
                wp_trash_post($pid);
            }
        }

        echo wp_json_encode(array("status" => "success", "message" => "Filters Trash Successfully"));
    } else {
        echo wp_json_encode(array("status" => "error", "message" => "Something went's Wrong"));
    }
}

function trusty_woo_bulk_layouts_restore($data)
{
    $postIds = json_decode($data['post_ids']);
    if (!empty($postIds)) {
        foreach ($postIds as $pid) {
            if (get_post_status($pid)) {
                wp_untrash_post($pid);
            }
        }
        echo wp_json_encode(array("status" => "success", "message" => "Filters Restored Successfully"));
    } else {
        echo wp_json_encode(array("status" => "error", "message" => "Something went's Wrong"));
    }
}
function trusty_woo_bulk_layouts_delete_permanent($data)
{
    $postIds = json_decode($data['post_ids']);

    if (!empty($postIds)) {
        foreach ($postIds as $pid) {
            if (get_post_status($pid)) {
                wp_delete_post($pid, true);
            }
        }
        echo wp_json_encode(array("status" => "success", "message" => "Filters Deleted Successfully"));
    } else {
        echo wp_json_encode(array("status" => "error", "message" => "Something went's Wrong"));
    }
}
function trusty_woo_get_layout_data($data)
{
    ob_start();
    $layout_key = $data['layout_key'];
    if (get_post_meta($layout_key, 'trusty_checkout_data', true)) {
        echo wp_json_encode(array("status" => "success", "layout_data" => json_decode(get_post_meta($layout_key, 'trusty_checkout_data', true))));
    } else {
        echo wp_json_encode(array("status" => "success", "layout_data" => [], "message" => "No Result Found"));
    }
}

function trusty_woo_activate_layout($data)
{
    ob_start();
    $post_id = isset($data['post_id']) ? intval($data['post_id']) : 0;
    $deactivate = isset($data['deactivate']) ? filter_var($data['deactivate'], FILTER_VALIDATE_BOOLEAN) : false;
    if ($deactivate) {
        delete_option('trusty_active_template');
        echo wp_json_encode(array("status" => "success", "message" => "Successfully deactivated."));
    } else {
        update_option('trusty_active_template', $post_id);
        echo wp_json_encode(array("status" => "success", "message" => "Successfully activated."));
    }
}



function trusty_woo_rename_builder_layout_label($data)
{
    ob_start();
    $index = $data['index'];
    $new_label = $data['label'];
    $result = wp_update_post([
        'ID'         => $index,
        'post_title' => $new_label,
    ], true); // `true` returns WP_Error on failure

    if (is_wp_error($result)) {
        echo wp_json_encode(array("status" => "error", "msg" => "Data Not Updated"));
    } else {
        $layout_data = json_decode(get_post_meta($index, 'trusty_checkout_data', true));
        $layout_data->common_data->layout_name = $new_label;
        update_post_meta($index, 'trusty_checkout_data', wp_json_encode($layout_data));
        echo wp_json_encode(array("status" => "success", "label" => $new_label));
    }
}
function trusty_woo_update_builder_layout($data)
{
    ob_start();
    $layout_data = json_decode($data['layout_data']);
    $key = $data['layout_key'];
    $opt = 'trusty_woo_builder_layouts_list';
    update_post_meta($key, 'trusty_checkout_data', wp_json_encode($layout_data));
    $layout_data = json_decode(get_post_meta($key, 'trusty_checkout_data', true));
    echo wp_json_encode(array("status" => "success", "layout_data" => json_decode(get_post_meta($key, 'trusty_checkout_data', true))));
}

function trusty_woo_get_shipping_status($data)
{
    if (function_exists('WC') && class_exists('WC_Cart')) {

        if (null === WC()->session) {
            WC()->session = new WC_Session_Handler();
            WC()->session->init(); // Always call init after setting session
        }
        if (!WC()->session->has_session()) {
            WC()->session->init(); // Ensure session is active
        }
        if (null === WC()->customer) {
            WC()->customer = new WC_Customer(get_current_user_id(), true);
        }
        if (null === WC()->cart) {
            WC()->cart = new WC_Cart();
        }
        // Make sure the cart is loaded (esp. for guest users)
        WC()->cart->calculate_totals();
        $status = WC()->cart->needs_shipping();
        return new WP_REST_Response([
            'status' => 'success',
            'needs_shipping' => $status,
            'ship_to_different' => get_option('woocommerce_ship_to_destination') ? 1 : 0,
        ], 200);
    }

    return new WP_REST_Response([
        'status' => 'error',
        'message' => 'WooCommerce not initialized properly.'
    ], 500);
}

function trusty_woo_get_order_review_section($request)
{
    if (!function_exists('WC')) {
        return new WP_REST_Response([
            'status' => 'error',
            'message' => 'WooCommerce is not active.'
        ], 500);
    }
    // Ensure WC session/cart is initialized
    if (null === WC()->session) WC()->session = new WC_Session_Handler();
    if (!WC()->session->has_session()) WC()->session->init();
    if (null === WC()->customer) WC()->customer = new WC_Customer(get_current_user_id(), true);
    if (null === WC()->cart) WC()->cart = new WC_Cart();
    ob_start();
    if (WC()->cart->get_cart_contents_count() < 1) {
        echo '<p style="color:red;">Preview requires at least 1 product in cart.</p>';
    } else {
        wc_get_template('checkout/review-order.php');
    }

    $html = ob_get_clean();

    return new WP_REST_Response([
        'status' => 'success',
        'data'   => $html,
    ]);
}

function trusty_woo_get_payment_methods_section($request)
{
    if (!function_exists('WC')) {
        return new WP_REST_Response([
            'status' => 'error',
            'message' => 'WooCommerce is not active.'
        ], 500);
    }

    // Init session & cart if needed
    if (null === WC()->session) WC()->session = new WC_Session_Handler();
    if (!WC()->session->has_session()) WC()->session->init();
    if (null === WC()->customer) WC()->customer = new WC_Customer(get_current_user_id(), true);
    if (null === WC()->cart) WC()->cart = new WC_Cart();
    $available_gateways = WC()->payment_gateways()->get_available_payment_gateways();

    if (empty($available_gateways)) {
        return new WP_REST_Response([
            'status' => 'error',
            'message' => 'No payment gateways available.',
        ], 200);
    }

    ob_start();
    echo '<div id="payment" class="woocommerce-checkout-payment">';
    echo '<ul class="wc_payment_methods payment_methods methods">';
    foreach ($available_gateways as $gateway) {
        wc_get_template('checkout/payment-method.php', array('gateway' => $gateway));
    }
    echo '</ul>';
    echo '<div class="form-row place-order">';
    wc_get_template('checkout/terms.php');
    do_action('woocommerce_review_order_before_submit');
    echo '<button type="submit" class="button alt" name="woocommerce_checkout_place_order" id="place_order" value="Place Order" data-value="Place Order">Place Order</button>';
    do_action('woocommerce_review_order_after_submit');
    wp_nonce_field('woocommerce-process_checkout', 'woocommerce-process-checkout-nonce');

    echo '</div>';
    echo '</div>';

    $html = ob_get_clean();

    return new WP_REST_Response([
        'status' => 'success',
        'data'   => $html,
    ]);
}

function trusty_woo_get_coupon_section($request)
{
    if (! function_exists('WC')) {
        return new WP_REST_Response([
            'status' => 'error',
            'message' => 'WooCommerce is not active.',
        ], 500);
    }

    ob_start();
?>


    <div class="checkout_coupon woocommerce-form-coupon" method="post">
        <p><?php esc_html_e('If you have a coupon code, please apply it below.', 'all-in-one-checkout-page-builder-for-woocommerce'); ?></p>
        <p class="form-row form-row-first">
            <input type="text" name="coupon_code" class="input-text" placeholder="<?php esc_attr_e('Coupon code', 'all-in-one-checkout-page-builder-for-woocommerce'); ?>" id="coupon_code" value="" />
        </p>

        <p class="form-row form-row-last">
            <button type="button" class="button" name="apply_coupon" value="<?php esc_attr_e('Apply coupon', 'all-in-one-checkout-page-builder-for-woocommerce'); ?>"><?php esc_html_e('Apply coupon', 'all-in-one-checkout-page-builder-for-woocommerce'); ?></button>
        </p>

        <div class="clear"></div>
    </div>
<?php
    $html = ob_get_clean();

    return new WP_REST_Response([
        'status' => 'success',
        'data'   => $html,
    ]);
}





add_filter('woocommerce_checkout_fields', 'trusty_custom_checkout_fields_from_layout');
function trusty_custom_checkout_fields_from_layout($fields)
{
    if (get_option('trusty_active_template')) {
        $active_layout = get_option('trusty_active_template');
        $layout_data = json_decode(get_post_meta($active_layout, 'trusty_checkout_data', true));
        if (!$layout_data || !isset($layout_data->post_layout_data->initial_data)) return $fields;

        $layout = $layout_data->post_layout_data->initial_data;

        foreach ($layout as $row) {
            foreach ($row->data as $column) {
                foreach ($column->data as $module) {
                    if ($module->key === 'billing_fields') {
                        unset($fields['billing']); // remove all default billing fields
                        $custom_fields = $module->settings->fields;
                        foreach ($custom_fields as $key => $settings) {
                            if (!empty($settings->disable)) continue;
                            $field = [];
                            $field['label'] = $settings->label ?? '';
                            $field['type'] = $settings->type ?? 'text';
                            $field['required'] = !empty($settings->required);
                            $field['priority'] = $settings->priority ?? 100;
                            $field['placeholder'] = $settings->placeholder ?? '';
                            $field['autocomplete'] = $settings->autocomplete ?? '';
                            $field['width'] = $settings->width ?? 'full';
                            $field['key'] = $settings->key;
                            // Optional CSS class for frontend styling
                            $field['class'] = ['trusty-checkout-field', "trusty-field-type-{$field['type']}", "trusty-field-width-{$field['width']}"];
                            // Display custom validation message (if needed in JS validation later)
                            if (!empty($settings->validation_message)) {
                                $field['custom_attributes']['data-validation-message'] = esc_attr($settings->validation_message);
                                $field['custom_attributes']['data-validation-position'] = esc_attr($settings->validation_position ?? 'bottom');
                            }
                            // Options parsing (select, checkbox, radio)
                            if (in_array($field['type'], ['select', 'radio', 'checkbox']) && !empty($settings->options)) {
                                $options = [];
                                foreach (explode(',', $settings->options) as $opt) {
                                    [$val, $label] = array_map('trim', explode(':', $opt));
                                    if ($val && $label) {
                                        $options[$val] = $label;
                                    }
                                }
                                // ✅ Fix for checkbox group (WooCommerce doesn't support it out of the box)
                                if ($field['type'] === 'checkbox' && count($options) > 1) {
                                    $field['type'] = 'checkbox_group';
                                    $field['options'] = $options;
                                } else if ($field['type'] === 'radio' && count($options) > 1) {
                                    $field['type'] = 'radio_group';
                                    $field['options'] = $options;
                                } else {
                                    $field['options'] = $options;
                                }
                            }
                            if ($field['type'] === 'heading') {
                                $field['style'] = $settings->style;
                            }
                            // Save the field
                            //$field_key = 'billing_' . preg_replace('/[^a-z0-9_]/', '', strtolower(str_replace(' ', '_', $field['label'])));

                            $fields['billing'][$field['key']] = $field;
                        }
                    }

                    if ($module->key === 'shipping_fields') {
                        unset($fields['shipping']); // remove all default billing fields
                        $custom_fields = $module->settings->fields;
                        foreach ($custom_fields as $key => $settings) {
                            if (!empty($settings->disable)) continue;
                            $field = [];
                            $field['label'] = $settings->label ?? '';
                            $field['type'] = $settings->type ?? 'text';
                            $field['required'] = !empty($settings->required);
                            $field['priority'] = $settings->priority ?? 100;
                            $field['placeholder'] = $settings->placeholder ?? '';
                            $field['autocomplete'] = $settings->autocomplete ?? '';
                            $field['width'] = $settings->width ?? 'full';
                            $field['key'] = $settings->key;
                            // Optional CSS class for frontend styling
                            $field['class'] = ['trusty-checkout-field', "trusty-field-type-{$field['type']}", "trusty-field-width-{$field['width']}"];
                            // Display custom validation message (if needed in JS validation later)
                            if (!empty($settings->validation_message)) {
                                $field['custom_attributes']['data-validation-message'] = esc_attr($settings->validation_message);
                                $field['custom_attributes']['data-validation-position'] = esc_attr($settings->validation_position ?? 'bottom');
                            }
                            // Options parsing (select, checkbox, radio)
                            if (in_array($field['type'], ['select', 'radio', 'checkbox']) && !empty($settings->options)) {
                                $options = [];
                                foreach (explode(',', $settings->options) as $opt) {
                                    [$val, $label] = array_map('trim', explode(':', $opt));
                                    if ($val && $label) {
                                        $options[$val] = $label;
                                    }
                                }
                                // ✅ Fix for checkbox group (WooCommerce doesn't support it out of the box)
                                if ($field['type'] === 'checkbox' && count($options) > 1) {
                                    $field['type'] = 'checkbox_group';
                                    $field['options'] = $options;
                                } else if ($field['type'] === 'radio' && count($options) > 1) {
                                    $field['type'] = 'radio_group';
                                    $field['options'] = $options;
                                } else {
                                    $field['options'] = $options;
                                }
                            }
                            if ($field['type'] === 'heading') {
                                $field['style'] = $settings->style;
                            }
                            // Save the field
                            $field_key = 'shipping_' . preg_replace('/[^a-z0-9_]/', '', strtolower(str_replace(' ', '_', $field['label'])));
                            $fields['shipping'][$field['key']] = $field;
                        }
                    }
                }
            }
        }

        // echo "<pre>";
        // print_r($fields['billing']);
        // echo "</pre>";
        return $fields;
    } else {
        return $fields;
    }
}






// 1. REMOVE WooCommerce's default billing fields output
//remove_action('woocommerce_checkout_billing', 'woocommerce_checkout_billing', 10);
add_filter('woocommerce_form_field', 'trusty_override_field_renderer', 10, 4);


function trusty_override_field_renderer($field_html, $key, $args, $value)
{

    // var_dump($field_html);
    $vl = '';
    if ($args['required'] == '1') {
        $vl = 'validate-required';
    }
    if (!empty($args['type']) && $args['type'] === 'checkbox_group' && !empty($args['options'])) {
        ob_start();
        // var_dump($field_html);
        echo '<p class="form-row form-row-wide trusty-checkout-field trusty-checkout-field-custom trusty-field-type-' . esc_attr($args['type']) . ' trusty-field-width-' . esc_attr($args['width']) . ' ' . esc_attr($vl) . '" data-priority="' . esc_attr($args['priority']) . '" id="' . esc_attr($args['id']) . '_field">';
        $custom_attrs = '';
        if (!empty($args['custom_attributes']) && is_array($args['custom_attributes'])) {
            foreach ($args['custom_attributes'] as $attr => $val) {
                $custom_attrs .= esc_attr($attr) . '="' . esc_attr($val) . '" ';
            }
        }

        echo '<label class="trusty-validate-attr" ' . wp_kses($custom_attrs, ['data-*' => true]) . '>' . esc_html($args['label']);
        if ($args['required'] == '1') {
            echo "&nbsp;<span class='required' aria-hidden='true'>*</span>";
        }
        echo '</label>';

        foreach ($args['options'] as $val => $label) {
            echo '<label style="margin-right:10px">';
            echo '<input type="checkbox" name="' . esc_attr($key) . '[]" value="' . esc_attr($val) . '" ' .
                (is_array($value) && in_array($val, $value) ? 'checked' : '') . '> ' .
                esc_html($label) . '</label>';
        }
        echo '</p>';
        return ob_get_clean();
    }

    if (!empty($args['type']) && $args['type'] === 'radio_group' && !empty($args['options'])) {
        ob_start();
        echo '<p class="form-row form-row-wide trusty-checkout-field trusty-checkout-field-custom trusty-field-type-' . esc_attr($args['type']) . ' trusty-field-width-' . esc_attr($args['width']) . ' ' . esc_attr($vl) . '" data-priority="' . esc_attr($args['priority']) . '" id="' . esc_attr($args['id']) . '_field">';
        $custom_attrs = '';
        if (!empty($args['custom_attributes']) && is_array($args['custom_attributes'])) {
            foreach ($args['custom_attributes'] as $attr => $val) {
                $custom_attrs .= esc_attr($attr) . '="' . esc_attr($val) . '" ';
            }
        }

        echo '<label class="trusty-validate-attr" ' . wp_kses($custom_attrs, ['data-*' => true]) . '>' . esc_html($args['label']);
        if ($args['required'] == '1') {
            echo "&nbsp;<span class='required' aria-hidden='true'>*</span>";
        }
        echo '</label>';
        foreach ($args['options'] as $val => $label) {
            echo '<label style="margin-right:10px">';
            echo '<input type="radio" name="' . esc_attr($key) . '" value="' . esc_attr($val) . '" ' .
                (is_array($value) && in_array($val, $value) ? 'checked' : '') . '> ' .
                esc_html($label) . '</label>';
        }
        echo '</p>';
        return ob_get_clean();
    }

    if ($args['type'] === 'heading') {

        $allowed_tags = ['h1', 'h2', 'h3', 'h4', 'h5', 'h6'];
        $tag = in_array($args['heading_type'] ?? '', $allowed_tags, true) ? $args['heading_type'] : 'h2';
    
        $px_props = [
            'fontSize', 'lineHeight',
            'paddingTop', 'paddingRight', 'paddingBottom', 'paddingLeft',
            'marginTop', 'marginRight', 'marginBottom', 'marginLeft'
        ];
    
        $style_attr = ''; // ✅ define early to avoid undefined var
        if (!empty($args['style']) && is_object($args['style'])) {
            $styles = [];
    
            foreach ((array) $args['style'] as $prop => $value) {
                if ($value === '') continue;
    
                $cssProp = strtolower(preg_replace('/([a-z])([A-Z])/', '$1-$2', $prop));
    
                if (in_array($prop, $px_props, true) && is_numeric($value)) {
                    $value .= 'px';
                }
    
                $styles[] = $cssProp . ': ' . esc_attr($value);
            }
    
            if (!empty($styles)) {
                $style_attr = sprintf(' style="%s"', esc_attr(implode('; ', $styles)));
            }
        }
    
        // Final safe output
        printf(
            '<%1$s%2$s>%3$s</%1$s>',
            esc_html($tag),
            $style_attr,
            esc_html($args['label'])
        );
    }
    



    return $field_html; // fallback to default renderer
}




add_action('wp_enqueue_scripts', 'trusty_woo_enqueue_custom_google_fonts');

function trusty_woo_enqueue_custom_google_fonts()
{
    if (get_option('trusty_active_template')) {
        $active_layout = get_option('trusty_active_template');
        $layout = json_decode(get_post_meta($active_layout, 'trusty_checkout_data', true));
        $used_fonts = [];

        foreach ($layout->post_layout_data->initial_data ?? [] as $row) {

            foreach ($row->data ?? [] as $column) {
                foreach ($column->data ?? [] as $module) {

                    if (!empty($module->settings->fields)) {
                        foreach ($module->settings->fields ?? [] as $field) {
                            if (!empty($field->style->fontFamily)) {
                                $used_fonts[] = $field->style->fontFamily;
                            }
                        }
                    }
                    if (isset($module->style->desktop->default->fontFamily)) {
                        $used_fonts[] = $module->style->desktop->default->fontFamily;
                    }
                    if (isset($module->style->label->desktop->default->fontFamily)) {
                        $used_fonts[] = $module->style->label->desktop->default->fontFamily;
                    }
                    if (isset($module->style->meta->desktop->default->fontFamily)) {
                        $used_fonts[] = $module->style->meta->desktop->default->fontFamily;
                    }
                }
            }
        }
        $families = array_unique(array_map(function ($font) {
            return str_replace(' ', '+', trim($font));
        }, $used_fonts));
        if (!empty($families)) {
            $query = implode('|', $families);
            $href = 'https://fonts.googleapis.com/css?family=' . $query . '&display=swap';

            wp_enqueue_style('trusty-google-fonts', $href, [], TRUSTY_WOO_CHECKOUT_VERSION);
        }

        if (is_checkout()) {
            wp_enqueue_script('trusty-woo-checkout-validation', plugin_dir_url(__FILE__) . '../assets/js/builder.js', ['jquery'], TRUSTY_WOO_CHECKOUT_VERSION, true);
            wp_localize_script('trusty-woo-checkout-validation', 'trusty_woo_ajax', [
                'ajax_url' => admin_url('admin-ajax.php'),
                'site_base_url' => site_url(),
                'nonce'    => wp_create_nonce('front_nonce'),
                'plugin_path' => TRUSTY_WOO_CHECKOUT_URL
            ]);
        }
    }
}

function trusty_woo_checkout_camelCasetoCssString($key)
{
    $key = preg_replace('/([a-z])([A-Z])/', '$1-$2', $key);
    $key = strtolower($key);
    return $key;
}
function trusty_woo_checkout_removeDuplicateProperty($arr, $item)
{
    // If the array is empty, return it as is
    if (empty($arr)) {
        return $arr;
    }

    $deletedVal = "";

    // Iterate over the array to find the property to remove
    foreach ($arr as $property) {
        $propVal = explode(":", $property); // Split the string by ":"
        if ($item == $propVal[0]) { // Check if the item matches the property name
            $deletedVal = $property; // Save the property to be deleted
            break; // Exit the loop as we found the duplicate
        }
    }

    // If a property to delete was found, filter it out
    if ($deletedVal !== "") {
        return array_filter($arr, function ($e) use ($deletedVal) {
            return $e !== $deletedVal;
        });
    }

    // Return the array as is if no duplicates are found
    return $arr;
}

function trusty_woo_checkout_generateCss($style, $device, $state, $div)
{
    $styleArr = [];

    if ($device == "desktop") {
        if ($state == "default") {
            foreach ($style->$device->$state as $key => $value) {
                $property = trusty_woo_checkout_camelCasetoCssString($key);
                $styleArr = trusty_woo_checkout_removeDuplicateProperty($styleArr, $property);
                $cssString = $property . ":" . $value . ";";
                array_push($styleArr, $cssString);

                // if ($property == "font-family") {
                //     $this->enqueue_font_family_from_object($value);
                // }
            }
        }
    }

    $implode = implode(" ", $styleArr);
    $res = $div . " { " . $implode . " }";
    return $res;
}


add_action('wp_enqueue_scripts', function () {
    if (!is_checkout()) return;

    $dynamic_css = '';

    // Fetch layout from active template
    $active_layout = get_option('trusty_active_template');
    if ($active_layout) {
        $layout_data = json_decode(get_post_meta($active_layout, 'trusty_checkout_data', true));
        if (!empty($layout_data) && isset($layout_data->post_layout_data->initial_data)) {
            $layout = $layout_data->post_layout_data->initial_data;

            foreach ($layout as $rowkey => $row) {
                if (!empty($row->style)) {
                    $dynamic_css .= trusty_woo_checkout_generateCss($row->style, 'desktop', 'default', '.trusty-woo-checkout-row-' . $rowkey);
                    foreach ($row->data as $columnkey => $column) {
                        $dynamic_css .= trusty_woo_checkout_generateCss($column->style, 'desktop', 'default', '.trusty-woo-checkout-row-' . $rowkey . '-column-' . $columnkey);
                        foreach ($column->data as $modulekey => $module) {
                            if ($module->key == 'billing_fields' || $module->key == 'shipping_fields') {
                                //echo "<pre>"; var_dump($module); echo "</pre>";
                                $dynamic_css .= trusty_woo_checkout_generateCss($module->style, 'desktop', 'default', '.woocommerce form .trusty-woo-checkout-row-' . $rowkey . '-column-' . $columnkey . '-module-' . $modulekey . ' .form-row.trusty-checkout-field');
                                $dynamic_css .= trusty_woo_checkout_generateCss($module->style->label, 'desktop', 'default', '.woocommerce form .trusty-woo-checkout-row-' . $rowkey . '-column-' . $columnkey . '-module-' . $modulekey . ' .form-row.trusty-checkout-field label');
                                $dynamic_css .= trusty_woo_checkout_generateCss($module->style->meta, 'desktop', 'default', '.woocommerce form .trusty-woo-checkout-row-' . $rowkey . '-column-' . $columnkey . '-module-' . $modulekey . ' .form-row.trusty-checkout-field input,
                                .woocommerce form .trusty-woo-checkout-row-' . $rowkey . '-column-' . $columnkey . '-module-' . $modulekey . ' .form-row.trusty-checkout-field select,.woocommerce form .trusty-woo-checkout-row-' . $rowkey . '-column-' . $columnkey . '-module-' . $modulekey . ' .form-row.trusty-checkout-field .select2-container .select2-dropdown, .woocommerce form .trusty-woo-checkout-row-' . $rowkey . '-column-' . $columnkey . '-module-' . $modulekey . ' .form-row.trusty-checkout-field .select2-container .select2-selection');
                            }
                            if ($module->key == 'order_review') {
                                //echo "<pre>"; var_dump($module); echo "</pre>";
                                $dynamic_css .= trusty_woo_checkout_generateCss($module->style, 'desktop', 'default', '.woocommerce form .trusty-woo-checkout-row-' . $rowkey . '-column-' . $columnkey . '-module-' . $modulekey . ' table.shop_table thead th');
                                $dynamic_css .= trusty_woo_checkout_generateCss($module->style->label, 'desktop', 'default', '.woocommerce form .trusty-woo-checkout-row-' . $rowkey . '-column-' . $columnkey . '-module-' . $modulekey . ' table.shop_table tbody td');
                                $dynamic_css .= trusty_woo_checkout_generateCss($module->style->meta, 'desktop', 'default', '.woocommerce form .trusty-woo-checkout-row-' . $rowkey . '-column-' . $columnkey . '-module-' . $modulekey . ' table.shop_table tfoot td');
                            }
                            if ($module->key == 'payment_method') {
                                //echo "<pre>"; var_dump($module); echo "</pre>";
                                $dynamic_css .= trusty_woo_checkout_generateCss($module->style, 'desktop', 'default', '.woocommerce form .trusty-woo-checkout-row-' . $rowkey . '-column-' . $columnkey . '-module-' . $modulekey . ' #payment');
                            }
                            if ($module->key == 'apply_coupon') {
                                //echo "<pre>"; var_dump($module); echo "</pre>";
                                $dynamic_css .= trusty_woo_checkout_generateCss($module->style, 'desktop', 'default', '.woocommerce form .trusty-woo-checkout-row-' . $rowkey . '-column-' . $columnkey . '-module-' . $modulekey . ' .checkout_coupon label');
                                $dynamic_css .= trusty_woo_checkout_generateCss($module->style->label, 'desktop', 'default', '.woocommerce form .trusty-woo-checkout-row-' . $rowkey . '-column-' . $columnkey . '-module-' . $modulekey . ' .checkout_coupon input');
                                $dynamic_css .= trusty_woo_checkout_generateCss($module->style->meta, 'desktop', 'default', '.woocommerce form .trusty-woo-checkout-row-' . $rowkey . '-column-' . $columnkey . '-module-' . $modulekey . ' .checkout_coupon button');
                            }
                            if ($module->key == 'customtext') {
                                $dynamic_css .= trusty_woo_checkout_generateCss($module->style, 'desktop', 'default', '.woocommerce form .trusty-woo-checkout-row-' . $rowkey . '-column-' . $columnkey . '-module-' . $modulekey . ' .woo-checkout-text-wrapper');
                            }
                        }
                    }
                }
            }
        }
    }

    wp_enqueue_style('trusty-woo-checkout-style', TRUSTY_WOO_CHECKOUT_URL . '/assets/css/css.css', [], TRUSTY_WOO_CHECKOUT_VERSION);
    if (!empty($dynamic_css)) {
        wp_add_inline_style('trusty-woo-checkout-style', esc_html($dynamic_css));
    }
});


function trusty_move_wc_payment_section()
{
    remove_action('woocommerce_checkout_order_review', 'woocommerce_checkout_payment', 20);
    add_action('woocommerce_checkout_after_order_review', 'woocommerce_checkout_payment');
}
add_action('wp_loaded', 'trusty_move_wc_payment_section');

add_action('woocommerce_order_details_after_order_table', 'trusty_woo_order_details_custom');
add_action('woocommerce_email_after_order_table', 'trusty_woo_order_details_custom');
function trusty_woo_order_details_custom($order)
{
    if (!get_option('trusty_active_template')) return;

    $active_layout = get_option('trusty_active_template');
    $layout_data = json_decode(get_post_meta($active_layout, 'trusty_checkout_data', true));

    if (empty($layout_data) || !isset($layout_data->post_layout_data->initial_data)) return;

    $layout = $layout_data->post_layout_data->initial_data;

    $rows = [];

    foreach ($layout as $row) {
        foreach ($row->data as $column) {
            foreach ($column->data as $module) {
                if (!in_array($module->key, ['billing_fields', 'shipping_fields'])) continue;

                $fields = $module->settings->fields ?? [];

                foreach ($fields as $field) {
                    // Only custom fields, not Woo default
                    if (!empty($field->woo_default)) continue;

                    // Only if display is enabled
                    if (empty($field->display_in_order)) continue;

                    $meta_key = '_' . $field->key;
                    $value = $order->get_meta($meta_key);

                    if (!empty($value)) {
                        // Format array values (e.g., checkbox group) into a comma-separated string
                        $formatted_value = is_array($value) ? implode(', ', array_map('esc_html', $value)) : esc_html($value);

                        $rows[] = [
                            'label' => $field->label ?? ucfirst($field->key),
                            'value' => $formatted_value
                        ];
                    }
                }
            }
        }
    }

    // Render if we have at least 1 row
    if (!empty($rows)) {
        echo '<section class="woocommerce-order-custom-fields">';
        echo '<h2>' . esc_html__('Additional Information', 'all-in-one-checkout-page-builder-for-woocommerce') . '</h2>';
        echo '<table class="woocommerce-table woocommerce-table--order-details shop_table order_details"><tbody>';

        foreach ($rows as $row) {
            echo '<tr>';
            echo '<th>' . esc_html($row['label']) . ':</th>';
            echo '<td>' . esc_html($row['value']) . '</td>';
            echo '</tr>';
        }

        echo '</tbody></table>';
        echo '</section>';
    }
}


add_action('woocommerce_admin_order_data_after_billing_address', 'trusty_woo_display_custom_fields_in_billing_admin', 10, 1);

function trusty_woo_display_custom_fields_in_billing_admin($order)
{
    if (!get_option('trusty_active_template')) return;

    $active_layout = get_option('trusty_active_template');
    $layout_data = json_decode(get_post_meta($active_layout, 'trusty_checkout_data', true));
    if (empty($layout_data) || !isset($layout_data->post_layout_data->initial_data)) return;

    $layout = $layout_data->post_layout_data->initial_data;

    $output = ''; // collect output to check later

    foreach ($layout as $row) {
        foreach ($row->data as $column) {
            foreach ($column->data as $module) {
                if ($module->key !== 'billing_fields') continue;

                $fields = $module->settings->fields ?? [];

                foreach ($fields as $field) {
                    if (!empty($field->woo_default)) continue;
                    if (empty($field->display_in_order)) continue;

                    $meta_key = '_' . $field->key;
                    $value = $order->get_meta($meta_key);

                    if (!empty($value)) {
                        $formatted_value = is_array($value)
                            ? implode(', ', array_map('esc_html', $value))
                            : esc_html($value);

                        $output .= '<p><strong>' . esc_html($field->label ?? ucfirst($field->key)) . ':</strong> ' . $formatted_value . '</p>';
                    }
                }
            }
        }
    }

    // Only display the heading and wrapper if we have fields to show
    if (!empty($output)) {
        echo '<div class="trusty-custom-admin-fields">';
        echo '<h4>' . esc_html__('Custom Billing Fields', 'all-in-one-checkout-page-builder-for-woocommerce') . '</h4>';
        echo wp_kses_post($output);
        echo '</div>';
    }
}


add_action('woocommerce_admin_order_data_after_shipping_address', 'trusty_woo_display_custom_fields_in_shipping_admin', 10, 1);

function trusty_woo_display_custom_fields_in_shipping_admin($order)
{
    if (!get_option('trusty_active_template')) return;

    $active_layout = get_option('trusty_active_template');
    $layout_data = json_decode(get_post_meta($active_layout, 'trusty_checkout_data', true));
    if (empty($layout_data) || !isset($layout_data->post_layout_data->initial_data)) return;

    $layout = $layout_data->post_layout_data->initial_data;

    $output = ''; // Collect displayable field output

    foreach ($layout as $row) {
        foreach ($row->data as $column) {
            foreach ($column->data as $module) {
                if ($module->key !== 'shipping_fields') continue;

                $fields = $module->settings->fields ?? [];

                foreach ($fields as $field) {
                    if (!empty($field->woo_default)) continue;
                    if (empty($field->display_in_order)) continue;

                    $meta_key = '_' . $field->key;
                    $value = $order->get_meta($meta_key);

                    if (!empty($value)) {
                        $formatted_value = is_array($value)
                            ? implode(', ', array_map('esc_html', $value))
                            : esc_html($value);

                        $output .= '<p><strong>' . esc_html($field->label ?? ucfirst($field->key)) . ':</strong> ' . $formatted_value . '</p>';
                    }
                }
            }
        }
    }

    if (!empty($output)) {
        echo '<div class="trusty-custom-admin-fields">';
        echo '<h4>' . esc_html__('Custom Shipping Fields', 'all-in-one-checkout-page-builder-for-woocommerce') . '</h4>';
        echo wp_kses_post($output);
        echo '</div>';
    }
}
