<?php
/**
 * Plugin Name: All in Box
 * Description: All in Box plugin, usable via block and shortcode
 * Version: 1.1.0
 * Requires at least: 5.0
 * Requires PHP: 7.0
 * Author: All in Box
 * Author URI: https://apps.allinbox.fr
 */

defined( 'ABSPATH' ) || exit;

function all_in_box_shortcode_init() {
	add_shortcode( 'allinbox', 'all_in_box_shortcode' );
}
add_action( 'init', 'all_in_box_shortcode_init' );

function all_in_box_shortcode( $atts = array(), $content = null, $tag = '' ) {
	$atts = array_change_key_case( (array) $atts, CASE_LOWER );

	$shortcode_atts = shortcode_atts(
        array(
            'code'   => null,
			'height' => 1000,
        ), $atts, $tag
    );

	if ( empty( $shortcode_atts['code'] ) || ! ctype_alnum( $shortcode_atts['code'] ) ) {
		return;
	}

	$height = (int) $shortcode_atts['height'] ?: 1000;

	return '<iframe src="https://allinbox.fr/landing/' . $shortcode_atts['code'] . '" width="100%" height="' . $height . '"></iframe>';
}

function all_in_box_script() {
	wp_register_script(
		'all-in-box-script',
		plugins_url( 'all-in-box.js', __FILE__ ),
		array( 'wp-blocks', 'wp-components', 'wp-element', 'wp-i18n', 'wp-editor' ),
		'1.1.0'
	);
}
add_action( 'init', 'all_in_box_script' );

function all_in_box_block() {
	register_block_type(
		'all-in-box/block',
		array(
			'editor_script'   => 'all-in-box-script',
			'render_callback' => 'all_in_box_iframe',
			'attributes'      => array(
				'code'   => array( 'type' => 'string' ),
				'height' => array( 'type' => 'string' ),
			),
		)
	);
}
add_action( 'init', 'all_in_box_block' );

function all_in_box_iframe( $attributes ) {
	$content = null;

	if ( empty( $attributes['code'] ) ) {
		$content = '<p>Use the Sidebar to add the code to embed All in Box.</p>';
	} elseif ( ! ctype_alnum( $attributes['code'] ) ) {
		$content = '<p>The code you entered to embed All in Box is invalid.</p>';
	} else {
		$height = 1500;
		if ( isset( $attributes['height'] ) && $attributes['height'] > 0 ) {
			$height = (int) $attributes['height'];
		}
		
		$content = '<iframe src="https://allinbox.fr/landing/' . $attributes['code'] . '" width="100%" height="' . $height . '"></iframe>';
	}

	return $content;
}
