( function ( blocks, editor, components, element ) {
	var e = wp.element.createElement
	var registerBlockType = wp.blocks.registerBlockType
	var InspectorControls = wp.blockEditor.InspectorControls
	var TextControl = components.TextControl
	var ServerSideRender = wp.serverSideRender

	var aib_icon = e( 'svg' , {
		'width': '20',
		'height': '20',
		'viewBox': '0 0 48 48',
		},
		e( 'g' , { 'transform': 'translate(149.98469,1.6038747)' },
			e( 'path', {
				'fill': '#00a4d7',
				'd': 'm -145.33071,7.4791129 a 2.4257536,2.4257536 0 0 0 -2.42565,2.42565 2.4257536,2.4257536 0 0 0 2.42565,2.4256501 2.4257536,2.4257536 0 0 0 1.16855,-0.300384 l 15.11429,8.725915 a 3.1314629,3.1314629 0 0 0 -0.0156,0.290837 3.1314629,3.1314629 0 0 0 1.96205,2.903573 v 17.403651 a 2.4257536,2.4257536 0 0 0 -1.21456,2.101826 2.4257536,2.4257536 0 0 0 2.42608,2.425652 2.4257536,2.4257536 0 0 0 2.42565,-2.425652 2.4257536,2.4257536 0 0 0 -1.18504,-2.084461 V 23.901304 a 3.1314629,3.1314629 0 0 0 1.84876,-2.854523 3.1314629,3.1314629 0 0 0 -0.0196,-0.349438 l 14.80306,-8.546206 a 2.4257536,2.4257536 0 0 0 0.91374,0.179276 2.4257536,2.4257536 0 0 0 2.42565,-2.4256501 2.4257536,2.4257536 0 0 0 -2.42565,-2.42565 2.4257536,2.4257536 0 0 0 -2.42608,2.42565 2.4257536,2.4257536 0 0 0 0.003,0.05903 l -14.63246,8.5014971 a 3.1314629,3.1314629 0 0 0 -1.77236,-0.549983 3.1314629,3.1314629 0 0 0 -1.8188,0.584275 l -15.16384,-8.8096941 a 2.4257536,2.4257536 0 0 0 -2.4161,-2.21078 z'
			}),
			e( 'path', {
				'fill': '#80ba42',
				'd': 'm -137.93526,3.1708487 a 2.4257536,2.4257536 0 0 0 -2.42565,2.4256502 2.4257536,2.4257536 0 0 0 2.42565,2.42565 2.4257536,2.4257536 0 0 0 1.16941,-0.301686 l 10.6845,6.2963591 0.0785,-1.112118 0.0785,1.112118 10.6845,-6.2963591 a 2.4257536,2.4257536 0 0 0 1.16941,0.301686 2.4257536,2.4257536 0 0 0 2.42565,-2.42565 2.4257536,2.4257536 0 0 0 -2.42565,-2.4256502 2.4257536,2.4257536 0 0 0 -2.42391,2.3327562 l -9.50857,5.4894021 -9.50857,-5.4894021 a 2.4257536,2.4257536 0 0 0 -2.42391,-2.3327562 z'
			}),
			e( 'path', {
				'fill': '#00a4d7',
				'd': 'm -130.45559,-1.0892324 a 2.4257536,2.4257536 0 0 0 -2.42565,2.4256503 2.4257536,2.4257536 0 0 0 2.42565,2.4256505 2.4257536,2.4257536 0 0 0 1.26795,-0.35942 l 3.20266,1.9116975 V 2.4993237 l -2.0454,-1.1807031 a 2.4257536,2.4257536 0 0 0 -2.42521,-2.407853 z m 4.47061,3.5885561 0.20575,2.8206652 2.9904,-1.8895593 a 2.4257536,2.4257536 0 0 0 1.22324,0.3316388 2.4257536,2.4257536 0 0 0 2.42565,-2.4256505 2.4257536,2.4257536 0 0 0 -2.42565,-2.4256503 2.4257536,2.4257536 0 0 0 -2.42565,2.4256503 2.4257536,2.4257536 0 0 0 4.4e-4,0.01172 z'
			}),
			e( 'path', {
				'fill': '#80ba42',
				'd': 'm -145.31595,16.034001 a 2.4257536,2.4257536 0 0 0 -2.42566,2.425651 2.4257536,2.4257536 0 0 0 2.42566,2.425651 2.4257536,2.4257536 0 0 0 1.26013,-0.352909 l 9.60494,5.545398 v 11.041744 a 2.4257536,2.4257536 0 0 0 -1.28358,2.137854 2.4257536,2.4257536 0 0 0 2.42564,2.42565 2.4257536,2.4257536 0 0 0 2.42565,-2.42565 2.4257536,2.4257536 0 0 0 -1.11689,-2.042355 V 24.627957 l -10.89328,-6.289414 a 2.4257536,2.4257536 0 0 0 -2.42261,-2.304542 z'
			}),
			e( 'path', {
				'fill': '#00a4d7',
				'd': 'm -145.30641,24.62926 a 2.4257536,2.4257536 0 0 0 -2.42608,2.42565 2.4257536,2.4257536 0 0 0 2.42608,2.426085 2.4257536,2.4257536 0 0 0 1.20328,-0.31992 l 2.02455,1.168984 v 2.673511 a 2.4257536,2.4257536 0 0 0 -1.05699,2.00242 2.4257536,2.4257536 0 0 0 2.42566,2.426085 2.4257536,2.4257536 0 0 0 2.42565,-2.426085 2.4257536,2.4257536 0 0 0 -1.11299,-2.039751 v -3.924101 l -3.48394,-2.011536 a 2.4257536,2.4257536 0 0 0 -2.42522,-2.401342 z'
			}),
			e( 'path', {
				'fill': '#80ba42',
				'd': 'm -106.63865,16.034001 a 2.4257536,2.4257536 0 0 1 2.42563,2.425651 2.4257536,2.4257536 0 0 1 -2.42563,2.425651 2.4257536,2.4257536 0 0 1 -1.26014,-0.352909 l -9.60492,5.545398 v 11.041745 a 2.4257536,2.4257536 0 0 1 1.28358,2.137853 2.4257536,2.4257536 0 0 1 -2.42566,2.42565 2.4257536,2.4257536 0 0 1 -2.42565,-2.42565 2.4257536,2.4257536 0 0 1 1.1169,-2.042355 V 24.627957 l 10.89329,-6.289414 a 2.4257536,2.4257536 0 0 1 2.4226,-2.304542 z'
			}),
			e( 'path', {
				'fill': '#00a4d7',
				'd': 'm -106.6482,24.62926 a 2.4257536,2.4257536 0 0 1 2.42607,2.42565 2.4257536,2.4257536 0 0 1 -2.42607,2.426085 2.4257536,2.4257536 0 0 1 -1.20327,-0.31992 l -2.02456,1.168984 v 2.673512 a 2.4257536,2.4257536 0 0 1 1.05699,2.002419 2.4257536,2.4257536 0 0 1 -2.42565,2.426085 2.4257536,2.4257536 0 0 1 -2.42564,-2.426085 2.4257536,2.4257536 0 0 1 1.11298,-2.03975 v -3.924102 l 3.48394,-2.011536 a 2.4257536,2.4257536 0 0 1 2.42521,-2.401342 z'
			}),
		)
	);

	registerBlockType( 'all-in-box/block', {
		title: 'All in Box',
		description: 'A block to embed All in Box.',
		icon: aib_icon,
		category: 'embed',
		attributes: {
			code: {
				type: 'string',
			},
			height: {
				type: 'string',
				default: '1500px',
			},
		},
		edit: function ( props ) {
			var code   = props.attributes.code
			var height = props.attributes.height

			return [
				e( 'div', { style: { pointerEvents: 'none' } },
					e( ServerSideRender, {
						block: 'all-in-box/block',
						attributes: props.attributes
					} )
				),
				e(
					InspectorControls,
					{ key: 'inspector' },
					e(
						components.PanelBody, {
							title: 'Settings',
							className: 'all-in-box-block-settings',
							initialOpen: true
						},
						e(
							TextControl, {
								type: 'text',
								label: 'Enter the code for iframe',
								value: code,
								onChange: function ( new_code ) {
									props.setAttributes( { code: new_code } )
								}
							}
						),
						e(
							TextControl, {
								type: 'text',
								label: 'Enter the height for iframe',
								value: height,
								onChange: function ( new_height ) {
									props.setAttributes( { height: new_height } )
								}
							}
						),
					)
				),
			]
		},
		save: () => {
			return null
		}
	});
})(
	window.wp.blocks,
	window.wp.editor,
	window.wp.components,
	window.wp.element
)