<?php
// includes/shortcodes.php

if ( ! defined( 'ABSPATH' ) ) exit;

// Render the Alba Board via shortcode [alba_board id="..."]
function alba_board_render_shortcode($atts) {
    $atts = shortcode_atts(['id' => 0], $atts);
    $board_id = intval($atts['id']);
    if (!$board_id) return '<p>' . esc_html__('Invalid board ID', 'alba-board') . '</p>';

    include_once(ABSPATH . 'wp-admin/includes/plugin.php');
    $addon_active = is_plugin_active('alba-board-frontend-interactions/alba-board-frontend-interactions.php');

    ob_start();

    $lists = get_posts([
        'post_type'   => 'alba_list',
        'numberposts' => -1,
        'orderby'     => 'menu_order',
        'order'       => 'ASC',
        'meta_key'    => 'alba_board_parent',
        'meta_value'  => $board_id
    ]);

    $options = get_option('alba_board_limits');
    $max_cards = isset($options['limit_cards']) ? intval($options['limit_cards']) : 0;

    $cards_by_list = [];
    if (!empty($lists)) {
        $list_ids = wp_list_pluck($lists, 'ID');
        
        foreach ($list_ids as $lid) {
            $cards_by_list[$lid] = [];
        }

        $all_cards = get_posts([
            'post_type'   => 'alba_card',
            'numberposts' => -1,
            'orderby'     => 'menu_order',
            'order'       => 'ASC',
            'meta_query'  => [
                [
                    'key'     => 'alba_list_parent',
                    'value'   => $list_ids,
                    'compare' => 'IN'
                ]
            ],
            'update_post_term_cache' => true 
        ]);

        foreach ($all_cards as $card) {
            $parent_id = get_post_meta($card->ID, 'alba_list_parent', true);
            if (isset($cards_by_list[$parent_id])) {
                $cards_by_list[$parent_id][] = $card;
            }
        }
    }

    echo '<div class="alba-board-outerwrap">';
    echo '<div class="alba-board-wrapper">';
    foreach ($lists as $list) {
        echo '<div class="alba-list-column">';
        echo '<h3>' . esc_html($list->post_title) . '</h3>';

        $cards = isset($cards_by_list[$list->ID]) ? $cards_by_list[$list->ID] : [];

        echo '<div class="alba-cards" data-list-id="' . esc_attr($list->ID) . '"'
            . ($max_cards > 0 ? ' data-max-cards="' . esc_attr($max_cards) . '"' : '')
            . '>';

        foreach ($cards as $card) {
            echo '<div class="alba-card" data-card-id="' . esc_attr($card->ID) . '">';
            
            // 👉 AQUÍ ESTÁ EL GANCHO MÁGICO PARA EL FRONT-END 👈
            do_action('alba_board_card_tags', $card->ID);

            echo '<span class="alba-card-title">' . esc_html($card->post_title) . '</span>';

            echo '<div class="alba-card-footer" style="display: flex; justify-content: flex-end; align-items: flex-end; margin-top: 8px;">';

            $author_id = $card->post_author;
            if ($author_id) {
                $author_name = get_the_author_meta('display_name', $author_id);
                /* translators: %s: User display name */
                echo '<div class="alba-card-avatar" title="' . esc_attr(sprintf(__('Assigned to: %s', 'alba-board'), $author_name)) . '" style="line-height: 0; flex-shrink: 0; margin-left: 8px;">';
                echo get_avatar($author_id, 28, '', $author_name, ['style' => 'border-radius: 50%; box-shadow: 2.2px 2.2px 7px #e3e7ef, -1.5px -1.5px 6px #fff; border: 2px solid #fff;']);
                echo '</div>';
            }

            echo '</div>'; 
            echo '</div>'; 
        }
        echo '</div>'; 
        echo '</div>'; 
    }
    echo '</div>'; 
    echo '</div>'; 

    ?>
    <div id="alba-card-modal" class="alba-card-modal">
        <div class="alba-modal-content">
            <button id="alba-modal-close" title="<?php esc_attr_e('Close', 'alba-board'); ?>" class="alba-modal-close-btn">&times;</button>
            <div id="alba-modal-body"><?php esc_html_e('Loading...', 'alba-board'); ?></div>
        </div>
    </div>
    <?php

    wp_enqueue_script(
        'alba-board-frontend',
        plugin_dir_url(__FILE__) . '../assets/js/alba-board-frontend.js',
        array('jquery'),
        '1.0.0',
        true
    );

    wp_localize_script(
        'alba-board-frontend',
        'AlbaBoardI18n',
        [
            'loading'        => esc_html__('Loading...', 'alba-board'),
            'confirm_delete' => esc_html__('Are you sure you want to delete this card?', 'alba-board'),
            'delete_error'   => esc_html__('Error deleting card', 'alba-board'),
        ]
    );    
    
    return ob_get_clean();
}
add_shortcode('alba_board', 'alba_board_render_shortcode');