<?php
// includes/settings.php
if ( ! defined( 'ABSPATH' ) ) exit; // Prevent direct access

// Register the settings page
function alba_board_register_settings_page() {
    add_submenu_page(
        'alba-board-visual', 
        esc_html__('Settings', 'alba-board'),
        esc_html__('Settings', 'alba-board'),
        'manage_options',
        'alba-board-settings',
        'alba_board_settings_page_callback'
    );
}
add_action('admin_menu', 'alba_board_register_settings_page');

function alba_board_register_settings() {
    register_setting('alba_board_settings_group', 'alba_board_limits', ['type' => 'array', 'sanitize_callback' => 'alba_board_sanitize_limits']);
    register_setting('alba_board_settings_group', 'alba_board_notifications', ['type' => 'array', 'sanitize_callback' => 'alba_board_sanitize_notifications']);
    register_setting('alba_board_settings_group', 'alba_delete_on_uninstall', ['type' => 'boolean', 'sanitize_callback' => 'absint', 'default' => 0]);
    register_setting('alba_board_settings_group', 'alba_board_uploads', ['type' => 'array', 'sanitize_callback' => 'alba_board_sanitize_uploads']);
    
    // 👉 NEW: Display Options Array 👈
    register_setting('alba_board_settings_group', 'alba_board_display', ['type' => 'array', 'sanitize_callback' => 'alba_board_sanitize_display']);

    // Display Options Section
    add_settings_section('alba_board_section_display', esc_html__('Display Options', 'alba-board'), null, 'alba-board-settings');
    add_settings_field('alba_board_show_avatars', esc_html__('User Avatars', 'alba-board'), 'alba_board_show_avatars_callback', 'alba-board-settings', 'alba_board_section_display');

    add_settings_section('alba_board_section_main', esc_html__('Limits & Parameters', 'alba-board'), null, 'alba-board-settings');
    add_settings_field('alba_board_limit_cards', esc_html__('Maximum cards per list', 'alba-board'), 'alba_board_limit_cards_callback', 'alba-board-settings', 'alba_board_section_main');

    add_settings_section('alba_board_section_uploads', esc_html__('File Uploads (Attachments)', 'alba-board'), null, 'alba-board-settings');
    add_settings_field('alba_board_max_files', esc_html__('Max files per card', 'alba-board'), 'alba_board_max_files_callback', 'alba-board-settings', 'alba_board_section_uploads');
    add_settings_field('alba_board_max_size', esc_html__('Max file size (MB)', 'alba-board'), 'alba_board_max_size_callback', 'alba-board-settings', 'alba_board_section_uploads');
    add_settings_field('alba_board_allowed_formats', esc_html__('Allowed formats', 'alba-board'), 'alba_board_allowed_formats_callback', 'alba-board-settings', 'alba_board_section_uploads');

    add_settings_section('alba_board_section_notifications', esc_html__('Notifications', 'alba-board'), null, 'alba-board-settings');
    add_settings_field('alba_board_notify', esc_html__('Notify when creating a new card', 'alba-board'), 'alba_board_notify_callback', 'alba-board-settings', 'alba_board_section_notifications');

    add_settings_section('alba_board_section_uninstall', esc_html__('Uninstall Options', 'alba-board'), null, 'alba-board-settings');
    add_settings_field('alba_delete_on_uninstall', esc_html__('Delete all Alba Board data on uninstall', 'alba-board'), 'alba_board_delete_on_uninstall_callback', 'alba-board-settings', 'alba_board_section_uninstall');
}
add_action('admin_init', 'alba_board_register_settings');

// Sanitization Callbacks
function alba_board_sanitize_limits($input) { $output = []; $output['limit_cards'] = isset($input['limit_cards']) ? intval($input['limit_cards']) : ''; return $output; }
function alba_board_sanitize_notifications($input) { $output = []; $output['notify_on_card'] = !empty($input['notify_on_card']) ? 1 : 0; return $output; }
function alba_board_sanitize_uploads($input) {
    $output = [];
    $output['max_files'] = isset($input['max_files']) ? absint($input['max_files']) : 3;
    $output['max_size'] = isset($input['max_size']) ? absint($input['max_size']) : 2;
    if (isset($input['allowed_formats'])) { $output['allowed_formats'] = preg_replace('/[^a-zA-Z0-9,]/', '', strtolower($input['allowed_formats'])); } else { $output['allowed_formats'] = 'jpg,png,pdf,docx'; }
    return $output;
}
function alba_board_sanitize_display($input) {
    $output = [];
    $output['show_avatars'] = isset($input['show_avatars']) ? 1 : 0;
    return $output;
}

// Field Callbacks
function alba_board_show_avatars_callback() { 
    $options = get_option('alba_board_display', ['show_avatars' => 1]); // default true
    $enabled = !empty($options['show_avatars']) ? 1 : 0; 
    echo '<input type="checkbox" name="alba_board_display[show_avatars]" value="1" ' . checked(1, $enabled, false) . '> <span>' . esc_html__('Show user profile images on board cards', 'alba-board') . '</span>'; 
}
function alba_board_limit_cards_callback() { $options = get_option('alba_board_limits'); $value = isset($options['limit_cards']) ? intval($options['limit_cards']) : ''; echo '<input type="number" name="alba_board_limits[limit_cards]" value="' . esc_attr($value) . '" min="1">'; }
function alba_board_max_files_callback() { $options = get_option('alba_board_uploads'); $value = isset($options['max_files']) ? intval($options['max_files']) : 3; echo '<input type="number" name="alba_board_uploads[max_files]" value="' . esc_attr($value) . '" min="0"> <p class="description">' . esc_html__('Set to 0 to disable uploads.', 'alba-board') . '</p>'; }
function alba_board_max_size_callback() { $options = get_option('alba_board_uploads'); $value = isset($options['max_size']) ? intval($options['max_size']) : 2; echo '<input type="number" name="alba_board_uploads[max_size]" value="' . esc_attr($value) . '" min="1"> <p class="description">' . esc_html__('Maximum file size in Megabytes (MB).', 'alba-board') . '</p>'; }
function alba_board_allowed_formats_callback() { $options = get_option('alba_board_uploads'); $value = isset($options['allowed_formats']) ? $options['allowed_formats'] : 'jpg,png,pdf,docx'; echo '<input type="text" name="alba_board_uploads[allowed_formats]" value="' . esc_attr($value) . '" class="regular-text"> <p class="description">' . esc_html__('Comma-separated extensions without dots (e.g. jpg,png,pdf,zip).', 'alba-board') . '</p>'; }
function alba_board_notify_callback() { $options = get_option('alba_board_notifications'); $enabled = !empty($options['notify_on_card']) ? 1 : 0; echo '<input type="checkbox" name="alba_board_notifications[notify_on_card]" value="1" ' . checked(1, $enabled, false) . '> <span>' . esc_html__('Enable email notifications', 'alba-board') . '</span>'; }
function alba_board_delete_on_uninstall_callback() { $value = get_option('alba_delete_on_uninstall', 0); echo '<input type="checkbox" name="alba_delete_on_uninstall" value="1" ' . checked(1, $value, false) . '> <span>' . esc_html__('Enable this option to delete all boards, lists, cards and tags when the plugin is deleted.', 'alba-board') . '</span>'; }

function alba_board_settings_page_callback() {
    echo '<div class="wrap"><h1>' . esc_html__('Alba Board Settings', 'alba-board') . '</h1><form method="post" action="options.php">';
    settings_fields('alba_board_settings_group'); do_settings_sections('alba-board-settings'); submit_button();
    echo '</form></div>';
}