<?php
if ( ! defined( 'ABSPATH' ) ) exit;

add_action('wp_ajax_alba_save_card_details_admin', 'alba_ajax_save_card_details_admin');

function alba_ajax_save_card_details_admin() {
    $nonce = isset($_POST['nonce']) ? sanitize_text_field(wp_unslash($_POST['nonce'])) : '';
    if (empty($nonce) || !wp_verify_nonce($nonce, 'alba_save_card_details_admin')) wp_send_json_error(['message' => esc_html__('Invalid security token.', 'alba-board')]);
    if (!current_user_can('edit_cards')) wp_send_json_error(['message' => esc_html__('Permission denied.', 'alba-board')]);
    
    $card_id = isset($_POST['card_id']) ? absint($_POST['card_id']) : 0;
    if (!$card_id) wp_send_json_error(['message' => esc_html__('Invalid card ID.', 'alba-board')]);

    $post_data = [ 'ID' => $card_id, 'post_title' => isset($_POST['card_title']) ? sanitize_text_field(wp_unslash($_POST['card_title'])) : '', 'post_content' => isset($_POST['card_content']) ? sanitize_textarea_field(wp_unslash($_POST['card_content'])) : '' ];
    if (isset($_POST['card_author'])) $post_data['post_author'] = absint($_POST['card_author']);

    $updated = wp_update_post($post_data);
    if (is_wp_error($updated)) wp_send_json_error(['message' => esc_html__('Error updating card.', 'alba-board')]);

    // 👉 GANCHO PARA ADD-ONS (AQUÍ EL ADD-ON GUARDARÁ LAS ETIQUETAS) 👈
    do_action('alba_save_card_details_admin', $card_id, wp_unslash($_POST));

    if (!empty($_POST['new_comment'])) {
        $current_user = wp_get_current_user();
        $comments = get_post_meta($card_id, 'alba_comments', true);
        if (!is_array($comments)) { $comments = @unserialize($comments); if (!is_array($comments)) $comments = []; }
        $comments[] = [ 'author' => $current_user->display_name, 'date' => current_time('mysql'), 'text' => sanitize_textarea_field(wp_unslash($_POST['new_comment'])) ];
        update_post_meta($card_id, 'alba_comments', $comments);
    }

    ob_start();
    alba_output_card_details_admin_modal($card_id);
    $html = ob_get_clean();
    wp_send_json_success(['html' => $html]);
}