<?php
// includes/admin-board-page.php
if ( ! defined( 'ABSPATH' ) ) exit; // Prevent direct access

// Main admin Kanban page renderer
function alba_render_admin_board_page() {
    // --- Handle Create Demo Board (Onboarding) ---
    if ( isset($_POST['alba_create_demo_board']) && check_admin_referer('alba_create_demo_board_action') ) {
        $board_id = wp_insert_post(['post_type' => 'alba_board', 'post_title' => __('Project Alpha (Demo)', 'alba-board'), 'post_status' => 'publish', 'post_author' => get_current_user_id()]);
        if ($board_id && !is_wp_error($board_id)) {
            $lists_names = [__('To Do', 'alba-board'), __('In Progress', 'alba-board'), __('Done', 'alba-board')];
            $list_ids = []; $menu_order = 0;
            foreach ($lists_names as $list_title) {
                $list_ids[] = wp_insert_post(['post_type' => 'alba_list', 'post_title' => $list_title, 'post_status' => 'publish', 'post_author' => get_current_user_id(), 'menu_order' => $menu_order++, 'meta_input' => ['alba_board_parent' => $board_id]]);
            }
            if (count($list_ids) >= 3) {
                $cards_data = [
                    ['title' => __('👋 Welcome to Alba Board!', 'alba-board'), 'content' => __('This is your first card. Click me to edit the description, assign a user, or add comments.', 'alba-board'), 'list_id' => $list_ids[0], 'order' => 0],
                    ['title' => __('🖱️ Drag and Drop me', 'alba-board'), 'content' => __('Try dragging this card to the "In Progress" list.', 'alba-board'), 'list_id' => $list_ids[0], 'order' => 1],
                    ['title' => __('🚀 Build something awesome', 'alba-board'), 'content' => '', 'list_id' => $list_ids[1], 'order' => 0]
                ];
                foreach ($cards_data as $c) {
                    wp_insert_post(['post_type' => 'alba_card', 'post_title' => $c['title'], 'post_content'=> $c['content'], 'post_status' => 'publish', 'post_author' => get_current_user_id(), 'menu_order' => $c['order'], 'meta_input' => ['alba_list_parent' => $c['list_id']]]);
                }
            }
            wp_safe_redirect(admin_url('admin.php?page=alba-board-visual&board_id=' . $board_id)); exit;
        }
    }

    // --- Handle Create Board ---
    if ( isset($_POST['alba_create_board']) && !empty($_POST['alba_new_board_title']) && check_admin_referer('alba_create_board_action') ) {
        $board_id = wp_insert_post(['post_type' => 'alba_board', 'post_title' => sanitize_text_field(wp_unslash($_POST['alba_new_board_title'])), 'post_status' => 'publish', 'post_author' => get_current_user_id()]);
        if ( $board_id && ! is_wp_error($board_id) ) { wp_safe_redirect(admin_url('admin.php?page=alba-board-visual&board_id=' . $board_id)); exit; }
    }

    // --- Handle Create List ---
    if ( isset($_POST['alba_create_list']) && !empty($_POST['alba_new_list_title']) && !empty($_POST['current_board_id']) && check_admin_referer('alba_create_list_action') ) {
        $board_id = absint($_POST['current_board_id']);
        global $wpdb;
        $max_list_order = $wpdb->get_var( $wpdb->prepare("SELECT MAX(menu_order) FROM $wpdb->posts WHERE post_type = %s AND post_status = 'publish' AND ID IN (SELECT post_id FROM $wpdb->postmeta WHERE meta_key = 'alba_board_parent' AND meta_value = %d)", 'alba_list', $board_id) );
        $new_list_order = (($max_list_order !== null) ? intval($max_list_order) + 1 : 0);
        $list_id = wp_insert_post(['post_type' => 'alba_list', 'post_title' => sanitize_text_field(wp_unslash($_POST['alba_new_list_title'])), 'post_status' => 'publish', 'post_author' => get_current_user_id(), 'menu_order' => $new_list_order, 'meta_input' => ['alba_board_parent' => $board_id]]);
        if ( $list_id && ! is_wp_error($list_id) ) { wp_safe_redirect(admin_url('admin.php?page=alba-board-visual&board_id=' . $board_id)); exit; }
    }

    // --- Handle Create Card ---
    if ( isset($_POST['alba_create_card'], $_POST['alba_new_card_title'], $_POST['current_list_id']) && !empty($_POST['alba_new_card_title']) && !empty($_POST['current_list_id']) && check_admin_referer('alba_create_card_action') ) {
        $list_id = absint($_POST['current_list_id']);
        $board_id = isset($_POST['current_board_id']) ? absint($_POST['current_board_id']) : 0;
        global $wpdb;
        $max_menu_order = $wpdb->get_var( $wpdb->prepare("SELECT MAX(menu_order) FROM $wpdb->posts WHERE post_type = %s AND post_status = 'publish' AND ID IN (SELECT post_id FROM $wpdb->postmeta WHERE meta_key = 'alba_list_parent' AND meta_value = %d)", 'alba_card', $list_id));
        $card_id = wp_insert_post(['post_type' => 'alba_card', 'post_title' => sanitize_text_field(wp_unslash($_POST['alba_new_card_title'])), 'post_status' => 'publish', 'post_author' => get_current_user_id(), 'menu_order' => (($max_menu_order !== null) ? intval($max_menu_order) + 1 : 0), 'meta_input' => ['alba_list_parent' => $list_id]]);
        if ( $card_id && ! is_wp_error($card_id) ) { wp_safe_redirect(admin_url('admin.php?page=alba-board-visual' . ($board_id ? '&board_id=' . $board_id : ''))); exit; }
    }

    $boards = get_posts(['post_type' => 'alba_board', 'numberposts' => -1, 'orderby' => 'title', 'order' => 'ASC']);
    $selected_board_id = isset($_GET['board_id']) ? absint($_GET['board_id']) : (!empty($boards) ? $boards[0]->ID : 0);
    
    // 👉 NEW: Check Avatar Settings 👈
    $display_opts = get_option('alba_board_display', ['show_avatars' => 1]);
    $show_avatars = !empty($display_opts['show_avatars']);

    echo '<div class="wrap"><h1>' . esc_html__('Boards', 'alba-board') . '</h1>';

    if (!empty($boards)) {
        echo '<div class="alba-top-action-bar">';
        echo '<form method="get">';
        echo '<input type="hidden" name="page" value="alba-board-visual">';
        echo '<label>' . esc_html__('Select a board:', 'alba-board') . '</label>';
        echo '<select name="board_id" class="alba-board-selector alba-auto-submit-select">'; 
        foreach ($boards as $board) echo '<option value="' . esc_attr($board->ID) . '"' . ($board->ID == $selected_board_id ? ' selected' : '') . '>' . esc_html($board->post_title) . '</option>';
        echo '</select></form>';
        echo '<button class="button" id="alba-show-new-board-btn">' . esc_html__('Add Board', 'alba-board') . '</button>';

        if ( $selected_board_id && current_user_can('administrator') ) {
            $csv_url = wp_nonce_url(admin_url('admin-post.php?action=alba_export_board&board_id=' . $selected_board_id . '&format=csv'), 'alba_export_board_' . $selected_board_id);
            $json_url = wp_nonce_url(admin_url('admin-post.php?action=alba_export_board&board_id=' . $selected_board_id . '&format=json'), 'alba_export_board_' . $selected_board_id);
            echo '<a href="' . esc_url($csv_url) . '" class="button">' . esc_html__('Export CSV', 'alba-board') . '</a>';
            echo '<a href="' . esc_url($json_url) . '" class="button">' . esc_html__('Export JSON', 'alba-board') . '</a>';
        }
        echo '</div>'; 

        echo '<form id="alba-new-board-form" class="alba-inline-form alba-is-hidden" method="post">'; 
        wp_nonce_field('alba_create_board_action');
        echo '<input type="hidden" name="alba_create_board" value="1">'; 
        echo '<input type="text" name="alba_new_board_title" class="alba-form-input-text" placeholder="' . esc_attr__('Board title', 'alba-board') . '" required>';
        echo '<input type="submit" class="button button-primary" value="' . esc_attr__('Create Board', 'alba-board') . '">';
        echo '<button type="button" class="button" id="alba-cancel-new-board-btn">' . esc_html__('Cancel', 'alba-board') . '</button>';
        echo '</form>';
    } else {
        echo '<div class="alba-empty-state">';
        echo '<h2>' . esc_html__('Welcome to Alba Board! 🎉', 'alba-board') . '</h2>';
        echo '<p>' . esc_html__('It looks like you don\'t have any boards yet. Let\'s get you started quickly so you can see the magic in action.', 'alba-board') . '</p>';
        echo '<form method="post">'; wp_nonce_field('alba_create_demo_board_action');
        echo '<button type="submit" name="alba_create_demo_board" class="button button-primary button-hero alba-demo-btn">' . esc_html__('Create a Sample Board', 'alba-board') . '</button></form>';
        echo '<hr class="alba-empty-divider">';
        echo '<form method="post" class="alba-empty-state-footer">'; wp_nonce_field('alba_create_board_action');
        echo '<input type="hidden" name="alba_create_board" value="1">';
        echo '<span>' . esc_html__('Or start from scratch:', 'alba-board') . '</span>';
        echo '<input type="text" name="alba_new_board_title" placeholder="' . esc_attr__('Board title', 'alba-board') . '" class="alba-input-rounded" required>';
        echo ' <input type="submit" class="button alba-btn-rounded" value="' . esc_attr__('Add Empty Board', 'alba-board') . '"></form></div>';
    }

    if ($selected_board_id) {
        $board = get_post($selected_board_id);
        if ($board && $board->post_type === 'alba_board') {
            echo '<h2>' . esc_html($board->post_title) . '</h2>';
            $lists = get_posts(['post_type' => 'alba_list', 'numberposts' => -1, 'meta_key' => 'alba_board_parent', 'meta_value' => $board->ID, 'orderby' => 'menu_order', 'order' => 'ASC']);
            
            echo '<div class="alba-board-wrapper">'; 

            if ($lists) {
                foreach ($lists as $list) {
                    echo '<div class="alba-list alba-list-scrollable" data-list-id="' . esc_attr($list->ID) . '">';
                    
                    echo '<div class="alba-list-header">';
                    echo '<h3>' . esc_html($list->post_title) . '</h3>';
                    echo '<button type="button" class="alba-delete-list-btn" data-list-id="' . esc_attr($list->ID) . '" title="' . esc_attr__('Delete list', 'alba-board') . '">✕</button>';
                    echo '</div>';
                    
                    echo '<div class="alba-cards-container" data-list-id="' . esc_attr($list->ID) . '">';

                    $cards = get_posts(['post_type' => 'alba_card', 'numberposts' => -1, 'meta_key' => 'alba_list_parent', 'meta_value' => $list->ID, 'orderby' => 'menu_order', 'order' => 'ASC']);
                    
                    if ($cards) {
                        foreach ($cards as $card) {
                            echo '<div class="alba-card" data-card-id="' . esc_attr($card->ID) . '">';
                            echo '<strong class="alba-card-title">' . esc_html($card->post_title) . '</strong>';
                            
                            echo '<div class="alba-card-footer">';
                            echo '<div class="alba-card-tags-wrapper">';
                            do_action('alba_board_card_tags', $card->ID); 
                            echo '</div>';

                            // 👉 NEW: Conditionally render the avatar based on settings 👈
                            if ($show_avatars) {
                                $author_id = $card->post_author;
                                if ($author_id) {
                                    $author_name = get_the_author_meta('display_name', $author_id);
                                    echo '<div class="alba-card-avatar" title="' . esc_attr(sprintf(__('Assigned to: %s', 'alba-board'), $author_name)) . '">';
                                    echo get_avatar($author_id, 26, '', $author_name, ['class' => 'alba-avatar-img']);
                                    echo '</div>';
                                } else {
                                    echo '<div></div>'; 
                                }
                            } else {
                                echo '<div></div>'; 
                            }
                            
                            echo '</div></div>'; 
                        }
                    } 
                    
                    $no_cards_class = empty($cards) ? 'alba-no-cards-msg' : 'alba-no-cards-msg alba-is-hidden';
                    echo '<p class="' . esc_attr($no_cards_class) . '"><em>' . esc_html__('No cards.', 'alba-board') . '</em></p>';
                    echo '</div>'; 
                    
                    echo '<div class="alba-list-footer">';
                    echo '<button type="button" class="alba-show-add-card-btn">+ ' . esc_html__('Add Card', 'alba-board') . '</button>';
                    echo '<form class="alba-add-card-form alba-stacked-form alba-is-hidden" method="post">';
                    wp_nonce_field('alba_create_card_action');
                    echo '<input type="hidden" name="alba_create_card" value="1">'; 
                    echo '<input type="hidden" name="current_list_id" value="' . absint($list->ID) . '">';
                    echo '<input type="hidden" name="current_board_id" value="' . absint($selected_board_id) . '">';
                    echo '<input type="text" name="alba_new_card_title" class="alba-form-input-text alba-mb-8" placeholder="' . esc_attr__('Card title', 'alba-board') . '" required>';
                    echo '<div class="alba-actions-row">';
                    echo '<input type="submit" class="alba-btn-neumorphic" value="' . esc_attr__('Add', 'alba-board') . '">';
                    echo '<button type="button" class="alba-btn-cancel alba-cancel-new-card-btn">' . esc_html__('Cancel', 'alba-board') . '</button>';
                    echo '</div></form></div>'; 
                    echo '</div>'; 
                }
            }

            echo '<div class="alba-list alba-add-list-wrapper">';
            $add_list_text = empty($lists) ? esc_html__('Add List', 'alba-board') : esc_html__('Add another list', 'alba-board');
            echo '<button type="button" class="alba-show-add-list-btn">+ ' . $add_list_text . '</button>';
            echo '<form class="alba-new-list-form alba-stacked-form alba-is-hidden" method="post">';
            wp_nonce_field('alba_create_list_action');
            echo '<input type="hidden" name="alba_create_list" value="1">'; 
            echo '<input type="hidden" name="current_board_id" value="' . absint($selected_board_id) . '">';
            echo '<input type="text" name="alba_new_list_title" class="alba-form-input-text alba-mb-8 alba-inset-shadow" placeholder="' . esc_attr__('Enter list title...', 'alba-board') . '" required>';
            echo '<div class="alba-actions-row">';
            echo '<input type="submit" class="alba-btn-neumorphic" value="' . esc_attr__('Add List', 'alba-board') . '">';
            echo '<button type="button" class="alba-btn-cancel alba-cancel-new-list-btn">' . esc_html__('Cancel', 'alba-board') . '</button>';
            echo '</div></form></div></div>';
        }
    }

    ?>
    <div id="alba-card-modal-admin" class="alba-is-hidden"><div class="alba-modal-content"><button id="alba-modal-close-admin" type="button">✕</button><div id="alba-modal-body-admin"><?php esc_html_e('Loading...', 'alba-board'); ?></div></div></div>
    <?php echo '</div>'; 
}

add_action('wp_ajax_alba_delete_list_action', function() {
    check_ajax_referer('alba_delete_list_nonce', 'nonce');
    if (!current_user_can('delete_posts')) wp_send_json_error(['message' => __('Permission denied.', 'alba-board')]); 
    $list_id = isset($_POST['list_id']) ? absint($_POST['list_id']) : 0;
    if ($list_id && get_post_type($list_id) === 'alba_list') {
        $cards = get_posts(['post_type' => 'alba_card', 'numberposts' => -1, 'meta_key' => 'alba_list_parent', 'meta_value' => $list_id]);
        foreach ($cards as $card) wp_trash_post($card->ID);
        wp_trash_post($list_id);
        wp_send_json_success();
    }
    wp_send_json_error(['message' => __('Invalid list ID.', 'alba-board')]);
});

add_action('wp_ajax_alba_move_list_action', function() {
    check_ajax_referer('alba_move_list_nonce', 'nonce');
    if (!current_user_can('edit_posts')) wp_send_json_error();
    $list_orders = isset($_POST['order']) ? $_POST['order'] : [];
    if (!empty($list_orders) && is_array($list_orders)) {
        global $wpdb;
        foreach ($list_orders as $index => $list_id) {
            $wpdb->update($wpdb->posts, ['menu_order' => intval($index)], ['ID' => intval($list_id)]);
        }
        wp_send_json_success();
    }
    wp_send_json_error();
});