<?php
/**
 * Akkedli Settings Page Template
 */

if (!defined('ABSPATH')) {
    exit;
}

$akkedli_is_configured = Akkedli_Settings::is_configured();
$akkedli_is_validated = Akkedli_Settings::is_validated();
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Display-only URL param from our own redirect.
$akkedli_just_connected = isset($_GET['connected']) && sanitize_text_field(wp_unslash($_GET['connected'])) === '1';
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Display-only URL param from our own redirect.
$akkedli_error = isset($_GET['error']) ? sanitize_text_field(wp_unslash($_GET['error'])) : '';
?>

<div class="wrap akkedli-settings-wrap">
    <h1>
        <span class="akkedli-logo">✓</span>
        <?php esc_html_e('Akkedli Connector', 'akkedli-connector'); ?>
    </h1>

    <?php if ($akkedli_just_connected): ?>
        <div class="notice notice-success inline" style="border-left-color: #10b981;">
            <p>
                <strong>🎉 <?php esc_html_e('Successfully Connected!', 'akkedli-connector'); ?></strong> —
                <?php esc_html_e('Your store is now linked to Akkedli. New orders will be sent automatically.', 'akkedli-connector'); ?>
            </p>
        </div>
    <?php elseif ($akkedli_error === 'missing_params'): ?>
        <div class="notice notice-error inline">
            <p>
                <strong><?php esc_html_e('Connection Failed', 'akkedli-connector'); ?></strong> —
                <?php esc_html_e('Missing API Key or Webhook URL. Please try connecting again from the Akkedli Dashboard.', 'akkedli-connector'); ?>
            </p>
        </div>
    <?php elseif (!$akkedli_is_configured): ?>
        <div class="notice notice-warning inline">
            <p>
                <strong><?php esc_html_e('Not Connected', 'akkedli-connector'); ?></strong> —
                <?php esc_html_e('Please enter your API Key and Webhook URL to start sending orders to Akkedli.', 'akkedli-connector'); ?>
            </p>
        </div>
    <?php else: ?>
        <div class="notice notice-success inline">
            <p>
                <strong><?php esc_html_e('Connected', 'akkedli-connector'); ?></strong> —
                <?php esc_html_e('Orders will be sent to Akkedli automatically.', 'akkedli-connector'); ?>
                <?php if ($akkedli_is_validated): ?>
                    <span style="color: #059669;">✓ <?php esc_html_e('Verified', 'akkedli-connector'); ?></span>
                <?php endif; ?>
            </p>
        </div>
    <?php endif; ?>

    <div class="akkedli-settings-card">
        <form method="post" action="options.php">
            <?php
            settings_fields('akkedli_settings');
            do_settings_sections('akkedli-connector');
            submit_button(__('Save Settings', 'akkedli-connector'));
            ?>
        </form>
    </div>

    <div class="akkedli-info-card">
        <h2>
            <?php esc_html_e('How it works', 'akkedli-connector'); ?>
        </h2>
        <ol>
            <li>
                <?php esc_html_e('Enter your Akkedli API Key and Webhook URL from your dashboard.', 'akkedli-connector'); ?>
            </li>
            <li>
                <?php esc_html_e('When a new order is created (Pending or Processing), it will be sent to Akkedli.', 'akkedli-connector'); ?>
            </li>
            <li>
                <?php esc_html_e('Akkedli will verify the order via WhatsApp with your customer.', 'akkedli-connector'); ?>
            </li>
            <li>
                <?php esc_html_e('Confirmed orders will be updated to "Confirmed by Akkedli" status.', 'akkedli-connector'); ?>
            </li>
        </ol>
    </div>

    <div class="akkedli-footer">
        <p>
            <?php
            printf(
                /* translators: %s: plugin version */
                esc_html__('Akkedli Connector v%s', 'akkedli-connector'),
                esc_html(AKKEDLI_VERSION)
            );
            ?> |
            <a href="https://akkedli.com/docs" target="_blank">
                <?php esc_html_e('Documentation', 'akkedli-connector'); ?>
            </a> |
            <a href="https://akkedli.com/support" target="_blank">
                <?php esc_html_e('Support', 'akkedli-connector'); ?>
            </a>
        </p>
    </div>
</div>