<?php
namespace AIZLabs\ChatAgent;

if (!defined('ABSPATH')) {
    exit;
}

$aizl_db_handler = new DBHandler();
$aizl_global_setting = $aizl_db_handler->get_global_setting();
$aizl_agents_header = isset($aizl_global_setting->agents_header) ? $aizl_global_setting->agents_header : '';
$aizl_agents_theme = isset($aizl_global_setting->theme_name ) && $aizl_global_setting->theme_name != '' ? $aizl_global_setting->theme_name : 'Default';
?>

<div class="aizl-plugin-container">
    <form method="post" id="aizl_save_ui_form">
        <h2>Agents Appearance</h2>
        <hr class="aizl-hr">
        <h4>The agents header and theme can be customized to match your website's branding. </h4>
        <div class="form-field">
            <label for="agents_header">Agents Header
                <span class="aizl-tooltip">i
                    <span class="aizl-tooltip-text">
                    This text will appear in the header section of all agent chat panels.
                    </span>
                </span>
            </label>
            <input type="text" id="agents_header" name="agents_header" value="<?php echo esc_attr($aizl_agents_header); ?>" required maxlength="50">
            
            <label for="agents_theme">Agents Theme
                <span class="aizl-tooltip">i
                    <span class="aizl-tooltip-text">
                    The current active site theme has been applied to all agents automatically to match your website's style.
                    </span>
                </span>
            </label>
            <select id="agents_theme" name="agents_theme">
                <option value="agents_theme" selected><?php echo esc_html($aizl_agents_theme); ?></option>
            </select>
        </div>
        <div class="aizl-row-middle">
            <button type="submit" id="aizl_save_ui_button">Save Appearance</button>
        </div>
    </form>
</div>