<?php
namespace AIZLabs\ChatAgent;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $wpdb;
$aizl_db_handler = new DBHandler();
$aizl_agents = $aizl_db_handler->get_agents();

$aizl_table_agent = Config::get_table_name('agent');
$aizl_pages = get_pages();

// Add homepage to pages if it's not already included
$aizl_homepage_id = get_option('page_on_front');
$aizl_show_on_front = get_option('show_on_front');

// If homepage is set to show posts or if homepage is a static page not in pages list
if ($aizl_show_on_front === 'posts' || ($aizl_homepage_id && !array_filter($aizl_pages, function($aizl_page) use ($aizl_homepage_id) {
    return $aizl_page->ID == $aizl_homepage_id;
}))) {
    // Create homepage object
    $aizl_homepage = new \stdClass();
    $aizl_homepage->ID = $aizl_homepage_id ? $aizl_homepage_id : 0; // Use 0 for posts page
    $aizl_homepage->post_title = $aizl_homepage_id ? get_the_title($aizl_homepage_id) : 'Homepage';

    // Add homepage to beginning of pages array
    array_unshift($aizl_pages, $aizl_homepage);
}

// Get admin pages
global $menu, $submenu;
if (empty($menu)) {
    // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedHooknameFound -- Using WordPress core hook
    do_action('admin_menu');
}

$aizl_admin_pages = [];
foreach ($menu as $aizl_item) {
    $aizl_slug = isset($aizl_item[2]) ? $aizl_item[2] : '';
    $aizl_title = isset($aizl_item[0]) ? wp_strip_all_tags($aizl_item[0]) : '';
    if ($aizl_slug && $aizl_title) {
        $aizl_admin_pages[] = [
            'slug' => $aizl_slug,
            'title' => $aizl_title,
        ];
        // Add submenus
        if (isset($submenu[$aizl_slug])) {
            foreach ($submenu[$aizl_slug] as $aizl_subitem) {
                $aizl_sub_slug = isset($aizl_subitem[2]) ? $aizl_subitem[2] : '';
                $aizl_sub_title = isset($aizl_subitem[0]) ? wp_strip_all_tags($aizl_subitem[0]) : '';
                if ($aizl_sub_slug && $aizl_sub_title) {
                    $aizl_admin_pages[] = [
                        'slug' => $aizl_sub_slug,
                        'title' => $aizl_title . ' → ' . $aizl_sub_title,
                    ];
                }
            }
        }
    }
}

?>

<div class="aizl-agent-list3">
    <div class="aizl-panel-header">Agent List</div>
    <ul>
        <?php
        // Get agents from database
        $aizl_agents = $aizl_db_handler->get_agents();
        if ($aizl_agents) {
            foreach ($aizl_agents as $aizl_agent) {
                ?>
                <li>
                    <a href="#" data-agent_id="<?php echo esc_attr($aizl_agent->id); ?>">
                        <?php echo esc_html($aizl_agent->name); ?>
                    </a>
                </li>
                <?php
            }
        } else {
            ?>
            <li>No Agent</li>
            <?php
        }
        ?>
    </ul>
</div>

<div class="aizl-plugin-container">
    <form method="post" id="aizl-publish-agent-form">
    <h2>Publish Agent</h2>
    <hr class="aizl-hr">
    <h4>Publish your agents to the selected website admin pages and frontend pages.</h4>

    <label for="name">Selected Agent</label>
    <select name="agent_id" required id="agent-select">
        <option value="">Select an agent...</option>
        <?php foreach ($aizl_agents as $aizl_agent): ?>
            <option value="<?php echo esc_attr($aizl_agent->id); ?>"><?php echo esc_html($aizl_agent->name); ?></option>
        <?php endforeach; ?>
    </select>

    <!-- Page Selection -->
    <h3>Agent Deployment Scope</h3>
    <div class="aizl-publish-scope-container">
        <div>
            <label for="name">Selected Frontend Pages</label>
            <select name="selected_pages[]" multiple size="10" disabled>
                <?php foreach ($aizl_pages as $aizl_page): ?>
                    <option value="<?php echo esc_attr($aizl_page->ID); ?>"><?php echo esc_html($aizl_page->post_title); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div>
            <label for="name">Selected Admin Pages</label>
            <select name="selected_admin_pages[]" multiple size="10" disabled>
                <?php foreach ($aizl_admin_pages as $aizl_page): ?>
                    <option value="<?php echo esc_attr($aizl_page['slug']); ?>">
                        <?php echo esc_html($aizl_page['title']); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
    </div>
    <div>
        <p>After publishing, a chat icon will appear at the bottom-right corner of each selected frontend and admin page.</p>
    </div>
    <div class="aizl-row-middle">
        <button type="submit" id="aizl_publish_agent_button">Publish Agent</button>

    </div>
    </form>
</div>