<?php
namespace AIZLabs\ChatAgent;

if (!defined('ABSPATH')) {
    exit;
}

$aizl_db_handler = new DBHandler();
$aizl_global_setting = $aizl_db_handler->get_global_setting();
$aizl_access_key = isset($aizl_global_setting->access_key) ? $aizl_global_setting->access_key : '';

?>

<div class="aizl-plugin-container">
    <form method="post" id="aizl_save_key_form">
        <h2>Access Key</h2>
        <hr class="aizl-hr">
        <h4>The access key will be provided after you obtain the preferred plan (free plan is available). Please check out the <a href="https://aizlabs.com/#pricing" target="_blank">pricing page</a> for more details.</h4>
        <div class="form-field">
            <label for="access_key">Access Key
                <span class="aizl-tooltip">i
                    <span class="aizl-tooltip-text">
                    This access key is used to authenticate agents when interacting with the AI APIs. You can also use it on your other WordPress sites, and all sites will collectively consume the monthly request quota.
                    </span>
                </span>
            </label>
            <input type="text" id="access_key" name="access_key" value="<?php echo esc_attr($aizl_access_key); ?>" required pattern="[a-zA-Z0-9\-]+" maxlength="50">
        </div>
        <div class="aizl-row-middle">
            <button type="submit" id="aizl_save_key_button">Save Key</button>
        </div>
    </form>
</div>