<?php
namespace AIZLabs\ChatAgent;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $wpdb;
$aizl_db_handler = new DBHandler();
$aizl_articles = $aizl_db_handler->get_articles();
$aizl_functions = $aizl_db_handler->get_functions();

?>

<div class="aizl-body">
    <div class="aizl-title"><img class="aizl-logo" src="<?php echo esc_url(AIZL_CHAT_AGENT_PLUGIN_URL . 'assets/img/logo_h.png'); ?>" alt="Chat Agent"></div>
    <div class="aizl-chart-toolbar">
                <select id="aizl-chart-range">
                <option value="24h" selected>Last 24 hours</option>
                    <option value="7d">Last 7 days</option>
                    <option value="30d">Last 30 days</option>
                    <option value="90d">Last 90 days</option>
                    <option value="1y">Last 1 year</option>
                    <option value="all">All</option>
                </select>
                <input type="datetime-local" id="aizl-chart-date-from" style="display: none;" value="<?php echo esc_attr(wp_date('Y-m-d\TH:i', strtotime('-30 days'))); ?>">
                <input type="datetime-local" id="aizl-chart-date-to" style="display: none;" value="<?php echo esc_attr(wp_date('Y-m-d\TH:i')); ?>">
            </div>
    <div id="aizl_home_content">
        <div id="aizl-dashboard-metrics"></div>
        <div id="aizl-dashboard-chart-section">
            <div class="aizl-chart-container">
                <canvas id="aizl-dashboard-chart"></canvas>
            </div>
        </div>
        <div>
        </div>
        <!-- New Agent/Conversation Dashboard Row -->
        <div id="aizl-dashboard-agent-row" class="aizl-dashboard-row">
            <div class="aizl-agent-list1">
                <div class="aizl-panel-header">Agent List</div>
                <ul class="aizl-agent-list-ul">
                <?php
                // Get agents from database
                $aizl_agents = $aizl_db_handler->get_agents();
                if ($aizl_agents) {
                    foreach ($aizl_agents as $aizl_agent) {
                        ?>
                        <li>
                            <a href="#" data-agent_id="<?php echo esc_attr($aizl_agent->id); ?>">
                                <?php echo esc_html($aizl_agent->name); ?>
                            </a>
                        </li>
                        <?php
                    }
                } else {
                        ?>
                        <li>No Agent</li>
                        <?php
                        }
                ?>
                </ul>
                <input type="hidden" id="aizl-selected-agent-id" value="">
            </div>
            <div id="aizl-dashboard-agent-detail-panel" class="aizl-dashboard-panel aizl-dashboard-panel-right">
                <div id="aizl-conversation-placeholder" class="aizl-conversation-placeholder"></div>    
                <div id="aizl-conversation-table-container" class="aizl-table-container">
                    <table id="aizl-conversation-table" class="aizl-table" style="width:100%">
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>