<?php
namespace AIZLabs\ChatAgent;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $wpdb;
$aizl_db_handler = new DBHandler();
$aizl_articles = $aizl_db_handler->get_articles();
$aizl_functions = $aizl_db_handler->get_functions();

?>


<div class="aizl-agent-list2">
    <div class="aizl-panel-header">Agent List</div>
    <ul>
        <li><a href="#" data-agent_id="new">+ New Agent</a></li>
        <?php
        // Get agents from database
        $aizl_agents = $aizl_db_handler->get_agents();
        if ($aizl_agents) {
            foreach ($aizl_agents as $aizl_agent) {
                ?>
                <li>
                    <a href="#" data-agent_id="<?php echo esc_attr($aizl_agent->id); ?>">
                        <?php echo esc_html($aizl_agent->name); ?>
                    </a>
                </li>
                <?php
            }
        }
        ?>
    </ul>
</div>

<div class="aizl-plugin-container">
    <form id="aizl_create_agent_form" method="post" enctype="multipart/form-data">
    <h2 id="aizl_create_agent_title">Create Your Agent</h2>
    <hr class="aizl-hr">
    <h4>The AI Zone Labs Chat Agent is an AI-powered assistant that supports your customers by answering questions based on your knowledge articles and automating tasks through integration with popular WordPress plugins.</h4>
    
        <!-- Basic Info -->
        <h3>Agent Settings</h3>
        <div class="aizl-example-container">
            <a href="#" class="aizl-example-link" id="example1">Example 1</a>
            <a href="#" class="aizl-example-link" id="example2">Example 2</a>
            <a href="#" class="aizl-example-link" id="example3">Example 3</a>
        </div>
        <input type="hidden" id="agent_id" name="agent_id" value="">
        <label for="name">Agent Name
          <span class="aizl-tooltip">i
            <span class="aizl-tooltip-text">It will appear to your customers in the chat panel.</span>
          </span>
        </label>
        <input type="text" id="name" name="name" required maxlength="30">

        <label for="greeting_message">Greeting Message
            <span class="aizl-tooltip">i
                <span class="aizl-tooltip-text">It will be sent to your customers in the chat panel when they start a new chat.</span>
            </span>
        </label>
        <textarea id="greeting_message" name="greeting_message" class="aizl-textarea" required maxlength="1000"></textarea>

        <label for="instructions">Agent Instructions
            <span class="aizl-tooltip">i
                <span class="aizl-tooltip-text">It is guidelines provided to the Chat Agentto control how it behaves, responds to your customers' requests.</span>
            </span>
        </label>
        <textarea id="instructions" name="instructions" class="aizl-textarea" required maxlength="1000"></textarea>

        <label for="model">AI Model</label>
        <select id="model" name="model">
            <option value="gpt-4o-mini">gpt-4o-mini</option>
            <option value="gpt-4o">gpt-4o</option>
            <!-- Add more models as needed -->
        </select>

        <!-- Knowledge Base -->
        <h3>Knowledge Base</h3>
        <label>Select File
            <span class="aizl-tooltip">i
                <span class="aizl-tooltip-text">Select one or more files to include in this agent's knowledge base.</span>
            </span>
        </label>
        <a href="#" class="aizl-link" id="aizl-kb-link" data-page="upload">Upload Your New Knowledge Article</a> | <a href="#" class="aizl-link" id="aizl-scan-site-link">Scan My Site</a>

        <div id="aizl-article-list">
            <?php
            if ($aizl_articles) {
                foreach ($aizl_articles as $aizl_article) {
                    ?>
                        <div class="aizl-row aizl-article-row">
                            <div class="aizl-article-content">
                                <input type="checkbox" id="article_<?php echo esc_attr($aizl_article->id); ?>" name="articles[]" value="<?php echo esc_attr($aizl_article->id); ?>">
                                <label for="article_<?php echo esc_attr($aizl_article->id); ?>">
                                    <?php echo esc_html(strtoupper($aizl_article->file_name)); ?>
                                    <?php if (strtolower($aizl_article->file_name) === 'website_content.md') : ?>
                                        <?php
                                        $upload_dir = wp_upload_dir();
                                        $review_file_path = $upload_dir['basedir'] . '/aizlabs-chat-agent/website_content.md';
                                        if (file_exists($review_file_path)) :
                                            $review_file_url = admin_url('admin-ajax.php?action=aizl_download_scan_file&nonce=' . wp_create_nonce('aizl_setting'));
                                        ?>
                                        <a href="<?php echo esc_url($review_file_url); ?>" class="aizl-review-link" title="Download to review">[Review]</a>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <span class="aizl-tooltip">i
                                        <span class="aizl-tooltip-text">Uploaded: <?php echo esc_html(wp_date('H:i:s Y-m-d', strtotime($aizl_article->created_time))); ?></span>
                                    </span>
                                </label>
                            </div>
                            <div class="aizl-article-actions">
                                <button type="button" class="aizl-delete-article-btn" data-article-id="<?php echo esc_attr($aizl_article->id); ?>" data-article-name="<?php echo esc_attr($aizl_article->file_name); ?>" title="<?php echo $aizl_article->in_use ? 'Cannot delete - file is used by agent(s)' : 'Delete Article'; ?>" <?php echo $aizl_article->in_use ? 'disabled' : ''; ?>>
                                    <span class="aizl-trash-icon"></span>
                                </button>
                            </div>
                        </div>
                    <?php
                }
            } else {
                ?>
                <div>No files uploaded yet.</div>
                <?php
            }
            ?>
        </div>
       
        
        <!-- Function Enablement -->
        <h3>Function Tools Enablement</h3>
        <label>Select Function Tools
        <span class="aizl-tooltip">i
                <span class="aizl-tooltip-text">Function tools calling provides a powerful and flexible way for agents to interface with your code or services. You also can add your own custom function tools apart from these default pre-built function tools.</span>
            </span>
        </label>
        <a href="<?php echo esc_url(home_url('/aizl-custom-function')); ?>" class="aizl-link" id="aizl-custom-function-link" target="_blank">Add Custom Function Tool</a> | <a href="https://aizlabs.com/vote" class="aizl-link" id="aizl-vote-link" target="_blank">Vote for the Next Prebuilt Tool</a>
        
        <div id="aizl-function-list">
            <?php
            if ($aizl_functions) {
                foreach ($aizl_functions as $aizl_function) {
                    $aizl_is_available = $aizl_db_handler->is_function_available($aizl_function);
                    $aizl_disabled = $aizl_is_available ? '' : 'disabled';
                    ?>
                    <div class="aizl-function-row">
                        <div class="aizl-function-content">
                            <input type="checkbox" id="function_<?php echo esc_attr($aizl_function->id); ?>" name="functions[]" value="<?php echo esc_attr($aizl_function->id); ?>" <?php echo esc_attr($aizl_disabled); ?>>
                            <label for="function_<?php echo esc_attr($aizl_function->id); ?>">
                                <?php echo esc_html(strtoupper($aizl_function->name)); ?> : <?php echo esc_html($aizl_function->description); ?><?php if (!empty($aizl_function->dependency_plugin)): ?> ( <?php echo esc_html($aizl_function->dependency_plugin); ?> )<?php endif; ?>
                                <?php if (!$aizl_is_available): ?>
                                    <span class="aizl-tooltip">i
                                        <span class="aizl-tooltip-text">The WordPress plugin <?php echo esc_html($aizl_function->dependency_plugin); ?> is required to run this function.</span>
                                    </span>
                                <?php endif; ?>
                            </label>
                        </div>
                    </div>
                    <?php
                }
            } else {
                ?>
                <div>No functions available.</div>
                <?php
            }
            ?>
        </div>

        <div class="aizl-row-middle">
            <button type="submit" id="aizl_create_agent_button">Create Agent</button>
        </div>
        <div id="aizl_update_agent_info" style="display:none;">
            After updating your agent, open a new incognito window to test it with a fresh session.
        </div>
        <div class="aizl-row-middle-bottom">
            <a href="#" class="aizl-delete-agent-link" id="delete_agent_link" style="display:none;">Delete This Agent</a>
        </div>
    </form>
</div>