<?php
namespace AIZLabs\ChatAgent;

class UI {
    private $table_global;

    public function __construct() {
        $this->table_global = Config::get_table_name('global');
        add_action('wp_ajax_aizl_save_ui', array($this, 'aizl_save_ui'));

    }

    public function aizl_save_ui() {
        if (!check_ajax_referer('aizl_setting', 'nonce', false)) {
            wp_send_json_error('Invalid nonce.');
            return;
        }

        if (!isset($_POST['agents_header'])) {
            wp_send_json_error('No agents header provided.');
            return;
        }

        $agents_header = sanitize_text_field(wp_unslash($_POST['agents_header']));

        //save the agent header to the database
        $db_handler = new DBHandler();
        $global_setting = $db_handler->get_global_setting();
        if ($global_setting) {
            $global_setting->agents_header = $agents_header;
            $db_handler->update_global_setting($global_setting);
        } else {
            $db_handler->insert_global_setting(['agents_header' => $agents_header]);
        }

        wp_send_json_success('The agents appearance has been saved.');
    }

}