<?php
namespace AIZLabs\ChatAgent;

class Publish {
    private $table_agent;

    public function __construct() {
        $this->table_agent = Config::get_table_name('agent');
        add_action('wp_ajax_aizl_get_agent_scope', array($this, 'aizl_get_agent_scope'));

        add_action('wp_ajax_aizl_get_theme_color', array($this, 'aizl_get_theme_color'));
        add_action('wp_ajax_nopriv_aizl_get_theme_color', array($this, 'aizl_get_theme_color'));

        add_action('wp_ajax_aizl_publish_agent', array($this, 'aizl_publish_agent'));
    }

    /**
     * AJAX handler to get agent scope
     */
    public function aizl_get_agent_scope() {
        if (!check_ajax_referer('aizl_setting', 'nonce', false)) {
            wp_send_json_error('Invalid nonce.');
            return;
        }

        if (!isset($_POST['agent_id'])) {
            wp_send_json_error('No agent ID provided.');
            return;
        }

        $agent_id = intval($_POST['agent_id']);
        $db_handler = new DBHandler();
        $agent = $db_handler->get_agent_by_id($agent_id);

        if (!$agent) {
            wp_send_json_error('Agent not found.');
            return;
        }

        // Get the scope
        $scope = json_decode($agent->scope, true);
        
        if (!$scope) {
            $scope = array();
        }

        wp_send_json_success($scope);
    }


    /**
     * AJAX handler to publish the agent
     */
    public function aizl_publish_agent() {
        if (!check_ajax_referer('aizl_setting', 'nonce', false)) {
            wp_send_json_error('Invalid nonce.');
            return;
        }

        if (!current_user_can('manage_options')) {
            wp_send_json_error('Unauthorized access.');
            return;
        }

        // Handle form submission
        if (isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['agent_id']) && (isset($_POST['selected_pages']) || isset($_POST['selected_admin_pages']))) {
            $agent_id = intval($_POST['agent_id']);
            $selected_pages = isset($_POST['selected_pages']) ? array_map('intval', (array)$_POST['selected_pages']) : array();
            // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized,WordPress.Security.ValidatedSanitizedInput.MissingUnslash -- Sanitized with array_map below
            $selected_admin_pages_raw = isset($_POST['selected_admin_pages']) ? (array)$_POST['selected_admin_pages'] : array();
            $selected_admin_pages = array_map('sanitize_text_field', array_map('wp_unslash', $selected_admin_pages_raw));

            // Convert selected pages to JSON
            $scope_json = json_encode(array_merge($selected_pages, $selected_admin_pages));

            global $wpdb;
            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Updating custom plugin table
            $result = $wpdb->update(
                $this->table_agent,
                ['scope' => $scope_json],
                ['id' => $agent_id]
            );

            // Set the theme color when publishing the agent
            $this->set_theme_color();

            if ($result !== false) {
                wp_send_json_success('Agent has been published.');
            } else {
                wp_send_json_error('Error publishing agent.');
            }
        }

    }

    /**
     * Set the theme color for chat panel background color
     */
    public function set_theme_color() {
        $db_handler = new DBHandler();
        $global_setting = $db_handler->get_global_setting();
        $saved_theme_name = isset($global_setting->theme_name) ? $global_setting->theme_name : '';

        $current_theme = wp_get_theme();
        $current_theme_name = $current_theme->get('Name');

        //if new theme, run the agent to get the theme color
        if ($saved_theme_name !== $current_theme_name) {
            $run = new Run();
            $api_response = $run->aizl_run_the_agent(1, $current_theme->get_screenshot(), null);
            if ($api_response) {
                $new_theme_color = $api_response;
                $global_setting->theme_color = $new_theme_color;
                $global_setting->theme_name = $current_theme_name;
                $db_handler->update_global_setting($global_setting);
            }
        }
    }

    public function aizl_get_theme_color() {
        $db_handler = new DBHandler();
        $global_setting = $db_handler->get_global_setting();
        $theme_color = $global_setting->theme_color;
        wp_send_json_success(sanitize_text_field($theme_color));
    }


}