<?php
namespace AIZLabs\ChatAgent;

class Menu {

    public function __construct() {
        add_action('admin_menu', array($this, 'add_admin_menu'));
    }

    public function add_admin_menu() {
        // Main menu under AIZLabs Chat Agent
        add_menu_page(__('Chat Agent', 'aizlabs-chat-agent'), __('Chat Agent', 'aizlabs-chat-agent'), 'manage_options', 'aizlabs-chat-agent', array($this, 'render_dashboard_page'), 'dashicons-format-chat', 6);
        add_submenu_page('aizlabs-chat-agent', __('Dashboard', 'aizlabs-chat-agent'), __('Dashboard', 'aizlabs-chat-agent'), 'manage_options', 'aizlabs-chat-agent', array($this, 'render_dashboard_page'));
        add_submenu_page('aizlabs-chat-agent', __('Settings', 'aizlabs-chat-agent'), __('Settings', 'aizlabs-chat-agent'), 'manage_options', 'aizlabs-chat-agent-settings', array($this, 'render_settings_page'));
    }

    public function render_dashboard_page() {
        include(AIZL_CHAT_AGENT_PLUGIN_DIR . 'pages/dashboard.php');
    }

    public function render_settings_page() {
        include(AIZL_CHAT_AGENT_PLUGIN_DIR . 'pages/settings.php');
    }

}

