<?php
namespace AIZLabs\ChatAgent;

class Key {
    private $table_global;

    public function __construct() {
        $this->table_global = Config::get_table_name('global');
        add_action('wp_ajax_aizl_save_key', array($this, 'aizl_save_key'));

    }

    public function aizl_save_key() {
        if (!check_ajax_referer('aizl_setting', 'nonce', false)) {
            wp_send_json_error('Invalid nonce.');
            return;
        }

        if (!isset($_POST['access_key'])) {
            wp_send_json_error('No access key provided.');
            return;
        }

        $access_key = sanitize_text_field(wp_unslash($_POST['access_key'])); 

        $result = $this->create_qdrant_collection($access_key);
        if($result) {
            //save the access key to the database
            $db_handler = new DBHandler();
            $global_setting = $db_handler->get_global_setting();
            if ($global_setting) {
                $global_setting->access_key = $access_key;
                $db_handler->update_global_setting($global_setting);
            } else {
                $db_handler->insert_global_setting(['access_key' => $access_key]);
            }
            wp_send_json_success('The access key has been saved.');
        }
    }

    /**
     * Create a Qdrant collection
     */
    function create_qdrant_collection($access_key) {

        $api_url = Config::get_api_endpoint('collection');
        $api_response = wp_remote_post($api_url, array(
            'method' => 'POST',
            'body' => '',
            'headers' => array(
                'Content-Type' => 'application/json',
                'x-access-key' => $access_key,
                'x-plugin-source' => 'aizlabs_chat_agent'
            ),
            'timeout' => 60,
        ));

        if (is_wp_error($api_response)) {
            $api_error_msg = $api_response->get_error_message();
            wp_send_json_error('System Error: ' . $api_error_msg);
            return false;
        }

        if (wp_remote_retrieve_response_code($api_response) != 200) {

            if (wp_remote_retrieve_response_code($api_response) == 400) {
                wp_send_json_error('Bad Request');
            } elseif(wp_remote_retrieve_response_code($api_response) == 401) {
                wp_send_json_error('Invalid Access Key');
            } else {
                wp_send_json_error('Failed to create the collection. Please try again.');
            }
            return false;

        } else {
            $api_response_body = json_decode(wp_remote_retrieve_body($api_response), true);
            $api_msg = $api_response_body['message'];
            return true;
        }


    }
}