<?php
namespace AIZLabs\ChatAgent;

class Frontend {
    public function __construct() {
        add_action('admin_enqueue_scripts', array($this, 'enqueue_scripts'));
        add_action('wp_enqueue_scripts', array($this, 'enqueue_scripts')); 
    }

    public function enqueue_scripts() {
        // Enqueue CSS files
        wp_enqueue_style('aizl-css', AIZL_CHAT_AGENT_PLUGIN_URL . 'assets/css/aizl.css', array(), AIZL_CHAT_AGENT_VERSION);
        wp_enqueue_style('aizl-chat-css', AIZL_CHAT_AGENT_PLUGIN_URL . 'assets/css/aizl-chat.css', array(), AIZL_CHAT_AGENT_VERSION);

        // Enqueue core plugin JS files
        wp_enqueue_script('aizl-settings-js', AIZL_CHAT_AGENT_PLUGIN_URL . 'assets/js/aizl-settings.js', array('jquery'), AIZL_CHAT_AGENT_VERSION, true);
        wp_enqueue_script('aizl-dashboard-js', AIZL_CHAT_AGENT_PLUGIN_URL . 'assets/js/aizl-dashboard.js', array('jquery'), AIZL_CHAT_AGENT_VERSION, true);
        wp_enqueue_script('aizl-chat-js', AIZL_CHAT_AGENT_PLUGIN_URL . 'assets/js/aizl-chat.js', array('jquery'), AIZL_CHAT_AGENT_VERSION, true);
        wp_enqueue_script('aizl-example-js', AIZL_CHAT_AGENT_PLUGIN_URL . 'assets/js/aizl-example.js', array('jquery'), AIZL_CHAT_AGENT_VERSION, true);
        wp_enqueue_script('aizl-sitescanner-js', AIZL_CHAT_AGENT_PLUGIN_URL . 'assets/js/aizl-sitescanner.js', array('jquery', 'aizl-settings-js'), AIZL_CHAT_AGENT_VERSION, true);

        // DataTables scripts and styles (bundled locally)
        wp_enqueue_script('datatables-js', AIZL_CHAT_AGENT_PLUGIN_URL . 'assets/lib/datatables/js/jquery.dataTables.min.js', array('jquery'), '2.3.4', true);
        wp_enqueue_style('datatables-css', AIZL_CHAT_AGENT_PLUGIN_URL . 'assets/lib/datatables/css/dataTables.dataTables.min.css', array(), '2.3.4');
        // DataTables Buttons scripts and styles (bundled locally)
        wp_enqueue_script('datatables-buttons-js', AIZL_CHAT_AGENT_PLUGIN_URL . 'assets/lib/datatables/js/dataTables.buttons.min.js', array('jquery', 'datatables-js'), '3.2.5', true);
        wp_enqueue_script('datatables-buttons-html5-js', AIZL_CHAT_AGENT_PLUGIN_URL . 'assets/lib/datatables/js/buttons.html5.min.js', array('datatables-buttons-js'), '3.2.5', true);
        wp_enqueue_script('datatables-buttons-print-js', AIZL_CHAT_AGENT_PLUGIN_URL . 'assets/lib/datatables/js/buttons.print.min.js', array('datatables-buttons-js'), '3.2.5', true);
        wp_enqueue_script('jszip-js', AIZL_CHAT_AGENT_PLUGIN_URL . 'assets/lib/jszip/jszip.min.js', array(), '3.10.1', true);
        // Buttons CSS (bundled locally)
        wp_enqueue_style('datatables-buttons-css', AIZL_CHAT_AGENT_PLUGIN_URL . 'assets/lib/datatables/css/buttons.dataTables.min.css', array(), '3.2.5');

        // Enqueue Chart.js and related files (bundled locally)
        wp_enqueue_script('chartjs', AIZL_CHAT_AGENT_PLUGIN_URL . 'assets/lib/chartjs/chart.umd.min.js', array(), '4.5.1', true);
        wp_enqueue_script('aizl-chart-js', AIZL_CHAT_AGENT_PLUGIN_URL . 'assets/js/aizl-chart.js', array('jquery'), AIZL_CHAT_AGENT_VERSION, true);

        // Localize scripts for AJAX and security
        wp_localize_script('aizl-settings-js', 'aizl_setting_nonce', array(
            'nonce' => wp_create_nonce('aizl_setting'),
            'ajaxurl' => admin_url('admin-ajax.php')
        ));
        wp_localize_script('aizl-chat-js', 'aizl_request_nonce', array(
            'nonce' => wp_create_nonce('aizl_request'),
            'ajaxurl' => admin_url('admin-ajax.php'),
            'session_id' => wp_get_session_token()
        ));
        wp_localize_script('aizl-dashboard-js', 'aizl_dashboard_nonce', array(
            'nonce' => wp_create_nonce('aizl_dashboard'),
            'ajaxurl' => admin_url('admin-ajax.php')
        ));
        wp_localize_script('aizl-chart-js', 'aizl_dashboard_nonce', array(
            'nonce' => wp_create_nonce('aizl_dashboard'),
            'ajaxurl' => admin_url('admin-ajax.php')
        ));
    }

}
