<?php
namespace AIZLabs\ChatAgent;

class Config {
    private static $table_suffix = 'aizl_';

    public static function get_table_name($table_alias) {
        global $wpdb;
        return $wpdb->prefix . self::$table_suffix . $table_alias;
    }

    /**
     * Get API endpoint by type
     */
    public static function get_api_endpoint($type) {
        switch ($type) {
            case 'upload':
                return AIZL_API_UPLOAD_ENDPOINT;
            case 'run':
                return AIZL_API_RUN_ENDPOINT;
            case 'task':
                return AIZL_API_TASK_ENDPOINT;
            case 'collection':
                return AIZL_API_COLLECTION_ENDPOINT;
            case 'presign':
                return AIZL_API_PRESIGN_ENDPOINT;
            case 'delete':
                return AIZL_API_DELETE_ENDPOINT;
            case 'vector':
                return AIZL_API_VECTOR_ENDPOINT;
            default:
                return null;
        }
    }

    /**
     * Get all API endpoints as array
     */
    public static function get_all_api_endpoints() {
        return [
            'upload' => AIZL_API_UPLOAD_ENDPOINT,
            'run' => AIZL_API_RUN_ENDPOINT,
            'task' => AIZL_API_TASK_ENDPOINT,
            'collection' => AIZL_API_COLLECTION_ENDPOINT,
            'presign' => AIZL_API_PRESIGN_ENDPOINT,
            'delete' => AIZL_API_DELETE_ENDPOINT,
            'vector' => AIZL_API_VECTOR_ENDPOINT,
        ];
    }

    /**
     * Check if API endpoints are properly configured
     */
    public static function is_api_configured() {
        return defined('AIZL_API_BASE_URL') &&
               defined('AIZL_API_UPLOAD_ENDPOINT') &&
               defined('AIZL_API_RUN_ENDPOINT') &&
               defined('AIZL_API_TASK_ENDPOINT') &&
               defined('AIZL_API_COLLECTION_ENDPOINT') &&
               defined('AIZL_API_PRESIGN_ENDPOINT') &&
               defined('AIZL_API_DELETE_ENDPOINT') &&
               defined('AIZL_API_VECTOR_ENDPOINT');
    }
}
