<?php
namespace AIZLabs\ChatAgent;

class ChatAgent {
    private $menu;
    private $settings;
    private $upload;
    private $frontend;
    private $chat;
    private $publish;
    private $key;
    private $create;
    private $run;
    private $article;
    private $dashboard;
    private $sitescanner;
    private $ui;

    public function __construct() {
        // Constructor is now empty
    }

    public function init_plugin() {
        $this->init_components();
    }

    private function init_components() {
        // Check if required classes exist before instantiating
        if (!class_exists('AIZLabs\ChatAgent\Menu') ||
            !class_exists('AIZLabs\ChatAgent\Frontend') ||
            !class_exists('AIZLabs\ChatAgent\Upload') ||
            !class_exists('AIZLabs\ChatAgent\Create') ||
            !class_exists('AIZLabs\ChatAgent\Run') ||
            !class_exists('AIZLabs\ChatAgent\Chat') ||
            !class_exists('AIZLabs\ChatAgent\Publish') ||
            !class_exists('AIZLabs\ChatAgent\UI') ||
            !class_exists('AIZLabs\ChatAgent\Key') ||
            !class_exists('AIZLabs\ChatAgent\Article') ||
            !class_exists('AIZLabs\ChatAgent\Dashboard') ||
            !class_exists('AIZLabs\ChatAgent\SiteScanner')) {
            throw new \Exception('Required classes not found');
        }

        $this->menu = new Menu();
        $this->frontend = new Frontend();
        $this->upload = new Upload();
        $this->create = new Create();
        $this->run = new Run();
        $this->chat = new Chat();
        $this->publish = new Publish();
        $this->ui = new UI();
        $this->key = new Key();
        $this->article = Article::privacy_policy();// Use privacy policy as default
        $this->dashboard = new Dashboard();
        $this->sitescanner = new SiteScanner();
    }

    
}
