<?php
namespace AIZLabs\ChatAgent;

class Chat {
    private $table_agent;

    public function __construct() {
        $this->table_agent = Config::get_table_name('agent');
        add_action('wp_ajax_aizl_check_agent_scope', array($this, 'aizl_check_agent_scope'));
        add_action('wp_ajax_nopriv_aizl_check_agent_scope', array($this, 'aizl_check_agent_scope'));
    }

    public function aizl_check_agent_scope() {

        if (!check_ajax_referer('aizl_request', 'nonce', false)) {
            wp_send_json_error('Invalid nonce.');
            return;
        }

        $is_in_scope = false;

        $current_url = isset($_POST['current_url']) ? sanitize_text_field(wp_unslash($_POST['current_url'])) : '';
        if (empty($current_url)) {
            wp_send_json_error('Missing current URL.');
            return;
        }

        $page_id = url_to_postid($current_url);

        $db_handler = new DBHandler();
        $agents = $db_handler->get_agents();

        foreach ($agents as $agent) {

            if (!empty($agent->scope)) {
                $scope = json_decode($agent->scope, true);

                // Check if current page ID matches any frontend page in scope
                if (is_array($scope) && in_array($page_id, $scope)) {
                    $is_in_scope = true;
                }

                // Check if current admin page slug matches any admin page in scope
                if (is_admin() && is_array($scope)) {
                    $current_page = isset($_POST['page_slug']) ? sanitize_text_field(wp_unslash($_POST['page_slug'])) : (isset($_SERVER['PHP_SELF']) ? basename(sanitize_text_field(wp_unslash($_SERVER['PHP_SELF']))) : '');

                    // Normalize the current page slug for custom plugin pages
                    $current_page = str_replace('/wp-admin/admin.php?page=', '', $current_page);
                    // Normalize the current page slug for standard pages
                    $current_page = str_replace('/wp-admin/', '', $current_page);

                    if (isset($_GET['post_type'])) {
                        $current_page .= '?post_type=' . sanitize_text_field(wp_unslash($_GET['post_type']));
                    }
                    
                    // Check if the current page matches any scope item
                    foreach ($scope as $scope_page) {
                        if ($scope_page === $current_page) {
                            $is_in_scope = true;
                        }
                    }
                }
            }

            if ($is_in_scope) {

                $agents_header = $db_handler->get_agents_header();
                $greeting_message = $agent->greeting_message;

                //get selected function tools
                $function_ids = json_decode($agent->function_ids, true);
                if (!empty($function_ids)) {
                    $greeting_message .= "\n\nIn addition, you can choose options from below to send your request.";
                }
                foreach ($function_ids as $function_id) {
                    $function_tool = $db_handler->get_function_tool($function_id);
                    if ($function_tool && !empty($function_tool->name) && $db_handler->is_function_available($function_tool)) {
                        $greeting_message .= "\n\n<a href='#' class='aizl-function-link' data-function='" . esc_attr($function_tool->name) . "'>" . esc_html($function_tool->description) . "</a>";
                    }
                }

                if (class_exists('\AIZLabs\ChatAgent\Article')) {
                    $article = \AIZLabs\ChatAgent\Article::privacy_policy();
                    $privacy_url = "/" . $article->page_slug;
                    $policy_message = "\n\nBy continuing you agree to our <a href='" . esc_url($privacy_url) . "' target='_blank'>privacy policy</a>.";
                    $greeting_message .= $policy_message;
                }

                wp_send_json_success(array(
                    'agent_id' => $agent->id,
                    'agents_header' => esc_html($agents_header),
                    'name' => esc_html($agent->name),
                    'greeting_message' => wp_kses_post($greeting_message),
                    'message' => 'This page is in scope'
                ));
                
                return;
            }
        }
        wp_send_json_error('Page is not in scope for any agent.');
    }
}