<?php
namespace AIZLabs\ChatAgent;

class Article {
    public $page_title;
    public $page_slug;
    public $page_content;
    public $shortcode;
    public $html_file;
    public $div_class;

    public function __construct($args) {
        $this->page_title  = $args['page_title'];
        $this->page_slug   = $args['page_slug'];
        $this->shortcode   = $args['shortcode'];
        $this->html_file   = $args['html_file'];
        $this->div_class   = $args['div_class'] ?? 'aizl-article';
        $this->page_content = '[' . $this->shortcode . ']';
    }

    public static function register_shortcodes() {
        add_shortcode('aizl_privacy_policy', [self::class, 'article_shortcode']);
        add_shortcode('aizl_custom_function_doc', [self::class, 'article_shortcode']);
    }

    public static function article_shortcode($atts = [], $content = '', $shortcode_tag = '') {
        $map = [
            'aizl_privacy_policy' => [
                'file' => 'assets/html/aizl-privacy.html',
                'div_class' => 'aizl-privacy-policy',
            ],
            'aizl_custom_function_doc' => [
                'file' => 'assets/html/aizl-custom-function.html',
                'div_class' => 'aizl-custom-function-doc',
            ],
        ];
        if (isset($map[$shortcode_tag])) {
            $file_path = AIZL_CHAT_AGENT_PLUGIN_DIR . $map[$shortcode_tag]['file'];
            if (file_exists($file_path)) {
                $content = file_get_contents($file_path);
                return '<div class="' . esc_attr($map[$shortcode_tag]['div_class']) . '">' . wp_kses_post($content) . '</div>';
            } else {
// phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_error_log
                error_log('Article file not found: ' . $file_path);
                return '<div class="' . esc_attr($map[$shortcode_tag]['div_class']) . '">Article file not found.</div>';
            }
        }
        return '';
    }

    public function create_page($network_wide = false) {
        if (is_multisite() && $network_wide) {
            $aizl_sites = get_sites();
            foreach ($aizl_sites as $aizl_site) {
                switch_to_blog($aizl_site->blog_id);
                $this->create_single_page();
                restore_current_blog();
            }
        } else {
            $this->create_single_page();
        }
    }

    private function create_single_page() {
        $aizl_page = get_page_by_path($this->page_slug);
        if (!$aizl_page) {
            $page_id = wp_insert_post([
                'post_title'   => $this->page_title,
                'post_name'    => $this->page_slug,
                'post_content' => $this->page_content,
                'post_status'  => 'publish',
                'post_type'    => 'page',
            ]);

            if ($page_id && !is_wp_error($page_id)) {
// phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_error_log
                error_log('Article page created: ' . $page_id);
            }
        } else {
// phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_error_log
            error_log('Article page already exists: ' . $aizl_page->ID);
        }
    }

    // Static helpers for common articles
    public static function privacy_policy() {
        return new self([
            'page_title' => 'Chat Agent- Privacy Policy',
            'page_slug' => 'aizl-privacy-policy',
            'shortcode' => 'aizl_privacy_policy',
            'html_file' => 'assets/html/aizl-privacy.html',
            'div_class' => 'aizl-privacy-policy',
        ]);
    }

    public static function custom_function_doc() {
        return new self([
            'page_title' => 'Chat Agent- Add Custom Function Tool',
            'page_slug' => 'aizl-custom-function',
            'shortcode' => 'aizl_custom_function_doc',
            'html_file' => 'assets/html/aizl-custom-function.html',
            'div_class' => 'aizl-custom-function-doc',
        ]);
    }
} 