jQuery(document).ready(function($) {
    'use strict';

    // Scan Site Link - Show confirmation modal
    $(document).on('click', '#aizl-scan-site-link', function(e) {
        e.preventDefault();

        var modalHtml = `
            <div class="aizl-modal-overlay">
                <div class="aizl-modal">
                    <button class="aizl-modal-close" title="Close">&times;</button>
                    <div class="aizl-modal-header">
                        <h2>Scan Website & Generate Knowledge Article</h2>
                    </div>
                    <hr class="aizl-hr">
                    <div class="aizl-modal-content">
                        <div class="aizl-modal-description">
                            <h4>This feature will automatically scan your WordPress website and create a comprehensive knowledge article.</h4>
                        </div>
                        <div class="aizl-modal-info">
                            <p><b>What will be scanned:</b></p>
                            <ul>
                                <li>Your website homepage</li>
                                <li>All pages linked in your navigation menus</li>
                                <li>Actual rendered page content (including shortcodes and dynamic content)</li>
                            </ul>
                            <p><b>What will be included in the knowledge article:</b></p>
                            <ul>
                                <li>Site information (name, URL, description)</li>
                                <li>Navigation menu structure (all menus and links)</li>
                                <li>Page content from internal pages only</li>
                            </ul>
                            <p><b>Output:</b> A file named <code>website_content.md</code> will be automatically created and uploaded to your knowledge base.</p>
                            <p><b>Note:</b>This process may take a few moments depending on the number of pages.</p>
                        </div>
                        <div class="aizl-modal-button">
                            <button id="aizl-confirm-scan-site">Start Scan</button>
                            <button id="aizl-confirm-cancel">Cancel</button>
                        </div>
                    </div>
                </div>
            </div>
        `;

        $('.aizl-modal-overlay').remove();
        $('body').append(modalHtml);
    });

    // Handle scan site confirmation
    $(document).on('click', '#aizl-confirm-scan-site', function() {
        var $button = $(this);
        $button.prop('disabled', true).text('Scanning...');

        // Step 1: Scan website and generate file
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'aizl_scan_website',
                nonce: aizl_setting_nonce.nonce
            },
            success: function(response) {
                if (response.success) {
                    // Store content for later use
                    // Note: Local file is now saved server-side during scan (avoids WAF blocking)
                    var scannedContent = response.data.content;
                    var fileName = response.data.file_name;
                    var fileSize = response.data.file_size;

                    $button.text('Uploading...');

                    // Step 3: Upload to S3
                    $.ajax({
                        url: ajaxurl,
                        type: 'POST',
                        data: {
                            action: 'aizl_upload_scanned_content',
                            nonce: aizl_setting_nonce.nonce,
                            file_content: scannedContent,
                            file_name: fileName,
                            file_size: fileSize
                        },
                        success: function(uploadResponse) {
                            if (uploadResponse.success) {
                                $button.text('Processing...');

                                // Step 3: Process with Lambda
                                $.ajax({
                                    url: ajaxurl,
                                    type: 'POST',
                                    data: {
                                        action: 'aizl_process_s3_file',
                                        nonce: aizl_setting_nonce.nonce,
                                        file_key: uploadResponse.data.file_key,
                                        file_name: uploadResponse.data.file_name,
                                        file_size: uploadResponse.data.file_size
                                    },
                                    success: function(processResponse) {
                                        if (processResponse.success) {
                                            showNotification('Website scanned and knowledge article created successfully!', 'success');
                                            reloadArticleList();
                                            $('.aizl-modal-overlay').remove();
                                        } else {
                                            showNotification('Failed to process file: ' + processResponse.data, 'error');
                                        }
                                    },
                                    error: function() {
                                        showNotification('Failed to process file.', 'error');
                                    },
                                    complete: function() {
                                        $button.prop('disabled', false).text('Start Scan');
                                    }
                                });
                            } else {
                                showNotification('Failed to upload: ' + uploadResponse.data, 'error');
                                $button.prop('disabled', false).text('Start Scan');
                            }
                        },
                        error: function() {
                            showNotification('Failed to upload scanned content.', 'error');
                            $button.prop('disabled', false).text('Start Scan');
                        }
                    });
                } else {
                    showNotification('Scan failed: ' + response.data, 'error');
                    $button.prop('disabled', false).text('Start Scan');
                }
            },
            error: function() {
                showNotification('Failed to scan website.', 'error');
                $button.prop('disabled', false).text('Start Scan');
            }
        });
    });
});
