document.addEventListener('DOMContentLoaded', function() {
    // Define your example instructions
    const instructions_examples = {
        example1: "You are a helpful AI assistant with access to a knowledge base. Always answer questions using only the provided knowledge. If you cannot find the answer within the knowledge base, politely inform the user that you don't have that specific information and suggest they raise a support ticket at https://itsupport.yourdomain.com.",
        example2: "You are an expert virtual shopping assistant with deep knowledge of our entire product catalog. Help customers quickly decide the right products by asking clarifying questions, offering comparisons, and suggesting alternatives based on their preferences and needs.",
        example3: "You are a friendly onboarding guide for new software users. Use simple, welcoming language to walk them through their first steps, explain features in plain terms, and point them toward helpful resources, tutorials, and quick tips so they can get started with confidence."
    };

    const greeting_examples = {
        example1: "Hello! I'm here to help answer your questions using our knowledge base. If something isn't covered, I can guide you on how to raise a support ticket so you'll get the right help quickly. What can I help you with today?",
        example2: "Hi there! I'm your personal shopping assistant. Tell me a bit about what you're looking for, and I'll help you compare options, highlight the best choices, and even suggest alternatives you might love. What's on your shopping list today?",
        example3: "Welcome! I'm here to make your first steps with our software easy and stress-free. I can walk you through setup, show you where everything is, and share quick tips to help you get started. Ready to dive in?"
    };

    const name_examples = {
        example1: "InfoGuide",
        example2: "ShopSmart",
        example3: "StartMate"
    };

    // Attach click listeners to each example link
    Object.keys(instructions_examples).forEach(function(id) {
        const link = document.getElementById(id);
        if (link) {
            link.addEventListener('click', function(e) {
                e.preventDefault();
                document.getElementById('name').value = name_examples[id];
                document.getElementById('instructions').value = instructions_examples[id];
                document.getElementById('greeting_message').value = greeting_examples[id];
            });
        }
    });
});