jQuery(document).ready(function($) {

    // Dashboard Metrics Fetch & Render
    if ($('#aizl-dashboard-metrics').length) { // Fixed selector syntax
        getDashboardMetrics();
    }

    function getDashboardMetrics() {
        if (typeof window !== 'undefined') {
            window.getDashboardMetrics = getDashboardMetrics;
        }
        renderDashboardMetricsLoading();

        //get from and to from date pickers
        const from = $('#aizl-chart-date-from').val();
        const to = $('#aizl-chart-date-to').val();

        timezone = Intl.DateTimeFormat().resolvedOptions().timeZone;
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: { action: 'aizl_get_dashboard_metrics', nonce: aizl_dashboard_nonce.nonce, timezone: timezone, from: from, to: to },
            success: function(response) {
                if (response.success && response.data) {
                    renderDashboardMetrics(response.data);
                } else {
                    renderDashboardMetricsError();
                }
            },
            error: renderDashboardMetricsError
        });
    }


    function renderDashboardMetricsLoading() {
        const loading = [1,2,3,4].map(() => `
            <div class="aizl-metric-card aizl-metric-loading">
                <div class="aizl-metric-icon aizl-metric-loading-bg"></div>
                <div class="aizl-metric-value aizl-metric-loading-bar"></div>
                <div class="aizl-metric-label aizl-metric-loading-bar"></div>
            </div>
        `).join('');
        $('#aizl-dashboard-metrics').html(`<div class="aizl-metrics-row">${loading}</div>`);
    }
    function renderDashboardMetricsError() {
        $('#aizl-dashboard-metrics').html('<div class="aizl-metrics-row"><div class="aizl-metric-card">Error loading metrics</div></div>');
    }
    function renderDashboardMetrics(data) {
        const metrics = [
            {
                value: data.total_agents,
                label: 'Total Agents',
                color: 'aizl-metric-blue',
                tooltip: 'Total number of agents created.'
            },
            {
                value: data.published_agents,
                label: 'Published Agents',
                color: 'aizl-metric-green',
                tooltip: 'Total number of agents published.'
            },
            {
                value: data.unique_users,
                label: 'Unique Visitors',
                color: 'aizl-metric-purple',
                tooltip: 'Total number of unique visitors interacting with agents in the selected time range.'
            },
            {
                value: data.total_interactions,
                label: 'Effective Interactions',
                color: 'aizl-metric-orange',
                tooltip: 'Total number of questions answered and requests handled by agents in the selected time range.'
            }
        ];
        const html = metrics.map(m => `
            <div class="aizl-metric-card ${m.color}">
                <div class="aizl-metric-value">${m.value ?? 0}</div>
                <div class="aizl-metric-label">${m.label}
                    <span class="aizl-tooltip" tabindex="0">i
                        <span class="aizl-tooltip-text">${m.tooltip}</span>
                    </span>
                </div>
            </div>
        `).join('');
        $('#aizl-dashboard-metrics').html(`<div class="aizl-metrics-row">${html}</div>`);
    }




    $('#aizl-conversation-table-container').hide();
    $('#aizl-conversation-placeholder').html('Select an agent to view conversation history');

    $('.aizl-agent-list1 li').on('click', function(event) {
        event.preventDefault();
        const agent_id = $(this).find('a').data('agent_id');
        $('#aizl-selected-agent-id').val(agent_id);
        $('#aizl-conversation-table').hide();
        getConversationHistory(agent_id);
    });


    $(document).ready(function() {
        if ($('.aizl-agent-list1 li').length > 0) {
            setTimeout(function() {
                $('.aizl-agent-list1 li').first().trigger('click');
            }, 100); // Small delay to ensure list is fully rendered
        }
    });

    window.getConversationHistory = function(selected_agent_id) {
        if (!selected_agent_id) {
            selected_agent_id = $('#aizl-selected-agent-id').val();
        }
        const from = $('#aizl-chart-date-from').val();
        const to = $('#aizl-chart-date-to').val();
        getConversationHistory_agent(selected_agent_id, from, to);
    }

    function getConversationHistory_agent(agent_id, from, to) {
        if (!agent_id) {
            return;
        }
        timezone = Intl.DateTimeFormat().resolvedOptions().timeZone;
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: { action: 'aizl_get_conversation_history', nonce: aizl_dashboard_nonce.nonce, agent_id: agent_id, timezone: timezone, from: from, to: to },
            success: function(response) {
                if (response.success && response.data) {
                    renderConversationHistory(response.data);
                }
            },
            error: function(response) {
                renderConversationHistory(response.data);
            }
        });
    }

    const table_conversation_history = $('#aizl-conversation-table').DataTable({
        autoWidth: false,
        stateSave: false,
        layout: {
            topStart: 'pageLength',
            topEnd: 'search',
            bottomStart: 'info',
            bottomEnd: 'paging'
        },
        pageLength: 10,
        lengthMenu: [[5, 10, 25, 50, 100, -1], [5, 10, 25, 50, 100, "All"]], 
        paging: true,
        ordering: true,
        language: {
            loadingRecords: 'Loading...',
            processing: 'Loading...',
            emptyTable: 'No data available in table',
            zeroRecords: 'No matching records found',
            lengthMenu: "Show _MENU_ entries",
            info: "Showing _START_ to _END_ of _TOTAL_ entries <span class='aizl-tooltip'>i<span class='aizl-tooltip-text'>The conversation history is real time and excludes greeting messages.</span></span>",
            infoEmpty: "Showing 0 to 0 of 0 entries",
            infoFiltered: "(filtered from _MAX_ total entries)",
            paginate: {
                first: "First",
                last: "Last", 
                next: "Next",
                previous: "Previous"
            }
        },
        processing: true,
        columns: [
            {
                data: null,
                title: '',
                orderable: false,
                searchable: false,
                className: 'aizl-icon-col',
                render: function(data, type, row) {
                    if (row.source === 'qdrant') {
                        const score = (row.score * 100).toFixed(0) + '%';
                        return '<span class="aizl-tooltip">i<span class="aizl-tooltip-text">Cached response (' + score + ' match)</span></span>' +
                               '<span class="aizl-delete-cache" data-id="' + row.id + '" title="Delete cached response"><span class="aizl-trash-icon"></span></span>';
                    } else if (row.source === 'qdrant_cleared') {
                        return '<span class="aizl-tooltip aizl-cleared-icon">&#10003;<span class="aizl-tooltip-text">Cache was cleared for this question</span></span>';
                    }
                    return '';
                }
            },
            { data: 'id', title: 'ID', visible: false, searchable: false},
            { data: 'response_time', title: 'Response Time'},
            { data: 'session_id', title: 'Visitor ID'}, 
            { data: 'content', title: 'Question/Request'},
            { data: 'response', title: 'Response'},
            { data: 'processing_time', title: 'Duration(s)', className: 'aizl-dt-center' },
            { data: 'source', title: 'Source', visible: false, searchable: false}
        ],
        order: [[1, 'desc']],
        rowCallback: function(row, data) {
            if (data.source === 'qdrant') {
                $(row).addClass('aizl-row-qdrant');
            } else if (data.source === 'qdrant_cleared') {
                $(row).addClass('aizl-row-cleared');
            }
        }
    });

    function renderConversationHistory(data) {
        table_conversation_history.clear().rows.add(data).draw();
        table_conversation_history.columns.adjust().draw();
        $('#aizl-conversation-table').show();
        $('#aizl-conversation-table-container').show();
        $('#aizl-conversation-placeholder').hide();
    }

    // Delete cache click handler - use custom modal
    $('#aizl-conversation-table').on('click', '.aizl-delete-cache', function(e) {
        e.stopPropagation();
        const id = $(this).data('id');
        const $btn = $(this);
        const $row = $btn.closest('tr');

        // Show confirmation modal
        const modalHtml = `
            <div class="aizl-modal-overlay">
                <div class="aizl-modal">
                    <button class="aizl-modal-close">&times;</button>
                    <h3>Delete Cached Response?</h3>
                    <p>Future similar questions will be answered fresh by AI.</p>
                    <div class="aizl-modal-button">
                        <button class="button aizl-modal-cancel">Cancel</button>
                        <button class="button button-primary aizl-modal-confirm">Delete Cache</button>
                    </div>
                </div>
            </div>`;

        const $modal = $(modalHtml).appendTo('body');

        // Close modal handlers
        $modal.find('.aizl-modal-close, .aizl-modal-cancel').on('click', function() {
            $modal.remove();
        });

        // Confirm delete
        $modal.find('.aizl-modal-confirm').on('click', function() {
            $modal.remove();
            $btn.addClass('aizl-deleting');

            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'aizl_delete_qdrant_cache',
                    nonce: aizl_dashboard_nonce.nonce,
                    conversation_id: id
                },
                success: function(response) {
                    $btn.removeClass('aizl-deleting');
                    if (response.success) {
                        // Replace delete icon with cleared checkmark
                        const $iconCol = $btn.closest('td');
                        $btn.remove();
                        $iconCol.find('.aizl-tooltip').remove();
                        $iconCol.html('<span class="aizl-tooltip aizl-cleared-icon">&#10003;<span class="aizl-tooltip-text">Cache was cleared for this question</span></span>');
                        $row.removeClass('aizl-row-qdrant').addClass('aizl-row-cleared');

                        showNotification('Cache deleted. Future similar questions will get fresh AI responses.', 'success');
                    } else {
                        showNotification('Error: ' + (response.data || 'Failed to delete cache'), 'error');
                    }
                },
                error: function() {
                    $btn.removeClass('aizl-deleting');
                    showNotification('Failed to delete cache. Please try again.', 'error');
                }
            });
        });
    });

    // Notification helper function
    function showNotification(message, type) {
        let $container = $('#aizl-notification-container');
        if (!$container.length) {
            $container = $('<div id="aizl-notification-container"></div>').appendTo('body');
        }

        const $notification = $('<div class="aizl-notification aizl-notification-' + type + '">' + message + '</div>');
        $container.append($notification);

        setTimeout(function() {
            $notification.fadeOut(400, function() {
                $(this).remove();
            });
        }, 4000);
    }

});







