<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}
?>
<div class="wrap">
    <h1>AIventory Connector</h1>
    
    <?php
    // Determine the AIventory URL based on environment
    $aiventory_url = defined('AIVENTORY_URL') ? AIVENTORY_URL : 'https://aiventory.org';
    ?>
    
    <div class="card" style="max-width: 800px;">
        <h2>Connection Details</h2>
        <p>Use these credentials to connect your WooCommerce store to AIventory.</p>
        
        <table class="form-table">
            <tr>
                <th scope="row">Store URL</th>
                <td>
                    <input type="text" readonly value="<?php echo esc_attr($store_url); ?>" class="regular-text" onclick="this.select();">
                    <button type="button" class="button" onclick="copyToClipboard('<?php echo esc_js($store_url); ?>')">Copy</button>
                </td>
            </tr>
            <tr>
                <th scope="row">API Key</th>
                <td>
                    <input type="text" readonly value="<?php echo esc_attr($api_key); ?>" class="regular-text" onclick="this.select();">
                    <button type="button" class="button" onclick="copyToClipboard('<?php echo esc_js($api_key); ?>')">Copy</button>
                    <p class="description">Keep this key secure. Anyone with this key can read your store data.</p>
                </td>
            </tr>
        </table>
        
        <form method="post">
            <?php wp_nonce_field('aiventory_regenerate'); ?>
            <p>
                <button type="submit" name="regenerate_key" class="button button-secondary" 
                    onclick="return confirm('This will invalidate the current key. Continue?')">
                    Regenerate API Key
                </button>
            </p>
        </form>
    </div>
    
    <div class="card" style="max-width: 800px; margin-top: 20px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
        <h2 style="color: white; margin-top: 0;">🚀 Get Started with AIventory</h2>
        <p style="font-size: 16px;">Transform your inventory management with AI-powered forecasting and analytics.</p>
        
        <div style="margin: 20px 0;">
            <a href="<?php echo esc_url($aiventory_url . '/signup'); ?>" target="_blank" class="button button-primary button-hero" 
               style="background: white; color: #667eea; border: none; padding: 12px 30px; font-size: 16px; text-decoration: none; display: inline-block; margin-right: 10px;">
                ✨ Create Free Account
            </a>
            <a href="<?php echo esc_url($aiventory_url . '/login'); ?>" target="_blank" class="button button-hero" 
               style="background: rgba(255,255,255,0.2); color: white; border: 1px solid white; padding: 12px 30px; font-size: 16px; text-decoration: none; display: inline-block;">
                🔑 Sign In
            </a>
        </div>
        
        <p style="font-size: 14px; opacity: 0.9;">Already have an account? Sign in and go to Settings → Integrations to connect your store.</p>
    </div>
    
    <div class="card" style="max-width: 800px; margin-top: 20px;">
        <h2>How to Connect</h2>
        <ol>
            <li><strong>Create your AIventory account</strong> using the button above (or sign in if you have one)</li>
            <li>Copy the <strong>Store URL</strong> and <strong>API Key</strong> from this page</li>
            <li>In AIventory, navigate to <strong>Settings → Integrations → WooCommerce</strong></li>
            <li>Paste your Store URL and API Key</li>
            <li>Click <strong>Connect</strong></li>
        </ol>
        
        <p>Your inventory will sync automatically to AIventory's advanced analytics and forecasting platform.</p>
    </div>
    
    <div class="card" style="max-width: 800px; margin-top: 20px;">
        <h2>What Gets Synced</h2>
        <ul>
            <li>✅ Products & Variations</li>
            <li>✅ Inventory Levels</li>
            <li>✅ Orders & Sales</li>
            <li>✅ Customers</li>
            <li>✅ Categories</li>
            <li>✅ Coupons & Discounts</li>
        </ul>
        <p class="description">All data is read-only. AIventory cannot modify your WooCommerce store.</p>
    </div>
</div>
