# AIventory Connector for WooCommerce

Connect your WooCommerce store to AIventory for advanced inventory management and analytics.

## Features

- ✅ **14 REST API Endpoints** - Complete data access
- ✅ **Read-Only Access** - Your store stays safe
- ✅ **Simple Setup** - Install, activate, copy API key
- ✅ **Real-Time Sync** - Always up-to-date inventory
- ✅ **Multi-Store Support** - Manage multiple WooCommerce stores
- ✅ **Secure Authentication** - API key-based access

## Installation

1. Download `aiventory-connector.zip`
2. Go to **WordPress Admin → Plugins → Add New → Upload Plugin**
3. Choose the zip file and click **Install Now**
4. Click **Activate**
5. Go to **WooCommerce → AIventory**
6. Copy your Store URL and API Key
7. Enter them at [AIventory.org](https://aiventory.org)

## API Endpoints

All endpoints require authentication via `X-API-Key` header or `api_key` query parameter.

### Store & Configuration
- `GET /wp-json/aiventory/v1/test` - Test connection
- `GET /wp-json/aiventory/v1/store` - Store information

### Products & Inventory
- `GET /wp-json/aiventory/v1/products` - All products
- `GET /wp-json/aiventory/v1/variants` - Product variations
- `GET /wp-json/aiventory/v1/collections` - Categories
- `GET /wp-json/aiventory/v1/inventory-ledger` - Stock movements

### Orders & Sales
- `GET /wp-json/aiventory/v1/orders` - All orders
- `GET /wp-json/aiventory/v1/order-line-items` - Order items
- `GET /wp-json/aiventory/v1/fulfillments` - Shipments
- `GET /wp-json/aiventory/v1/refunds` - Refunds
- `GET /wp-json/aiventory/v1/refund-line-items` - Refund items

### Customers
- `GET /wp-json/aiventory/v1/customers` - All customers
- `GET /wp-json/aiventory/v1/customer-addresses` - Customer addresses

### Marketing
- `GET /wp-json/aiventory/v1/discounts` - Coupons

### Query Parameters
- `page` - Page number (default: 1)
- `per_page` - Items per page (default: 50, max: 100)
- `status` - Filter by status
- `product_id` - Filter by product
- `order_id` - Filter by order

## Testing

```bash
# Test connection
curl https://your-store.com/wp-json/aiventory/v1/test?api_key=YOUR_KEY

# Get products
curl https://your-store.com/wp-json/aiventory/v1/products?api_key=YOUR_KEY&per_page=5
```

## Requirements

- WordPress 5.8+
- WooCommerce 5.0+
- PHP 7.4+

## Support

- Email: support@aiventory.org
- Website: https://aiventory.org
- Documentation: https://aiventory.org/docs

## License

GPL v2 or later
